/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.junit.Assert;
import org.junit.Test;

public class TestYARNTokenIdentifier {
    @Test
    public void testNMTokenIdentifier() throws IOException {
        this.testNMTokenIdentifier(false);
    }

    @Test
    public void testNMTokenIdentifierOldFormat() throws IOException {
        this.testNMTokenIdentifier(true);
    }

    public void testNMTokenIdentifier(boolean oldFormat) throws IOException {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        NodeId nodeId = NodeId.newInstance((String)"host0", (int)0);
        String applicationSubmitter = "usr0";
        int masterKeyId = 1;
        NMTokenIdentifier token = new NMTokenIdentifier(appAttemptId, nodeId, applicationSubmitter, masterKeyId);
        NMTokenIdentifier anotherToken = new NMTokenIdentifier();
        byte[] tokenContent = oldFormat ? this.writeInOldFormat(token) : token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assert.assertEquals((String)"Token is not the same after serialization and deserialization.", (Object)token, (Object)anotherToken);
        Assert.assertEquals((String)"appAttemptId from proto is not the same with original token", (Object)anotherToken.getApplicationAttemptId(), (Object)appAttemptId);
        Assert.assertEquals((String)"NodeId from proto is not the same with original token", (Object)anotherToken.getNodeId(), (Object)nodeId);
        Assert.assertEquals((String)"applicationSubmitter from proto is not the same with original token", (Object)anotherToken.getApplicationSubmitter(), (Object)applicationSubmitter);
        Assert.assertEquals((String)"masterKeyId from proto is not the same with original token", (long)anotherToken.getKeyId(), (long)masterKeyId);
    }

    @Test
    public void testAMRMTokenIdentifier() throws IOException {
        this.testAMRMTokenIdentifier(false);
    }

    @Test
    public void testAMRMTokenIdentifierOldFormat() throws IOException {
        this.testAMRMTokenIdentifier(true);
    }

    public void testAMRMTokenIdentifier(boolean oldFormat) throws IOException {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        int masterKeyId = 1;
        AMRMTokenIdentifier token = new AMRMTokenIdentifier(appAttemptId, masterKeyId);
        AMRMTokenIdentifier anotherToken = new AMRMTokenIdentifier();
        byte[] tokenContent = oldFormat ? this.writeInOldFormat(token) : token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assert.assertEquals((String)"Token is not the same after serialization and deserialization.", (Object)token, (Object)anotherToken);
        Assert.assertEquals((String)"ApplicationAttemptId from proto is not the same with original token", (Object)anotherToken.getApplicationAttemptId(), (Object)appAttemptId);
        Assert.assertEquals((String)"masterKeyId from proto is not the same with original token", (long)anotherToken.getKeyId(), (long)masterKeyId);
    }

    @Test
    public void testClientToAMTokenIdentifier() throws IOException {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        String clientName = "user";
        ClientToAMTokenIdentifier token = new ClientToAMTokenIdentifier(appAttemptId, clientName);
        ClientToAMTokenIdentifier anotherToken = new ClientToAMTokenIdentifier();
        byte[] tokenContent = token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assert.assertEquals((String)"Token is not the same after serialization and deserialization.", (Object)token, (Object)anotherToken);
        Assert.assertEquals((String)"ApplicationAttemptId from proto is not the same with original token", (Object)anotherToken.getApplicationAttemptID(), (Object)appAttemptId);
        Assert.assertEquals((String)"clientName from proto is not the same with original token", (Object)anotherToken.getClientName(), (Object)clientName);
    }

    @Test
    public void testContainerTokenIdentifierProtoMissingFields() throws IOException {
        YarnSecurityTokenProtos.ContainerTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.ContainerTokenIdentifierProto.newBuilder();
        YarnSecurityTokenProtos.ContainerTokenIdentifierProto proto = builder.build();
        Assert.assertFalse((boolean)proto.hasContainerType());
        Assert.assertFalse((boolean)proto.hasExecutionType());
        Assert.assertFalse((boolean)proto.hasNodeLabelExpression());
        byte[] tokenData = proto.toByteArray();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenData, tokenData.length);
        ContainerTokenIdentifier tid = new ContainerTokenIdentifier();
        tid.readFields((DataInput)dib);
        Assert.assertEquals((String)"container type", (Object)ContainerType.TASK, (Object)tid.getContainerType());
        Assert.assertEquals((String)"execution type", (Object)ExecutionType.GUARANTEED, (Object)tid.getExecutionType());
        Assert.assertEquals((String)"node label expression", (Object)"", (Object)tid.getNodeLabelExpression());
    }

    @Test
    public void testContainerTokenIdentifier() throws IOException {
        this.testContainerTokenIdentifier(false, false);
    }

    @Test
    public void testContainerTokenIdentifierOldFormat() throws IOException {
        this.testContainerTokenIdentifier(true, true);
        this.testContainerTokenIdentifier(true, false);
    }

    public void testContainerTokenIdentifier(boolean oldFormat, boolean withLogAggregation) throws IOException {
        ContainerId containerID = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (long)1L);
        String hostName = "host0";
        String appSubmitter = "usr0";
        Resource r = Resource.newInstance((int)1024, (int)1);
        long expiryTimeStamp = 1000L;
        int masterKeyId = 1;
        long rmIdentifier = 1L;
        Priority priority = Priority.newInstance((int)1);
        long creationTime = 1000L;
        ContainerTokenIdentifier token = new ContainerTokenIdentifier(containerID, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime);
        ContainerTokenIdentifier anotherToken = new ContainerTokenIdentifier();
        byte[] tokenContent = oldFormat ? this.writeInOldFormat(token, withLogAggregation) : token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assert.assertEquals((String)"Token is not the same after serialization and deserialization.", (Object)token, (Object)anotherToken);
        Assert.assertEquals((String)"ContainerID from proto is not the same with original token", (Object)anotherToken.getContainerID(), (Object)containerID);
        Assert.assertEquals((String)"Hostname from proto is not the same with original token", (Object)anotherToken.getNmHostAddress(), (Object)hostName);
        Assert.assertEquals((String)"ApplicationSubmitter from proto is not the same with original token", (Object)anotherToken.getApplicationSubmitter(), (Object)appSubmitter);
        Assert.assertEquals((String)"Resource from proto is not the same with original token", (Object)anotherToken.getResource(), (Object)r);
        Assert.assertEquals((String)"expiryTimeStamp from proto is not the same with original token", (long)anotherToken.getExpiryTimeStamp(), (long)expiryTimeStamp);
        Assert.assertEquals((String)"KeyId from proto is not the same with original token", (long)anotherToken.getMasterKeyId(), (long)masterKeyId);
        Assert.assertEquals((String)"RMIdentifier from proto is not the same with original token", (long)anotherToken.getRMIdentifier(), (long)rmIdentifier);
        Assert.assertEquals((String)"Priority from proto is not the same with original token", (Object)anotherToken.getPriority(), (Object)priority);
        Assert.assertEquals((String)"CreationTime from proto is not the same with original token", (long)anotherToken.getCreationTime(), (long)creationTime);
        Assert.assertNull((Object)anotherToken.getLogAggregationContext());
        Assert.assertEquals((Object)"", (Object)anotherToken.getNodeLabelExpression());
        Assert.assertEquals((Object)ContainerType.TASK, (Object)anotherToken.getContainerType());
        Assert.assertEquals((Object)ExecutionType.GUARANTEED, (Object)anotherToken.getExecutionType());
    }

    @Test
    public void testRMDelegationTokenIdentifier() throws IOException {
        this.testRMDelegationTokenIdentifier(false);
    }

    @Test
    public void testRMDelegationTokenIdentifierOldFormat() throws IOException {
        this.testRMDelegationTokenIdentifier(true);
    }

    public void testRMDelegationTokenIdentifier(boolean oldFormat) throws IOException {
        Text owner = new Text("user1");
        Text renewer = new Text("user2");
        Text realUser = new Text("user3");
        long issueDate = 1L;
        long maxDate = 2L;
        int sequenceNumber = 3;
        int masterKeyId = 4;
        RMDelegationTokenIdentifier originalToken = new RMDelegationTokenIdentifier(owner, renewer, realUser);
        originalToken.setIssueDate(issueDate);
        originalToken.setMaxDate(maxDate);
        originalToken.setSequenceNumber(sequenceNumber);
        originalToken.setMasterKeyId(masterKeyId);
        RMDelegationTokenIdentifier anotherToken = new RMDelegationTokenIdentifier();
        if (oldFormat) {
            DataInputBuffer inBuf = new DataInputBuffer();
            DataOutputBuffer outBuf = new DataOutputBuffer();
            originalToken.writeInOldFormat((DataOutput)outBuf);
            inBuf.reset(outBuf.getData(), 0, outBuf.getLength());
            anotherToken.readFieldsInOldFormat((DataInput)inBuf);
            inBuf.close();
        } else {
            byte[] tokenContent = originalToken.getBytes();
            DataInputBuffer dib = new DataInputBuffer();
            dib.reset(tokenContent, tokenContent.length);
            anotherToken.readFields((DataInput)dib);
            dib.close();
        }
        Assert.assertEquals((String)"Token is not the same after serialization and deserialization.", (Object)originalToken, (Object)anotherToken);
        Assert.assertEquals((String)"owner from proto is not the same with original token", (Object)owner, (Object)anotherToken.getOwner());
        Assert.assertEquals((String)"renewer from proto is not the same with original token", (Object)renewer, (Object)anotherToken.getRenewer());
        Assert.assertEquals((String)"realUser from proto is not the same with original token", (Object)realUser, (Object)anotherToken.getRealUser());
        Assert.assertEquals((String)"issueDate from proto is not the same with original token", (long)issueDate, (long)anotherToken.getIssueDate());
        Assert.assertEquals((String)"maxDate from proto is not the same with original token", (long)maxDate, (long)anotherToken.getMaxDate());
        Assert.assertEquals((String)"sequenceNumber from proto is not the same with original token", (long)sequenceNumber, (long)anotherToken.getSequenceNumber());
        Assert.assertEquals((String)"masterKeyId from proto is not the same with original token", (long)masterKeyId, (long)anotherToken.getMasterKeyId());
        YarnSecurityTokenProtos.YARNDelegationTokenIdentifierProto tokenProto = originalToken.getProto();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        tokenProto.writeTo((OutputStream)out);
        byte[] tokenData = baos.toByteArray();
        RMDelegationTokenIdentifier readToken = new RMDelegationTokenIdentifier();
        DataInputBuffer db = new DataInputBuffer();
        db.reset(tokenData, tokenData.length);
        readToken.readFields((DataInput)db);
        Assert.assertEquals((String)"Token from getProto is not the same after serialization and deserialization.", (Object)originalToken, (Object)readToken);
        db.close();
        out.close();
    }

    @Test
    public void testTimelineDelegationTokenIdentifier() throws IOException {
        Text owner = new Text("user1");
        Text renewer = new Text("user2");
        Text realUser = new Text("user3");
        long issueDate = 1L;
        long maxDate = 2L;
        int sequenceNumber = 3;
        int masterKeyId = 4;
        TimelineDelegationTokenIdentifier token = new TimelineDelegationTokenIdentifier(owner, renewer, realUser);
        token.setIssueDate(issueDate);
        token.setMaxDate(maxDate);
        token.setSequenceNumber(sequenceNumber);
        token.setMasterKeyId(masterKeyId);
        TimelineDelegationTokenIdentifier anotherToken = new TimelineDelegationTokenIdentifier();
        byte[] tokenContent = token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assert.assertEquals((String)"Token is not the same after serialization and deserialization.", (Object)token, (Object)anotherToken);
        Assert.assertEquals((String)"owner from proto is not the same with original token", (Object)anotherToken.getOwner(), (Object)owner);
        Assert.assertEquals((String)"renewer from proto is not the same with original token", (Object)anotherToken.getRenewer(), (Object)renewer);
        Assert.assertEquals((String)"realUser from proto is not the same with original token", (Object)anotherToken.getRealUser(), (Object)realUser);
        Assert.assertEquals((String)"issueDate from proto is not the same with original token", (long)anotherToken.getIssueDate(), (long)issueDate);
        Assert.assertEquals((String)"maxDate from proto is not the same with original token", (long)anotherToken.getMaxDate(), (long)maxDate);
        Assert.assertEquals((String)"sequenceNumber from proto is not the same with original token", (long)anotherToken.getSequenceNumber(), (long)sequenceNumber);
        Assert.assertEquals((String)"masterKeyId from proto is not the same with original token", (long)anotherToken.getMasterKeyId(), (long)masterKeyId);
    }

    @Test
    public void testParseTimelineDelegationTokenIdentifierRenewer() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0]([nr]m@.*EXAMPLE.COM)s/.*/yarn/");
        HadoopKerberosName.setConfiguration((Configuration)conf);
        Text owner = new Text("owner");
        Text renewer = new Text("rm/localhost@EXAMPLE.COM");
        Text realUser = new Text("realUser");
        TimelineDelegationTokenIdentifier token = new TimelineDelegationTokenIdentifier(owner, renewer, realUser);
        Assert.assertEquals((Object)new Text("yarn"), (Object)token.getRenewer());
    }

    @Test
    public void testAMContainerTokenIdentifier() throws IOException {
        ContainerId containerID = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (long)1L);
        String hostName = "host0";
        String appSubmitter = "usr0";
        Resource r = Resource.newInstance((int)1024, (int)1);
        long expiryTimeStamp = 1000L;
        int masterKeyId = 1;
        long rmIdentifier = 1L;
        Priority priority = Priority.newInstance((int)1);
        long creationTime = 1000L;
        ContainerTokenIdentifier token = new ContainerTokenIdentifier(containerID, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, null, "", ContainerType.APPLICATION_MASTER);
        ContainerTokenIdentifier anotherToken = new ContainerTokenIdentifier();
        byte[] tokenContent = token.getBytes();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assert.assertEquals((Object)ContainerType.APPLICATION_MASTER, (Object)anotherToken.getContainerType());
        Assert.assertEquals((Object)ExecutionType.GUARANTEED, (Object)anotherToken.getExecutionType());
        token = new ContainerTokenIdentifier(containerID, 0, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, null, "", ContainerType.TASK, ExecutionType.OPPORTUNISTIC);
        anotherToken = new ContainerTokenIdentifier();
        tokenContent = token.getBytes();
        dib = new DataInputBuffer();
        dib.reset(tokenContent, tokenContent.length);
        anotherToken.readFields((DataInput)dib);
        Assert.assertEquals((Object)ContainerType.TASK, (Object)anotherToken.getContainerType());
        Assert.assertEquals((Object)ExecutionType.OPPORTUNISTIC, (Object)anotherToken.getExecutionType());
    }

    private byte[] writeInOldFormat(ContainerTokenIdentifier token, boolean withLogAggregation) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        ApplicationAttemptId applicationAttemptId = token.getContainerID().getApplicationAttemptId();
        ApplicationId applicationId = applicationAttemptId.getApplicationId();
        out.writeLong(applicationId.getClusterTimestamp());
        out.writeInt(applicationId.getId());
        out.writeInt(applicationAttemptId.getAttemptId());
        out.writeLong(token.getContainerID().getContainerId());
        out.writeUTF(token.getNmHostAddress());
        out.writeUTF(token.getApplicationSubmitter());
        out.writeInt(token.getResource().getMemory());
        out.writeInt(token.getResource().getVirtualCores());
        out.writeLong(token.getExpiryTimeStamp());
        out.writeInt(token.getMasterKeyId());
        out.writeLong(token.getRMIdentifier());
        out.writeInt(token.getPriority().getPriority());
        out.writeLong(token.getCreationTime());
        if (withLogAggregation) {
            if (token.getLogAggregationContext() == null) {
                out.writeInt(-1);
            } else {
                byte[] logAggregationContext = ((LogAggregationContextPBImpl)token.getLogAggregationContext()).getProto().toByteArray();
                out.writeInt(logAggregationContext.length);
                out.write(logAggregationContext);
            }
        }
        out.close();
        return baos.toByteArray();
    }

    private byte[] writeInOldFormat(NMTokenIdentifier token) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        ApplicationId applicationId = token.getApplicationAttemptId().getApplicationId();
        out.writeLong(applicationId.getClusterTimestamp());
        out.writeInt(applicationId.getId());
        out.writeInt(token.getApplicationAttemptId().getAttemptId());
        out.writeUTF(token.getNodeId().toString());
        out.writeUTF(token.getApplicationSubmitter());
        out.writeInt(token.getKeyId());
        out.close();
        return baos.toByteArray();
    }

    private byte[] writeInOldFormat(AMRMTokenIdentifier token) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        ApplicationId applicationId = token.getApplicationAttemptId().getApplicationId();
        out.writeLong(applicationId.getClusterTimestamp());
        out.writeInt(applicationId.getId());
        out.writeInt(token.getApplicationAttemptId().getAttemptId());
        out.writeInt(token.getKeyId());
        out.close();
        return baos.toByteArray();
    }
}

