/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.junit.Assert;

public class NodeLabelTestBase {
    public static void assertMapEquals(Map<NodeId, Set<String>> expected, ImmutableMap<NodeId, Set<String>> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (NodeId k : expected.keySet()) {
            Assert.assertTrue((boolean)actual.containsKey((Object)k));
            NodeLabelTestBase.assertCollectionEquals((Collection<String>)expected.get(k), (Collection)actual.get((Object)k));
        }
    }

    public static void assertLabelInfoMapEquals(Map<NodeId, Set<NodeLabel>> expected, ImmutableMap<NodeId, Set<NodeLabel>> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (NodeId k : expected.keySet()) {
            Assert.assertTrue((boolean)actual.containsKey((Object)k));
            NodeLabelTestBase.assertNLCollectionEquals((Collection<NodeLabel>)expected.get(k), (Collection)actual.get((Object)k));
        }
    }

    public static void assertLabelsToNodesEquals(Map<String, Set<NodeId>> expected, ImmutableMap<String, Set<NodeId>> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (String k : expected.keySet()) {
            Assert.assertTrue((boolean)actual.containsKey((Object)k));
            HashSet expectedS1 = new HashSet(expected.get(k));
            HashSet actualS2 = new HashSet((Collection)actual.get((Object)k));
            Assert.assertEquals(expectedS1, actualS2);
            Assert.assertTrue((boolean)expectedS1.containsAll(actualS2));
        }
    }

    public static ImmutableMap<String, Set<NodeId>> transposeNodeToLabels(Map<NodeId, Set<String>> mapNodeToLabels) {
        HashMap<String, HashSet<NodeId>> mapLabelsToNodes = new HashMap<String, HashSet<NodeId>>();
        for (Map.Entry<NodeId, Set<String>> entry : mapNodeToLabels.entrySet()) {
            NodeId node = entry.getKey();
            Set<String> setLabels = entry.getValue();
            for (String label : setLabels) {
                HashSet<NodeId> setNode = (HashSet<NodeId>)mapLabelsToNodes.get(label);
                if (setNode == null) {
                    setNode = new HashSet<NodeId>();
                }
                setNode.add(NodeId.newInstance((String)node.getHost(), (int)node.getPort()));
                mapLabelsToNodes.put(label, setNode);
            }
        }
        return ImmutableMap.copyOf(mapLabelsToNodes);
    }

    public static void assertMapContains(Map<NodeId, Set<String>> expected, ImmutableMap<NodeId, Set<String>> actual) {
        for (NodeId k : actual.keySet()) {
            Assert.assertTrue((boolean)expected.containsKey(k));
            NodeLabelTestBase.assertCollectionEquals((Collection<String>)expected.get(k), (Collection)actual.get((Object)k));
        }
    }

    public static void assertCollectionEquals(Collection<String> expected, Collection<String> actual) {
        if (expected == null) {
            Assert.assertNull(actual);
        } else {
            Assert.assertNotNull(actual);
        }
        HashSet<String> expectedSet = new HashSet<String>(expected);
        HashSet<String> actualSet = new HashSet<String>(actual);
        Assert.assertEquals(expectedSet, actualSet);
        Assert.assertTrue((boolean)expectedSet.containsAll(actualSet));
    }

    public static void assertNLCollectionEquals(Collection<NodeLabel> expected, Collection<NodeLabel> actual) {
        if (expected == null) {
            Assert.assertNull(actual);
        } else {
            Assert.assertNotNull(actual);
        }
        HashSet<NodeLabel> expectedSet = new HashSet<NodeLabel>(expected);
        HashSet<NodeLabel> actualSet = new HashSet<NodeLabel>(actual);
        Assert.assertEquals(expectedSet, actualSet);
        Assert.assertTrue((boolean)expectedSet.containsAll(actualSet));
    }

    public static <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    public static Set<NodeLabel> toNodeLabelSet(String ... nodeLabelsStr) {
        if (null == nodeLabelsStr) {
            return null;
        }
        HashSet<NodeLabel> labels = new HashSet<NodeLabel>();
        for (String label : nodeLabelsStr) {
            labels.add(NodeLabel.newInstance((String)label));
        }
        return labels;
    }

    public NodeId toNodeId(String str) {
        if (str.contains(":")) {
            int idx = str.indexOf(58);
            NodeId id = NodeId.newInstance((String)str.substring(0, idx), (int)Integer.parseInt(str.substring(idx + 1)));
            return id;
        }
        return NodeId.newInstance((String)str, (int)0);
    }

    public static void assertLabelsInfoToNodesEquals(Map<NodeLabel, Set<NodeId>> expected, ImmutableMap<NodeLabel, Set<NodeId>> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (NodeLabel k : expected.keySet()) {
            Assert.assertTrue((boolean)actual.containsKey((Object)k));
            HashSet expectedS1 = new HashSet(expected.get(k));
            HashSet actualS2 = new HashSet((Collection)actual.get((Object)k));
            Assert.assertEquals(expectedS1, actualS2);
            Assert.assertTrue((boolean)expectedS1.containsAll(actualS2));
        }
    }
}

