/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogDeletionService;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.tfile.LogAggregationTFileController;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAggregatedLogDeletionService {
    @Before
    public void closeFilesystems() throws IOException {
        FileSystem.closeAll();
    }

    @Test
    public void testDeletion() throws Exception {
        long now = System.currentTimeMillis();
        long toDeleteTime = now - 2000000L;
        long toKeepTime = now - 1500000L;
        String root = "mockfs://foo/";
        String remoteRootLogDir = root + "tmp/logs";
        String suffix = "logs";
        String newSuffix = LogAggregationUtils.getBucketSuffix() + suffix;
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        conf.set("fs.defaultFS", root);
        conf.set("yarn.log-aggregation-enable", "true");
        conf.set("yarn.log-aggregation.retain-seconds", "1800");
        conf.set("yarn.nodemanager.remote-app-log-dir", remoteRootLogDir);
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", suffix);
        conf.set("yarn.log-aggregation.file-formats", "TFile");
        conf.set(String.format("yarn.log-aggregation.file-controller.%s.class", "TFile"), LogAggregationTFileController.class.getName());
        Path rootPath = new Path(root);
        FileSystem rootFs = rootPath.getFileSystem(conf);
        FileSystem mockFs = ((FilterFileSystem)rootFs).getRawFileSystem();
        Path remoteRootLogPath = new Path(remoteRootLogDir);
        Path userDir = new Path(remoteRootLogPath, "me");
        FileStatus userDirStatus = new FileStatus(0L, true, 0, 0L, toKeepTime, userDir);
        Mockito.when((Object)mockFs.listStatus(remoteRootLogPath)).thenReturn((Object)new FileStatus[]{userDirStatus});
        ApplicationId appId1 = ApplicationId.newInstance((long)now, (int)1);
        Path suffixDir = new Path(userDir, newSuffix);
        FileStatus suffixDirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, suffixDir);
        Path bucketDir = LogAggregationUtils.getRemoteBucketDir((Path)remoteRootLogPath, (String)"me", (String)suffix, (ApplicationId)appId1);
        FileStatus bucketDirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, bucketDir);
        Path app1Dir = LogAggregationUtils.getRemoteAppLogDir((Path)remoteRootLogPath, (ApplicationId)appId1, (String)"me", (String)suffix);
        FileStatus app1DirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, app1Dir);
        ApplicationId appId2 = ApplicationId.newInstance((long)now, (int)2);
        Path app2Dir = LogAggregationUtils.getRemoteAppLogDir((Path)remoteRootLogPath, (ApplicationId)appId2, (String)"me", (String)suffix);
        FileStatus app2DirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, app2Dir);
        ApplicationId appId3 = ApplicationId.newInstance((long)now, (int)3);
        Path app3Dir = LogAggregationUtils.getRemoteAppLogDir((Path)remoteRootLogPath, (ApplicationId)appId3, (String)"me", (String)suffix);
        FileStatus app3DirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, app3Dir);
        ApplicationId appId4 = ApplicationId.newInstance((long)now, (int)4);
        Path app4Dir = LogAggregationUtils.getRemoteAppLogDir((Path)remoteRootLogPath, (ApplicationId)appId4, (String)"me", (String)suffix);
        FileStatus app4DirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, app4Dir);
        Mockito.when((Object)mockFs.listStatus(userDir)).thenReturn((Object)new FileStatus[]{suffixDirStatus});
        Mockito.when((Object)mockFs.listStatus(suffixDir)).thenReturn((Object)new FileStatus[]{bucketDirStatus});
        Mockito.when((Object)mockFs.listStatus(bucketDir)).thenReturn((Object)new FileStatus[]{app1DirStatus, app2DirStatus, app3DirStatus, app4DirStatus});
        Mockito.when((Object)mockFs.listStatus(app1Dir)).thenReturn((Object)new FileStatus[0]);
        Path app2Log1 = new Path(app2Dir, "host1");
        FileStatus app2Log1Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app2Log1);
        Path app2Log2 = new Path(app2Dir, "host2");
        FileStatus app2Log2Status = new FileStatus(10L, false, 1, 1L, toKeepTime, app2Log2);
        Mockito.when((Object)mockFs.listStatus(app2Dir)).thenReturn((Object)new FileStatus[]{app2Log1Status, app2Log2Status});
        Path app3Log1 = new Path(app3Dir, "host1");
        FileStatus app3Log1Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app3Log1);
        Path app3Log2 = new Path(app3Dir, "host2");
        FileStatus app3Log2Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app3Log2);
        Mockito.when((Object)mockFs.delete(app3Dir, true)).thenThrow(new Throwable[]{new AccessControlException("Injected Error\nStack Trace :(")});
        Mockito.when((Object)mockFs.listStatus(app3Dir)).thenReturn((Object)new FileStatus[]{app3Log1Status, app3Log2Status});
        Path app4Log1 = new Path(app4Dir, "host1");
        FileStatus app4Log1Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app4Log1);
        Path app4Log2 = new Path(app4Dir, "host2");
        FileStatus app4Log2Status = new FileStatus(10L, false, 1, 1L, toKeepTime, app4Log2);
        Mockito.when((Object)mockFs.listStatus(app4Dir)).thenReturn((Object)new FileStatus[]{app4Log1Status, app4Log2Status});
        final List<ApplicationId> finishedApplications = Collections.unmodifiableList(Arrays.asList(appId1, appId2, appId3));
        final List<ApplicationId> runningApplications = Collections.unmodifiableList(Arrays.asList(appId4));
        AggregatedLogDeletionService deletionService = new AggregatedLogDeletionService(){

            protected ApplicationClientProtocol createRMClient() throws IOException {
                try {
                    return TestAggregatedLogDeletionService.createMockRMClient(finishedApplications, runningApplications);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }

            protected void stopRMClient() {
            }
        };
        deletionService.init(conf);
        deletionService.start();
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)2000L))).delete(app1Dir, true);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)2000L).times(0))).delete(app2Dir, true);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)2000L))).delete(app3Dir, true);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)2000L).times(0))).delete(app4Dir, true);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)2000L))).delete(app4Log1, true);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)2000L).times(0))).delete(app4Log2, true);
        deletionService.stop();
    }

    @Test
    public void testRefreshLogRetentionSettings() throws Exception {
        long now = System.currentTimeMillis();
        long before2000Secs = now - 2000000L;
        long before50Secs = now - 50000L;
        String root = "mockfs://foo/";
        String remoteRootLogDir = root + "tmp/logs";
        String suffix = "logs";
        String newSuffix = LogAggregationUtils.getBucketSuffix() + suffix;
        final Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        conf.set("fs.defaultFS", root);
        conf.set("yarn.log-aggregation-enable", "true");
        conf.set("yarn.log-aggregation.retain-seconds", "1800");
        conf.set("yarn.log-aggregation.retain-check-interval-seconds", "1");
        conf.set("yarn.nodemanager.remote-app-log-dir", remoteRootLogDir);
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", suffix);
        conf.set("yarn.log-aggregation.file-formats", "TFile");
        conf.set(String.format("yarn.log-aggregation.file-controller.%s.class", "TFile"), LogAggregationTFileController.class.getName());
        Path rootPath = new Path(root);
        FileSystem rootFs = rootPath.getFileSystem(conf);
        FileSystem mockFs = ((FilterFileSystem)rootFs).getRawFileSystem();
        Path remoteRootLogPath = new Path(remoteRootLogDir);
        Path userDir = new Path(remoteRootLogPath, "me");
        FileStatus userDirStatus = new FileStatus(0L, true, 0, 0L, before50Secs, userDir);
        Mockito.when((Object)mockFs.listStatus(remoteRootLogPath)).thenReturn((Object)new FileStatus[]{userDirStatus});
        Path suffixDir = new Path(userDir, newSuffix);
        FileStatus suffixStatus = new FileStatus(0L, true, 0, 0L, before50Secs, suffixDir);
        ApplicationId appId1 = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Path app1Dir = LogAggregationUtils.getRemoteAppLogDir((Path)remoteRootLogPath, (ApplicationId)appId1, (String)"me", (String)suffix);
        Path bucketDir = LogAggregationUtils.getRemoteBucketDir((Path)remoteRootLogPath, (String)"me", (String)suffix, (ApplicationId)appId1);
        FileStatus bucketDirStatus = new FileStatus(0L, true, 0, 0L, before50Secs, bucketDir);
        FileStatus app1DirStatus = new FileStatus(0L, true, 0, 0L, before2000Secs, app1Dir);
        ApplicationId appId2 = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)2);
        Path app2Dir = LogAggregationUtils.getRemoteAppLogDir((Path)remoteRootLogPath, (ApplicationId)appId2, (String)"me", (String)suffix);
        FileStatus app2DirStatus = new FileStatus(0L, true, 0, 0L, before50Secs, app2Dir);
        Mockito.when((Object)mockFs.listStatus(userDir)).thenReturn((Object)new FileStatus[]{suffixStatus});
        Mockito.when((Object)mockFs.listStatus(suffixDir)).thenReturn((Object)new FileStatus[]{bucketDirStatus});
        Mockito.when((Object)mockFs.listStatus(bucketDir)).thenReturn((Object)new FileStatus[]{app1DirStatus, app2DirStatus});
        Path app1Log1 = new Path(app1Dir, "host1");
        FileStatus app1Log1Status = new FileStatus(10L, false, 1, 1L, before2000Secs, app1Log1);
        Mockito.when((Object)mockFs.listStatus(app1Dir)).thenReturn((Object)new FileStatus[]{app1Log1Status});
        Path app2Log1 = new Path(app2Dir, "host1");
        FileStatus app2Log1Status = new FileStatus(10L, false, 1, 1L, before50Secs, app2Log1);
        Mockito.when((Object)mockFs.listStatus(app2Dir)).thenReturn((Object)new FileStatus[]{app2Log1Status});
        final List<ApplicationId> finishedApplications = Collections.unmodifiableList(Arrays.asList(appId1, appId2));
        AggregatedLogDeletionService deletionSvc = new AggregatedLogDeletionService(){

            protected Configuration createConf() {
                return conf;
            }

            protected ApplicationClientProtocol createRMClient() throws IOException {
                try {
                    return TestAggregatedLogDeletionService.createMockRMClient(finishedApplications, null);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }

            protected void stopRMClient() {
            }
        };
        deletionSvc.init(conf);
        deletionSvc.start();
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)10000L))).delete(app1Dir, true);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)3000L).times(0))).delete(app2Dir, true);
        conf.set("yarn.log-aggregation.retain-seconds", "50");
        conf.set("yarn.log-aggregation.retain-check-interval-seconds", "2");
        Assert.assertTrue((2000L != deletionSvc.getCheckIntervalMsecs() ? 1 : 0) != 0);
        deletionSvc.refreshLogRetentionSettings();
        Assert.assertTrue((2000L == deletionSvc.getCheckIntervalMsecs() ? 1 : 0) != 0);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)10000L))).delete(app2Dir, true);
        deletionSvc.stop();
    }

    @Test
    public void testCheckInterval() throws Exception {
        long RETENTION_SECS = 864000L;
        long now = System.currentTimeMillis();
        long toDeleteTime = now - RETENTION_SECS * 1000L;
        String root = "mockfs://foo/";
        String remoteRootLogDir = root + "tmp/logs";
        String suffix = "logs";
        String newSuffix = LogAggregationUtils.getBucketSuffix() + suffix;
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        conf.set("fs.defaultFS", root);
        conf.set("yarn.log-aggregation-enable", "true");
        conf.set("yarn.log-aggregation.retain-seconds", "864000");
        conf.set("yarn.log-aggregation.retain-check-interval-seconds", "1");
        conf.set("yarn.nodemanager.remote-app-log-dir", remoteRootLogDir);
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", suffix);
        conf.set("yarn.log-aggregation.file-formats", "TFile");
        conf.set(String.format("yarn.log-aggregation.file-controller.%s.class", "TFile"), LogAggregationTFileController.class.getName());
        FileSystem.closeAll();
        Path rootPath = new Path(root);
        FileSystem rootFs = rootPath.getFileSystem(conf);
        FileSystem mockFs = ((FilterFileSystem)rootFs).getRawFileSystem();
        Path remoteRootLogPath = new Path(remoteRootLogDir);
        Path userDir = new Path(remoteRootLogPath, "me");
        FileStatus userDirStatus = new FileStatus(0L, true, 0, 0L, now, userDir);
        Mockito.when((Object)mockFs.listStatus(remoteRootLogPath)).thenReturn((Object)new FileStatus[]{userDirStatus});
        ApplicationId appId1 = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Path suffixDir = new Path(userDir, newSuffix);
        FileStatus suffixDirStatus = new FileStatus(0L, true, 0, 0L, now, suffixDir);
        Path bucketDir = LogAggregationUtils.getRemoteBucketDir((Path)remoteRootLogPath, (String)"me", (String)suffix, (ApplicationId)appId1);
        Path app1Dir = LogAggregationUtils.getRemoteAppLogDir((Path)remoteRootLogPath, (ApplicationId)appId1, (String)"me", (String)suffix);
        FileStatus bucketDirStatus = new FileStatus(0L, true, 0, 0L, now, bucketDir);
        FileStatus app1DirStatus = new FileStatus(0L, true, 0, 0L, now, app1Dir);
        Mockito.when((Object)mockFs.listStatus(userDir)).thenReturn((Object)new FileStatus[]{suffixDirStatus});
        Mockito.when((Object)mockFs.listStatus(suffixDir)).thenReturn((Object)new FileStatus[]{bucketDirStatus});
        Mockito.when((Object)mockFs.listStatus(bucketDir)).thenReturn((Object)new FileStatus[]{app1DirStatus});
        Path app1Log1 = new Path(app1Dir, "host1");
        FileStatus app1Log1Status = new FileStatus(10L, false, 1, 1L, now, app1Log1);
        Mockito.when((Object)mockFs.listStatus(app1Dir)).thenReturn((Object)new FileStatus[]{app1Log1Status});
        final List<ApplicationId> finishedApplications = Collections.unmodifiableList(Arrays.asList(appId1));
        AggregatedLogDeletionService deletionSvc = new AggregatedLogDeletionService(){

            protected ApplicationClientProtocol createRMClient() throws IOException {
                try {
                    return TestAggregatedLogDeletionService.createMockRMClient(finishedApplications, null);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }

            protected void stopRMClient() {
            }
        };
        deletionSvc.init(conf);
        deletionSvc.start();
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)10000L).atLeast(4))).listStatus((Path)Mockito.any(Path.class));
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).delete(app1Dir, true);
        bucketDirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, bucketDir);
        app1DirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, app1Dir);
        app1Log1Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app1Log1);
        Mockito.when((Object)mockFs.listStatus(userDir)).thenReturn((Object)new FileStatus[]{suffixDirStatus});
        Mockito.when((Object)mockFs.listStatus(suffixDir)).thenReturn((Object)new FileStatus[]{bucketDirStatus});
        Mockito.when((Object)mockFs.listStatus(bucketDir)).thenReturn((Object)new FileStatus[]{app1DirStatus});
        Mockito.when((Object)mockFs.listStatus(app1Dir)).thenReturn((Object)new FileStatus[]{app1Log1Status});
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((long)10000L))).delete(app1Dir, true);
        deletionSvc.stop();
    }

    @Test
    public void testRobustLogDeletion() throws Exception {
        long RETENTION_SECS = 864000L;
        String root = "mockfs://foo/";
        String remoteRootLogDir = root + "tmp/logs";
        String suffix = "logs";
        String newSuffix = LogAggregationUtils.getBucketSuffix() + suffix;
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        conf.set("fs.defaultFS", root);
        conf.set("yarn.log-aggregation-enable", "true");
        conf.set("yarn.log-aggregation.retain-seconds", "864000");
        conf.set("yarn.log-aggregation.retain-check-interval-seconds", "1");
        conf.set("yarn.nodemanager.remote-app-log-dir", remoteRootLogDir);
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", suffix);
        conf.set("yarn.log-aggregation.file-formats", "TFile");
        conf.set(String.format("yarn.log-aggregation.file-controller.%s.class", "TFile"), LogAggregationTFileController.class.getName());
        FileSystem.closeAll();
        Path rootPath = new Path(root);
        FileSystem rootFs = rootPath.getFileSystem(conf);
        FileSystem mockFs = ((FilterFileSystem)rootFs).getRawFileSystem();
        Path remoteRootLogPath = new Path(remoteRootLogDir);
        Path userDir = new Path(remoteRootLogPath, "me");
        Path suffixDir = new Path(userDir, newSuffix);
        FileStatus userDirStatus = new FileStatus(0L, true, 0, 0L, 0L, userDir);
        FileStatus suffixStatus = new FileStatus(0L, true, 0, 0L, 0L, suffixDir);
        Path bucketDir = new Path(suffixDir, String.valueOf(0));
        FileStatus bucketDirStatus = new FileStatus(0L, true, 0, 0L, 0L, bucketDir);
        Mockito.when((Object)mockFs.listStatus(remoteRootLogPath)).thenReturn((Object)new FileStatus[]{userDirStatus});
        Mockito.when((Object)mockFs.listStatus(userDir)).thenReturn((Object)new FileStatus[]{suffixStatus});
        Mockito.when((Object)mockFs.listStatus(suffixDir)).thenReturn((Object)new FileStatus[]{bucketDirStatus});
        ApplicationId appId1 = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Path app1Dir = new Path(bucketDir, appId1.toString());
        FileStatus app1DirStatus = new FileStatus(0L, true, 0, 0L, 0L, app1Dir);
        ApplicationId appId2 = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)2);
        Path app2Dir = new Path(bucketDir, "application_a");
        FileStatus app2DirStatus = new FileStatus(0L, true, 0, 0L, 0L, app2Dir);
        ApplicationId appId3 = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)3);
        Path app3Dir = new Path(bucketDir, appId3.toString());
        FileStatus app3DirStatus = new FileStatus(0L, true, 0, 0L, 0L, app3Dir);
        Mockito.when((Object)mockFs.listStatus(bucketDir)).thenReturn((Object)new FileStatus[]{app1DirStatus, app2DirStatus, app3DirStatus});
        Mockito.when((Object)mockFs.listStatus(app2Dir)).thenReturn((Object)new FileStatus[0]);
        Mockito.when((Object)mockFs.listStatus(app1Dir)).thenThrow(new Throwable[]{new RuntimeException("Should Be Caught and Logged")});
        Path app3Log3 = new Path(app3Dir, "host1");
        FileStatus app3Log3Status = new FileStatus(10L, false, 1, 1L, 0L, app3Log3);
        Mockito.when((Object)mockFs.listStatus(app3Dir)).thenReturn((Object)new FileStatus[]{app3Log3Status});
        List<ApplicationId> finishedApplications = Collections.unmodifiableList(Arrays.asList(appId1, appId3));
        ApplicationClientProtocol rmClient = TestAggregatedLogDeletionService.createMockRMClient(finishedApplications, null);
        AggregatedLogDeletionService.LogDeletionTask deletionTask = new AggregatedLogDeletionService.LogDeletionTask(conf, 864000L, rmClient);
        deletionTask.run();
        ((FileSystem)Mockito.verify((Object)mockFs)).delete(app3Dir, true);
    }

    private static ApplicationClientProtocol createMockRMClient(List<ApplicationId> finishedApplicaitons, List<ApplicationId> runningApplications) throws Exception {
        GetApplicationReportResponse response;
        GetApplicationReportRequest request;
        ApplicationClientProtocol mockProtocol = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
        if (finishedApplicaitons != null && !finishedApplicaitons.isEmpty()) {
            for (ApplicationId appId : finishedApplicaitons) {
                request = GetApplicationReportRequest.newInstance((ApplicationId)appId);
                response = TestAggregatedLogDeletionService.createApplicationReportWithFinishedApplication();
                Mockito.when((Object)mockProtocol.getApplicationReport(request)).thenReturn((Object)response);
            }
        }
        if (runningApplications != null && !runningApplications.isEmpty()) {
            for (ApplicationId appId : runningApplications) {
                request = GetApplicationReportRequest.newInstance((ApplicationId)appId);
                response = TestAggregatedLogDeletionService.createApplicationReportWithRunningApplication();
                Mockito.when((Object)mockProtocol.getApplicationReport(request)).thenReturn((Object)response);
            }
        }
        return mockProtocol;
    }

    private static GetApplicationReportResponse createApplicationReportWithRunningApplication() {
        ApplicationReport report = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        Mockito.when((Object)report.getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        GetApplicationReportResponse response = (GetApplicationReportResponse)Mockito.mock(GetApplicationReportResponse.class);
        Mockito.when((Object)response.getApplicationReport()).thenReturn((Object)report);
        return response;
    }

    private static GetApplicationReportResponse createApplicationReportWithFinishedApplication() {
        ApplicationReport report = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        Mockito.when((Object)report.getYarnApplicationState()).thenReturn((Object)YarnApplicationState.FINISHED);
        GetApplicationReportResponse response = (GetApplicationReportResponse)Mockito.mock(GetApplicationReportResponse.class);
        Mockito.when((Object)response.getApplicationReport()).thenReturn((Object)report);
        return response;
    }

    static class MockFileSystem
    extends FilterFileSystem {
        MockFileSystem() {
            super((FileSystem)Mockito.mock(FileSystem.class));
        }

        public void initialize(URI name, Configuration conf) throws IOException {
        }
    }
}

