/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;

public class DrainDispatcher
extends AsyncDispatcher {
    private volatile boolean drained = false;
    private final BlockingQueue<Event> queue;
    private final Object mutex;

    public DrainDispatcher() {
        this(new LinkedBlockingQueue<Event>());
    }

    public DrainDispatcher(BlockingQueue<Event> eventQueue) {
        super(eventQueue);
        this.queue = eventQueue;
        this.mutex = this;
        this.disableExitOnDispatchException();
    }

    public void waitForEventThreadToWait() {
        while (!this.isEventThreadWaiting()) {
            Thread.yield();
        }
    }

    public void await() {
        while (!this.isDrained()) {
            Thread.yield();
        }
    }

    Runnable createThread() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!DrainDispatcher.this.isStopped() && !Thread.currentThread().isInterrupted()) {
                    Event event;
                    Object object = DrainDispatcher.this.mutex;
                    synchronized (object) {
                        DrainDispatcher.this.drained = DrainDispatcher.this.queue.isEmpty();
                    }
                    try {
                        event = (Event)DrainDispatcher.this.queue.take();
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                    if (event == null) continue;
                    DrainDispatcher.this.dispatch(event);
                }
            }
        };
    }

    public EventHandler<Event> getEventHandler() {
        final EventHandler actual = super.getEventHandler();
        return new EventHandler<Event>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Event event) {
                Object object = DrainDispatcher.this.mutex;
                synchronized (object) {
                    actual.handle(event);
                    DrainDispatcher.this.drained = false;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDrained() {
        Object object = this.mutex;
        synchronized (object) {
            return this.drained;
        }
    }
}

