/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.CollectorInfo;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.client.api.impl.TimelineV2ClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTimelineClientV2Impl {
    private static final Logger LOG = LoggerFactory.getLogger(TestTimelineClientV2Impl.class);
    private TestV2TimelineClient client;
    private static final long TIME_TO_SLEEP = 150L;
    private static final String EXCEPTION_MSG = "Exception in the content";
    @Rule
    public TestName currTestName = new TestName();
    private YarnConfiguration conf;

    @Before
    public void setup() {
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.timeline-service.enabled", true);
        this.conf.setFloat("yarn.timeline-service.version", 2.0f);
        this.conf.setInt("yarn.timeline-service.timeline-client.number-of-async-entities-to-merge", 3);
        if (!this.currTestName.getMethodName().contains("testRetryOnConnectionFailure")) {
            this.client = this.createTimelineClient(this.conf);
        }
    }

    private TestV2TimelineClient createTimelineClient(YarnConfiguration config) {
        ApplicationId id = ApplicationId.newInstance((long)0L, (int)0);
        TestV2TimelineClient tc = new TestV2TimelineClient(id);
        tc.init((Configuration)config);
        tc.start();
        return tc;
    }

    @Test
    public void testExceptionMultipleRetry() {
        Throwable cause;
        TestV2TimelineClientForExceptionHandling c = new TestV2TimelineClientForExceptionHandling(ApplicationId.newInstance((long)0L, (int)0));
        int maxRetries = 2;
        this.conf.setInt("yarn.timeline-service.client.max-retries", maxRetries);
        c.init((Configuration)this.conf);
        c.start();
        c.setTimelineCollectorInfo(CollectorInfo.newInstance((String)"localhost:12345"));
        try {
            c.putEntities(new TimelineEntity[]{new TimelineEntity()});
        }
        catch (IOException e) {
            Assert.fail((String)"YARN exception is expected");
        }
        catch (YarnException e) {
            cause = e.getCause();
            Assert.assertTrue((String)"IOException is expected", (boolean)(cause instanceof IOException));
            Assert.assertTrue((String)"YARN exception is expected", (boolean)cause.getMessage().contains("TimelineClient has reached to max retry times : " + maxRetries));
        }
        c.setThrowYarnException(true);
        try {
            c.putEntities(new TimelineEntity[]{new TimelineEntity()});
        }
        catch (IOException e) {
            Assert.fail((String)"YARN exception is expected");
        }
        catch (YarnException e) {
            cause = e.getCause();
            Assert.assertTrue((String)"YARN exception is expected", (boolean)(cause instanceof YarnException));
            Assert.assertTrue((String)"YARN exception is expected", (boolean)cause.getMessage().contains(EXCEPTION_MSG));
        }
        c.stop();
    }

    @Test
    public void testPostEntities() throws Exception {
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected");
        }
    }

    @Test
    public void testASyncCallMerge() throws Exception {
        this.client.setSleepBeforeReturn(true);
        try {
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
            Thread.sleep(75L);
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("2")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("3")});
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected");
        }
        for (int i = 0; i < 4 && this.client.getNumOfTimelineEntitiesPublished() != 2; ++i) {
            Thread.sleep(150L);
        }
        Assert.assertEquals((String)"two merged TimelineEntities needs to be published", (long)2L, (long)this.client.getNumOfTimelineEntitiesPublished());
        TimelineEntities secondPublishedEntities = this.client.getPublishedEntities(1);
        Assert.assertEquals((String)"Merged TimelineEntities Object needs to 2 TimelineEntity Object", (long)2L, (long)secondPublishedEntities.getEntities().size());
        Assert.assertEquals((String)"Order of Async Events Needs to be FIFO", (Object)"2", (Object)((TimelineEntity)secondPublishedEntities.getEntities().get(0)).getId());
        Assert.assertEquals((String)"Order of Async Events Needs to be FIFO", (Object)"3", (Object)((TimelineEntity)secondPublishedEntities.getEntities().get(1)).getId());
    }

    @Test
    public void testSyncCall() throws Exception {
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("2")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("3")});
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("4")});
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected");
        }
        for (int i = 0; i < 4 && this.client.getNumOfTimelineEntitiesPublished() != 3; ++i) {
            Thread.sleep(150L);
        }
        this.printReceivedEntities();
        boolean asyncPushesMerged = this.client.getNumOfTimelineEntitiesPublished() == 3;
        int lastPublishIndex = asyncPushesMerged ? 2 : 3;
        TimelineEntities firstPublishedEntities = this.client.getPublishedEntities(0);
        Assert.assertEquals((String)"sync entities should not be merged with async", (long)1L, (long)firstPublishedEntities.getEntities().size());
        if (asyncPushesMerged) {
            TimelineEntities secondPublishedEntities = this.client.getPublishedEntities(1);
            Assert.assertEquals((String)"async entities should be merged before publishing sync", (long)2L, (long)secondPublishedEntities.getEntities().size());
            Assert.assertEquals((String)"Order of Async Events Needs to be FIFO", (Object)"2", (Object)((TimelineEntity)secondPublishedEntities.getEntities().get(0)).getId());
            Assert.assertEquals((String)"Order of Async Events Needs to be FIFO", (Object)"3", (Object)((TimelineEntity)secondPublishedEntities.getEntities().get(1)).getId());
        } else {
            TimelineEntities secondAsyncPublish = this.client.getPublishedEntities(1);
            Assert.assertEquals((String)"Order of Async Events Needs to be FIFO", (Object)"2", (Object)((TimelineEntity)secondAsyncPublish.getEntities().get(0)).getId());
            TimelineEntities thirdAsyncPublish = this.client.getPublishedEntities(2);
            Assert.assertEquals((String)"Order of Async Events Needs to be FIFO", (Object)"3", (Object)((TimelineEntity)thirdAsyncPublish.getEntities().get(0)).getId());
        }
        TimelineEntities thirdPublishedEntities = this.client.getPublishedEntities(lastPublishIndex);
        Assert.assertEquals((String)"sync entities had to be published at the last", (long)1L, (long)thirdPublishedEntities.getEntities().size());
        Assert.assertEquals((String)"Expected last sync Event is not proper", (Object)"4", (Object)((TimelineEntity)thirdPublishedEntities.getEntities().get(0)).getId());
    }

    @Test
    public void testExceptionCalls() throws Exception {
        this.client.setThrowYarnException(true);
        try {
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
        }
        catch (YarnException e) {
            Assert.fail((String)"Async calls are not expected to throw exception");
        }
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("2")});
            Assert.fail((String)"Sync calls are expected to throw exception");
        }
        catch (YarnException e) {
            Assert.assertEquals((String)"Same exception needs to be thrown", (Object)"ActualException", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testConfigurableNumberOfMerges() throws Exception {
        this.client.setSleepBeforeReturn(true);
        try {
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("2")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("3")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("4")});
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("5")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("6")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("7")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("8")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("9")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("10")});
        }
        catch (YarnException e) {
            Assert.fail((String)"No exception expected");
        }
        Thread.sleep(300L);
        this.printReceivedEntities();
        for (TimelineEntities publishedEntities : this.client.publishedEntities) {
            Assert.assertTrue((String)("Number of entities should not be greater than 3 for each publish, but was " + publishedEntities.getEntities().size()), (publishedEntities.getEntities().size() <= 3 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetTimelineToken() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Assert.assertEquals((long)0L, (long)ugi.getTokens().size());
        Assert.assertNull((String)"Timeline token in v2 client should not be set", (Object)this.client.currentTimelineToken);
        Token token = Token.newInstance((byte[])new byte[0], (String)"kind", (byte[])new byte[0], (String)"service");
        this.client.setTimelineCollectorInfo(CollectorInfo.newInstance(null, (Token)token));
        Assert.assertNull((String)"Timeline token in v2 client should not be set as token kind is unexepcted.", (Object)this.client.currentTimelineToken);
        Assert.assertEquals((long)0L, (long)ugi.getTokens().size());
        token = Token.newInstance((byte[])new byte[0], (String)TimelineDelegationTokenIdentifier.KIND_NAME.toString(), (byte[])new byte[0], null);
        this.client.setTimelineCollectorInfo(CollectorInfo.newInstance(null, (Token)token));
        Assert.assertNull((String)"Timeline token in v2 client should not be set as serice is not set.", (Object)this.client.currentTimelineToken);
        Assert.assertEquals((long)0L, (long)ugi.getTokens().size());
        TimelineDelegationTokenIdentifier ident = new TimelineDelegationTokenIdentifier(new Text(ugi.getUserName()), new Text("renewer"), null);
        ident.setSequenceNumber(1);
        token = Token.newInstance((byte[])ident.getBytes(), (String)TimelineDelegationTokenIdentifier.KIND_NAME.toString(), (byte[])new byte[0], (String)"localhost:1234");
        this.client.setTimelineCollectorInfo(CollectorInfo.newInstance(null, (Token)token));
        Assert.assertEquals((long)1L, (long)ugi.getTokens().size());
        Assert.assertNotNull((String)"Timeline token should be set in v2 client.", (Object)this.client.currentTimelineToken);
        Assert.assertEquals((Object)token, (Object)this.client.currentTimelineToken);
        ident.setSequenceNumber(20);
        Token newToken = Token.newInstance((byte[])ident.getBytes(), (String)TimelineDelegationTokenIdentifier.KIND_NAME.toString(), (byte[])new byte[0], (String)"localhost:1234");
        this.client.setTimelineCollectorInfo(CollectorInfo.newInstance(null, (Token)newToken));
        Assert.assertEquals((long)1L, (long)ugi.getTokens().size());
        Assert.assertNotEquals((Object)token, (Object)this.client.currentTimelineToken);
        Assert.assertEquals((Object)newToken, (Object)this.client.currentTimelineToken);
    }

    @Test
    public void testAfterStop() throws Exception {
        this.client.setSleepBeforeReturn(true);
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
            for (int i = 2; i < 20; ++i) {
                this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("" + i)});
            }
            this.client.stop();
            try {
                this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("50")});
                Assert.fail((String)"Exception expected");
            }
            catch (YarnException i) {}
        }
        catch (YarnException e) {
            Assert.fail((String)"No exception expected");
        }
        for (int i = 0; i < 5; ++i) {
            TimelineEntities publishedEntities = (TimelineEntities)this.client.publishedEntities.get(this.client.publishedEntities.size() - 1);
            TimelineEntity timelineEntity = (TimelineEntity)publishedEntities.getEntities().get(publishedEntities.getEntities().size() - 1);
            if (timelineEntity.getId().equals("19")) continue;
            Thread.sleep(300L);
        }
        this.printReceivedEntities();
        TimelineEntities publishedEntities = (TimelineEntities)this.client.publishedEntities.get(this.client.publishedEntities.size() - 1);
        TimelineEntity timelineEntity = (TimelineEntity)publishedEntities.getEntities().get(publishedEntities.getEntities().size() - 1);
        Assert.assertEquals((String)"", (Object)"19", (Object)timelineEntity.getId());
    }

    private void printReceivedEntities() {
        for (int i = 0; i < this.client.getNumOfTimelineEntitiesPublished(); ++i) {
            TimelineEntities publishedEntities = this.client.getPublishedEntities(i);
            StringBuilder entitiesPerPublish = new StringBuilder();
            for (TimelineEntity entity : publishedEntities.getEntities()) {
                entitiesPerPublish.append(entity.getId());
                entitiesPerPublish.append(",");
            }
            LOG.info("Entities Published @ index " + i + " : " + entitiesPerPublish.toString());
        }
    }

    private static TimelineEntity generateEntity(String id) {
        TimelineEntity entity = new TimelineEntity();
        entity.setId(id);
        entity.setType("testEntity");
        entity.setCreatedTime(Long.valueOf(System.currentTimeMillis()));
        return entity;
    }

    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    private class TestV2TimelineClient
    extends TestV2TimelineClientForExceptionHandling {
        private boolean sleepBeforeReturn;
        private List<TimelineEntities> publishedEntities;

        public TimelineEntities getPublishedEntities(int putIndex) {
            Assert.assertTrue((String)"Not So many entities Published", (putIndex < this.publishedEntities.size() ? 1 : 0) != 0);
            return this.publishedEntities.get(putIndex);
        }

        public void setSleepBeforeReturn(boolean sleepBeforeReturn) {
            this.sleepBeforeReturn = sleepBeforeReturn;
        }

        public int getNumOfTimelineEntitiesPublished() {
            return this.publishedEntities.size();
        }

        public TestV2TimelineClient(ApplicationId id) {
            super(id);
            this.publishedEntities = new ArrayList<TimelineEntities>();
        }

        protected void putObjects(String path, MultivaluedMap<String, String> params, Object obj) throws IOException, YarnException {
            if (this.isThrowYarnException()) {
                throw new YarnException("ActualException");
            }
            this.publishedEntities.add((TimelineEntities)obj);
            if (this.sleepBeforeReturn) {
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class TestV2TimelineClientForExceptionHandling
    extends TimelineV2ClientImpl {
        private boolean throwYarnException;

        public TestV2TimelineClientForExceptionHandling(ApplicationId id) {
            super(id);
        }

        public void setThrowYarnException(boolean throwYarnException) {
            this.throwYarnException = throwYarnException;
        }

        public boolean isThrowYarnException() {
            return this.throwYarnException;
        }

        protected void putObjects(URI base, String path, MultivaluedMap<String, String> params, Object obj) throws IOException, YarnException {
            if (this.throwYarnException) {
                throw new YarnException(TestTimelineClientV2Impl.EXCEPTION_MSG);
            }
            throw new IOException("Failed to get the response from the timeline server.");
        }
    }
}

