/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller.nodelocal;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.LogToolUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationDFSException;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.nodelocal.NodeLocalAggregatedLogsBlock;
import org.apache.hadoop.yarn.logaggregation.filecontroller.nodelocal.NodeLocalMetadataReader;
import org.apache.hadoop.yarn.logaggregation.filecontroller.nodelocal.NodeLocalMetadataWriter;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAggregationNodeLocalTFileController
extends LogAggregationFileController {
    private static final Logger LOG = LoggerFactory.getLogger(LogAggregationNodeLocalTFileController.class);
    private AggregatedLogFormat.LogWriter writer;
    private TFileLogReader tfReader = null;
    private NodeLocalMetadataWriter nodeLocalMetadataWriter;
    private NodeLocalMetadataReader nodeLocalMetadataReader;
    private Path nodeLocalMetadataDir;
    private String nodeLocalMetadataDirPrefix;

    @Override
    protected void extractRemoteRootLogDir() {
        String remoteDir = this.conf.get("yarn.log-aggregation.nodeLocal.remote-app-log-dir", "/var/mapr/local/%s/mapred/nodeManager/logs/");
        String nodeId = this.conf.get("yarn.node-local-log-aggregation.node-id");
        if (nodeId == null || nodeId.isEmpty()) {
            return;
        }
        if (nodeId.contains(":")) {
            nodeId = nodeId.substring(0, nodeId.indexOf(":"));
        }
        this.remoteRootLogDir = new Path(String.format(remoteDir, nodeId));
    }

    @Override
    protected void extractRemoteRootLogDirSuffix() {
        this.remoteRootLogDirSuffix = this.conf.get("yarn.nodemanager.remote-app-log-dir-suffix", "logs");
    }

    @Override
    public void initInternal(Configuration conf) {
        this.nodeLocalMetadataWriter = new NodeLocalMetadataWriter(conf);
        this.nodeLocalMetadataReader = new NodeLocalMetadataReader(conf);
        this.nodeLocalMetadataDir = new Path(conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        this.nodeLocalMetadataDirPrefix = conf.get("yarn.node-local-log-aggregation.metadata-path", "logsMeta");
    }

    @Override
    public void createAppDir(final String user, final ApplicationId appId, UserGroupInformation userUgi) {
        try {
            userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        FileSystem remoteFS = LogAggregationNodeLocalTFileController.this.getFileSystem(LogAggregationNodeLocalTFileController.this.conf);
                        Path appDir = LogAggregationNodeLocalTFileController.this.getRemoteNodeLogFileForAppForNodeLocalAggregator(appId, user);
                        appDir = appDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
                        if (!LogAggregationNodeLocalTFileController.this.checkExists(remoteFS, appDir, APP_DIR_PERMISSIONS)) {
                            LogAggregationNodeLocalTFileController.this.createDir(remoteFS, appDir, APP_DIR_PERMISSIONS);
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Failed to setup application log directory for " + appId, (Throwable)e);
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                throw new YarnRuntimeException((Throwable)((RemoteException)e).unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class}));
            }
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    @Override
    public void initializeWriter(LogAggregationFileControllerContext context) throws IOException {
        this.writer = new AggregatedLogFormat.LogWriter();
        this.writer.initialize(this.conf, context.getRemoteNodeTmpLogFileForApp(), context.getUserUgi());
        this.writer.writeApplicationACLs(context.getAppAcls());
        this.writer.writeApplicationOwner(context.getUserUgi().getShortUserName());
    }

    @Override
    public void closeWriter() throws LogAggregationDFSException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (DSQuotaExceededException e) {
                throw new LogAggregationDFSException(e);
            }
            finally {
                this.writer = null;
            }
        }
    }

    @Override
    public void write(AggregatedLogFormat.LogKey logKey, AggregatedLogFormat.LogValue logValue) throws IOException {
        this.writer.append(logKey, logValue);
    }

    @Override
    public void postWrite(final LogAggregationFileControllerContext record) throws Exception {
        try {
            this.nodeLocalMetadataWriter.write(record.getAppId(), record.getNodeId(), new ArrayList<ContainerId>(record.getUploadedContainersList()), record.getUserUgi().getUserName());
        }
        catch (IOException e) {
            LOG.error("Failed to write metadata info for " + record.getAppId(), (Throwable)e);
        }
        if (record.isUploadedLogsInThisCycle() && record.isLogAggregationInRolling()) {
            this.cleanOldLogs(record.getRemoteNodeLogFileForApp(), record.getNodeId(), record.getUserUgi());
            record.increcleanupOldLogTimes();
        }
        this.closeWriter();
        final Path renamedPath = record.getRollingMonitorInterval() <= 0L ? record.getRemoteNodeLogFileForApp() : new Path(record.getRemoteNodeLogFileForApp().getParent(), record.getRemoteNodeLogFileForApp().getName() + "_" + record.getLogUploadTimeStamp());
        final boolean rename = record.isUploadedLogsInThisCycle();
        try {
            record.getUserUgi().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    FileSystem remoteFS = record.getRemoteNodeLogFileForApp().getFileSystem(LogAggregationNodeLocalTFileController.this.conf);
                    if (rename) {
                        remoteFS.rename(record.getRemoteNodeTmpLogFileForApp(), renamedPath);
                    } else {
                        remoteFS.delete(record.getRemoteNodeTmpLogFileForApp(), false);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error("Failed to move temporary log file to final location: [" + record.getRemoteNodeTmpLogFileForApp() + "] to [" + renamedPath + "]", (Throwable)e);
            throw new Exception("Log uploaded failed for Application: " + record.getAppId() + " in NodeManager: " + LogAggregationUtils.getNodeString(record.getNodeId()) + " at " + Times.format(record.getLogUploadTimeStamp()) + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean readAggregatedLogs(ContainerLogsRequest logRequest, OutputStream os) throws IOException {
        findLogs = false;
        createPrintStream = os == null;
        appId = logRequest.getAppId();
        nodeId = logRequest.getNodeId();
        logTypes = new ArrayList<String>();
        if (logRequest.getLogTypes() != null && !logRequest.getLogTypes().isEmpty()) {
            logTypes.addAll(logRequest.getLogTypes());
        }
        getAllContainers = (containerIdStr = logRequest.getContainerId()) == null || containerIdStr.isEmpty() != false;
        size = logRequest.getBytes();
        nodeFiles = this.nodeLocalMetadataReader.getLogsDirsFileStatusListForApp(appId, logRequest.getAppOwner());
        buf = new byte[65535];
        block7: for (FileStatus thisNodeFile : nodeFiles) {
            nodeName = nodeId;
            if (nodeName != null && nodeName.contains(":")) {
                nodeName = nodeName.substring(0, nodeId.indexOf(":"));
            }
            logName = thisNodeFile.getPath().getName();
            if (nodeId != null && !nodeId.isEmpty() && !thisNodeFile.getPath().toString().contains(nodeName) || logName.endsWith(".tmp")) continue;
            reader = null;
            try {
                reader = new AggregatedLogFormat.LogReader(this.conf, thisNodeFile.getPath());
                key = new AggregatedLogFormat.LogKey();
                valueStream = reader.next(key);
                while (valueStream != null) {
                    if (getAllContainers || key.toString().equals(containerIdStr)) {
                        if (createPrintStream) {
                            os = LogToolUtils.createPrintStream(logRequest.getOutputLocalDir(), nodeName, key.toString());
                        }
                        try {
                            try {
                                block9: while (true) {
                                    fileType = valueStream.readUTF();
                                    fileLengthStr = valueStream.readUTF();
                                    fileLength = Long.parseLong(fileLengthStr);
                                    if (logTypes == null || logTypes.isEmpty() || logTypes.contains(fileType)) {
                                        LogToolUtils.outputContainerLog(key.toString(), nodeName, fileType, fileLength, size, Times.format(thisNodeFile.getModificationTime()), valueStream, os, buf, ContainerLogAggregationType.AGGREGATED);
                                        b = this.aggregatedLogSuffix(fileType).getBytes(Charset.forName("UTF-8"));
                                        os.write(b, 0, b.length);
                                        findLogs = true;
                                        continue;
                                    }
                                    totalSkipped = 0L;
                                    currSkipped = 0L;
                                    while (true) {
                                        if (currSkipped != -1L && totalSkipped < fileLength) ** break;
                                        continue block9;
                                        currSkipped = valueStream.skip(fileLength - totalSkipped);
                                        totalSkipped += currSkipped;
                                    }
                                    break;
                                }
                            }
                            catch (EOFException eof) {
                                os.flush();
                                if (createPrintStream) {
                                    this.closePrintStream(os);
                                }
                            }
                        }
                        catch (Throwable var29_27) {
                            os.flush();
                            if (createPrintStream) {
                                this.closePrintStream(os);
                            }
                            throw var29_27;
                        }
                        if (!getAllContainers) continue block7;
                    }
                    key = new AggregatedLogFormat.LogKey();
                    valueStream = reader.next(key);
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        return findLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerLogMeta> readAggregatedLogsMeta(ContainerLogsRequest logRequest) throws IOException {
        ArrayList<ContainerLogMeta> containersLogMeta = new ArrayList<ContainerLogMeta>();
        String containerIdStr = logRequest.getContainerId();
        String nodeId = logRequest.getNodeId();
        String nodeName = nodeId;
        if (nodeName != null && nodeName.contains(":")) {
            nodeName = nodeName.substring(0, nodeId.indexOf(":"));
        }
        ApplicationId appId = logRequest.getAppId();
        String appOwner = logRequest.getAppOwner();
        ApplicationAttemptId appAttemptId = logRequest.getAppAttemptId();
        boolean getAllContainers = containerIdStr == null && appAttemptId == null;
        boolean getOnlyOneContainer = containerIdStr != null;
        String nodeIdStr = nodeId == null || nodeId.isEmpty() ? null : nodeName;
        List<FileStatus> nodeFiles = this.nodeLocalMetadataReader.getLogsDirsFileStatusListForApp(appId, appOwner);
        if (nodeFiles == null) {
            throw new IOException("There is no available log file for application:" + appId);
        }
        block5: for (FileStatus thisNodeFile : nodeFiles) {
            String thisNodeName = this.nodeLocalMetadataReader.getNodeFromFilePath(thisNodeFile);
            if (nodeIdStr != null && !thisNodeFile.getPath().toString().contains(nodeIdStr) || thisNodeFile.getPath().getName().endsWith(".tmp")) continue;
            try (AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.conf, thisNodeFile.getPath());){
                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                DataInputStream valueStream = reader.next(key);
                while (valueStream != null) {
                    if (getAllContainers || key.toString().equals(containerIdStr) || this.belongsToAppAttempt(appAttemptId, key.toString())) {
                        ContainerLogMeta containerLogMeta = new ContainerLogMeta(key.toString(), thisNodeName);
                        try {
                            while (true) {
                                Pair<String, String> logMeta = AggregatedLogFormat.LogReader.readContainerMetaDataAndSkipData(valueStream);
                                containerLogMeta.addLogMeta((String)logMeta.getFirst(), (String)logMeta.getSecond(), Times.format(thisNodeFile.getModificationTime()));
                            }
                        }
                        catch (EOFException eof) {
                            containersLogMeta.add(containerLogMeta);
                            if (getOnlyOneContainer) continue block5;
                        }
                    }
                    key = new AggregatedLogFormat.LogKey();
                    valueStream = reader.next(key);
                }
            }
        }
        return containersLogMeta;
    }

    @Override
    public void renderAggregatedLogsBlock(HtmlBlock.Block html, View.ViewContext context) {
        NodeLocalAggregatedLogsBlock block = new NodeLocalAggregatedLogsBlock(context, this.conf, this);
        block.render(html);
    }

    @Override
    public Path getRemoteNodeLogFileForApp(ApplicationId appId, String user, NodeId nodeId) {
        return new Path(this.getRemoteNodeLogFileForAppForNodeLocalAggregator(appId, user), this.remoteRootLogDirSuffix);
    }

    Path getRemoteNodeLogFileForAppForNodeLocalAggregator(ApplicationId appId, String user) {
        return new Path(this.remoteRootLogDir + "/" + user + "/" + appId.toString());
    }

    @Override
    public Path getRemoteAppLogDir(ApplicationId appId, String appOwner) throws IOException {
        Path remoteAppDir = null;
        if (appOwner == null) {
            Path qualifiedRemoteRootLogDir = FileContext.getFileContext((Configuration)this.conf).makeQualified(this.remoteRootLogDir);
            FileContext fc = FileContext.getFileContext((URI)qualifiedRemoteRootLogDir.toUri(), (Configuration)this.conf);
            Path toMatch = this.nodeLocalMetadataReader.getPathForApp(appId.toString(), "*");
            FileStatus[] matching = fc.util().globStatus(toMatch);
            if (matching == null || matching.length != 1) {
                throw new IOException("Can not find remote application directory for the application:" + appId);
            }
            remoteAppDir = matching[0].getPath();
        } else {
            remoteAppDir = this.nodeLocalMetadataReader.getPathForApp(appId.toString(), appOwner);
        }
        return remoteAppDir;
    }

    @Override
    public Path getOlderRemoteAppLogDir(ApplicationId appId, String appOwner) throws IOException {
        Path remoteRootLogDirOlder = new Path(this.conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        String remoteRootLogDirSuffixOlder = this.conf.get("yarn.nodemanager.remote-app-log-dir-suffix", "logs");
        return LogAggregationUtils.getOlderRemoteAppLogDir(this.conf, appId, appOwner, remoteRootLogDirOlder, remoteRootLogDirSuffixOlder);
    }

    @Override
    protected void cleanOldLogs(Path remoteNodeLogFileForApp, NodeId nodeId, UserGroupInformation userUgi) {
        try {
            final FileSystem remoteFS = remoteNodeLogFileForApp.getFileSystem(this.conf);
            Path appDir = remoteNodeLogFileForApp.getParent().makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
            Set<Object> status = new HashSet<FileStatus>(Arrays.asList(remoteFS.listStatus(appDir)));
            status = status.stream().filter(next -> next.getPath().getName().contains(this.remoteRootLogDirSuffix) && !next.getPath().getName().endsWith(".tmp")).collect(Collectors.toSet());
            if (status.size() >= this.retentionSize) {
                ArrayList<Object> statusList = new ArrayList<Object>(status);
                Collections.sort(statusList, new Comparator<FileStatus>(){

                    @Override
                    public int compare(FileStatus s1, FileStatus s2) {
                        return s1.getModificationTime() < s2.getModificationTime() ? -1 : (s1.getModificationTime() > s2.getModificationTime() ? 1 : 0);
                    }
                });
                for (int i = 0; i <= statusList.size() - this.retentionSize; ++i) {
                    final FileStatus remove = (FileStatus)statusList.get(i);
                    try {
                        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                remoteFS.delete(remove.getPath(), false);
                                return null;
                            }
                        });
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to delete " + remove.getPath(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to clean old logs", (Throwable)e);
        }
    }

    public NodeLocalMetadataReader getNodeLocalMetadataReader() {
        return this.nodeLocalMetadataReader;
    }

    public Path getNodeLocalMetadataDir() {
        return this.nodeLocalMetadataDir;
    }

    public String getNodeLocalMetadataDirPrefix() {
        return this.nodeLocalMetadataDirPrefix;
    }

    @Override
    public String getApplicationOwner(Path aggregatedLog, ApplicationId appId) throws IOException {
        this.createTFileLogReader(aggregatedLog);
        return this.tfReader.getLogReader().getApplicationOwner();
    }

    @Override
    public Map<ApplicationAccessType, String> getApplicationAcls(Path aggregatedLog, ApplicationId appId) throws IOException {
        this.createTFileLogReader(aggregatedLog);
        return this.tfReader.getLogReader().getApplicationAcls();
    }

    private void createTFileLogReader(Path aggregatedLog) throws IOException {
        if (this.tfReader == null || !this.tfReader.getAggregatedLogPath().equals((Object)aggregatedLog)) {
            AggregatedLogFormat.LogReader logReader = new AggregatedLogFormat.LogReader(this.conf, aggregatedLog);
            this.tfReader = new TFileLogReader(logReader, aggregatedLog);
        }
    }

    private static class TFileLogReader {
        private AggregatedLogFormat.LogReader logReader;
        private Path aggregatedLogPath;

        TFileLogReader(AggregatedLogFormat.LogReader logReader, Path aggregatedLogPath) {
            this.setLogReader(logReader);
            this.setAggregatedLogPath(aggregatedLogPath);
        }

        public AggregatedLogFormat.LogReader getLogReader() {
            return this.logReader;
        }

        public void setLogReader(AggregatedLogFormat.LogReader logReader) {
            this.logReader = logReader;
        }

        public Path getAggregatedLogPath() {
            return this.aggregatedLogPath;
        }

        public void setAggregatedLogPath(Path aggregatedLogPath) {
            this.aggregatedLogPath = aggregatedLogPath;
        }
    }
}

