/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.log;

import com.google.inject.Inject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class AggregatedLogsBlock
extends HtmlBlock {
    private final Configuration conf;

    @Inject
    AggregatedLogsBlock(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void render(HtmlBlock.Block html) {
        RemoteIterator nodeFiles;
        Path remoteAppDir;
        ContainerId containerId = this.verifyAndGetContainerId(html);
        NodeId nodeId = this.verifyAndGetNodeId(html);
        String appOwner = this.verifyAndGetAppOwner(html);
        LogLimits logLimits = this.verifyAndGetLogLimits(html);
        if (containerId == null) return;
        if (nodeId == null) return;
        if (appOwner == null) return;
        if (appOwner.isEmpty()) return;
        if (logLimits == null) {
            return;
        }
        ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
        String logEntity = this.$("entity.string");
        if (logEntity == null || logEntity.isEmpty()) {
            logEntity = containerId.toString();
        }
        if (!this.conf.getBoolean("yarn.log-aggregation-enable", false) && !this.conf.getBoolean("yarn.node-local-log-aggregation.enable", false)) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Aggregation is not enabled. Try the nodemanager at " + nodeId}))).__();
            return;
        }
        if (!YarnConfiguration.isNodeLocalAggregationEnabled((Configuration)this.conf)) {
            Path remoteRootLogDir = new Path(this.conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
            remoteAppDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, applicationId, appOwner, LogAggregationUtils.getRemoteNodeLogDirSuffix(this.conf));
        } else {
            remoteAppDir = LogAggregationUtils.getDirPathForApplicationOnNode(applicationId.toString(), nodeId.getHost(), appOwner);
        }
        try {
            Path qualifiedLogDir = FileContext.getFileContext((Configuration)this.conf).makeQualified(remoteAppDir);
            nodeFiles = FileContext.getFileContext((URI)qualifiedLogDir.toUri(), (Configuration)this.conf).listStatus(remoteAppDir);
        }
        catch (FileNotFoundException fnf) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Logs not available for " + logEntity + ". Aggregation may not be complete, Check back later or try the nodemanager at " + nodeId}))).__();
            return;
        }
        catch (Exception ex) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Error getting logs at " + nodeId}))).__();
            return;
        }
        boolean foundLog = false;
        String desiredLogType = this.$("log.type");
        try {
            while (nodeFiles.hasNext()) {
                AggregatedLogFormat.LogReader reader = null;
                try {
                    FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
                    if (!this.conf.getBoolean("yarn.node-local-log-aggregation.enable", false) && (!thisNodeFile.getPath().getName().contains(LogAggregationUtils.getNodeString(nodeId)) || thisNodeFile.getPath().getName().endsWith(".tmp"))) continue;
                    long logUploadedTime = thisNodeFile.getModificationTime();
                    reader = new AggregatedLogFormat.LogReader(this.conf, thisNodeFile.getPath());
                    String owner = null;
                    Map<ApplicationAccessType, String> appAcls = null;
                    try {
                        owner = reader.getApplicationOwner();
                        appAcls = reader.getApplicationAcls();
                    }
                    catch (IOException e) {
                        LOG.error("Error getting logs for " + logEntity, (Throwable)e);
                        if (reader == null) continue;
                        reader.close();
                        continue;
                    }
                    ApplicationACLsManager aclsManager = new ApplicationACLsManager(this.conf);
                    aclsManager.addApplication(applicationId, appAcls);
                    String remoteUser = this.request().getRemoteUser();
                    UserGroupInformation callerUGI = null;
                    if (remoteUser != null) {
                        callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
                    }
                    if (callerUGI != null && !aclsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, owner, applicationId)) {
                        ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"User [" + remoteUser + "] is not authorized to view the logs for " + logEntity + " in log file [" + thisNodeFile.getPath().getName() + "]"}))).__();
                        LOG.error("User [" + remoteUser + "] is not authorized to view the logs for " + logEntity);
                        continue;
                    }
                    AggregatedLogFormat.ContainerLogsReader logReader = reader.getContainerLogsReader(containerId);
                    if (logReader == null) continue;
                    foundLog = this.readContainerLogs(html, logReader, logLimits, desiredLogType, logUploadedTime);
                }
                catch (IOException ex) {
                    LOG.error("Error getting logs for " + logEntity, (Throwable)ex);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            if (foundLog) return;
            if (desiredLogType.isEmpty()) {
                html.h1("No logs available for container " + containerId.toString());
                return;
            }
            html.h1("Unable to locate '" + desiredLogType + "' log for container " + containerId.toString());
            return;
        }
        catch (IOException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Error getting logs for " + logEntity}))).__();
            LOG.error("Error getting logs for " + logEntity, (Throwable)e);
        }
    }

    private boolean readContainerLogs(HtmlBlock.Block html, AggregatedLogFormat.ContainerLogsReader logReader, LogLimits logLimits, String desiredLogType, long logUpLoadTime) throws IOException {
        int bufferSize = 65536;
        char[] cbuf = new char[bufferSize];
        boolean foundLog = false;
        String logType = logReader.nextLog();
        while (logType != null) {
            if (desiredLogType == null || desiredLogType.isEmpty() || desiredLogType.equals(logType)) {
                long ret;
                long logLength = logReader.getCurrentLogLength();
                if (foundLog) {
                    ((HamletImpl.EImp)((Object)((Hamlet.PRE)html.pre()).__(new Object[]{"\n\n"}))).__();
                }
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p()).__(new Object[]{"Log Type: " + logType}))).__();
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p()).__(new Object[]{"Log Upload Time: " + Times.format(logUpLoadTime)}))).__();
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p()).__(new Object[]{"Log Length: " + Long.toString(logLength)}))).__();
                long start = logLimits.start < 0L ? logLength + logLimits.start : logLimits.start;
                start = start < 0L ? 0L : start;
                start = start > logLength ? logLength : start;
                long end = logLimits.end < 0L ? logLength + logLimits.end : logLimits.end;
                end = end < 0L ? 0L : end;
                end = end > logLength ? logLength : end;
                end = end < start ? start : end;
                long toRead = end - start;
                if (toRead < logLength) {
                    ((HamletImpl.EImp)((Object)((Hamlet.P)((Hamlet.P)((Hamlet.P)html.p()).__(new Object[]{"Showing " + toRead + " bytes of " + logLength + " total. Click "})).a(this.url("logs", this.$("nm.id"), this.$("container.id"), this.$("entity.string"), this.$("app.owner"), logType, "?start=0"), "here")).__(new Object[]{" for the full log."}))).__();
                }
                for (long totalSkipped = 0L; totalSkipped < start; totalSkipped += ret) {
                    ret = logReader.skip(start - totalSkipped);
                    if (ret != 0L) continue;
                    int nextByte = logReader.read();
                    if (nextByte == -1) {
                        throw new IOException("Premature EOF from container log");
                    }
                    ret = 1L;
                }
                int len = 0;
                int currentToRead = toRead > (long)bufferSize ? bufferSize : (int)toRead;
                HamletSpec.PRE pre = html.pre();
                while (toRead > 0L && (len = logReader.read(cbuf, 0, currentToRead)) > 0) {
                    ((Hamlet.PRE)pre).__(new Object[]{new String(cbuf, 0, len)});
                    currentToRead = (toRead -= (long)len) > (long)bufferSize ? bufferSize : (int)toRead;
                }
                ((HamletImpl.EImp)((Object)pre)).__();
                foundLog = true;
            }
            logType = logReader.nextLog();
        }
        return foundLog;
    }

    private ContainerId verifyAndGetContainerId(HtmlBlock.Block html) {
        String containerIdStr = this.$("container.id");
        if (containerIdStr == null || containerIdStr.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Cannot get container logs without a ContainerId"}))).__();
            return null;
        }
        ContainerId containerId = null;
        try {
            containerId = ConverterUtils.toContainerId(containerIdStr);
        }
        catch (IllegalArgumentException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Cannot get container logs for invalid containerId: " + containerIdStr}))).__();
            return null;
        }
        return containerId;
    }

    private NodeId verifyAndGetNodeId(HtmlBlock.Block html) {
        String nodeIdStr = this.$("nm.id");
        if (nodeIdStr == null || nodeIdStr.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Cannot get container logs without a NodeId"}))).__();
            return null;
        }
        NodeId nodeId = null;
        try {
            nodeId = ConverterUtils.toNodeId(nodeIdStr);
        }
        catch (IllegalArgumentException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Cannot get container logs. Invalid nodeId: " + nodeIdStr}))).__();
            return null;
        }
        return nodeId;
    }

    private String verifyAndGetAppOwner(HtmlBlock.Block html) {
        String appOwner = this.$("app.owner");
        if (appOwner == null || appOwner.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Cannot get container logs without an app owner"}))).__();
        }
        return appOwner;
    }

    private LogLimits verifyAndGetLogLimits(HtmlBlock.Block html) {
        String endStr;
        long start = -4096L;
        long end = Long.MAX_VALUE;
        boolean isValid = true;
        String startStr = this.$("start");
        if (startStr != null && !startStr.isEmpty()) {
            try {
                start = Long.parseLong(startStr);
            }
            catch (NumberFormatException e) {
                isValid = false;
                ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Invalid log start value: " + startStr}))).__();
            }
        }
        if ((endStr = this.$("end")) != null && !endStr.isEmpty()) {
            try {
                end = Long.parseLong(endStr);
            }
            catch (NumberFormatException e) {
                isValid = false;
                ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Invalid log end value: " + endStr}))).__();
            }
        }
        if (!isValid) {
            return null;
        }
        LogLimits limits = new LogLimits();
        limits.start = start;
        limits.end = end;
        return limits;
    }

    private static class LogLimits {
        long start;
        long end;

        private LogLimits() {
        }
    }
}

