/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebServicesTestUtils {
    public static long getXmlLong(Element element, String name) {
        String val = WebServicesTestUtils.getXmlString(element, name);
        return Long.parseLong(val);
    }

    public static int getXmlInt(Element element, String name) {
        String val = WebServicesTestUtils.getXmlString(element, name);
        return Integer.parseInt(val);
    }

    public static Boolean getXmlBoolean(Element element, String name) {
        String val = WebServicesTestUtils.getXmlString(element, name);
        return Boolean.parseBoolean(val);
    }

    public static float getXmlFloat(Element element, String name) {
        String val = WebServicesTestUtils.getXmlString(element, name);
        return Float.parseFloat(val);
    }

    public static String getXmlString(Element element, String name) {
        NodeList id = element.getElementsByTagName(name);
        Element line = (Element)id.item(0);
        if (line == null) {
            return null;
        }
        Node first = line.getFirstChild();
        if (first == null) {
            return "";
        }
        String val = first.getNodeValue();
        if (val == null) {
            return "";
        }
        return val;
    }

    public static String getXmlAttrString(Element element, String name) {
        Attr at = element.getAttributeNode(name);
        if (at != null) {
            return at.getValue();
        }
        return null;
    }

    public static void checkStringMatch(String print, String expected, String got) {
        Assert.assertTrue((String)(print + " doesn't match, got: " + got + " expected: " + expected), (boolean)got.matches(expected));
    }

    public static void checkStringContains(String print, String expected, String got) {
        Assert.assertTrue((String)(print + " doesn't contain expected string, got: " + got + " expected: " + expected), (boolean)got.contains(expected));
    }

    public static void checkStringEqual(String print, String expected, String got) {
        Assert.assertTrue((String)(print + " is not equal, got: " + got + " expected: " + expected), (boolean)got.equals(expected));
    }

    public static void assertResponseStatusCode(Response.StatusType expected, Response.StatusType actual) {
        WebServicesTestUtils.assertResponseStatusCode(null, expected, actual);
    }

    public static void assertResponseStatusCode(String errmsg, Response.StatusType expected, Response.StatusType actual) {
        Assert.assertEquals((String)errmsg, (long)expected.getStatusCode(), (long)actual.getStatusCode());
    }
}

