/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.util.RackResolver;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRackResolver {
    private static final Logger LOG = LoggerFactory.getLogger(TestRackResolver.class);
    private static final String invalidHost = "invalidHost";

    @Test
    public void testCaching() {
        Configuration conf = new Configuration();
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        RackResolver.init((Configuration)conf);
        try {
            InetAddress iaddr = InetAddress.getByName("host1");
            MyResolver.resolvedHost1 = iaddr.getHostAddress();
        }
        catch (UnknownHostException iaddr) {
            // empty catch block
        }
        Node node = RackResolver.resolve((String)"host1");
        Assert.assertEquals((Object)"/rack1", (Object)node.getNetworkLocation());
        node = RackResolver.resolve((String)"host1");
        Assert.assertEquals((Object)"/rack1", (Object)node.getNetworkLocation());
        node = RackResolver.resolve((String)invalidHost);
        Assert.assertEquals((Object)"/default-rack", (Object)node.getNetworkLocation());
    }

    public static final class MyResolver
    implements DNSToSwitchMapping {
        int numHost1 = 0;
        public static String resolvedHost1 = "host1";

        public List<String> resolve(List<String> hostList) {
            Assert.assertTrue((String)("hostList size is " + hostList.size()), (hostList.size() <= 1 ? 1 : 0) != 0);
            ArrayList<String> returnList = new ArrayList<String>();
            if (hostList.isEmpty()) {
                return returnList;
            }
            if (hostList.get(0).equals(TestRackResolver.invalidHost)) {
                return null;
            }
            LOG.info("Received resolve request for " + hostList.get(0));
            if (hostList.get(0).equals("host1") || hostList.get(0).equals(resolvedHost1)) {
                ++this.numHost1;
                returnList.add("/rack1");
            }
            Assert.assertTrue((this.numHost1 <= 1 ? 1 : 0) != 0);
            return returnList;
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> names) {
        }
    }
}

