/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.appcatalog.controller;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hadoop.yarn.appcatalog.application.AppCatalogSolrClient;
import org.apache.hadoop.yarn.appcatalog.model.AppStoreEntry;
import org.apache.hadoop.yarn.appcatalog.model.Application;

@Path(value="/app_store")
public class AppStoreController {
    @GET
    @Path(value="recommended")
    @Produces(value={"application/json"})
    public List<AppStoreEntry> get() {
        AppCatalogSolrClient sc = new AppCatalogSolrClient();
        return sc.getRecommendedApps();
    }

    @GET
    @Path(value="search")
    @Produces(value={"application/json"})
    public List<AppStoreEntry> search(@QueryParam(value="q") String keyword) {
        AppCatalogSolrClient sc = new AppCatalogSolrClient();
        return sc.search(keyword);
    }

    @GET
    @Path(value="get/{id}")
    @Produces(value={"application/json"})
    public AppStoreEntry get(@PathParam(value="id") String id) {
        AppCatalogSolrClient sc = new AppCatalogSolrClient();
        return sc.findAppStoreEntry(id);
    }

    @POST
    @Path(value="register")
    @Produces(value={"application/json"})
    public Response register(Application app) {
        try {
            if (app.getName() == null) {
                throw new IOException("Application name can not be empty.");
            }
            if (app.getOrganization() == null) {
                throw new IOException("Application organization can not be empty.");
            }
            if (app.getDescription() == null) {
                throw new IOException("Application description can not be empty.");
            }
            AppCatalogSolrClient sc = new AppCatalogSolrClient();
            sc.register(app);
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }
}

