/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.appcatalog.application;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.appcatalog.model.AppEntry;
import org.apache.hadoop.yarn.appcatalog.model.AppStoreEntry;
import org.apache.hadoop.yarn.appcatalog.model.Application;
import org.apache.hadoop.yarn.appcatalog.utils.RandomWord;
import org.apache.hadoop.yarn.appcatalog.utils.WordLengthException;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;

/*
 * Exception performing whole class analysis ignored.
 */
public class AppCatalogSolrClient {
    private static final Log LOG = LogFactory.getLog(AppCatalogSolrClient.class);
    private static String urlString;

    public AppCatalogSolrClient() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream input = classLoader.getResourceAsStream("appcatalog.properties");
        Properties properties = new Properties();
        try {
            properties.load(input);
            AppCatalogSolrClient.setSolrUrl((String)properties.getProperty("solr_url"));
        }
        catch (IOException e) {
            LOG.error((Object)"Error reading appcatalog configuration: ", (Throwable)e);
        }
    }

    private static synchronized void setSolrUrl(String url) {
        urlString = url;
    }

    public SolrClient getSolrClient() {
        return new HttpSolrClient.Builder(urlString).build();
    }

    public List<AppStoreEntry> getRecommendedApps() {
        ArrayList<AppStoreEntry> apps = new ArrayList<AppStoreEntry>();
        SolrClient solr = this.getSolrClient();
        SolrQuery query = new SolrQuery();
        query.setQuery("*:*");
        query.setSort("download_i", SolrQuery.ORDER.desc);
        query.setFilterQueries(new String[]{"type_s:AppStoreEntry"});
        query.setRows(Integer.valueOf(40));
        try {
            QueryResponse response = solr.query((SolrParams)query);
            ListIterator list = response.getResults().listIterator();
            while (list.hasNext()) {
                SolrDocument d = (SolrDocument)list.next();
                AppStoreEntry entry = new AppStoreEntry();
                entry.setId(d.get((Object)"id").toString());
                entry.setOrg(d.get((Object)"org_s").toString());
                entry.setName(d.get((Object)"name_s").toString());
                entry.setDesc(d.get((Object)"desc_s").toString());
                if (d.get((Object)"icon_s") != null) {
                    entry.setIcon(d.get((Object)"icon_s").toString());
                }
                entry.setLike((long)Integer.parseInt(d.get((Object)"like_i").toString()));
                entry.setDownload((long)Integer.parseInt(d.get((Object)"download_i").toString()));
                apps.add(entry);
            }
        }
        catch (IOException | SolrServerException e) {
            LOG.error((Object)"Error getting a list of recommended applications: ", e);
        }
        return apps;
    }

    public List<AppStoreEntry> search(String keyword) {
        ArrayList<AppStoreEntry> apps = new ArrayList<AppStoreEntry>();
        SolrClient solr = this.getSolrClient();
        SolrQuery query = new SolrQuery();
        if (keyword.length() == 0) {
            query.setQuery("*:*");
            query.setFilterQueries(new String[]{"type_s:AppStoreEntry"});
        } else {
            query.setQuery(keyword);
            query.setFilterQueries(new String[]{"type_s:AppStoreEntry"});
        }
        query.setRows(Integer.valueOf(40));
        try {
            QueryResponse response = solr.query((SolrParams)query);
            ListIterator list = response.getResults().listIterator();
            while (list.hasNext()) {
                SolrDocument d = (SolrDocument)list.next();
                AppStoreEntry entry = new AppStoreEntry();
                entry.setId(d.get((Object)"id").toString());
                entry.setOrg(d.get((Object)"org_s").toString());
                entry.setName(d.get((Object)"name_s").toString());
                entry.setDesc(d.get((Object)"desc_s").toString());
                entry.setLike((long)Integer.parseInt(d.get((Object)"like_i").toString()));
                entry.setDownload((long)Integer.parseInt(d.get((Object)"download_i").toString()));
                apps.add(entry);
            }
        }
        catch (IOException | SolrServerException e) {
            LOG.error((Object)"Error in searching for applications: ", e);
        }
        return apps;
    }

    public List<AppEntry> listAppEntries() {
        ArrayList<AppEntry> list = new ArrayList<AppEntry>();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SolrClient solr = this.getSolrClient();
        SolrQuery query = new SolrQuery();
        query.setQuery("*:*");
        query.setFilterQueries(new String[]{"type_s:AppEntry"});
        query.setRows(Integer.valueOf(40));
        try {
            QueryResponse response = solr.query((SolrParams)query);
            ListIterator appList = response.getResults().listIterator();
            while (appList.hasNext()) {
                SolrDocument d = (SolrDocument)appList.next();
                AppEntry entry = new AppEntry();
                entry.setId(d.get((Object)"id").toString());
                entry.setName(d.get((Object)"name_s").toString());
                entry.setApp(d.get((Object)"app_s").toString());
                entry.setYarnfile((Service)mapper.readValue(d.get((Object)"yarnfile_s").toString(), Service.class));
                list.add(entry);
            }
        }
        catch (IOException | SolrServerException e) {
            LOG.error((Object)"Error in listing deployed applications: ", e);
        }
        return list;
    }

    public AppStoreEntry findAppStoreEntry(String id) {
        AppStoreEntry entry = new AppStoreEntry();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SolrClient solr = this.getSolrClient();
        SolrQuery query = new SolrQuery();
        query.setQuery("id:" + id);
        query.setFilterQueries(new String[]{"type_s:AppStoreEntry"});
        query.setRows(Integer.valueOf(1));
        try {
            QueryResponse response = solr.query((SolrParams)query);
            ListIterator appList = response.getResults().listIterator();
            while (appList.hasNext()) {
                String name;
                SolrDocument d = (SolrDocument)appList.next();
                entry.setId(d.get((Object)"id").toString());
                entry.setOrg(d.get((Object)"org_s").toString());
                entry.setName(d.get((Object)"name_s").toString());
                entry.setDesc(d.get((Object)"desc_s").toString());
                entry.setLike((long)Integer.parseInt(d.get((Object)"like_i").toString()));
                entry.setDownload((long)Integer.parseInt(d.get((Object)"download_i").toString()));
                Service yarnApp = (Service)mapper.readValue(d.get((Object)"yarnfile_s").toString(), Service.class);
                try {
                    Random r = new Random();
                    int low = 3;
                    int high = 10;
                    int seed = r.nextInt(high - low) + low;
                    int seed2 = r.nextInt(high - low) + low;
                    name = RandomWord.getNewWord((int)seed).toLowerCase() + "-" + RandomWord.getNewWord((int)seed2).toLowerCase();
                }
                catch (WordLengthException e) {
                    name = "c" + UUID.randomUUID().toString().substring(0, 11);
                }
                yarnApp.setName(name);
                entry.setApp(yarnApp);
            }
        }
        catch (IOException | SolrServerException e) {
            LOG.error((Object)("Error in finding deployed application: " + id), e);
        }
        return entry;
    }

    public AppEntry findAppEntry(String id) {
        AppEntry entry = new AppEntry();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SolrClient solr = this.getSolrClient();
        SolrQuery query = new SolrQuery();
        query.setQuery("id:" + id);
        query.setFilterQueries(new String[]{"type_s:AppEntry"});
        query.setRows(Integer.valueOf(1));
        try {
            QueryResponse response = solr.query((SolrParams)query);
            ListIterator appList = response.getResults().listIterator();
            while (appList.hasNext()) {
                SolrDocument d = (SolrDocument)appList.next();
                entry.setId(d.get((Object)"id").toString());
                entry.setApp(d.get((Object)"app_s").toString());
                entry.setName(d.get((Object)"name_s").toString());
                entry.setYarnfile((Service)mapper.readValue(d.get((Object)"yarnfile_s").toString(), Service.class));
            }
        }
        catch (IOException | SolrServerException e) {
            LOG.error((Object)("Error in finding deployed application: " + id), e);
        }
        return entry;
    }

    public void deployApp(String id, Service service) throws SolrServerException, IOException {
        long download = 0L;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        HashSet<SolrInputDocument> docs = new HashSet<SolrInputDocument>();
        SolrClient solr = this.getSolrClient();
        SolrQuery query = new SolrQuery();
        query.setQuery("id:" + id);
        query.setFilterQueries(new String[]{"type_s:AppStoreEntry"});
        query.setRows(Integer.valueOf(1));
        QueryResponse response = solr.query((SolrParams)query);
        ListIterator appList = response.getResults().listIterator();
        AppStoreEntry entry = new AppStoreEntry();
        while (appList.hasNext()) {
            SolrDocument d = (SolrDocument)appList.next();
            entry.setOrg(d.get((Object)"org_s").toString());
            entry.setName(d.get((Object)"name_s").toString());
            entry.setDesc(d.get((Object)"desc_s").toString());
            entry.setLike((long)Integer.parseInt(d.get((Object)"like_i").toString()));
            entry.setDownload((long)Integer.parseInt(d.get((Object)"download_i").toString()));
            download = entry.getDownload() + 1L;
            docs.add(this.incrementDownload(d, download));
        }
        if (service != null) {
            SolrInputDocument request = new SolrInputDocument(new String[0]);
            String name = service.getName();
            request.addField("type_s", (Object)"AppEntry");
            request.addField("id", (Object)name);
            request.addField("name_s", (Object)name);
            request.addField("app_s", (Object)(entry.getOrg() + "/" + entry.getName()));
            request.addField("yarnfile_s", (Object)mapper.writeValueAsString((Object)service));
            docs.add(request);
        }
        try {
            this.commitSolrChanges(solr, docs);
        }
        catch (IOException e) {
            throw new IOException("Unable to register docker instance with application entry.", e);
        }
    }

    private SolrInputDocument incrementDownload(SolrDocument doc, long download) {
        Collection names = doc.getFieldNames();
        SolrInputDocument s = new SolrInputDocument(new String[0]);
        for (String name : names) {
            if (name.equals("_version_")) continue;
            s.addField(name, (Object)doc.getFieldValues(name));
        }
        s.setField("download_i", (Object)(++download));
        return s;
    }

    public void deleteApp(String id) {
        SolrClient solr = this.getSolrClient();
        try {
            solr.deleteById(id);
            solr.commit();
        }
        catch (IOException | SolrServerException e) {
            LOG.error((Object)("Error in removing deployed application: " + id), e);
        }
    }

    public void register(Application app) throws IOException {
        HashSet<SolrInputDocument> docs = new HashSet<SolrInputDocument>();
        SolrClient solr = this.getSolrClient();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            SolrInputDocument buffer = new SolrInputDocument(new String[0]);
            buffer.setField("id", (Object)UUID.randomUUID().toString().substring(0, 11));
            buffer.setField("org_s", (Object)app.getOrganization());
            buffer.setField("name_s", (Object)app.getName());
            buffer.setField("desc_s", (Object)app.getDescription());
            if (app.getIcon() != null) {
                buffer.setField("icon_s", (Object)app.getIcon());
            }
            buffer.setField("type_s", (Object)"AppStoreEntry");
            buffer.setField("like_i", (Object)0);
            buffer.setField("download_i", (Object)0);
            String yarnFile = mapper.writeValueAsString((Object)app);
            LOG.info((Object)("app:" + yarnFile));
            Service yarnApp = (Service)mapper.readValue(yarnFile, Service.class);
            buffer.setField("yarnfile_s", (Object)mapper.writeValueAsString((Object)yarnApp));
            docs.add(buffer);
            this.commitSolrChanges(solr, docs);
        }
        catch (IOException | SolrServerException e) {
            throw new IOException("Unable to register application in Application Store. ", e);
        }
    }

    protected void register(AppStoreEntry app) throws IOException {
        HashSet<SolrInputDocument> docs = new HashSet<SolrInputDocument>();
        SolrClient solr = this.getSolrClient();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            SolrInputDocument buffer = new SolrInputDocument(new String[0]);
            buffer.setField("id", (Object)UUID.randomUUID().toString().substring(0, 11));
            buffer.setField("org_s", (Object)app.getOrg());
            buffer.setField("name_s", (Object)app.getName());
            buffer.setField("desc_s", (Object)app.getDesc());
            if (app.getIcon() != null) {
                buffer.setField("icon_s", (Object)app.getIcon());
            }
            buffer.setField("type_s", (Object)"AppStoreEntry");
            buffer.setField("like_i", (Object)app.getLike());
            buffer.setField("download_i", (Object)app.getDownload());
            String yarnFile = mapper.writeValueAsString((Object)app);
            LOG.info((Object)("app:" + yarnFile));
            Service yarnApp = (Service)mapper.readValue(yarnFile, Service.class);
            buffer.setField("yarnfile_s", (Object)mapper.writeValueAsString((Object)yarnApp));
            docs.add(buffer);
            this.commitSolrChanges(solr, docs);
        }
        catch (IOException | SolrServerException e) {
            throw new IOException("Unable to register application in Application Store. ", e);
        }
    }

    public void upgradeApp(Service service) throws IOException, SolrServerException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        HashSet<SolrInputDocument> docs = new HashSet<SolrInputDocument>();
        SolrClient solr = this.getSolrClient();
        if (service != null) {
            String name = service.getName();
            String app = "";
            SolrQuery query = new SolrQuery();
            query.setQuery("id:" + name);
            query.setFilterQueries(new String[]{"type_s:AppEntry"});
            query.setRows(Integer.valueOf(1));
            try {
                QueryResponse response = solr.query((SolrParams)query);
                ListIterator appList = response.getResults().listIterator();
                while (appList.hasNext()) {
                    SolrDocument d = (SolrDocument)appList.next();
                    app = d.get((Object)"app_s").toString();
                }
            }
            catch (IOException | SolrServerException e) {
                LOG.error((Object)("Error in finding deployed application: " + name), e);
            }
            SolrInputDocument request = new SolrInputDocument(new String[0]);
            request.addField("type_s", (Object)"AppEntry");
            request.addField("id", (Object)name);
            request.addField("name_s", (Object)name);
            request.addField("app_s", (Object)app);
            request.addField("yarnfile_s", (Object)mapper.writeValueAsString((Object)service));
            docs.add(request);
        }
        try {
            this.commitSolrChanges(solr, docs);
        }
        catch (IOException e) {
            throw new IOException("Unable to register docker instance with application entry.", e);
        }
    }

    private void commitSolrChanges(SolrClient solr, Collection<SolrInputDocument> docs) throws IOException, SolrServerException {
        UpdateResponse detailsResponse = solr.add(docs);
        if (detailsResponse.getStatus() != 0) {
            throw new IOException("Failed to commit document in solr, status code: " + detailsResponse.getStatus());
        }
        solr.commit();
    }
}

