/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import java.util.Map;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestResourceInformation {
    TestResourceInformation() {
    }

    @Test
    void testName() {
        String name = "yarn.io/test";
        ResourceInformation ri = ResourceInformation.newInstance((String)name);
        Assertions.assertEquals((Object)name, (Object)ri.getName(), (String)"Resource name incorrect");
    }

    @Test
    void testUnits() {
        String name = "yarn.io/test";
        String units = "m";
        ResourceInformation ri = ResourceInformation.newInstance((String)name, (String)units);
        Assertions.assertEquals((Object)name, (Object)ri.getName(), (String)"Resource name incorrect");
        Assertions.assertEquals((Object)units, (Object)ri.getUnits(), (String)"Resource units incorrect");
        units = "z";
        try {
            ResourceInformation.newInstance((String)name, (String)units).setUnits(units);
            Assertions.fail((String)(units + "is not a valid unit"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testValue() {
        String name = "yarn.io/test";
        long value = 1L;
        ResourceInformation ri = ResourceInformation.newInstance((String)name, (long)value);
        Assertions.assertEquals((Object)name, (Object)ri.getName(), (String)"Resource name incorrect");
        Assertions.assertEquals((long)value, (long)ri.getValue(), (String)"Resource value incorrect");
    }

    @Test
    void testResourceInformation() {
        String name = "yarn.io/test";
        long value = 1L;
        String units = "m";
        ResourceInformation ri = ResourceInformation.newInstance((String)name, (String)units, (long)value);
        Assertions.assertEquals((Object)name, (Object)ri.getName(), (String)"Resource name incorrect");
        Assertions.assertEquals((long)value, (long)ri.getValue(), (String)"Resource value incorrect");
        Assertions.assertEquals((Object)units, (Object)ri.getUnits(), (String)"Resource units incorrect");
    }

    @Test
    void testEqualsWithTagsAndAttributes() {
        ResourceInformation ri01 = ResourceInformation.newInstance((String)"r1", (String)"M", (long)100L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)100L, (Set)ImmutableSet.of((Object)"A", (Object)"B"), null);
        ResourceInformation ri02 = ResourceInformation.newInstance((String)"r1", (String)"M", (long)100L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)100L, (Set)ImmutableSet.of((Object)"B", (Object)"A"), null);
        Assertions.assertEquals((Object)ri01, (Object)ri02);
        ResourceInformation ri11 = ResourceInformation.newInstance((String)"r1", (String)"M", (long)100L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)100L, null, null);
        ResourceInformation ri12 = ResourceInformation.newInstance((String)"r1", (String)"M", (long)100L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)100L, (Set)ImmutableSet.of((Object)"B", (Object)"A"), null);
        Assertions.assertNotEquals((Object)ri11, (Object)ri12);
        ResourceInformation ri21 = ResourceInformation.newInstance((String)"r1", (String)"M", (long)100L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)100L, null, (Map)ImmutableMap.of((Object)"A", (Object)"A1", (Object)"B", (Object)"B1"));
        ResourceInformation ri22 = ResourceInformation.newInstance((String)"r1", (String)"M", (long)100L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)100L, null, (Map)ImmutableMap.of((Object)"A", (Object)"A1", (Object)"B", (Object)"B2"));
        Assertions.assertNotEquals((Object)ri21, (Object)ri22);
        ResourceInformation ri31 = ResourceInformation.newInstance((String)"r1", (String)"M", (long)100L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)100L, null, null);
        ResourceInformation ri32 = ResourceInformation.newInstance((String)"r1", (String)"M", (long)100L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)100L, null, null);
        Assertions.assertEquals((Object)ri31, (Object)ri32);
        ResourceInformation ri41 = ResourceInformation.newInstance((String)"r1", (String)"M", (long)100L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)100L, (Set)ImmutableSet.of(), null);
        ResourceInformation ri42 = ResourceInformation.newInstance((String)"r1", (String)"M", (long)100L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)100L, null, (Map)ImmutableMap.of());
        Assertions.assertEquals((Object)ri41, (Object)ri42);
    }
}

