/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.ZombieCluster;
import org.apache.hadoop.tools.rumen.ZombieJob;

public class ZombieJobProducer
implements JobStoryProducer {
    private final JobTraceReader reader;
    private final ZombieCluster cluster;

    private ZombieJobProducer(JobTraceReader reader, ZombieCluster cluster) {
        this.reader = reader;
        this.cluster = cluster;
    }

    public ZombieJobProducer(Path path, ZombieCluster cluster, Configuration conf) throws IOException {
        this(new JobTraceReader(path, conf), cluster);
    }

    public ZombieJobProducer(InputStream input, ZombieCluster cluster) throws IOException {
        this(new JobTraceReader(input), cluster);
    }

    @Override
    public ZombieJob getNextJob() throws IOException {
        LoggedJob job = (LoggedJob)this.reader.getNext();
        return job == null ? null : new ZombieJob(job, this.cluster);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

