/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.tools.rumen.LogRecordType;

class ParsedLine {
    Properties content = new Properties();
    LogRecordType type;
    static final Pattern keyValPair = Pattern.compile(" *([a-zA-Z0-9_]+)=\"((?:[^\"\\\\]|\\\\[ .\"\\\\])*)\"");

    ParsedLine(String fullLine, int version) {
        int firstSpace = fullLine.indexOf(" ");
        if (firstSpace < 0) {
            firstSpace = fullLine.length();
        }
        if (firstSpace == 0) {
            return;
        }
        this.type = LogRecordType.intern(fullLine.substring(0, firstSpace));
        String propValPairs = fullLine.substring(firstSpace + 1);
        while (propValPairs.length() > 0 && propValPairs.charAt(0) == ' ') {
            propValPairs = propValPairs.substring(1);
        }
        int cursor = 0;
        while (cursor < propValPairs.length()) {
            int endValue;
            int nextCursor;
            int equals = propValPairs.indexOf(61, cursor);
            if (equals < 0) {
                return;
            }
            if (propValPairs.charAt(equals + 1) == '\"') {
                int closeQuote = propValPairs.indexOf(34, equals + 2);
                nextCursor = closeQuote + 1;
                endValue = closeQuote;
                if (closeQuote < 0) {
                    nextCursor = endValue = propValPairs.length();
                }
            } else {
                int closeSpace = propValPairs.indexOf(32, equals + 1);
                if (closeSpace < 0) {
                    closeSpace = propValPairs.length();
                }
                nextCursor = endValue = closeSpace;
            }
            this.content.setProperty(propValPairs.substring(cursor, equals), propValPairs.substring(equals + 2, endValue));
            for (cursor = nextCursor; cursor < propValPairs.length() && propValPairs.charAt(cursor) == ' '; ++cursor) {
            }
        }
    }

    protected LogRecordType getType() {
        return this.type;
    }

    protected String get(String key) {
        return this.content.getProperty(key);
    }

    protected long getLong(String key) {
        String val = this.get(key);
        return Long.parseLong(val);
    }
}

