/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

class JsonObjectMapperParser<T>
implements Closeable {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Class<? extends T> clazz;
    private final JsonParser jsonParser;
    private final Decompressor decompressor;

    public JsonObjectMapperParser(Path path, Class<? extends T> clazz, Configuration conf) throws IOException {
        FSDataInputStream input;
        this.mapper.configure(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        this.clazz = clazz;
        FileSystem fs = path.getFileSystem(conf);
        CompressionCodec codec = new CompressionCodecFactory(conf).getCodec(path);
        if (codec == null) {
            input = fs.open(path);
            this.decompressor = null;
        } else {
            FSDataInputStream fsdis = fs.open(path);
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
            input = codec.createInputStream((InputStream)fsdis, this.decompressor);
        }
        this.jsonParser = this.mapper.getJsonFactory().createJsonParser((InputStream)input);
    }

    public JsonObjectMapperParser(InputStream input, Class<? extends T> clazz) throws IOException {
        this.mapper.configure(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        this.clazz = clazz;
        this.decompressor = null;
        this.jsonParser = this.mapper.getJsonFactory().createJsonParser(input);
    }

    public T getNext() throws IOException {
        try {
            return (T)this.mapper.readValue(this.jsonParser, this.clazz);
        }
        catch (EOFException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.jsonParser.close();
        }
        finally {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
            }
        }
    }
}

