/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.tools.rumen.ClusterStory;
import org.apache.hadoop.tools.rumen.MachineNode;
import org.apache.hadoop.tools.rumen.Node;
import org.apache.hadoop.tools.rumen.RackNode;

public abstract class AbstractClusterStory
implements ClusterStory {
    protected Set<MachineNode> machineNodes;
    protected Set<RackNode> rackNodes;
    protected MachineNode[] mNodesFlattened;
    protected Map<String, MachineNode> mNodeMap;
    protected Map<String, RackNode> rNodeMap;
    protected int maximumDistance = 0;
    protected Random random;

    @Override
    public Set<MachineNode> getMachines() {
        this.parseTopologyTree();
        return this.machineNodes;
    }

    @Override
    public synchronized Set<RackNode> getRacks() {
        this.parseTopologyTree();
        return this.rackNodes;
    }

    @Override
    public synchronized MachineNode[] getRandomMachines(int expected) {
        int i;
        if (expected == 0) {
            return new MachineNode[0];
        }
        this.parseTopologyTree();
        int total = this.machineNodes.size();
        int select = Math.min(expected, total);
        if (this.mNodesFlattened == null) {
            this.mNodesFlattened = this.machineNodes.toArray(new MachineNode[total]);
            this.random = new Random();
        }
        MachineNode[] retval = new MachineNode[select];
        for (i = 0; i != select && total != i + select; ++i) {
            int index = this.random.nextInt(total - i);
            MachineNode tmp = this.mNodesFlattened[index];
            this.mNodesFlattened[index] = this.mNodesFlattened[total - i - 1];
            this.mNodesFlattened[total - i - 1] = tmp;
        }
        if (i == select) {
            System.arraycopy(this.mNodesFlattened, total - i, retval, 0, select);
        } else {
            System.arraycopy(this.mNodesFlattened, 0, retval, 0, select);
        }
        return retval;
    }

    protected synchronized void buildMachineNodeMap() {
        if (this.mNodeMap == null) {
            this.mNodeMap = new HashMap<String, MachineNode>(this.machineNodes.size());
            for (MachineNode mn : this.machineNodes) {
                this.mNodeMap.put(mn.getName(), mn);
            }
        }
    }

    @Override
    public MachineNode getMachineByName(String name) {
        this.buildMachineNodeMap();
        return this.mNodeMap.get(name);
    }

    @Override
    public int distance(Node a, Node b) {
        int i;
        int lvl_a = a.getLevel();
        int lvl_b = b.getLevel();
        int retval = 0;
        if (lvl_a > lvl_b) {
            retval = lvl_a - lvl_b;
            for (i = 0; i < retval; ++i) {
                a = a.getParent();
            }
        } else if (lvl_a < lvl_b) {
            retval = lvl_b - lvl_a;
            for (i = 0; i < retval; ++i) {
                b = b.getParent();
            }
        }
        while (a != b) {
            a = a.getParent();
            b = b.getParent();
            ++retval;
        }
        return retval;
    }

    protected synchronized void buildRackNodeMap() {
        if (this.rNodeMap == null) {
            this.rNodeMap = new HashMap<String, RackNode>(this.rackNodes.size());
            for (RackNode rn : this.rackNodes) {
                this.rNodeMap.put(rn.getName(), rn);
            }
        }
    }

    @Override
    public RackNode getRackByName(String name) {
        this.buildRackNodeMap();
        return this.rNodeMap.get(name);
    }

    @Override
    public int getMaximumDistance() {
        this.parseTopologyTree();
        return this.maximumDistance;
    }

    protected synchronized void parseTopologyTree() {
        if (this.machineNodes == null) {
            Node root = this.getClusterTopology();
            TreeSet<MachineNode> mNodes = new TreeSet<MachineNode>();
            TreeSet<RackNode> rNodes = new TreeSet<RackNode>();
            ArrayDeque<Node> unvisited = new ArrayDeque<Node>();
            ArrayDeque<Integer> distUnvisited = new ArrayDeque<Integer>();
            unvisited.add(root);
            distUnvisited.add(0);
            Node n = (Node)unvisited.poll();
            while (n != null) {
                int distance = (Integer)distUnvisited.poll();
                if (n instanceof RackNode) {
                    rNodes.add((RackNode)n);
                    mNodes.addAll(((RackNode)n).getMachinesInRack());
                    if (distance + 1 > this.maximumDistance) {
                        this.maximumDistance = distance + 1;
                    }
                } else if (n instanceof MachineNode) {
                    mNodes.add((MachineNode)n);
                    if (distance > this.maximumDistance) {
                        this.maximumDistance = distance;
                    }
                } else {
                    for (Node child : n.getChildren()) {
                        unvisited.addFirst(child);
                        distUnvisited.addFirst(distance + 1);
                    }
                }
                n = (Node)unvisited.poll();
            }
            this.machineNodes = Collections.unmodifiableSortedSet(mNodes);
            this.rackNodes = Collections.unmodifiableSortedSet(rNodes);
        }
    }
}

