/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogsTruncater;
import org.apache.hadoop.mapred.TestMiniMRMapRedDebugScript;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapreduce.server.tasktracker.JVMInfo;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestTaskLogsTruncater {
    static final Log LOG = LogFactory.getLog(TestTaskLogsTruncater.class);
    private static int truncatedMsgSize = "[ ... this log file was truncated because of excess length]\n".getBytes().length;
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private static String STDERR_LOG = "stderr log";

    @After
    public void tearDown() throws IOException {
        File logDir = TaskLog.getUserLogDir();
        for (File attemptDir : logDir.listFiles()) {
            attemptDir.setWritable(true);
            FileUtil.fullyDelete((File)attemptDir);
        }
    }

    private void writeBytes(TaskAttemptID firstAttemptID, TaskAttemptID attemptID, TaskLog.LogName logName, long numBytes, boolean random, char data) throws IOException {
        File logFile = TaskLog.getTaskLogFile((TaskAttemptID)firstAttemptID, (boolean)false, (TaskLog.LogName)logName);
        File logLocation = logFile.getParentFile();
        LOG.info((Object)("Going to write " + numBytes + " real bytes to the log file " + logFile));
        if (!logLocation.exists() && !logLocation.mkdirs()) {
            throw new IOException("Couldn't create all ancestor dirs for " + logFile);
        }
        File attemptDir = TaskLog.getAttemptDir((TaskAttemptID)attemptID, (boolean)false);
        if (!attemptDir.exists() && !attemptDir.mkdirs()) {
            throw new IOException("Couldn't create all ancestor dirs for " + logFile);
        }
        TaskLog.syncLogs((String)logLocation.toString(), (TaskAttemptID)attemptID, (boolean)false, (boolean)true);
        FileOutputStream outputStream = new FileOutputStream(logFile, true);
        Random r = new Random();
        for (long i = 0L; i < numBytes; ++i) {
            if (random) {
                outputStream.write(r.nextInt());
                continue;
            }
            outputStream.write(data);
        }
        outputStream.close();
        TaskLog.syncLogs((String)logLocation.toString(), (TaskAttemptID)attemptID, (boolean)false, (boolean)true);
        LOG.info((Object)("Written " + logFile.length() + " real bytes to the log file " + logFile));
    }

    private void writeRandomBytes(TaskAttemptID firstAttemptID, TaskAttemptID attemptID, TaskLog.LogName logName, long numBytes) throws IOException {
        this.writeBytes(firstAttemptID, attemptID, logName, numBytes, true, ' ');
    }

    private void writeRealChars(TaskAttemptID firstAttemptID, TaskAttemptID attemptID, TaskLog.LogName logName, long numChars, char data) throws IOException {
        this.writeBytes(firstAttemptID, attemptID, logName, numChars, false, data);
    }

    private static Map<TaskLog.LogName, Long> getAllLogsFileLengths(TaskAttemptID tid, boolean isCleanup) throws IOException {
        HashMap<TaskLog.LogName, Long> allLogsFileLengths = new HashMap<TaskLog.LogName, Long>();
        if (!TaskLog.getIndexFile((TaskAttemptID)tid, (boolean)isCleanup).exists()) {
            for (TaskLog.LogName log : TaskLog.LogName.values()) {
                allLogsFileLengths.put(log, 0L);
            }
            return allLogsFileLengths;
        }
        Map logFilesDetails = TaskLog.getAllLogsFileDetails((TaskAttemptID)tid, (boolean)isCleanup, (boolean)false);
        for (TaskLog.LogName log : logFilesDetails.keySet()) {
            allLogsFileLengths.put(log, ((TaskLog.LogFileDetail)logFilesDetails.get((Object)log)).length);
        }
        return allLogsFileLengths;
    }

    private Configuration setRetainSizes(long mapRetainSize, long reduceRetainSize) {
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.cluster.map.userlog.retain-size", mapRetainSize);
        conf.setLong("mapreduce.cluster.reduce.userlog.retain-size", reduceRetainSize);
        return conf;
    }

    @Test
    public void testNoTruncationNeeded() throws IOException {
        File logFile;
        Configuration conf = this.setRetainSizes(1000L, 1000L);
        TaskLogsTruncater trunc = new TaskLogsTruncater(conf);
        TaskID baseId = new TaskID();
        int taskcount = 0;
        TaskAttemptID attemptID = new TaskAttemptID(baseId, taskcount++);
        MapTask task = new MapTask(null, attemptID, 0, new JobSplit.TaskSplitIndex(), 0);
        for (TaskLog.LogName log : TaskLog.LogName.values()) {
            this.writeRandomBytes(attemptID, attemptID, log, 500L);
        }
        File logIndex = TaskLog.getIndexFile((TaskAttemptID)attemptID, (boolean)false);
        long indexModificationTimeStamp = logIndex.lastModified();
        File attemptDir = TaskLog.getAttemptDir((TaskAttemptID)attemptID, (boolean)false);
        Assert.assertTrue((String)(attemptDir + " doesn't exist!"), (boolean)attemptDir.exists());
        Assert.assertEquals((String)"index file got modified", (long)indexModificationTimeStamp, (long)logIndex.lastModified());
        JVMInfo jvmInfo = new JVMInfo(attemptDir, Arrays.asList(task));
        trunc.truncateLogs(jvmInfo);
        Assert.assertTrue((boolean)attemptDir.exists());
        Assert.assertEquals((String)"index file got modified", (long)indexModificationTimeStamp, (long)logIndex.lastModified());
        Map<TaskLog.LogName, Long> logLengths = TestTaskLogsTruncater.getAllLogsFileLengths(attemptID, false);
        for (TaskLog.LogName log : TaskLog.LogName.values()) {
            logFile = TaskLog.getTaskLogFile((TaskAttemptID)attemptID, (boolean)false, (TaskLog.LogName)log);
            Assert.assertEquals((long)500L, (long)logFile.length());
            Assert.assertEquals((long)500L, (long)logLengths.get(log));
        }
        trunc.truncateLogs(jvmInfo);
        Assert.assertEquals((String)"index file got modified", (long)indexModificationTimeStamp, (long)logIndex.lastModified());
        logLengths = TestTaskLogsTruncater.getAllLogsFileLengths(attemptID, false);
        for (TaskLog.LogName log : TaskLog.LogName.values()) {
            logFile = TaskLog.getTaskLogFile((TaskAttemptID)attemptID, (boolean)false, (TaskLog.LogName)log);
            Assert.assertEquals((long)500L, (long)logFile.length());
            Assert.assertEquals((long)500L, (long)logLengths.get(log));
        }
    }

    @Test
    public void testDisabledLogTruncation() throws IOException {
        Configuration conf = this.setRetainSizes(-1L, -1L);
        TaskLogsTruncater trunc = new TaskLogsTruncater(conf);
        TaskID baseId = new TaskID();
        int taskcount = 0;
        TaskAttemptID attemptID = new TaskAttemptID(baseId, taskcount++);
        MapTask task = new MapTask(null, attemptID, 0, new JobSplit.TaskSplitIndex(), 0);
        for (TaskLog.LogName log : TaskLog.LogName.values()) {
            this.writeRandomBytes(attemptID, attemptID, log, 1500L);
        }
        File attemptDir = TaskLog.getAttemptDir((TaskAttemptID)attemptID, (boolean)false);
        Assert.assertTrue((String)(attemptDir + " doesn't exist!"), (boolean)attemptDir.exists());
        JVMInfo jvmInfo = new JVMInfo(attemptDir, Arrays.asList(task));
        trunc.truncateLogs(jvmInfo);
        Assert.assertTrue((boolean)attemptDir.exists());
        Map<TaskLog.LogName, Long> logLengths = TestTaskLogsTruncater.getAllLogsFileLengths(attemptID, false);
        for (TaskLog.LogName log : TaskLog.LogName.values()) {
            File logFile = TaskLog.getTaskLogFile((TaskAttemptID)attemptID, (boolean)false, (TaskLog.LogName)log);
            Assert.assertEquals((long)1500L, (long)logFile.length());
            Assert.assertEquals((long)1500L, (long)logLengths.get(log));
        }
    }

    @Test
    public void testLogTruncationOnFinishing() throws IOException {
        File logFile;
        Configuration conf = this.setRetainSizes(1000L, 1000L);
        TaskLogsTruncater trunc = new TaskLogsTruncater(conf);
        TaskID baseId = new TaskID();
        int taskcount = 0;
        TaskAttemptID attemptID = new TaskAttemptID(baseId, taskcount++);
        MapTask task = new MapTask(null, attemptID, 0, new JobSplit.TaskSplitIndex(), 0);
        for (TaskLog.LogName log : TaskLog.LogName.values()) {
            this.writeRandomBytes(attemptID, attemptID, log, 1500L);
        }
        File attemptDir = TaskLog.getAttemptDir((TaskAttemptID)attemptID, (boolean)false);
        Assert.assertTrue((String)(attemptDir + " doesn't exist!"), (boolean)attemptDir.exists());
        JVMInfo jvmInfo = new JVMInfo(attemptDir, Arrays.asList(task));
        trunc.truncateLogs(jvmInfo);
        Assert.assertTrue((boolean)attemptDir.exists());
        Map<TaskLog.LogName, Long> logLengths = TestTaskLogsTruncater.getAllLogsFileLengths(attemptID, false);
        for (TaskLog.LogName log : TaskLog.LogName.values()) {
            logFile = TaskLog.getTaskLogFile((TaskAttemptID)attemptID, (boolean)false, (TaskLog.LogName)log);
            Assert.assertEquals((long)(1000 + truncatedMsgSize), (long)logFile.length());
            Assert.assertEquals((long)(1000 + truncatedMsgSize), (long)logLengths.get(log));
        }
        logLengths = TestTaskLogsTruncater.getAllLogsFileLengths(attemptID, false);
        for (TaskLog.LogName log : TaskLog.LogName.values()) {
            logFile = TaskLog.getTaskLogFile((TaskAttemptID)attemptID, (boolean)false, (TaskLog.LogName)log);
            Assert.assertEquals((long)(1000 + truncatedMsgSize), (long)logFile.length());
            Assert.assertEquals((long)(1000 + truncatedMsgSize), (long)logLengths.get(log));
        }
    }

    @Test
    public void testLogTruncation() throws IOException {
        Configuration conf = this.setRetainSizes(1000L, 1000L);
        TaskLogsTruncater trunc = new TaskLogsTruncater(conf);
        TaskID baseId = new TaskID();
        int taskcount = 0;
        TaskAttemptID attemptID = new TaskAttemptID(baseId, taskcount++);
        MapTask task = new MapTask(null, attemptID, 0, new JobSplit.TaskSplitIndex(), 0);
        this.writeRandomBytes(attemptID, attemptID, TaskLog.LogName.SYSLOG, 1500L);
        this.writeRandomBytes(attemptID, attemptID, TaskLog.LogName.STDERR, 500L);
        File attemptDir = TaskLog.getAttemptDir((TaskAttemptID)attemptID, (boolean)false);
        Assert.assertTrue((String)(attemptDir + " doesn't exist!"), (boolean)attemptDir.exists());
        JVMInfo jvmInfo = new JVMInfo(attemptDir, Arrays.asList(task));
        trunc.truncateLogs(jvmInfo);
        Assert.assertTrue((boolean)attemptDir.exists());
        Map<TaskLog.LogName, Long> logLengths = TestTaskLogsTruncater.getAllLogsFileLengths(attemptID, false);
        File logFile = TaskLog.getTaskLogFile((TaskAttemptID)attemptID, (boolean)false, (TaskLog.LogName)TaskLog.LogName.SYSLOG);
        Assert.assertEquals((long)(1000 + truncatedMsgSize), (long)logFile.length());
        Assert.assertEquals((long)(1000 + truncatedMsgSize), (long)logLengths.get(TaskLog.LogName.SYSLOG));
        String syslog = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.SYSLOG, attemptID, false);
        Assert.assertTrue((boolean)syslog.startsWith("[ ... this log file was truncated because of excess length]\n"));
        logFile = TaskLog.getTaskLogFile((TaskAttemptID)attemptID, (boolean)false, (TaskLog.LogName)TaskLog.LogName.STDERR);
        Assert.assertEquals((long)500L, (long)logFile.length());
        Assert.assertEquals((long)500L, (long)logLengths.get(TaskLog.LogName.STDERR));
        String stderr = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.STDERR, attemptID, false);
        Assert.assertFalse((boolean)stderr.startsWith("[ ... this log file was truncated because of excess length]\n"));
        trunc.truncateLogs(jvmInfo);
        logLengths = TestTaskLogsTruncater.getAllLogsFileLengths(attemptID, false);
        logFile = TaskLog.getTaskLogFile((TaskAttemptID)attemptID, (boolean)false, (TaskLog.LogName)TaskLog.LogName.SYSLOG);
        Assert.assertEquals((long)(1000 + truncatedMsgSize), (long)logFile.length());
        Assert.assertEquals((long)(1000 + truncatedMsgSize), (long)logLengths.get(TaskLog.LogName.SYSLOG));
        logFile = TaskLog.getTaskLogFile((TaskAttemptID)attemptID, (boolean)false, (TaskLog.LogName)TaskLog.LogName.STDERR);
        Assert.assertEquals((long)500L, (long)logFile.length());
        Assert.assertEquals((long)500L, (long)logLengths.get(TaskLog.LogName.STDERR));
    }

    @Test
    public void testLogTruncationOnFinishingWithJVMReuse() throws IOException {
        int i;
        Configuration conf = this.setRetainSizes(150L, 150L);
        TaskLogsTruncater trunc = new TaskLogsTruncater(conf);
        TaskID baseTaskID = new TaskID();
        int attemptsCount = 0;
        TaskAttemptID attempt1 = new TaskAttemptID(baseTaskID, attemptsCount++);
        MapTask task1 = new MapTask(null, attempt1, 0, new JobSplit.TaskSplitIndex(), 0);
        this.writeRealChars(attempt1, attempt1, TaskLog.LogName.SYSLOG, 200L, 'A');
        File attemptDir = TaskLog.getAttemptDir((TaskAttemptID)attempt1, (boolean)false);
        Assert.assertTrue((String)(attemptDir + " doesn't exist!"), (boolean)attemptDir.exists());
        TaskAttemptID attempt2 = new TaskAttemptID(baseTaskID, attemptsCount++);
        MapTask task2 = new MapTask(null, attempt2, 0, new JobSplit.TaskSplitIndex(), 0);
        this.writeRealChars(attempt1, attempt2, TaskLog.LogName.SYSLOG, 100L, 'B');
        TaskAttemptID attempt3 = new TaskAttemptID(baseTaskID, attemptsCount++);
        MapTask task3 = new MapTask(null, attempt3, 0, new JobSplit.TaskSplitIndex(), 0);
        this.writeRealChars(attempt1, attempt3, TaskLog.LogName.SYSLOG, 225L, 'C');
        JVMInfo jvmInfo = new JVMInfo(attemptDir, Arrays.asList(task1, task2, task3));
        trunc.truncateLogs(jvmInfo);
        Assert.assertTrue((boolean)attemptDir.exists());
        File logFile = TaskLog.getTaskLogFile((TaskAttemptID)attempt1, (boolean)false, (TaskLog.LogName)TaskLog.LogName.SYSLOG);
        Assert.assertEquals((long)(400 + 2 * truncatedMsgSize), (long)logFile.length());
        Assert.assertEquals((long)(150 + truncatedMsgSize), (long)TestTaskLogsTruncater.getAllLogsFileLengths(attempt1, false).get(TaskLog.LogName.SYSLOG));
        Assert.assertEquals((long)100L, (long)TestTaskLogsTruncater.getAllLogsFileLengths(attempt2, false).get(TaskLog.LogName.SYSLOG));
        Assert.assertEquals((long)(150 + truncatedMsgSize), (long)TestTaskLogsTruncater.getAllLogsFileLengths(attempt3, false).get(TaskLog.LogName.SYSLOG));
        String syslog = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.SYSLOG, attempt1, false);
        Assert.assertTrue((boolean)syslog.startsWith("[ ... this log file was truncated because of excess length]\n"));
        String truncatedLog = syslog.substring(truncatedMsgSize);
        for (i = 0; i < 150; ++i) {
            Assert.assertEquals((String)("Truncation didn't happen properly. At " + (i + 1) + "th byte, expected 'A' but found " + truncatedLog.charAt(i)), (long)65L, (long)truncatedLog.charAt(i));
        }
        syslog = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.SYSLOG, attempt2, false);
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((String)("Truncation didn't happen properly. At " + (i + 1) + "th byte, expected 'B' but found " + truncatedLog.charAt(i)), (long)66L, (long)syslog.charAt(i));
        }
        syslog = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.SYSLOG, attempt3, false);
        Assert.assertTrue((boolean)syslog.startsWith("[ ... this log file was truncated because of excess length]\n"));
        truncatedLog = syslog.substring(truncatedMsgSize);
        for (i = 0; i < 150; ++i) {
            Assert.assertEquals((String)("Truncation didn't happen properly. At " + (i + 1) + "th byte, expected 'C' but found " + truncatedLog.charAt(i)), (long)67L, (long)truncatedLog.charAt(i));
        }
        trunc.truncateLogs(jvmInfo);
        Assert.assertEquals((long)(400 + 2 * truncatedMsgSize), (long)logFile.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    @Ignore
    public void testLogsMonitoringWithMiniMR() throws IOException {
        MiniMRCluster mr = null;
        try {
            long LSIZE = 10000L;
            JobConf clusterConf = new JobConf();
            clusterConf.setLong("mapreduce.cluster.map.userlog.retain-size", 10000L);
            clusterConf.setLong("mapreduce.cluster.reduce.userlog.retain-size", 10000L);
            mr = new MiniMRCluster(1, "file:///", 3, null, null, clusterConf);
            JobConf conf = mr.createJobConf();
            Path inDir = new Path(TEST_ROOT_DIR + "/input");
            Path outDir = new Path(TEST_ROOT_DIR + "/output");
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (fs.exists(outDir)) {
                fs.delete(outDir, true);
            }
            if (!fs.exists(inDir)) {
                fs.mkdirs(inDir);
            }
            String input = "The quick brown fox jumped over the lazy dog";
            FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
            file.writeBytes(input);
            file.close();
            conf.setInputFormat(TextInputFormat.class);
            conf.setOutputKeyClass(LongWritable.class);
            conf.setOutputValueClass(Text.class);
            FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
            conf.setNumMapTasks(1);
            conf.setNumReduceTasks(0);
            conf.setMapperClass(LoggingMapper.class);
            RunningJob job = JobClient.runJob((JobConf)conf);
            Assert.assertTrue((job.getJobState() == 2 ? 1 : 0) != 0);
            long maxLength = 10000 + truncatedMsgSize;
            boolean truncated = false;
            long stopLoopingTime = System.currentTimeMillis() + 20000L;
            while (!truncated) {
                boolean expired = System.currentTimeMillis() > stopLoopingTime;
                for (TaskCompletionEvent tce : job.getTaskCompletionEvents(0)) {
                    long length = TaskLog.getTaskLogFile((TaskAttemptID)tce.getTaskAttemptId(), (boolean)false, (TaskLog.LogName)TaskLog.LogName.STDOUT).length();
                    boolean bl = truncated = length <= maxLength;
                    if (!truncated && expired) {
                        Assert.fail((String)("STDOUT log file length for " + tce.getTaskAttemptId() + " is " + length + " and not <=" + maxLength));
                    }
                    if (!tce.isMap) continue;
                    String stderr = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.STDERR, tce.getTaskAttemptId(), false);
                    System.out.println("STDERR log:" + stderr);
                    Assert.assertTrue((boolean)stderr.equals(STDERR_LOG));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    @Ignore
    public void testDebugLogsTruncationWithMiniMR() throws IOException {
        block24: {
            MiniMRCluster mr = null;
            try {
                long LSIZE = 10000L;
                JobConf clusterConf = new JobConf();
                clusterConf.setLong("mapreduce.cluster.map.userlog.retain-size", 10000L);
                clusterConf.setLong("mapreduce.cluster.reduce.userlog.retain-size", 10000L);
                mr = new MiniMRCluster(1, "file:///", 3, null, null, clusterConf);
                JobConf conf = mr.createJobConf();
                Path inDir = new Path(TEST_ROOT_DIR + "/input");
                Path outDir = new Path(TEST_ROOT_DIR + "/output");
                FileSystem fs = FileSystem.get((Configuration)conf);
                if (fs.exists(outDir)) {
                    fs.delete(outDir, true);
                }
                if (!fs.exists(inDir)) {
                    fs.mkdirs(inDir);
                }
                String input = "The quick brown fox jumped over the lazy dog";
                FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
                file.writeBytes(input);
                file.close();
                conf.setInputFormat(TextInputFormat.class);
                conf.setOutputKeyClass(LongWritable.class);
                conf.setOutputValueClass(Text.class);
                FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
                FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
                conf.setNumMapTasks(1);
                conf.setMaxMapAttempts(1);
                conf.setNumReduceTasks(0);
                conf.setMapperClass(TestMiniMRMapRedDebugScript.MapClass.class);
                Path scriptPath = new Path(TEST_ROOT_DIR, "debug-script.txt");
                String debugScriptContent = "for ((i=0;i<1000;i++)); do echo \"Lots of logs! Lots of logs! Waiting to be truncated! Lots of logs!\";done";
                FSDataOutputStream scriptFile = fs.create(scriptPath);
                scriptFile.writeBytes(debugScriptContent);
                scriptFile.close();
                new File(scriptPath.toUri().getPath()).setExecutable(true);
                URI uri = scriptPath.toUri();
                DistributedCache.createSymlink((Configuration)conf);
                DistributedCache.addCacheFile((URI)uri, (Configuration)conf);
                conf.setMapDebugScript(scriptPath.toUri().getPath());
                RunningJob job = null;
                try {
                    JobClient jc = new JobClient(conf);
                    job = jc.submitJob(conf);
                    try {
                        jc.monitorAndPrintJob(conf, job);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                catch (IOException maxLength) {
                    long maxLength2 = 10000 + truncatedMsgSize;
                    boolean truncated = false;
                    long stopLoopingTime = System.currentTimeMillis() + 20000L;
                    while (!truncated) {
                        boolean expired = System.currentTimeMillis() > stopLoopingTime;
                        for (TaskCompletionEvent tce : job.getTaskCompletionEvents(0)) {
                            File debugOutFile = TaskLog.getTaskLogFile((TaskAttemptID)tce.getTaskAttemptId(), (boolean)false, (TaskLog.LogName)TaskLog.LogName.DEBUGOUT);
                            Assert.assertTrue((String)("DEBUGOUT log file for " + tce.getTaskAttemptId() + " should exist"), (!expired || debugOutFile.exists() ? 1 : 0) != 0);
                            if (!debugOutFile.exists()) continue;
                            long length = debugOutFile.length();
                            truncated = length == maxLength2;
                            Assert.assertTrue((String)("DEBUGOUT log file length for " + tce.getTaskAttemptId() + " is " + length + " and not " + maxLength2), (truncated || !expired ? 1 : 0) != 0);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    break block24;
                    catch (Throwable throwable) {
                        long maxLength3 = 10000 + truncatedMsgSize;
                        boolean truncated2 = false;
                        long stopLoopingTime2 = System.currentTimeMillis() + 20000L;
                        while (!truncated2) {
                            boolean expired = System.currentTimeMillis() > stopLoopingTime2;
                            for (TaskCompletionEvent tce : job.getTaskCompletionEvents(0)) {
                                File debugOutFile = TaskLog.getTaskLogFile((TaskAttemptID)tce.getTaskAttemptId(), (boolean)false, (TaskLog.LogName)TaskLog.LogName.DEBUGOUT);
                                Assert.assertTrue((String)("DEBUGOUT log file for " + tce.getTaskAttemptId() + " should exist"), (!expired || debugOutFile.exists() ? 1 : 0) != 0);
                                if (!debugOutFile.exists()) continue;
                                long length = debugOutFile.length();
                                truncated2 = length == maxLength3;
                                Assert.assertTrue((String)("DEBUGOUT log file length for " + tce.getTaskAttemptId() + " is " + length + " and not " + maxLength3), (truncated2 || !expired ? 1 : 0) != 0);
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        throw throwable;
                    }
                }
                long maxLength = 10000 + truncatedMsgSize;
                boolean truncated = false;
                long stopLoopingTime = System.currentTimeMillis() + 20000L;
                while (!truncated) {
                    boolean expired = System.currentTimeMillis() > stopLoopingTime;
                    for (TaskCompletionEvent tce : job.getTaskCompletionEvents(0)) {
                        File debugOutFile = TaskLog.getTaskLogFile((TaskAttemptID)tce.getTaskAttemptId(), (boolean)false, (TaskLog.LogName)TaskLog.LogName.DEBUGOUT);
                        Assert.assertTrue((String)("DEBUGOUT log file for " + tce.getTaskAttemptId() + " should exist"), (!expired || debugOutFile.exists() ? 1 : 0) != 0);
                        if (!debugOutFile.exists()) continue;
                        long length = debugOutFile.length();
                        truncated = length == maxLength;
                        Assert.assertTrue((String)("DEBUGOUT log file length for " + tce.getTaskAttemptId() + " is " + length + " and not " + maxLength), (truncated || !expired ? 1 : 0) != 0);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                if (mr != null) {
                    mr.shutdown();
                }
            }
        }
    }

    public static class LoggingMapper<K, V>
    extends IdentityMapper<K, V> {
        public void map(K key, V val, OutputCollector<K, V> output, Reporter reporter) throws IOException {
            for (int i = 0; i < 1000; ++i) {
                System.out.println("Lots of logs! Lots of logs! Waiting to be truncated! Lots of logs!");
            }
            System.err.println(STDERR_LOG);
            super.map(key, val, output, reporter);
        }
    }
}

