/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TestJobHistory;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.security.UserGroupInformation;

public class TestLostTracker
extends TestCase {
    final Path testDir = new Path("/jt-lost-tt");
    final Path inDir = new Path(this.testDir, "input");
    final Path shareDir = new Path(this.testDir, "share");
    final Path outputDir = new Path(this.testDir, "output");

    private JobConf configureJob(JobConf conf, int maps, int reduces, String mapSignal, String redSignal) throws IOException {
        UtilsForTests.configureWaitingJobConf(conf, this.inDir, this.outputDir, maps, reduces, "test-lost-tt", mapSignal, redSignal);
        return conf;
    }

    public void testLostTracker(MiniDFSCluster dfs, MiniMRCluster mr) throws IOException {
        DistributedFileSystem fileSys = dfs.getFileSystem();
        JobConf jobConf = mr.createJobConf();
        int numMaps = 10;
        int numReds = 1;
        String mapSignalFile = UtilsForTests.getMapSignalFile(this.shareDir);
        String redSignalFile = UtilsForTests.getReduceSignalFile(this.shareDir);
        jobConf.set("user.name", UserGroupInformation.getCurrentUser().getUserName());
        JobConf job = this.configureJob(jobConf, numMaps, numReds, mapSignalFile, redSignalFile);
        fileSys.delete(this.shareDir, true);
        JobClient jobClient = new JobClient(job);
        RunningJob rJob = jobClient.submitJob(job);
        JobID id = rJob.getID();
        mr.initializeJob(id);
        while (UtilsForTests.getJobStatus(jobClient, id).mapProgress() < 0.5f) {
            UtilsForTests.waitFor(10L);
        }
        TaskAttemptID taskid = ((TaskStatus)mr.getTaskTrackerRunner(0).getTaskTracker().getNonRunningTasks().get(0)).getTaskID();
        mr.stopTaskTracker(0);
        UtilsForTests.signalTasks(dfs, (FileSystem)fileSys, true, mapSignalFile, redSignalFile);
        UtilsForTests.signalTasks(dfs, (FileSystem)fileSys, false, mapSignalFile, redSignalFile);
        UtilsForTests.waitTillDone(jobClient);
        TestLostTracker.assertEquals((int)jobClient.getClusterStatus().getTaskTrackers(), (int)1);
        TestLostTracker.assertEquals((int)2, (int)rJob.getJobState());
        TaskInProgress tip = mr.getJobTrackerRunner().getJobTracker().getTip(taskid.getTaskID());
        TestLostTracker.assertTrue((boolean)tip.isComplete());
        TestLostTracker.assertEquals((int)tip.numKilledTasks(), (int)1);
        JobTracker jt = mr.getJobTrackerRunner().getJobTracker();
        for (TaskInProgress mtip : jt.getJob(id).getTasks(TaskType.MAP)) {
            this.testTaskStatuses(mtip.getTaskStatuses());
        }
        TestJobHistory.validateJobHistoryFileFormat(id, job, "SUCCESS", true);
        TestJobHistory.validateJobHistoryFileContent(mr, rJob, job);
    }

    private void testTaskStatuses(TaskStatus[] tasks) {
        for (TaskStatus status : tasks) {
            TestLostTracker.assertTrue((String)("Invalid start time " + status.getStartTime()), (status.getStartTime() > 0L ? 1 : 0) != 0);
            TestLostTracker.assertTrue((String)("Invalid finish time " + status.getFinishTime()), (status.getFinishTime() > 0L ? 1 : 0) != 0);
            TestLostTracker.assertTrue((String)("Start time (" + status.getStartTime() + ") is greater than " + "the finish time (" + status.getFinishTime() + ")"), (status.getStartTime() <= status.getFinishTime() ? 1 : 0) != 0);
            TestLostTracker.assertNotNull((String)"Task phase information is null", (Object)status.getPhase());
            TestLostTracker.assertNotNull((String)"Task run-state information is null", (Object)status.getRunState());
            TestLostTracker.assertNotNull((String)"TaskTracker information is null", (Object)status.getTaskTracker());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLostTracker() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster(conf, 1, true, null, null);
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            fileSys.delete(this.testDir, true);
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file"), (short)1);
            dfs.startDataNodes(conf, 1, true, null, null, null, null);
            dfs.waitActive();
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            JobConf jtConf = new JobConf();
            jtConf.setInt("mapred.tasktracker.map.tasks.maximum", 1);
            jtConf.setInt("mapred.tasktracker.reduce.tasks.maximum", 1);
            jtConf.setLong("mapred.tasktracker.expiry.interval", 10000L);
            jtConf.setInt("mapred.reduce.copy.backoff", 4);
            mr = new MiniMRCluster(2, namenode, 1, null, null, jtConf);
            this.testLostTracker(dfs, mr);
        }
        finally {
            if (mr != null) {
                try {
                    mr.shutdown();
                }
                catch (Exception exception) {}
            }
            if (dfs != null) {
                try {
                    dfs.shutdown();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) throws IOException {
        new TestLostTracker().testLostTracker();
    }
}

