/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocketInputWrapper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestNetUtils {
    static final long TIME_FUDGE_MILLIS = 200L;

    @Test
    public void testAvoidLoopbackTcpSockets() throws Exception {
        Configuration conf = new Configuration();
        Socket socket = NetUtils.getDefaultSocketFactory((Configuration)conf).createSocket();
        socket.bind(new InetSocketAddress("127.0.0.1", 0));
        System.err.println("local address: " + socket.getLocalAddress());
        System.err.println("local port: " + socket.getLocalPort());
        try {
            NetUtils.connect((Socket)socket, (SocketAddress)new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort()), (int)20000);
            socket.close();
            Assert.fail((String)"Should not have connected");
        }
        catch (ConnectException ce) {
            System.err.println("Got exception: " + ce);
            Assert.assertTrue((boolean)ce.getMessage().contains("resulted in a loopback"));
        }
    }

    @Test
    public void testSocketReadTimeoutWithChannel() throws Exception {
        this.doSocketReadTimeoutTest(true);
    }

    @Test
    public void testSocketReadTimeoutWithoutChannel() throws Exception {
        this.doSocketReadTimeoutTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSocketReadTimeoutTest(boolean withChannel) throws IOException {
        SocketInputWrapper stm;
        Socket s;
        ServerSocket ss;
        block5: {
            ss = new ServerSocket(0);
            if (withChannel) {
                s = NetUtils.getDefaultSocketFactory((Configuration)new Configuration()).createSocket();
                Assume.assumeNotNull((Object[])new Object[]{s.getChannel()});
            } else {
                s = new Socket();
                Assert.assertNull((Object)s.getChannel());
            }
            stm = null;
            try {
                NetUtils.connect((Socket)s, (SocketAddress)ss.getLocalSocketAddress(), (int)1000);
                stm = NetUtils.getInputStream((Socket)s, (long)1000L);
                this.assertReadTimeout(stm, 1000);
                stm.setTimeout(1L);
                this.assertReadTimeout(stm, 1);
                s.setSoTimeout(1000);
                if (withChannel) {
                    this.assertReadTimeout(stm, 1);
                    break block5;
                }
                this.assertReadTimeout(stm, 1000);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(stm);
                IOUtils.closeSocket((Socket)s);
                ss.close();
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)stm);
        IOUtils.closeSocket((Socket)s);
        ss.close();
    }

    private void assertReadTimeout(SocketInputWrapper stm, int timeoutMillis) throws IOException {
        long st = System.nanoTime();
        try {
            stm.read();
            Assert.fail((String)"Didn't time out");
        }
        catch (SocketTimeoutException ste) {
            this.assertTimeSince(st, timeoutMillis);
        }
    }

    private void assertTimeSince(long startNanos, int expectedMillis) {
        long durationNano = System.nanoTime() - startNanos;
        long millis = TimeUnit.MILLISECONDS.convert(durationNano, TimeUnit.NANOSECONDS);
        Assert.assertTrue((String)("Expected " + expectedMillis + "ms, but took " + millis), (Math.abs(millis - (long)expectedMillis) < 200L ? 1 : 0) != 0);
    }
}

