/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricCounterLong;
import org.apache.hadoop.metrics2.impl.MetricGaugeDouble;
import org.apache.hadoop.metrics2.impl.MetricGaugeLong;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.apache.hadoop.metrics2.lib.AbstractMetricsSource;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;
import org.apache.hadoop.test.MoreAsserts;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMetricsSystemImpl {
    private static final Log LOG = LogFactory.getLog(TestMetricsSystemImpl.class);
    @Captor
    private ArgumentCaptor<MetricsRecord> r1;
    @Captor
    private ArgumentCaptor<MetricsRecord> r2;
    private static String hostname = MetricsSystemImpl.getHostname();

    @Test
    public void testInitFirst() throws Exception {
        ConfigBuilder cb = new ConfigBuilder().add("default.period", 8).add("Test.sink.0.class", "org.apache.hadoop.metrics.sink.FileSink").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        TestSource s1 = (TestSource)ms.register("s1", "s1 desc", (MetricsSource)new TestSource("s1rec"));
        s1.s1.add(0L);
        MetricsSink sink1 = (MetricsSink)Mockito.mock(MetricsSink.class);
        MetricsSink sink2 = (MetricsSink)Mockito.mock(MetricsSink.class);
        ms.register("sink1", "sink1 desc", sink1);
        ms.register("sink2", "sink2 desc", sink2);
        ms.onTimerEvent();
        ms.stop();
        ((MetricsSink)Mockito.verify((Object)sink1, (VerificationMode)Mockito.times((int)2))).putMetrics((MetricsRecord)this.r1.capture());
        List mr1 = this.r1.getAllValues();
        ((MetricsSink)Mockito.verify((Object)sink2, (VerificationMode)Mockito.times((int)2))).putMetrics((MetricsRecord)this.r2.capture());
        List mr2 = this.r2.getAllValues();
        TestMetricsSystemImpl.checkMetricsRecords(mr1);
        MoreAsserts.assertEquals("output", mr1, mr2);
    }

    static void checkMetricsRecords(List<MetricsRecord> recs) {
        LOG.debug(recs);
        MetricsRecord r = recs.get(0);
        Assert.assertEquals((String)"name", (Object)"s1rec", (Object)r.name());
        MoreAsserts.assertEquals("tags", new MetricsTag[]{new MetricsTag("context", "Metrics context", "test"), new MetricsTag("hostName", "Local hostname", hostname)}, r.tags());
        MoreAsserts.assertEquals("metrics", new Metric[]{new MetricCounterLong("c1", "c1 desc", 1L), new MetricGaugeLong("g1", "g1 desc", 2L), new MetricCounterLong("s1_num_ops", "Number of ops for s1 desc", 1L), new MetricGaugeDouble("s1_avg_time", "Average time for s1 desc", 0.0)}, r.metrics());
    }

    private static class TestSource
    extends AbstractMetricsSource {
        final MetricMutableCounterLong c1;
        final MetricMutableGaugeLong g1;
        final MetricMutableStat s1;

        TestSource(String name) {
            super(name);
            this.registry.setContext("test");
            this.c1 = this.registry.newCounter("c1", "c1 desc", 1L);
            this.g1 = this.registry.newGauge("g1", "g1 desc", 2L);
            this.s1 = this.registry.newStat("s1", "s1 desc", "ops", "time");
        }
    }
}

