/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class TestCombineFileInputFormat
extends TestCase {
    private static final String[] rack1 = new String[]{"/r1"};
    private static final String[] hosts1 = new String[]{"host1.rack1.com"};
    private static final String[] rack2 = new String[]{"/r2"};
    private static final String[] hosts2 = new String[]{"host2.rack2.com"};
    private static final String[] rack3 = new String[]{"/r3"};
    private static final String[] hosts3 = new String[]{"host3.rack3.com"};
    final Path inDir = new Path("/racktesting");
    final Path outputPath = new Path("/output");
    final Path dir1 = new Path(this.inDir, "/dir1");
    final Path dir2 = new Path(this.inDir, "/dir2");
    final Path dir3 = new Path(this.inDir, "/dir3");
    final Path dir4 = new Path(this.inDir, "/dir4");
    static final int BLOCKSIZE = 1024;
    static final byte[] databuf = new byte[1024];
    private static final String DUMMY_KEY = "dummy.rr.key";

    public void testRecordReaderInit() throws InterruptedException, IOException {
        TaskAttemptID taskId = new TaskAttemptID("jt", 0, true, 0, 0);
        Configuration conf1 = new Configuration();
        conf1.set(DUMMY_KEY, "STATE1");
        TaskAttemptContext context1 = new TaskAttemptContext(conf1, taskId);
        ChildRRInputFormat inputFormat = new ChildRRInputFormat();
        Path[] files = new Path[]{new Path("file1")};
        long[] lengths = new long[]{1L};
        CombineFileSplit split = new CombineFileSplit(files, lengths);
        RecordReader rr = inputFormat.createRecordReader((InputSplit)split, context1);
        TestCombineFileInputFormat.assertTrue((String)"Unexpected RR type!", (boolean)(rr instanceof CombineFileRecordReader));
        TestCombineFileInputFormat.assertEquals((String)"Invalid initial dummy key value", (String)"STATE1", (String)rr.getCurrentKey().toString());
        Configuration conf2 = new Configuration();
        conf2.set(DUMMY_KEY, "STATE2");
        TaskAttemptContext context2 = new TaskAttemptContext(conf2, taskId);
        rr.initialize((InputSplit)split, context2);
        TestCombineFileInputFormat.assertEquals((String)"Invalid secondary dummy key value", (String)"STATE2", (String)rr.getCurrentKey().toString());
    }

    public void testReinit() throws Exception {
        TaskAttemptID taskId = new TaskAttemptID("jt", 0, true, 0, 0);
        Configuration conf = new Configuration();
        TaskAttemptContext context = new TaskAttemptContext(conf, taskId);
        ChildRRInputFormat inputFormat = new ChildRRInputFormat();
        Path[] files = new Path[]{new Path("file1"), new Path("file2")};
        long[] lengths = new long[]{1L, 1L};
        CombineFileSplit split = new CombineFileSplit(files, lengths);
        RecordReader rr = inputFormat.createRecordReader((InputSplit)split, context);
        TestCombineFileInputFormat.assertTrue((String)"Unexpected RR type!", (boolean)(rr instanceof CombineFileRecordReader));
        rr.initialize((InputSplit)split, context);
        TestCombineFileInputFormat.assertTrue((boolean)rr.nextKeyValue());
        TestCombineFileInputFormat.assertEquals((String)"file1", (String)rr.getCurrentValue().toString());
        TestCombineFileInputFormat.assertTrue((boolean)rr.nextKeyValue());
        TestCombineFileInputFormat.assertEquals((String)"file2", (String)rr.getCurrentValue().toString());
        TestCombineFileInputFormat.assertFalse((boolean)rr.nextKeyValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitPlacement() throws IOException {
        MiniDFSCluster dfs = null;
        FileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster(conf, 1, true, rack1, hosts1);
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1");
            TestCombineFileInputFormat.writeFile(conf, file1, (short)1, 1);
            dfs.startDataNodes(conf, 1, true, null, rack2, hosts2, null);
            dfs.waitActive();
            Path file2 = new Path(this.dir2 + "/file2");
            TestCombineFileInputFormat.writeFile(conf, file2, (short)2, 2);
            DummyInputFormat inFormat = new DummyInputFormat();
            Job job = new Job(conf);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2));
            inFormat.setMinSplitSizeRack(1024L);
            List splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test1): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.size(), (int)2);
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            dfs.startDataNodes(conf, 1, true, null, rack3, hosts3, null);
            dfs.waitActive();
            Path file3 = new Path(this.dir3 + "/file3");
            TestCombineFileInputFormat.writeFile(conf, new Path(this.dir3 + "/file3"), (short)3, 3);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test2): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.size(), (int)3);
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)3);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts3[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            Path file4 = new Path(this.dir4 + "/file4");
            TestCombineFileInputFormat.writeFile(conf, file4, (short)3, 3);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test3): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.size(), (int)3);
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)6);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts3[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(2048L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test4): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.size(), (int)5);
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(3072L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.size(), (int)4);
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)3);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host2.rack2.com");
            fileSplit = (CombineFileSplit)splits.get(3);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host1.rack1.com");
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(4096L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.size(), (int)3);
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)4);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)4);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(3).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(3), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(3), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host2.rack2.com");
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(7168L);
            inFormat.setMinSplitSizeNode(3072L);
            inFormat.setMinSplitSizeRack(3072L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.size(), (int)2);
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)6);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)3);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host1.rack1.com");
            inFormat = new DummyInputFormat();
            FileInputFormat.addInputPath((Job)job, (Path)this.inDir);
            inFormat.setMinSplitSizeRack(1L);
            inFormat.createPool(new PathFilter[]{new TestFilter(this.dir1), new TestFilter(this.dir2)});
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.size(), (int)3);
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)6);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts3[0]);
            int numPools = 100;
            int numFiles = 1000;
            DummyInputFormat1 inFormat1 = new DummyInputFormat1();
            for (int i = 0; i < numFiles; ++i) {
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{file1});
            }
            inFormat1.setMinSplitSizeRack(1L);
            Path dirNoMatch1 = new Path(this.inDir, "/dirxx");
            Path dirNoMatch2 = new Path(this.inDir, "/diryy");
            for (int i = 0; i < numPools; ++i) {
                inFormat1.createPool(new PathFilter[]{new TestFilter(dirNoMatch1), new TestFilter(dirNoMatch2)});
            }
            long start = System.currentTimeMillis();
            splits = inFormat1.getSplits((JobContext)job);
            long end = System.currentTimeMillis();
            System.out.println("Elapsed time for " + numPools + " pools " + " and " + numFiles + " files is " + (end - start) / 1000L + " seconds.");
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static void writeFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        FSDataOutputStream stm = fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L);
        for (int i = 0; i < numBlocks; ++i) {
            stm.write(databuf);
        }
        stm.close();
        DFSTestUtil.waitReplication(fileSys, name, replication);
    }

    private void splitRealFiles(String[] args) throws IOException {
        Configuration conf = new Configuration();
        Job job = new Job();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IOException("Wrong file system: " + fs.getClass().getName());
        }
        int blockSize = conf.getInt("dfs.block.size", 0x8000000);
        DummyInputFormat inFormat = new DummyInputFormat();
        for (int i = 0; i < args.length; ++i) {
            FileInputFormat.addInputPaths((Job)job, (String)args[i]);
        }
        inFormat.setMinSplitSizeRack(blockSize);
        inFormat.setMaxSplitSize(10 * blockSize);
        List splits = inFormat.getSplits((JobContext)job);
        System.out.println("Total number of splits " + splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(i);
            System.out.println("Split[" + i + "] " + fileSplit);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.splitRealFiles(args);
        } else {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.testSplitPlacement();
        }
    }

    static class TestFilter
    implements PathFilter {
        private Path p;

        public TestFilter(Path p) {
            this.p = p;
        }

        public boolean accept(Path path) {
            return path.toString().indexOf(this.p.toString()) == 0;
        }

        public String toString() {
            return "PathFilter:" + this.p;
        }
    }

    private class ChildRRInputFormat
    extends CombineFileInputFormat<Text, Text> {
        private ChildRRInputFormat() {
        }

        public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return new CombineFileRecordReader((CombineFileSplit)split, context, DummyRecordReader.class);
        }
    }

    private static class DummyRecordReader
    extends RecordReader<Text, Text> {
        private TaskAttemptContext context;
        private CombineFileSplit s;
        private int idx;
        private boolean used;

        public DummyRecordReader(CombineFileSplit split, TaskAttemptContext context, Integer i) {
            this.context = context;
            this.idx = i;
            this.s = split;
            this.used = true;
        }

        public String getDummyConfVal() {
            return this.context.getConfiguration().get(TestCombineFileInputFormat.DUMMY_KEY);
        }

        public void initialize(InputSplit split, TaskAttemptContext context) {
            this.context = context;
            this.s = (CombineFileSplit)split;
            this.used = false;
        }

        public boolean nextKeyValue() {
            boolean ret = !this.used;
            this.used = true;
            return ret;
        }

        public Text getCurrentKey() {
            return new Text(this.context.getConfiguration().get(TestCombineFileInputFormat.DUMMY_KEY));
        }

        public Text getCurrentValue() {
            return new Text(this.s.getPath(this.idx).toString());
        }

        public float getProgress() {
            return this.used ? 1.0f : 0.0f;
        }

        public void close() {
        }
    }

    private class DummyInputFormat1
    extends DummyInputFormat {
        private DummyInputFormat1() {
        }

        protected List<FileStatus> listStatus(JobContext job) throws IOException {
            Path[] files = DummyInputFormat1.getInputPaths((JobContext)job);
            ArrayList<FileStatus> results = new ArrayList<FileStatus>();
            for (int i = 0; i < files.length; ++i) {
                Path p = files[i];
                FileSystem fs = p.getFileSystem(job.getConfiguration());
                results.add(fs.getFileStatus(p));
            }
            return results;
        }
    }

    private class DummyInputFormat
    extends CombineFileInputFormat<Text, Text> {
        private DummyInputFormat() {
        }

        public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return null;
        }
    }
}

