/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestDuplicateArchiveFileCachedURLMinicluster
extends ClusterMapReduceTestCase {
    public void testDuplicationsMinicluster() throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("hello1\n");
        wr.write("hello2\n");
        wr.write("hello3\n");
        wr.write("hello4\n");
        ((Writer)wr).close();
        JobConf conf = this.createJobConf();
        conf.setJobName("counters");
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputDir()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.getOutputDir());
        Path inputRoot = this.getInputDir().makeQualified(this.getFileSystem());
        Path unqualifiedInputRoot = this.getInputDir();
        System.out.println("The qualified input dir is " + inputRoot.toString());
        System.out.println("The unqualified input dir is " + unqualifiedInputRoot.toString());
        Path duplicatedPath = new Path(inputRoot, "text.txt");
        URI duplicatedURI = duplicatedPath.toUri();
        Path unqualifiedDuplicatedPath = new Path(unqualifiedInputRoot, "text.txt");
        URI unqualifiedDuplicatedURI = unqualifiedDuplicatedPath.toUri();
        System.out.println("The duplicated Path is " + duplicatedPath);
        System.out.println("The duplicated URI is " + duplicatedURI);
        System.out.println("The unqualified duplicated URI is " + unqualifiedDuplicatedURI);
        DistributedCache.addCacheArchive((URI)duplicatedURI, (Configuration)conf);
        DistributedCache.addCacheFile((URI)unqualifiedDuplicatedURI, (Configuration)conf);
        try {
            RunningJob runningJob = JobClient.runJob((JobConf)conf);
            TestDuplicateArchiveFileCachedURLMinicluster.assertFalse((String)"The job completed, which is wrong since there's a duplication", (boolean)true);
        }
        catch (InvalidJobConfException e) {
            System.out.println("We expect to see a stack trace here.");
            e.printStackTrace(System.out);
        }
    }

    public void testApparentDuplicationsMinicluster() throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text2.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("hello1\n");
        wr.write("hello2\n");
        wr.write("hello3\n");
        wr.write("hello4\n");
        ((Writer)wr).close();
        JobConf conf = this.createJobConf();
        conf.setJobName("counters");
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputDir()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.getOutputDir());
        Path localInputRoot = this.getInputDir().makeQualified((FileSystem)lfs);
        Path dfsInputRoot = this.getInputDir().makeQualified(this.getFileSystem());
        Path unqualifiedInputRoot = this.getInputDir();
        System.out.println("The qualified input dir is " + dfsInputRoot.toString());
        System.out.println("The unqualified input dir is " + unqualifiedInputRoot.toString());
        Path dfsUnqualPath = new Path(unqualifiedInputRoot, "text2.txt");
        Path dfsQualPath = new Path(dfsInputRoot, "test2.text");
        Path localQualPath = new Path(localInputRoot, "test2.text");
        System.out.println("The dfs unqualified Path is " + dfsUnqualPath);
        System.out.println("The dfs qualified Path is " + dfsQualPath);
        System.out.println("The local qualified path is " + localQualPath);
        DistributedCache.addCacheArchive((URI)localQualPath.toUri(), (Configuration)conf);
        DistributedCache.addCacheFile((URI)dfsUnqualPath.toUri(), (Configuration)conf);
        DistributedCache.addCacheFile((URI)dfsQualPath.toUri(), (Configuration)conf);
        try {
            RunningJob runningJob = JobClient.runJob((JobConf)conf);
            TestDuplicateArchiveFileCachedURLMinicluster.assertFalse((String)"The job completed, which is wrong since there's no local cached file", (boolean)true);
        }
        catch (InvalidJobConfException e) {
            System.out.println("We expect to see a stack trace here.");
            e.printStackTrace(System.out);
            TestDuplicateArchiveFileCachedURLMinicluster.assertFalse((String)"This error should not occur.", (boolean)true);
        }
        catch (FileNotFoundException e) {
            System.out.println(" got an expected FileNotFoundException because we didn't provide cached files");
        }
    }

    static enum EnumCounter {
        MAP_RECORDS;

    }
}

