/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSecureIOUtils {
    private static String realOwner;
    private static final File testFilePath;

    @BeforeClass
    public static void makeTestFile() throws Exception {
        FileOutputStream fos = new FileOutputStream(testFilePath);
        fos.write("hello".getBytes("UTF-8"));
        fos.close();
        Configuration conf = new Configuration();
        FileSystem rawFS = FileSystem.getLocal((Configuration)conf).getRaw();
        FileStatus stat = rawFS.getFileStatus(new Path(testFilePath.toString()));
        realOwner = stat.getOwner();
    }

    @Test
    public void testReadUnrestricted() throws IOException {
        SecureIOUtils.openForRead((File)testFilePath, null).close();
    }

    @Test
    public void testReadCorrectlyRestrictedWithSecurity() throws IOException {
        SecureIOUtils.openForRead((File)testFilePath, (String)realOwner).close();
    }

    @Test
    public void testReadIncorrectlyRestrictedWithSecurity() throws IOException {
        Assume.assumeTrue((boolean)NativeIO.isAvailable());
        System.out.println("Running test with native libs...");
        try {
            SecureIOUtils.forceSecureOpenForRead((File)testFilePath, (String)"invalidUser").close();
            Assert.fail((String)"Didn't throw expection for wrong ownership!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateForWrite() throws IOException {
        try {
            SecureIOUtils.createForWrite((File)testFilePath, (int)511);
            Assert.fail((String)("Was able to create file at " + testFilePath));
        }
        catch (SecureIOUtils.AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    static {
        testFilePath = new File(System.getProperty("test.build.data"), "TestSecureIOContext");
    }
}

