/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;

public class TestSafeMode
extends TestCase {
    static Log LOG = LogFactory.getLog(TestSafeMode.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManualSafeMode() throws IOException {
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            Configuration conf = new Configuration();
            conf.set("dfs.safemode.extension", "1");
            cluster = new MiniDFSCluster(conf, 1, true, null);
            cluster.waitActive();
            fs = (DistributedFileSystem)cluster.getFileSystem();
            Path file1 = new Path("/tmp/testManualSafeMode/file1");
            Path file2 = new Path("/tmp/testManualSafeMode/file2");
            LOG.info((Object)"Created file1 and file2.");
            DFSTestUtil.createFile((FileSystem)fs, file1, 1000L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)fs, file2, 2000L, (short)1, 0L);
            fs.close();
            cluster.shutdown();
            cluster = new MiniDFSCluster(conf, 0, false, null);
            cluster.waitActive();
            fs = (DistributedFileSystem)cluster.getFileSystem();
            LOG.info((Object)"Restarted cluster with just the NameNode");
            TestSafeMode.assertTrue((String)"No datanode is started. Should be in SafeMode", (boolean)fs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET));
            fs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.startDataNodes(conf, 1, true, null, null);
            cluster.waitActive();
            LOG.info((Object)"Datanode is started.");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            TestSafeMode.assertTrue((String)"should still be in SafeMode", (boolean)fs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET));
            fs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
            TestSafeMode.assertFalse((String)"should not be in SafeMode", (boolean)fs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET));
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDatanodeThreshold() throws IOException {
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            Configuration conf = new Configuration();
            conf.set("dfs.safemode.extension", "0");
            conf.set("dfs.safemode.min.datanodes", "1");
            cluster = new MiniDFSCluster(conf, 0, false, null);
            cluster.waitActive();
            fs = (DistributedFileSystem)cluster.getFileSystem();
            TestSafeMode.assertTrue((String)"No datanode started, but we require one - safemode expected", (boolean)fs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET));
            String tipMsg = cluster.getNameNode().getNamesystem().getSafeModeTip();
            TestSafeMode.assertTrue((String)"Safemode tip message looks right", (boolean)tipMsg.contains("The number of live datanodes 0 needs an additional 1 live"));
            cluster.startDataNodes(conf, 1, true, null, null);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            TestSafeMode.assertFalse((String)"Out of safe mode after starting datanode.", (boolean)fs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET));
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

