/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;

public class TestLeaseManager
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestLeaseManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiPathLeaseRecovery() throws IOException, InterruptedException {
        LeaseManager leaseManager;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        NameNode namenode = cluster.getNameNode();
        FSNamesystem spyNamesystem = (FSNamesystem)Mockito.spy((Object)namenode.getNamesystem());
        spyNamesystem.leaseManager = leaseManager = new LeaseManager(spyNamesystem);
        spyNamesystem.lmthread.interrupt();
        String holder = "client-1";
        String path1 = "/file-1";
        String path2 = "/file-2";
        leaseManager.setLeasePeriod(1L, 2L);
        leaseManager.addLease(holder, path1);
        leaseManager.addLease(holder, path2);
        Thread.sleep(1000L);
        FSNamesystem fSNamesystem = spyNamesystem;
        synchronized (fSNamesystem) {
            leaseManager.checkLeases();
        }
        ((FSNamesystem)Mockito.verify((Object)spyNamesystem)).internalReleaseLeaseOne((LeaseManager.Lease)Matchers.anyObject(), (String)Mockito.eq((Object)"/file-1"));
        ((FSNamesystem)Mockito.verify((Object)spyNamesystem)).internalReleaseLeaseOne((LeaseManager.Lease)Matchers.anyObject(), (String)Mockito.eq((Object)"/file-2"));
        ((FSNamesystem)Mockito.verify((Object)spyNamesystem, (VerificationMode)Mockito.never())).internalReleaseLease((LeaseManager.Lease)Matchers.anyObject(), Matchers.anyString());
    }
}

