/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestListPathServlet {
    private static final Configuration CONF = new Configuration();
    private static MiniDFSCluster cluster;
    private static FileSystem fs;
    private static URI hftpURI;
    private static HftpFileSystem hftpFs;
    private Random r = new Random();
    private List<String> filelist = new ArrayList<String>();

    @BeforeClass
    public static void setup() throws Exception {
        cluster = new MiniDFSCluster(CONF, 1, true, null);
        cluster.waitActive();
        fs = cluster.getFileSystem();
        String str = "hftp://" + CONF.get("dfs.http.address");
        hftpURI = new URI(str);
        hftpFs = (HftpFileSystem)FileSystem.get((URI)hftpURI, (Configuration)CONF);
    }

    @AfterClass
    public static void teardown() {
        cluster.shutdown();
    }

    private void createFile(String fileName, long fileLen) throws IOException {
        this.filelist.add(hftpURI + fileName);
        Path filePath = new Path(fileName);
        DFSTestUtil.createFile(fs, filePath, fileLen, (short)1, this.r.nextLong());
    }

    private void mkdirs(String dirName) throws IOException {
        this.filelist.add(hftpURI + dirName);
        fs.mkdirs(new Path(dirName));
    }

    @Test
    public void testListStatus() throws Exception {
        this.checkStatus("/");
        this.createFile("/a", 1L);
        this.createFile("/b", 1L);
        this.mkdirs("/dir");
        this.checkStatus("/");
        this.createFile("/dir/a", 1L);
        this.createFile("/dir/b", 1L);
        this.mkdirs("/dir/dir1");
        this.checkStatus("/dir");
        this.checkStatus("/nonexistent");
        this.checkStatus("/nonexistent/a");
    }

    private void checkStatus(String listdir) throws IOException {
        Path listpath = hftpFs.makeQualified(new Path(listdir));
        listdir = listpath.toString();
        FileStatus[] statuslist = hftpFs.listStatus(listpath);
        for (String directory : this.filelist) {
            System.out.println("dir:" + directory);
        }
        for (String file : this.filelist) {
            System.out.println("file:" + file);
        }
        for (FileStatus status : statuslist) {
            System.out.println("status:" + status.getPath().toString() + " type " + (status.isDir() ? "directory" : "file"));
        }
        for (String file : this.filelist) {
            boolean found = false;
            if (!file.startsWith(listpath.toString()) || file.equals(listpath.toString())) continue;
            for (FileStatus status : statuslist) {
                if (!status.getPath().toString().equals(file)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Directory/file not returned in list status " + file), (boolean)found);
        }
    }
}

