/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;

public class TestLeaseRecovery2
extends TestCase {
    static final long BLOCK_SIZE = 1024L;
    static final int FILE_SIZE = 16384;
    static final short REPLICATION_NUM = 3;
    static byte[] buffer = new byte[16384];
    private static String fakeUsername = "fakeUser1";
    private static String fakeGroup = "supergroup";

    public TestLeaseRecovery2() {
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlockSynchronization() throws Exception {
        long softLease = 1000L;
        long hardLease = 3600000L;
        int repl = 3;
        Configuration conf = new Configuration();
        int bufferSize = conf.getInt("io.file.buffer.size", 4096);
        conf.setLong("dfs.block.size", 1024L);
        conf.setInt("dfs.heartbeat.interval", 1);
        HashMap<String, String[]> u2g_map = new HashMap<String, String[]>(1);
        u2g_map.put(fakeUsername, new String[]{fakeGroup});
        DFSTestUtil.updateConfWithFakeGroupMapping(conf, u2g_map);
        MiniDFSCluster cluster = null;
        byte[] actual = new byte[16384];
        try {
            cluster = new MiniDFSCluster(conf, 5, true, null);
            cluster.waitActive();
            DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
            String filestr = "/foo" + AppendTestUtil.nextInt();
            System.out.println("filestr=" + filestr);
            Path filepath = new Path(filestr);
            FSDataOutputStream stm = dfs.create(filepath, true, bufferSize, (short)3, 1024L);
            TestLeaseRecovery2.assertTrue((boolean)dfs.dfs.exists(filestr));
            int size = AppendTestUtil.nextInt(16384);
            System.out.println("size=" + size);
            stm.write(buffer, 0, size);
            AppendTestUtil.LOG.info((Object)"sync");
            stm.sync();
            AppendTestUtil.LOG.info((Object)"leasechecker.interruptAndJoin()");
            dfs.dfs.leasechecker.interruptAndJoin();
            cluster.setLeasePeriod(1000L, 3600000L);
            UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)fakeUsername, (String[])new String[]{fakeGroup});
            FileSystem dfs2 = DFSTestUtil.getFileSystemAs(ugi, conf);
            boolean done = false;
            for (int i = 0; i < 10 && !done; ++i) {
                AppendTestUtil.LOG.info((Object)("i=" + i));
                try {
                    dfs2.create(filepath, false, bufferSize, (short)3, 1024L);
                    TestLeaseRecovery2.fail((String)"Creation of an existing file should never succeed.");
                }
                catch (IOException ioe) {
                    String message = ioe.getMessage();
                    if (message.contains("file exists")) {
                        AppendTestUtil.LOG.info((Object)"done", (Throwable)ioe);
                        done = true;
                    }
                    if (message.contains(AlreadyBeingCreatedException.class.getSimpleName())) {
                        AppendTestUtil.LOG.info((Object)("GOOD! got " + message));
                    }
                    AppendTestUtil.LOG.warn((Object)"UNEXPECTED IOException", (Throwable)ioe);
                }
                if (done) continue;
                AppendTestUtil.LOG.info((Object)"sleep 5000ms");
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            TestLeaseRecovery2.assertTrue((boolean)done);
            AppendTestUtil.LOG.info((Object)("Lease for file " + filepath + " is recovered. " + "Validating its contents now..."));
            TestLeaseRecovery2.assertTrue((String)("File should be " + size + " bytes, but is actually " + " found to be " + dfs.getFileStatus(filepath).getLen() + " bytes"), (dfs.getFileStatus(filepath).getLen() == (long)size ? 1 : 0) != 0);
            System.out.println("File size is good. Now validating sizes from datanodes...");
            FSDataInputStream stmin = dfs.open(filepath);
            stmin.readFully(0L, actual, 0, size);
            stmin.close();
        }
        finally {
            try {
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
            catch (Exception e) {}
        }
    }
}

