/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.MapRNode;
import org.apache.hadoop.hdfs.NodeState;
import org.apache.hadoop.hdfs.RunCommand;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.authorize.ProxyUsers;

public class MiniDFSCluster {
    static String installDir = "/opt/mapr";
    static String tmpPath = "/tmp/mapr-scratch/";
    static String mfsExe = installDir + "/server/mfs";
    static String hadoopExe = installDir + "/hadoop/hadoop-0.20.2/bin/hadoop";
    static String testConfigPy = installDir + "/server/testconfig.py";
    static String cldbInitScript = "/etc/init.d/mapr-cldb ";
    static String mruuidgen = installDir + "/server/mruuidgen";
    static String maprClustersFile = installDir + "/conf/mapr-clusters.conf";
    static String mfsdbFile = installDir + "/server/tools/mfsdb";
    static String maprCli = installDir + "/bin/maprcli";
    static int cldbPort = 7222;
    static int defaultMfsPort = 5660;
    static int blockSize = 8192;
    static int clusterSize = 8 * blockSize;
    static int chunkSize = 0x4000000;
    private String volName;
    private int numReplicas;
    private int numNodes;
    private MapRNode[] nodes;
    private boolean isClusterUp;
    private Configuration conf;
    public static final String MAPRFS_URI = "maprfs:///";

    public MiniDFSCluster() {
    }

    public MiniDFSCluster(Configuration conf, int numDataNodes, HdfsConstants.StartupOption nameNodeOperation) throws IOException {
        this(0, conf, numDataNodes, false, false, false, nameNodeOperation, null, null, null);
    }

    public MiniDFSCluster(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        this(0, conf, numDataNodes, format, true, true, null, racks, null, null);
    }

    public MiniDFSCluster(Configuration conf, int numDataNodes, boolean format, String[] racks, String[] hosts) throws IOException {
        this(0, conf, numDataNodes, format, true, true, null, racks, hosts, null);
    }

    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks) throws IOException {
        this(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, null);
    }

    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, simulatedCapacities);
    }

    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageNameDfsDirs, boolean manageDataDfsDirs, HdfsConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        this.conf = conf;
        conf.set("fs.default.name", MAPRFS_URI);
        int replication = conf.getInt("dfs.replication", 3);
        conf.setInt("dfs.replication", Math.min(replication, numDataNodes));
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        conf.set("io.file.buffer.size", "65536");
        conf.set("dfs.http.address", "127.0.0.1:0");
        this.InitNodes("TestVolume", numDataNodes);
        this.startDataNodes(conf, numDataNodes, manageDataDfsDirs, operation, racks, hosts, simulatedCapacities);
        this.waitClusterUp();
        if (!this.isClusterUp) {
            throw new IOException("Failed to create mapr cluster");
        }
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
    }

    void InitNodes(String volName, int numNodes) {
        this.volName = volName;
        this.numNodes = numNodes;
        this.nodes = new MapRNode[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            this.nodes[i] = new MapRNode();
            if (i == 0) {
                this.nodes[i].Init(true, true, true, i);
                continue;
            }
            this.nodes[i].Init(false, false, true, i);
        }
    }

    public void waitClusterUp() {
        RunCommand rc = new RunCommand();
        rc.Init(hadoopExe + " fs -lsr /", "", false, false);
        for (int i = 0; i < 240; ++i) {
            if (rc.Run() == 0) {
                this.isClusterUp = true;
                break;
            }
            try {
                Thread.sleep(5000L);
                System.out.println("Waiting for cluster to come up");
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void Start() {
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodes[i].Start();
        }
    }

    public void Stop() {
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodes[i].Stop();
        }
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        this.Start();
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, null);
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, simulatedCapacities);
    }

    public void finalizeCluster(Configuration conf) throws Exception {
        Assert.assertTrue((String)"Not supported", (boolean)false);
    }

    public NameNode getNameNode() {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public ArrayList<DataNode> getDataNodes() {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public ArrayList<MapRNode> getMapRNodes() {
        ArrayList<MapRNode> list = new ArrayList<MapRNode>();
        for (int i = 0; i < this.nodes.length; ++i) {
            list.add(this.nodes[i]);
        }
        return list;
    }

    public DataNode getDataNode(int ipcPort) {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public int getNameNodePort() {
        return cldbPort;
    }

    public void shutdown() {
        int i;
        System.out.println("Shutting down the MiniMapRCluster");
        for (i = 0; i < this.numNodes; ++i) {
            this.nodes[i].Stop();
        }
        for (i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].CleanUp();
        }
    }

    public void Restart() {
        this.Stop();
        this.Start();
    }

    public void shutdownDataNodes() {
        for (int i = 1; i < this.numNodes; ++i) {
            this.nodes[i].Stop();
        }
    }

    public synchronized void shutdownNameNode() {
        this.nodes[0].Stop();
    }

    public synchronized void restartNameNode() throws IOException {
        this.nodes[0].Stop();
        this.nodes[0].Start();
    }

    public boolean corruptBlock(String file, long offset) {
        boolean retVal = false;
        RunCommand rc = new RunCommand();
        String[] cmd = new String[]{"/bin/sh", "-c", hadoopExe + " mfs -ls " + file + "| (offset=" + offset + "; chunkSize=" + chunkSize + "; read line; read line; read line; if [ $offset -lt " + clusterSize + " ]; then echo $line; exit; fi;" + "reqIdx=$[offset/chunkSize];" + "i=0;" + "while read line; " + "do " + "if [ $i -eq $reqIdx ]; then echo $line; break; fi; " + "i=$[i+1]; " + "done)"};
        rc.Init(cmd, "", false, true);
        rc.Run();
        if (rc.OutPutStr() == null) {
            return false;
        }
        try {
            String[] tokens = rc.OutPutStr().split(" ");
            String fid = tokens[1];
            for (int i = 2; i < tokens.length; ++i) {
                String port = tokens[i].split(":")[1];
                int nodeId = Integer.parseInt(port) - defaultMfsPort;
                if (nodeId == 0) continue;
                Long block = this.nodes[nodeId].getBlockNumber(fid, offset % (long)chunkSize);
                retVal = this.nodes[nodeId].corruptBlock(block);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    void corruptBlockOnDataNodes(String blockName) throws Exception {
        Assert.assertTrue((String)"use corrputBlock(filename, offset) interface", (boolean)false);
    }

    boolean corruptBlockOnDataNode(int i, String blockName) throws Exception {
        Assert.assertTrue((String)"use corrputBlock(filename, offset) interface", (boolean)false);
        return false;
    }

    public synchronized DataNodeProperties stopDataNode(int i) {
        if (i < 1 || i >= this.nodes.length) {
            return null;
        }
        this.nodes[i].Stop();
        return null;
    }

    public synchronized DataNodeProperties stopDataNode(String name) {
        int i;
        for (i = 0; i < this.nodes.length && !this.nodes[i].GetName().equals(name); ++i) {
        }
        return this.stopDataNode(i);
    }

    public boolean restartDataNode(DataNodeProperties dnprop) throws IOException {
        Assert.assertTrue((String)"use restartDataNode(int i) interface", (boolean)false);
        return false;
    }

    public synchronized boolean restartDataNode(DataNodeProperties dnprop, boolean keepPort) throws IOException {
        Assert.assertTrue((String)"use restartDataNode(int i) interface", (boolean)false);
        return false;
    }

    public boolean restartDataNode(int i) throws IOException {
        return this.restartDataNode(i, false);
    }

    public synchronized boolean restartDataNode(int i, boolean keepPort) throws IOException {
        this.nodes[i].Stop();
        this.nodes[i].Start();
        return true;
    }

    public synchronized boolean restartDataNodes(boolean keepPort) throws IOException {
        for (int i = 1; i < this.numNodes; ++i) {
            this.nodes[i].Stop();
            this.nodes[i].Start();
        }
        return true;
    }

    public boolean restartDataNodes() throws IOException {
        return this.restartDataNodes(false);
    }

    public boolean isClusterUp() {
        return this.isClusterUp;
    }

    public boolean isDataNodeUp() {
        return this.nodes[0].State() == NodeState.RUNNING;
    }

    public FileSystem getFileSystem() throws IOException {
        return FileSystem.get((Configuration)this.conf);
    }

    public HftpFileSystem getHftpFileSystem() throws IOException {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public Collection<File> getNameDirs() {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public Collection<File> getNameEditsDirs() {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public void waitActive() throws IOException {
        this.waitActive(true);
    }

    public void waitActive(boolean waitHeartbeats) throws IOException {
        this.waitClusterUp();
        if (!this.isClusterUp) {
            throw new IOException("Failed to create mapr cluster");
        }
    }

    private synchronized boolean shouldWait(DatanodeInfo[] dnInfo, boolean waitHeartbeats) {
        return false;
    }

    public void waitForDNHeartbeat(int dnIndex, long timeoutMillis) {
    }

    public void formatDataNodeDirs() throws IOException {
    }

    public Block[] getBlockReport(int dataNodeIndex) {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public Block[][] getAllBlockReports() {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public void injectBlocks(int dataNodeIndex, Block[] blocksToInject) throws IOException {
        Assert.assertTrue((String)"Not supported", (boolean)false);
    }

    public void injectBlocks(Block[][] blocksToInject) throws IOException {
        Assert.assertTrue((String)"Not supported", (boolean)false);
    }

    void setLeasePeriod(long soft, long hard) {
        Assert.assertTrue((String)"Not supported", (boolean)false);
    }

    DataNode[] listDataNodes() {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public String getDataDirectory() {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public static File getBaseDir() {
        Assert.assertTrue((String)"Not supported", (boolean)false);
        return null;
    }

    public class DataNodeProperties {
        DataNode datanode;
        Configuration conf;
        String[] dnArgs;

        DataNodeProperties(DataNode node, Configuration conf, String[] args) {
            this.datanode = node;
            this.conf = conf;
            this.dnArgs = args;
        }
    }
}

