/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ManualSyncTester
extends Configured
implements Tool {
    public static Log LOG = LogFactory.getLog(ManualSyncTester.class);
    public static final byte[] THING_TO_WRITE = "hello\n".getBytes();

    private Process runChild(String dataPath, String progressPath) throws Exception {
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), "org.apache.hadoop.hdfs.ManualSyncTester$Child", dataPath, progressPath});
        new Pumper(p.getInputStream(), System.out).start();
        new Pumper(p.getErrorStream(), System.err).start();
        return p;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            throw new RuntimeException("usage: ManualSyncTester data-path /dev/shm/progress-path");
        }
        String dataPathStr = args[0];
        Path dataPath = new Path(dataPathStr);
        String progressPath = args[1];
        Process proc = this.runChild(dataPathStr, progressPath);
        LOG.info((Object)"Process started, letting it run for a bit...");
        Thread.sleep(15000L);
        LOG.info((Object)"Destroying process...");
        ManualSyncTester.killUnixProcess(proc, 9);
        int ret = proc.waitFor();
        if (ret != 137) {
            throw new RuntimeException("child not killed, rc=" + ret + "!");
        }
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        LOG.info((Object)"Recovering file...");
        AppendTestUtil.recoverFile(null, fs, dataPath);
        LOG.info((Object)"Recovered file...");
        ProgressRecorder recorder = new ProgressRecorder(progressPath);
        long expected = recorder.readIteration();
        recorder.close();
        this.verifyData(dataPath, expected);
        return 0;
    }

    private void verifyData(Path f, long expected) throws Exception {
        FSDataInputStream is = f.getFileSystem(this.getConf()).open(f);
        byte[] buf = new byte[THING_TO_WRITE.length];
        int i = 0;
        while ((long)i < expected) {
            IOUtils.readFully((InputStream)is, (byte[])buf, (int)0, (int)buf.length);
            if (WritableComparator.compareBytes((byte[])THING_TO_WRITE, (int)0, (int)THING_TO_WRITE.length, (byte[])buf, (int)0, (int)buf.length) != 0) {
                throw new RuntimeException("Error at iteration " + i);
            }
            ++i;
        }
        LOG.info((Object)("Verified " + expected + " iterations"));
    }

    public static int getUnixPID(Process process) throws Exception {
        if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
            Class<?> cl = process.getClass();
            Field field = cl.getDeclaredField("pid");
            field.setAccessible(true);
            Object pidObject = field.get(process);
            return (Integer)pidObject;
        }
        throw new IllegalArgumentException("Needs to be a UNIXProcess");
    }

    public static int killUnixProcess(Process process, int signal) throws Exception {
        int pid = ManualSyncTester.getUnixPID(process);
        return Runtime.getRuntime().exec("kill -" + signal + " " + pid).waitFor();
    }

    public static void main(String[] args) throws Exception {
        int rc = 0;
        while (rc == 0) {
            rc = ToolRunner.run((Tool)new ManualSyncTester(), (String[])args);
        }
        System.exit(rc);
    }

    public static class Pumper
    extends Thread {
        InputStream is;
        PrintStream os;

        public Pumper(InputStream is, PrintStream os) {
            this.is = is;
            this.os = os;
        }

        @Override
        public void run() {
            try {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));
                while ((s = reader.readLine()) != null) {
                    this.os.println(s);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class Child
    extends Configured
    implements Tool {
        AtomicReference<Throwable> err = new AtomicReference();
        ProgressRecorder recorder;
        volatile long curIteration = 0L;

        public int run(String[] args) throws Exception {
            Path path = new Path(args[0]);
            String progressPath = args[1];
            this.recorder = new ProgressRecorder(progressPath);
            FileSystem fs = path.getFileSystem(this.getConf());
            LOG.info((Object)("Writing to fs: " + fs));
            do {
                FSDataOutputStream stm = fs.create(path, true);
                Syncer syncer = new Syncer(stm);
                syncer.start();
                byte[] b = THING_TO_WRITE;
                long start = System.currentTimeMillis();
                long lastPrint = System.currentTimeMillis();
                while (syncer.isAlive()) {
                    stm.write(b);
                    ++this.curIteration;
                    if (System.currentTimeMillis() - lastPrint <= 1000L) continue;
                    LOG.info((Object)("Written " + this.curIteration + " writes"));
                    lastPrint = System.currentTimeMillis();
                }
                if (this.err.get() != null) {
                    throw new RuntimeException("Failed", this.err.get());
                }
                syncer.stopSyncing();
                syncer.join();
                stm.close();
            } while (this.err.get() == null);
            throw new RuntimeException("Failed", this.err.get());
        }

        public static void main(String[] args) throws Exception {
            System.exit(ToolRunner.run((Tool)new Child(), (String[])args));
        }

        class Syncer
        extends Thread {
            private final FSDataOutputStream stm;
            private volatile boolean done;

            Syncer(FSDataOutputStream stm) {
                this.stm = stm;
            }

            @Override
            public void run() {
                try {
                    while (!this.done) {
                        long iter = Child.this.curIteration;
                        this.stm.sync();
                        Child.this.recorder.recordIteration(iter);
                    }
                }
                catch (Throwable e) {
                    Child.this.err.set(e);
                }
            }

            public void stopSyncing() {
                this.done = true;
            }
        }
    }

    public static class ProgressRecorder {
        private RandomAccessFile raf;

        public ProgressRecorder(String path) throws IOException {
            this.raf = new RandomAccessFile(path, "rws");
        }

        public void recordIteration(long iteration) throws IOException {
            this.raf.seek(0L);
            this.raf.writeLong(iteration);
        }

        public long readIteration() throws IOException {
            this.raf.seek(0L);
            return this.raf.readLong();
        }

        public void close() throws IOException {
            if (this.raf != null) {
                this.raf.close();
            }
        }

        public void finalize() {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

