/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;

public class AppendTestUtil {
    static final Long RANDOM_NUMBER_GENERATOR_SEED = null;
    static final Log LOG = LogFactory.getLog(AppendTestUtil.class);
    private static final Random SEED = new Random();
    private static final ThreadLocal<Random> RANDOM;

    static int nextInt() {
        return RANDOM.get().nextInt();
    }

    static int nextInt(int n) {
        return RANDOM.get().nextInt(n);
    }

    static int nextLong() {
        return RANDOM.get().nextInt();
    }

    static byte[] randomBytes(long seed, int size) {
        LOG.info((Object)("seed=" + seed + ", size=" + size));
        byte[] b = new byte[size];
        Random rand = new Random(seed);
        rand.nextBytes(b);
        return b;
    }

    static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            LOG.info((Object)("ms=" + ms), (Throwable)e);
        }
    }

    public static FileSystem createHdfsWithDifferentUsername(Configuration conf) throws IOException, InterruptedException {
        String username = UserGroupInformation.getCurrentUser().getShortUserName() + "_XXX";
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{"supergroup"});
        return DFSTestUtil.getFileSystemAs(ugi, conf);
    }

    public static void write(OutputStream out, int offset, int length) throws IOException {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(offset + i);
        }
        out.write(bytes);
    }

    public static void check(FileSystem fs, Path p, long length) throws IOException {
        int i = -1;
        try {
            FileStatus status = fs.getFileStatus(p);
            TestCase.assertEquals((long)length, (long)status.getLen());
            FSDataInputStream in = fs.open(p);
            ++i;
            while ((long)i < length) {
                TestCase.assertEquals((byte)((byte)i), (byte)((byte)in.read()));
                ++i;
            }
            i = -((int)length);
            TestCase.assertEquals((int)-1, (int)in.read());
            in.close();
        }
        catch (IOException ioe) {
            throw new IOException("p=" + p + ", length=" + length + ", i=" + i, ioe);
        }
    }

    public static void loseLeases(FileSystem whichfs) throws Exception {
        LOG.info((Object)"leasechecker.interruptAndJoin()");
        DistributedFileSystem dfs = (DistributedFileSystem)whichfs;
        dfs.dfs.leasechecker.interruptAndJoin();
    }

    public static void recoverFile(MiniDFSCluster cluster, FileSystem fs, Path file1) throws IOException {
        int tries = 90;
        if (cluster != null) {
            cluster.setLeasePeriod(1000L, 3600000L);
            tries = 40;
        }
        boolean recovered = false;
        FSDataOutputStream out = null;
        while (!recovered && tries-- > 0) {
            try {
                out = fs.append(file1);
                LOG.info((Object)"Successfully opened for appends");
                recovered = true;
            }
            catch (IOException e) {
                if (!e.getMessage().contains("being recovered") && !e.getMessage().contains("being created")) {
                    throw e;
                }
                LOG.info((Object)"Failed open for append, waiting on lease recovery");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
        }
        if (out != null) {
            out.close();
        }
        if (!recovered) {
            throw new RuntimeException("Recovery failed");
        }
    }

    static {
        long seed = RANDOM_NUMBER_GENERATOR_SEED == null ? SEED.nextLong() : RANDOM_NUMBER_GENERATOR_SEED.longValue();
        LOG.info((Object)("seed=" + seed));
        SEED.setSeed(seed);
        RANDOM = new ThreadLocal<Random>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Random initialValue() {
                Random r = new Random();
                Random random = SEED;
                synchronized (random) {
                    long seed = SEED.nextLong();
                    r.setSeed(seed);
                    LOG.info((Object)(Thread.currentThread().getName() + ": seed=" + seed));
                }
                return r;
            }
        };
    }

    static class WriterThread
    extends Thread {
        private final FSDataOutputStream stm;
        private final AtomicReference<Throwable> thrown;
        private final int numWrites;
        private final CountDownLatch countdown;
        private final byte[] toWrite;
        private AtomicInteger numWritten = new AtomicInteger();

        public WriterThread(FSDataOutputStream stm, byte[] toWrite, AtomicReference<Throwable> thrown, CountDownLatch countdown, int numWrites) {
            this.toWrite = toWrite;
            this.stm = stm;
            this.thrown = thrown;
            this.numWrites = numWrites;
            this.countdown = countdown;
        }

        @Override
        public void run() {
            try {
                this.countdown.await();
                for (int i = 0; i < this.numWrites && this.thrown.get() == null; ++i) {
                    this.doAWrite();
                    this.numWritten.getAndIncrement();
                }
            }
            catch (Throwable t) {
                this.thrown.compareAndSet(null, t);
            }
        }

        private void doAWrite() throws IOException {
            this.stm.write(this.toWrite);
            this.stm.sync();
        }

        public int getNumWritten() {
            return this.numWritten.get();
        }
    }
}

