/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming.mapreduce;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSBuilder;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.impl.FutureIOSupport;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.KeyValueTextInputFormat;
import org.apache.hadoop.streaming.StreamUtil;

public class StreamInputFormat
extends KeyValueTextInputFormat {
    public RecordReader<Text, Text> createRecordReader(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        RecordReader reader;
        Constructor ctor;
        Configuration conf = context.getConfiguration();
        String c = conf.get("stream.recordreader.class");
        if (c == null || c.indexOf("LineRecordReader") >= 0) {
            return super.createRecordReader(genericSplit, context);
        }
        FileSplit split = (FileSplit)genericSplit;
        context.setStatus(split.toString());
        context.progress();
        Path path = split.getPath();
        FileSystem fs = path.getFileSystem(conf);
        FutureDataInputStreamBuilder builder = fs.openFile(path);
        FutureIOSupport.propagateOptions((FSBuilder)builder, (Configuration)conf, (String)"mapreduce.job.input.file.option.", (String)"mapreduce.job.input.file.must.");
        FSDataInputStream in = (FSDataInputStream)FutureIOSupport.awaitFuture((Future)builder.build());
        Class readerClass = StreamUtil.goodClassOrNull(conf, c, null);
        if (readerClass == null) {
            throw new RuntimeException("Class not found: " + c);
        }
        try {
            ctor = readerClass.getConstructor(FSDataInputStream.class, FileSplit.class, TaskAttemptContext.class, Configuration.class, FileSystem.class);
        }
        catch (NoSuchMethodException nsm) {
            throw new RuntimeException(nsm);
        }
        try {
            reader = (RecordReader)ctor.newInstance(in, split, context, conf, fs);
        }
        catch (Exception nsm) {
            throw new RuntimeException(nsm);
        }
        return reader;
    }
}

