/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.datatypes;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.rumen.anonymization.WordList;
import org.apache.hadoop.tools.rumen.anonymization.WordListAnonymizerUtility;
import org.apache.hadoop.tools.rumen.datatypes.AnonymizableDataType;
import org.apache.hadoop.tools.rumen.datatypes.NodeName;
import org.apache.hadoop.tools.rumen.state.State;
import org.apache.hadoop.tools.rumen.state.StatePool;
import org.apache.hadoop.util.StringUtils;

public class FileName
implements AnonymizableDataType<String> {
    private final String fileName;
    private String anonymizedFileName;
    private static final String PREV_DIR = "..";
    private static final String[] KNOWN_SUFFIXES = new String[]{".xml", ".jar", ".txt", ".tar", ".zip", ".json", ".gzip", ".lzo"};

    public FileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getValue() {
        return this.fileName;
    }

    @Override
    public String getAnonymizedValue(StatePool statePool, Configuration conf) {
        if (this.anonymizedFileName == null) {
            this.anonymize(statePool, conf);
        }
        return this.anonymizedFileName;
    }

    private void anonymize(StatePool statePool, Configuration conf) {
        FileNameState fState = (FileNameState)statePool.getState(this.getClass());
        if (fState == null) {
            fState = new FileNameState();
            statePool.addState(this.getClass(), fState);
        }
        String[] files = StringUtils.split((String)this.fileName);
        String[] anonymizedFileNames = new String[files.length];
        int i = 0;
        for (String f : files) {
            anonymizedFileNames[i++] = FileName.anonymize(statePool, conf, fState, f);
        }
        this.anonymizedFileName = StringUtils.arrayToString((String[])anonymizedFileNames);
    }

    private static String anonymize(StatePool statePool, Configuration conf, FileNameState fState, String fileName) {
        Object ret = null;
        try {
            URI uri = new URI(fileName);
            ret = FileName.anonymizePath(uri.getPath(), fState.getDirectoryState(), fState.getFileNameState());
            String authority = uri.getAuthority();
            String scheme = uri.getScheme();
            if (scheme != null) {
                String anonymizedAuthority = "";
                if (authority != null) {
                    NodeName hostName = new NodeName(null, uri.getHost());
                    anonymizedAuthority = hostName.getAnonymizedValue(statePool, conf);
                }
                ret = scheme + "://" + anonymizedAuthority + (String)ret;
            }
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
        return ret;
    }

    private static String anonymizePath(String path, WordList dState, WordList fState) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(path, "/", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("/".equals(token)) {
                buffer.append(token);
                continue;
            }
            if (".".equals(token)) {
                buffer.append(token);
                continue;
            }
            if (PREV_DIR.equals(token)) {
                buffer.append(token);
                continue;
            }
            if (tokenizer.hasMoreTokens()) {
                buffer.append(FileName.anonymize(token, dState));
                continue;
            }
            buffer.append(FileName.anonymize(token, fState));
        }
        return buffer.toString();
    }

    private static String anonymize(String data, WordList wordList) {
        if (data == null) {
            return null;
        }
        if (WordListAnonymizerUtility.needsAnonymization(data)) {
            String suffix = "";
            String coreData = data;
            if (WordListAnonymizerUtility.hasSuffix(data, KNOWN_SUFFIXES)) {
                String[] split = WordListAnonymizerUtility.extractSuffix(data, KNOWN_SUFFIXES);
                suffix = split[1];
                coreData = split[0];
            }
            Object anonymizedData = coreData;
            if (!WordListAnonymizerUtility.isKnownData(coreData)) {
                if (!wordList.contains(coreData)) {
                    wordList.add(coreData);
                }
                anonymizedData = wordList.getName() + wordList.indexOf(coreData);
            }
            return (String)anonymizedData + suffix;
        }
        return data;
    }

    public static class FileNameState
    implements State {
        private WordList dirState = new WordList("dir");
        private WordList fileNameState = new WordList("file");

        @Override
        public boolean isUpdated() {
            return this.dirState.isUpdated() || this.fileNameState.isUpdated();
        }

        public WordList getDirectoryState() {
            return this.dirState;
        }

        public WordList getFileNameState() {
            return this.fileNameState;
        }

        public void setDirectoryState(WordList state) {
            this.dirState = state;
        }

        public void setFileNameState(WordList state) {
            this.fileNameState = state;
        }

        @Override
        public String getName() {
            return "path";
        }

        @Override
        public void setName(String name) {
            if (!this.getName().equals(name)) {
                throw new RuntimeException("State name mismatch! Expected '" + this.getName() + "' but found '" + name + "'.");
            }
        }
    }
}

