/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.RegistryTestHelper;
import org.apache.hadoop.registry.conf.RegistryConfiguration;
import org.apache.hadoop.registry.server.services.AddingCompositeService;
import org.apache.hadoop.registry.server.services.MicroZookeeperService;
import org.apache.hadoop.service.Service;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractZKRegistryTest
extends RegistryTestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractZKRegistryTest.class);
    private static final AddingCompositeService servicesToTeardown = new AddingCompositeService("teardown");
    @Rule
    public final Timeout testTimeout = new Timeout(10000);
    @Rule
    public TestName methodName = new TestName();
    protected static MicroZookeeperService zookeeper;

    protected static void addToTeardown(Service svc) {
        servicesToTeardown.addService(svc);
    }

    @AfterClass
    public static void teardownServices() throws IOException {
        AbstractZKRegistryTest.describe(LOG, "teardown of static services", new Object[0]);
        servicesToTeardown.close();
    }

    @BeforeClass
    public static void createZKServer() throws Exception {
        File zkDir = new File("target/zookeeper");
        FileUtils.deleteDirectory((File)zkDir);
        AbstractZKRegistryTest.assertTrue((boolean)zkDir.mkdirs());
        zookeeper = new MicroZookeeperService("InMemoryZKService");
        RegistryConfiguration conf = new RegistryConfiguration();
        conf.set("hadoop.registry.zk.service.dir", zkDir.getAbsolutePath());
        zookeeper.init((Configuration)conf);
        zookeeper.start();
        AbstractZKRegistryTest.addToTeardown((Service)zookeeper);
    }

    @Before
    public void nameThread() {
        Thread.currentThread().setName("JUnit");
    }

    public String getConnectString() {
        return zookeeper.getConnectionString();
    }

    public Configuration createRegistryConfiguration() {
        RegistryConfiguration conf = new RegistryConfiguration();
        conf.setInt("hadoop.registry.zk.connection.timeout.ms", 1000);
        conf.setInt("hadoop.registry.zk.retry.interval.ms", 500);
        conf.setInt("hadoop.registry.zk.retry.times", 10);
        conf.setInt("hadoop.registry.zk.retry.ceiling.ms", 10);
        conf.set("hadoop.registry.zk.quorum", zookeeper.getConnectionString());
        return conf;
    }

    static {
        servicesToTeardown.init(new Configuration());
        servicesToTeardown.start();
    }
}

