/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.secure;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.data.ACL;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRegistrySecurityHelper
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(TestRegistrySecurityHelper.class);
    public static final String YARN_EXAMPLE_COM = "yarn@example.com";
    public static final String SASL_YARN_EXAMPLE_COM = "sasl:yarn@example.com";
    public static final String MAPRED_EXAMPLE_COM = "mapred@example.com";
    public static final String SASL_MAPRED_EXAMPLE_COM = "sasl:mapred@example.com";
    public static final String SASL_MAPRED_APACHE = "sasl:mapred@APACHE";
    public static final String DIGEST_F0AF = "digest:f0afbeeb00baa";
    public static final String SASL_YARN_SHORT = "sasl:yarn@";
    public static final String SASL_MAPRED_SHORT = "sasl:mapred@";
    public static final String REALM_EXAMPLE_COM = "example.com";
    private static RegistrySecurity registrySecurity;

    @BeforeClass
    public static void setupTestRegistrySecurityHelper() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.registry.secure", true);
        conf.set("hadoop.registry.kerberos.realm", "KERBEROS");
        registrySecurity = new RegistrySecurity("");
        registrySecurity.init(conf);
    }

    @Test
    public void testACLSplitRealmed() throws Throwable {
        List pairs = registrySecurity.splitAclPairs("sasl:yarn@example.com, sasl:mapred@example.com", "");
        TestRegistrySecurityHelper.assertEquals((Object)SASL_YARN_EXAMPLE_COM, pairs.get(0));
        TestRegistrySecurityHelper.assertEquals((Object)SASL_MAPRED_EXAMPLE_COM, pairs.get(1));
    }

    @Test
    public void testBuildAclsRealmed() throws Throwable {
        List acls = registrySecurity.buildACLs("sasl:yarn@example.com, sasl:mapred@example.com", "", 31);
        TestRegistrySecurityHelper.assertEquals((Object)YARN_EXAMPLE_COM, (Object)((ACL)acls.get(0)).getId().getId());
        TestRegistrySecurityHelper.assertEquals((Object)MAPRED_EXAMPLE_COM, (Object)((ACL)acls.get(1)).getId().getId());
    }

    @Test
    public void testACLDefaultRealm() throws Throwable {
        List pairs = registrySecurity.splitAclPairs("sasl:yarn@, sasl:mapred@", REALM_EXAMPLE_COM);
        TestRegistrySecurityHelper.assertEquals((Object)SASL_YARN_EXAMPLE_COM, pairs.get(0));
        TestRegistrySecurityHelper.assertEquals((Object)SASL_MAPRED_EXAMPLE_COM, pairs.get(1));
    }

    @Test
    public void testBuildAclsDefaultRealm() throws Throwable {
        List acls = registrySecurity.buildACLs("sasl:yarn@, sasl:mapred@", REALM_EXAMPLE_COM, 31);
        TestRegistrySecurityHelper.assertEquals((Object)YARN_EXAMPLE_COM, (Object)((ACL)acls.get(0)).getId().getId());
        TestRegistrySecurityHelper.assertEquals((Object)MAPRED_EXAMPLE_COM, (Object)((ACL)acls.get(1)).getId().getId());
    }

    @Test
    public void testACLSplitNullRealm() throws Throwable {
        List pairs = registrySecurity.splitAclPairs("sasl:yarn@, sasl:mapred@", "");
        TestRegistrySecurityHelper.assertEquals((Object)SASL_YARN_SHORT, pairs.get(0));
        TestRegistrySecurityHelper.assertEquals((Object)SASL_MAPRED_SHORT, pairs.get(1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuildAclsNullRealm() throws Throwable {
        registrySecurity.buildACLs("sasl:yarn@, sasl:mapred@", "", 31);
        TestRegistrySecurityHelper.fail((String)"");
    }

    @Test
    public void testACLDefaultRealmOnlySASL() throws Throwable {
        List pairs = registrySecurity.splitAclPairs("sasl:yarn@, digest:f0afbeeb00baa", REALM_EXAMPLE_COM);
        TestRegistrySecurityHelper.assertEquals((Object)SASL_YARN_EXAMPLE_COM, pairs.get(0));
        TestRegistrySecurityHelper.assertEquals((Object)DIGEST_F0AF, pairs.get(1));
    }

    @Test
    public void testACLSplitMixed() throws Throwable {
        List pairs = registrySecurity.splitAclPairs("sasl:yarn@, sasl:mapred@APACHE, ,,digest:f0afbeeb00baa", REALM_EXAMPLE_COM);
        TestRegistrySecurityHelper.assertEquals((Object)SASL_YARN_EXAMPLE_COM, pairs.get(0));
        TestRegistrySecurityHelper.assertEquals((Object)SASL_MAPRED_APACHE, pairs.get(1));
        TestRegistrySecurityHelper.assertEquals((Object)DIGEST_F0AF, pairs.get(2));
    }

    @Test
    public void testDefaultAClsValid() throws Throwable {
        registrySecurity.buildACLs("sasl:yarn@, sasl:mapred@, sasl:hdfs@, sasl:hadoop@", REALM_EXAMPLE_COM, 31);
    }

    @Test
    public void testDefaultRealm() throws Throwable {
        String realm = RegistrySecurity.getDefaultRealmInJVM();
        LOG.info("Realm {}", (Object)realm);
    }

    @Test
    public void testUGIProperties() throws Throwable {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        ACL acl = registrySecurity.createACLForUser(user, 31);
        TestRegistrySecurityHelper.assertFalse((boolean)RegistrySecurity.ALL_READWRITE_ACCESS.equals((Object)acl));
        LOG.info("User {} has ACL {}", (Object)user, (Object)acl);
    }

    @Test
    public void testSecurityImpliesKerberos() throws Throwable {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.authentication", true);
        conf.setBoolean("hadoop.registry.secure", true);
        conf.set("hadoop.registry.kerberos.realm", "KERBEROS");
        RegistrySecurity security = new RegistrySecurity("registry security");
        try {
            security.init(conf);
        }
        catch (Exception e) {
            TestRegistrySecurityHelper.assertTrue((String)("did not find Registry security is enabled -but Hadoop security is not enabled in " + e), (boolean)e.toString().contains("Registry security is enabled -but Hadoop security is not enabled"));
        }
    }
}

