/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maven.plugin.resourcegz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="resource-gz")
public class ResourceGzMojo
extends AbstractMojo {
    @Parameter(property="inputDirectory", required=true)
    private String inputDirectory;
    @Parameter(property="outputDirectory", required=true)
    private String outputDirectory;
    @Parameter(property="extensions", required=true)
    private String extensions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Path inputDir = new File(this.inputDirectory).toPath();
            File outputDir = new File(this.outputDirectory);
            ArrayList exts = Lists.newArrayList((Object[])this.extensions.split(","));
            exts.replaceAll(String::trim);
            GZConsumer cons = new GZConsumer(inputDir.toFile(), outputDir);
            Files.walk(inputDir, new FileVisitOption[0]).filter(path -> {
                for (String ext : exts) {
                    if (!path.getFileName().toString().endsWith("." + ext)) continue;
                    return true;
                }
                return false;
            }).forEach(cons);
            if (cons.getThrowable() != null) {
                throw new MojoExecutionException(cons.getThrowable().toString(), cons.getThrowable());
            }
        }
        catch (Throwable t) {
            throw new MojoExecutionException(t.toString(), t);
        }
    }

    private class GZConsumer
    implements Consumer<Path> {
        private final File inputDir;
        private final File outputDir;
        private Throwable throwable;

        public GZConsumer(File inputDir, File outputDir) {
            this.inputDir = inputDir;
            this.outputDir = outputDir;
            this.throwable = null;
        }

        @Override
        public void accept(Path path) {
            block15: {
                if (this.throwable != null) {
                    return;
                }
                try {
                    File outFile = new File(this.outputDir, path.toFile().getCanonicalPath().replaceFirst(Matcher.quoteReplacement(this.inputDir.getCanonicalPath()), "") + ".gz");
                    if (outFile.getParentFile().isDirectory() || outFile.getParentFile().mkdirs()) {
                        try (GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(outFile));
                             BufferedReader is = Files.newBufferedReader(path);){
                            ResourceGzMojo.this.getLog().info((CharSequence)("Compressing " + path + " to " + outFile));
                            IOUtils.copy((Reader)is, (OutputStream)os, (Charset)StandardCharsets.UTF_8);
                            break block15;
                        }
                    }
                    throw new IOException("Directory " + outFile.getParent() + " does not exist or was unable to be created");
                }
                catch (Throwable t) {
                    this.throwable = t;
                }
            }
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

