/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.AMFeedback;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.checkpoint.TaskCheckpointID;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMapProgress {
    public static final Logger LOG = LoggerFactory.getLogger(TestMapProgress.class);
    private static String TEST_ROOT_DIR;
    private FileSystem fs = null;
    private TestMapTask map = null;
    private JobID jobId = null;
    private FakeUmbilical fakeUmbilical = new FakeUmbilical();

    private void createInputFile(Path rootDir) throws IOException {
        if (this.fs.exists(rootDir)) {
            this.fs.delete(rootDir, true);
        }
        String str = "The quick brown fox\nThe brown quick fox\nThe fox brown quick\n";
        FSDataOutputStream inpFile = this.fs.create(new Path(rootDir, "part-0"));
        inpFile.writeBytes(str);
        inpFile.close();
    }

    @Test
    public void testMapProgress() throws Exception {
        JobConf job = new JobConf();
        this.fs = FileSystem.getLocal((Configuration)job);
        Path rootDir = new Path(TEST_ROOT_DIR);
        this.createInputFile(rootDir);
        job.setNumReduceTasks(0);
        TaskAttemptID taskId = TaskAttemptID.forName((String)"attempt_200907082313_0424_m_000000_0");
        job.setClass("mapreduce.job.outputformat.class", NullOutputFormat.class, OutputFormat.class);
        job.set("mapreduce.input.fileinputformat.inputdir", TEST_ROOT_DIR);
        this.jobId = taskId.getJobID();
        JobContextImpl jContext = new JobContextImpl(job, (org.apache.hadoop.mapreduce.JobID)this.jobId);
        InputFormat input = (InputFormat)ReflectionUtils.newInstance((Class)jContext.getInputFormatClass(), (Configuration)job);
        List splits = input.getSplits((JobContext)jContext);
        JobSplitWriter.createSplitFiles((Path)new Path(TEST_ROOT_DIR), (Configuration)job, (FileSystem)new Path(TEST_ROOT_DIR).getFileSystem((Configuration)job), (List)splits);
        JobSplit.TaskSplitMetaInfo[] splitMetaInfo = SplitMetaInfoReader.readSplitMetaInfo((org.apache.hadoop.mapreduce.JobID)this.jobId, (FileSystem)this.fs, (Configuration)job, (Path)new Path(TEST_ROOT_DIR));
        job.setUseNewMapper(true);
        for (int i = 0; i < splitMetaInfo.length; ++i) {
            this.map = new TestMapTask(job.get("mapreduce.jobtracker.system.dir", "/tmp/hadoop/mapred/system") + this.jobId + "job.xml", taskId, i, splitMetaInfo[i].getSplitIndex(), 1);
            JobConf localConf = new JobConf((Configuration)job);
            this.map.localizeConfiguration(localConf);
            this.map.setConf((Configuration)localConf);
            this.map.run(localConf, this.fakeUmbilical);
        }
        this.fs.delete(rootDir, true);
    }

    static {
        String root = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        TEST_ROOT_DIR = new Path(root, "mapPhaseprogress").toString();
    }

    class TestMapTask
    extends MapTask {
        public TestMapTask(String jobFile, TaskAttemptID taskId, int partition, JobSplit.TaskSplitIndex splitIndex, int numSlotsRequired) {
            super(jobFile, taskId, partition, splitIndex, numSlotsRequired);
        }

        Task.TaskReporter startReporter(TaskUmbilicalProtocol umbilical) {
            TestTaskReporter reporter = new TestTaskReporter((Task)TestMapProgress.this.map);
            return reporter;
        }
    }

    public class TestTaskReporter
    extends Task.TaskReporter {
        private int recordNum;

        TestTaskReporter(Task task) {
            Task task2 = task;
            Objects.requireNonNull(task2);
            super(task2, task.getProgress(), (TaskUmbilicalProtocol)TestMapProgress.this.fakeUmbilical);
            this.recordNum = 0;
        }

        public void setProgress(float progress) {
            super.setProgress(progress);
            float mapTaskProgress = TestMapProgress.this.map.getProgress().getProgress();
            LOG.info("Map task progress is " + mapTaskProgress);
            if (this.recordNum < 3) {
                ++this.recordNum;
            } else {
                return;
            }
            Assert.assertTrue((String)"Map progress is not the expected value.", ((double)Math.abs(mapTaskProgress - (float)this.recordNum / 3.0f) < 0.001 ? 1 : 0) != 0);
        }
    }

    static class FakeUmbilical
    implements TaskUmbilicalProtocol {
        FakeUmbilical() {
        }

        public long getProtocolVersion(String protocol, long clientVersion) {
            return 21L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
        }

        public void done(TaskAttemptID taskid) throws IOException {
            LOG.info("Task " + taskid + " reporting done.");
        }

        public void fsError(TaskAttemptID taskId, String message) throws IOException {
            LOG.info("Task " + taskId + " reporting file system error: " + message);
        }

        public void shuffleError(TaskAttemptID taskId, String message) throws IOException {
            LOG.info("Task " + taskId + " reporting shuffle error: " + message);
        }

        public void fatalError(TaskAttemptID taskId, String msg, boolean fastFail) throws IOException {
            LOG.info("Task " + taskId + " reporting fatal error: " + msg + " fast fail: " + fastFail);
        }

        public JvmTask getTask(JvmContext context) throws IOException {
            return null;
        }

        public boolean ping(TaskAttemptID taskid) throws IOException {
            return true;
        }

        public void commitPending(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskId, taskStatus);
        }

        public void preempted(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskId, taskStatus);
        }

        public boolean canCommit(TaskAttemptID taskid) throws IOException {
            return true;
        }

        public AMFeedback statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            StringBuffer buf = new StringBuffer("Task ");
            buf.append(taskId);
            if (taskStatus != null) {
                buf.append(" making progress to ");
                buf.append(taskStatus.getProgress());
                String state = taskStatus.getStateString();
                if (state != null) {
                    buf.append(" and state of ");
                    buf.append(state);
                }
            }
            LOG.info(buf.toString());
            AMFeedback a = new AMFeedback();
            a.setTaskFound(true);
            return a;
        }

        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace) throws IOException {
            LOG.info("Task " + taskid + " has problem " + trace);
        }

        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, TaskAttemptID id) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }

        public void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
            LOG.info("Task " + taskid + " reportedNextRecordRange " + range);
        }

        public TaskCheckpointID getCheckpointID(TaskID taskId) {
            return null;
        }

        public void setCheckpointID(TaskID downgrade, TaskCheckpointID cid) {
        }
    }
}

