/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.AccumulatingReducer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.IOMapperBase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.conf.MapReduceDefaultProperties;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDFSIO
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(TestDFSIO.class);
    private static final int DEFAULT_BUFFER_SIZE = 1000000;
    private static final String BASE_FILE_NAME = "test_io_";
    private static final String DEFAULT_RES_FILE_NAME = "TestDFSIO_results.log";
    private static final long MEGA = ByteMultiple.MB.value();
    private static final int DEFAULT_NR_BYTES = 128;
    private static final int DEFAULT_NR_FILES = 4;
    private static final String USAGE = "Usage: " + TestDFSIO.class.getSimpleName() + " [genericOptions] -read [-random | -backward | -skip [-skipSize Size]] | -write | -append | -truncate | -clean [-compression codecClassName] [-nrFiles N] [-size Size[B|KB|MB|GB|TB]] [-resFile resultFileName] [-bufferSize Bytes] [-storagePolicy storagePolicyName] [-erasureCodePolicy erasureCodePolicyName]";
    private Configuration config;
    private static final String STORAGE_POLICY_NAME_KEY = "test.io.block.storage.policy";
    private static final String ERASURE_CODE_POLICY_NAME_KEY = "test.io.erasure.code.policy";
    private ExecutorService excutorService = Executors.newFixedThreadPool(2 * Runtime.getRuntime().availableProcessors());
    private CompletionService<String> completionService = new ExecutorCompletionService<String>(this.excutorService);
    private static MiniDFSCluster cluster;
    private static TestDFSIO bench;

    public TestDFSIO() {
        this.config = new Configuration();
    }

    private static String getBaseDir(Configuration conf) {
        return conf.get("test.build.data", "/benchmarks/TestDFSIO");
    }

    private static Path getControlDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_control");
    }

    private static Path getWriteDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_write");
    }

    private static Path getReadDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_read");
    }

    private static Path getAppendDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_append");
    }

    private static Path getRandomReadDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_random_read");
    }

    private static Path getTruncateDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_truncate");
    }

    private static Path getDataDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_data");
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        bench = new TestDFSIO();
        bench.getConf().setInt("dfs.heartbeat.interval", 1);
        cluster = new MiniDFSCluster.Builder(bench.getConf()).numDataNodes(2).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        bench.createControlFile((FileSystem)fs, 128L, 4);
        TestDFSIO.testWrite();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (cluster == null) {
            return;
        }
        DistributedFileSystem fs = cluster.getFileSystem();
        bench.cleanup((FileSystem)fs);
        cluster.shutdown();
    }

    public static void testWrite() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        long execTime = bench.writeTest((FileSystem)fs);
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_WRITE, execTime);
    }

    @Test(timeout=10000L)
    public void testReadRandom() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        bench.getConf().setLong("test.io.skip.size", 0L);
        long execTime = bench.randomReadTest((FileSystem)fs);
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_READ_RANDOM, execTime);
    }

    @Test(timeout=10000L)
    public void testReadBackward() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        bench.getConf().setLong("test.io.skip.size", -1000000L);
        long execTime = bench.randomReadTest((FileSystem)fs);
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_READ_BACKWARD, execTime);
    }

    @Test(timeout=10000L)
    public void testReadSkip() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        bench.getConf().setLong("test.io.skip.size", 1L);
        long execTime = bench.randomReadTest((FileSystem)fs);
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_READ_SKIP, execTime);
    }

    @Test(timeout=10000L)
    public void testAppend() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        long execTime = bench.appendTest((FileSystem)fs);
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_APPEND, execTime);
    }

    @Test(timeout=60000L)
    public void testTruncate() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        bench.createControlFile((FileSystem)fs, 64L, 4);
        long execTime = bench.truncateTest((FileSystem)fs);
        bench.analyzeResult((FileSystem)fs, TestType.TEST_TYPE_TRUNCATE, execTime);
    }

    private void createControlFile(FileSystem fs, long nrBytes, int nrFiles) throws IOException {
        LOG.info("creating control file: " + nrBytes + " bytes, " + nrFiles + " files");
        int maxDirItems = this.config.getInt("dfs.namenode.fs-limits.max-directory-items", 0x100000);
        Path controlDir = TestDFSIO.getControlDir(this.config);
        if (nrFiles > maxDirItems) {
            String message = "The directory item limit of " + controlDir + " is exceeded: limit=" + maxDirItems + " items=" + nrFiles;
            throw new IOException(message);
        }
        fs.delete(controlDir, true);
        for (int i = 0; i < nrFiles; ++i) {
            String name = TestDFSIO.getFileName(i);
            Path controlFile = new Path(controlDir, "in_file_" + name);
            SequenceFile.Writer writer = null;
            try {
                writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.config, (Path)controlFile, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                ControlFileCreateTask controlFileCreateTask = new ControlFileCreateTask(writer, name, nrBytes);
                this.completionService.submit(controlFileCreateTask, "success");
                continue;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        boolean isSuccess = false;
        int count = 0;
        for (int i = 0; i < nrFiles; ++i) {
            try {
                Future<String> future = this.completionService.poll(3L, TimeUnit.MINUTES);
                if (future == null) break;
                future.get(3L, TimeUnit.MINUTES);
                ++count;
                continue;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IOException(e);
            }
        }
        if (count == nrFiles) {
            isSuccess = true;
        }
        if (!isSuccess) {
            throw new IOException("Create control files timeout.");
        }
        LOG.info("created control files for: " + nrFiles + " files");
    }

    private static String getFileName(int fIdx) {
        return BASE_FILE_NAME + Integer.toString(fIdx);
    }

    private long writeTest(FileSystem fs) throws IOException {
        Path writeDir = TestDFSIO.getWriteDir(this.config);
        fs.delete(TestDFSIO.getDataDir(this.config), true);
        fs.delete(writeDir, true);
        long tStart = System.currentTimeMillis();
        if (this.isECEnabled()) {
            this.createAndEnableECOnPath(fs, TestDFSIO.getDataDir(this.config));
        }
        this.runIOTest(WriteMapper.class, writeDir);
        long execTime = System.currentTimeMillis() - tStart;
        return execTime;
    }

    private void runIOTest(Class<? extends Mapper<Text, LongWritable, Text, Text>> mapperClass, Path outputDir) throws IOException {
        JobConf job = new JobConf(this.config, TestDFSIO.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{TestDFSIO.getControlDir(this.config)});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(mapperClass);
        job.setReducerClass(AccumulatingReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputDir);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        job.setSpeculativeExecution(false);
        JobClient.runJob((JobConf)job);
    }

    private long appendTest(FileSystem fs) throws IOException {
        Path appendDir = TestDFSIO.getAppendDir(this.config);
        fs.delete(appendDir, true);
        long tStart = System.currentTimeMillis();
        this.runIOTest(AppendMapper.class, appendDir);
        long execTime = System.currentTimeMillis() - tStart;
        return execTime;
    }

    private long readTest(FileSystem fs, long fileSize) throws IOException {
        Path readDir = TestDFSIO.getReadDir(this.config);
        fs.delete(readDir, true);
        long tStart = System.currentTimeMillis();
        JobConf job = new JobConf(this.config, TestDFSIO.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{TestDFSIO.getDataDir(this.config)});
        job.setInputFormat(DFSIOFileInputFormat.class);
        job.setMapperClass(DFSIOReadMapper.class);
        job.setReducerClass(AccumulatingReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)readDir);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        job.setSpeculativeExecution(false);
        job.setLong("mapred.min.split.size", fileSize);
        JobClient.runJob((JobConf)job);
        long execTime = System.currentTimeMillis() - tStart;
        return execTime;
    }

    private long randomReadTest(FileSystem fs) throws IOException {
        Path readDir = TestDFSIO.getRandomReadDir(this.config);
        fs.delete(readDir, true);
        long tStart = System.currentTimeMillis();
        this.runIOTest(RandomReadMapper.class, readDir);
        long execTime = System.currentTimeMillis() - tStart;
        return execTime;
    }

    private long truncateTest(FileSystem fs) throws IOException {
        Path TruncateDir = TestDFSIO.getTruncateDir(this.config);
        fs.delete(TruncateDir, true);
        long tStart = System.currentTimeMillis();
        this.runIOTest(TruncateMapper.class, TruncateDir);
        long execTime = System.currentTimeMillis() - tStart;
        return execTime;
    }

    private void sequentialTest(FileSystem fs, TestType testType, long fileSize, int nrFiles) throws IOException {
        IOStatMapper ioer = null;
        switch (testType) {
            case TEST_TYPE_READ: {
                ioer = new ReadMapper();
                break;
            }
            case TEST_TYPE_WRITE: {
                ioer = new WriteMapper();
                break;
            }
            case TEST_TYPE_APPEND: {
                ioer = new AppendMapper();
                break;
            }
            case TEST_TYPE_READ_RANDOM: 
            case TEST_TYPE_READ_BACKWARD: 
            case TEST_TYPE_READ_SKIP: {
                ioer = new RandomReadMapper();
                break;
            }
            case TEST_TYPE_TRUNCATE: {
                ioer = new TruncateMapper();
                break;
            }
            default: {
                return;
            }
        }
        for (int i = 0; i < nrFiles; ++i) {
            ioer.doIO(Reporter.NULL, BASE_FILE_NAME + Integer.toString(i), fileSize);
        }
    }

    public static void main(String[] args) {
        TestDFSIO bench = new TestDFSIO();
        int res = -1;
        try {
            res = ToolRunner.run((Tool)bench, (String[])args);
        }
        catch (Exception e) {
            System.err.print(StringUtils.stringifyException((Throwable)e));
            res = -2;
        }
        if (res == -1) {
            System.err.println(USAGE);
        }
        System.exit(res);
    }

    public int run(String[] args) throws IOException {
        TestType testType = null;
        int bufferSize = 1000000;
        long nrBytes = 1L * MEGA;
        String erasureCodePolicyName = null;
        int nrFiles = 1;
        long skipSize = 0L;
        String resFileName = DEFAULT_RES_FILE_NAME;
        String compressionClass = null;
        String storagePolicy = null;
        boolean isSequential = false;
        String version = TestDFSIO.class.getSimpleName() + ".1.8";
        LOG.info(version);
        if (args.length == 0) {
            System.err.println("Missing arguments.");
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (StringUtils.toLowerCase((String)args[i]).startsWith("-read")) {
                testType = TestType.TEST_TYPE_READ;
                continue;
            }
            if (args[i].equalsIgnoreCase("-write")) {
                testType = TestType.TEST_TYPE_WRITE;
                continue;
            }
            if (args[i].equalsIgnoreCase("-append")) {
                testType = TestType.TEST_TYPE_APPEND;
                continue;
            }
            if (args[i].equalsIgnoreCase("-random")) {
                if (testType != TestType.TEST_TYPE_READ) {
                    return -1;
                }
                testType = TestType.TEST_TYPE_READ_RANDOM;
                continue;
            }
            if (args[i].equalsIgnoreCase("-backward")) {
                if (testType != TestType.TEST_TYPE_READ) {
                    return -1;
                }
                testType = TestType.TEST_TYPE_READ_BACKWARD;
                continue;
            }
            if (args[i].equalsIgnoreCase("-skip")) {
                if (testType != TestType.TEST_TYPE_READ) {
                    return -1;
                }
                testType = TestType.TEST_TYPE_READ_SKIP;
                continue;
            }
            if (args[i].equalsIgnoreCase("-truncate")) {
                testType = TestType.TEST_TYPE_TRUNCATE;
                continue;
            }
            if (args[i].equalsIgnoreCase("-clean")) {
                testType = TestType.TEST_TYPE_CLEANUP;
                continue;
            }
            if (StringUtils.toLowerCase((String)args[i]).startsWith("-seq")) {
                isSequential = true;
                continue;
            }
            if (StringUtils.toLowerCase((String)args[i]).startsWith("-compression")) {
                compressionClass = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-nrfiles")) {
                nrFiles = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-filesize") || args[i].equalsIgnoreCase("-size")) {
                nrBytes = TestDFSIO.parseSize(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-skipsize")) {
                skipSize = TestDFSIO.parseSize(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-buffersize")) {
                bufferSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-resfile")) {
                resFileName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-storagePolicy")) {
                storagePolicy = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-erasureCodePolicy")) {
                erasureCodePolicyName = args[++i];
                continue;
            }
            System.err.println("Illegal argument: " + args[i]);
            return -1;
        }
        if (testType == null) {
            return -1;
        }
        if (testType == TestType.TEST_TYPE_READ_BACKWARD) {
            skipSize = -bufferSize;
        } else if (testType == TestType.TEST_TYPE_READ_SKIP && skipSize == 0L) {
            skipSize = bufferSize;
        }
        LOG.info("nrFiles = " + nrFiles);
        LOG.info("nrBytes (MB) = " + TestDFSIO.toMB(nrBytes));
        LOG.info("bufferSize = " + bufferSize);
        if (skipSize > 0L) {
            LOG.info("skipSize = " + skipSize);
        }
        LOG.info("baseDir = " + TestDFSIO.getBaseDir(this.config));
        if (compressionClass != null) {
            this.config.set("test.io.compression.class", compressionClass);
            LOG.info("compressionClass = " + compressionClass);
        }
        this.config.setInt("test.io.file.buffer.size", bufferSize);
        this.config.setLong("test.io.skip.size", skipSize);
        FileSystem fs = FileSystem.get((Configuration)this.config);
        if (erasureCodePolicyName != null && !this.checkErasureCodePolicy(erasureCodePolicyName, fs, testType)) {
            return -1;
        }
        if (storagePolicy != null && !this.checkStoragePolicy(storagePolicy, fs)) {
            return -1;
        }
        if (isSequential) {
            long tStart = System.currentTimeMillis();
            this.sequentialTest(fs, testType, nrBytes, nrFiles);
            long execTime = System.currentTimeMillis() - tStart;
            String resultLine = "Seq Test exec time sec: " + TestDFSIO.msToSecs(execTime);
            LOG.info(resultLine);
            return 0;
        }
        if (testType == TestType.TEST_TYPE_CLEANUP) {
            this.cleanup(fs);
            return 0;
        }
        try {
            this.createControlFile(fs, nrBytes, nrFiles);
        }
        catch (IOException e) {
            LOG.warn(e.toString());
            throw new IOException(e);
        }
        long tStart = System.currentTimeMillis();
        switch (testType) {
            case TEST_TYPE_WRITE: {
                this.writeTest(fs);
                break;
            }
            case TEST_TYPE_READ: {
                this.readTest(fs, nrBytes);
                break;
            }
            case TEST_TYPE_APPEND: {
                this.appendTest(fs);
                break;
            }
            case TEST_TYPE_READ_RANDOM: 
            case TEST_TYPE_READ_BACKWARD: 
            case TEST_TYPE_READ_SKIP: {
                this.randomReadTest(fs);
                break;
            }
            case TEST_TYPE_TRUNCATE: {
                this.truncateTest(fs);
                break;
            }
        }
        long execTime = System.currentTimeMillis() - tStart;
        this.analyzeResult(fs, testType, execTime, resFileName);
        return 0;
    }

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    static long parseSize(String arg) {
        String[] args = arg.split("\\D", 2);
        assert (args.length <= 2);
        long nrBytes = Long.parseLong(args[0]);
        String bytesMult = arg.substring(args[0].length());
        return nrBytes * ByteMultiple.parseString(bytesMult).value();
    }

    static float toMB(long bytes) {
        return (float)bytes / (float)MEGA;
    }

    static float msToSecs(long timeMillis) {
        return (float)timeMillis / 1000.0f;
    }

    private boolean checkErasureCodePolicy(String erasureCodePolicyName, FileSystem fs, TestType testType) throws IOException {
        Collection list = ((DistributedFileSystem)fs).getAllErasureCodingPolicies();
        boolean isValid = false;
        for (ErasureCodingPolicyInfo ec : list) {
            if (!erasureCodePolicyName.equals(ec.getPolicy().getName())) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            System.out.println("Invalid erasure code policy: " + erasureCodePolicyName);
            System.out.println("Current supported erasure code policy list: ");
            for (ErasureCodingPolicyInfo ec : list) {
                System.out.println(ec.getPolicy().getName());
            }
            return false;
        }
        if (testType == TestType.TEST_TYPE_APPEND || testType == TestType.TEST_TYPE_TRUNCATE) {
            System.out.println("So far append or truncate operation does not support erasureCodePolicy");
            return false;
        }
        this.config.set(ERASURE_CODE_POLICY_NAME_KEY, erasureCodePolicyName);
        LOG.info("erasureCodePolicy = " + erasureCodePolicyName);
        return true;
    }

    private boolean checkStoragePolicy(String storagePolicy, FileSystem fs) throws IOException {
        boolean isValid = false;
        Collection storagePolicies = ((DistributedFileSystem)fs).getAllStoragePolicies();
        try {
            for (BlockStoragePolicy policy : storagePolicies) {
                if (!policy.getName().equals(storagePolicy)) continue;
                isValid = true;
                break;
            }
        }
        catch (Exception e) {
            throw new IOException("Get block storage policies error: ", e);
        }
        if (!isValid) {
            System.out.println("Invalid block storage policy: " + storagePolicy);
            System.out.println("Current supported storage policy list: ");
            for (BlockStoragePolicy policy : storagePolicies) {
                System.out.println(policy.getName());
            }
            return false;
        }
        this.config.set(STORAGE_POLICY_NAME_KEY, storagePolicy);
        LOG.info("storagePolicy = " + storagePolicy);
        return true;
    }

    private boolean isECEnabled() {
        String erasureCodePolicyName = this.getConf().get(ERASURE_CODE_POLICY_NAME_KEY, null);
        return erasureCodePolicyName != null;
    }

    void createAndEnableECOnPath(FileSystem fs, Path path) throws IOException {
        String erasureCodePolicyName = this.getConf().get(ERASURE_CODE_POLICY_NAME_KEY, null);
        fs.mkdirs(path);
        Collection list = ((DistributedFileSystem)fs).getAllErasureCodingPolicies();
        for (ErasureCodingPolicyInfo info : list) {
            ErasureCodingPolicy ec = info.getPolicy();
            if (!erasureCodePolicyName.equals(ec.getName())) continue;
            ((DistributedFileSystem)fs).setErasureCodingPolicy(path, ec.getName());
            LOG.info("enable erasureCodePolicy = " + erasureCodePolicyName + " on " + path.toString());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeResult(FileSystem fs, TestType testType, long execTime, String resFileName) throws IOException {
        Path reduceFile = this.getReduceFilePath(testType);
        long tasks = 0L;
        long size = 0L;
        long time = 0L;
        float rate = 0.0f;
        float sqrate = 0.0f;
        FilterInputStream in = null;
        BufferedReader lines = null;
        try {
            String line;
            in = new DataInputStream((InputStream)fs.open(reduceFile));
            lines = new BufferedReader(new InputStreamReader(in));
            while ((line = lines.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%");
                String attr = tokens.nextToken();
                if (attr.endsWith(":tasks")) {
                    tasks = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":size")) {
                    size = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":time")) {
                    time = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":rate")) {
                    rate = Float.parseFloat(tokens.nextToken());
                    continue;
                }
                if (!attr.endsWith(":sqrate")) continue;
                sqrate = Float.parseFloat(tokens.nextToken());
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (lines != null) {
                lines.close();
            }
        }
        double med = rate / 1000.0f / (float)tasks;
        double stdDev = Math.sqrt(Math.abs((double)(sqrate / 1000.0f / (float)tasks) - med * med));
        DecimalFormat df = new DecimalFormat("#.##");
        String[] resultLines = new String[]{"----- TestDFSIO ----- : " + (Object)((Object)testType), "            Date & time: " + new Date(System.currentTimeMillis()), "        Number of files: " + tasks, " Total MBytes processed: " + df.format(TestDFSIO.toMB(size)), "      Throughput mb/sec: " + df.format(TestDFSIO.toMB(size) / TestDFSIO.msToSecs(time)), " Average IO rate mb/sec: " + df.format(med), "  IO rate std deviation: " + df.format(stdDev), "     Test exec time sec: " + df.format(TestDFSIO.msToSecs(execTime)), ""};
        try (PrintStream res = null;){
            res = new PrintStream(new FileOutputStream(new File(resFileName), true));
            for (int i = 0; i < resultLines.length; ++i) {
                LOG.info(resultLines[i]);
                res.println(resultLines[i]);
            }
        }
    }

    private Path getReduceFilePath(TestType testType) {
        switch (testType) {
            case TEST_TYPE_WRITE: {
                return new Path(TestDFSIO.getWriteDir(this.config), "part-00000");
            }
            case TEST_TYPE_APPEND: {
                return new Path(TestDFSIO.getAppendDir(this.config), "part-00000");
            }
            case TEST_TYPE_READ: {
                return new Path(TestDFSIO.getReadDir(this.config), "part-00000");
            }
            case TEST_TYPE_READ_RANDOM: 
            case TEST_TYPE_READ_BACKWARD: 
            case TEST_TYPE_READ_SKIP: {
                return new Path(TestDFSIO.getRandomReadDir(this.config), "part-00000");
            }
            case TEST_TYPE_TRUNCATE: {
                return new Path(TestDFSIO.getTruncateDir(this.config), "part-00000");
            }
        }
        return null;
    }

    private void analyzeResult(FileSystem fs, TestType testType, long execTime) throws IOException {
        String dir = System.getProperty("test.build.dir", "target/test-dir");
        this.analyzeResult(fs, testType, execTime, dir + "/" + DEFAULT_RES_FILE_NAME);
    }

    private void cleanup(FileSystem fs) throws IOException {
        LOG.info("Cleaning up test files");
        fs.delete(new Path(TestDFSIO.getBaseDir(this.config)), true);
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        Configuration.addDefaultResource((String)"mapred-default.xml");
        Configuration.addDefaultResource((Properties)MapReduceDefaultProperties.getProperties());
        Configuration.addDefaultResource((String)"mapred-site.xml");
    }

    public static class TruncateMapper
    extends IOStatMapper {
        private static final long DELAY = 100L;
        private Path filePath;
        private long fileSize;

        @Override
        public Closeable getIOStream(String name) throws IOException {
            this.filePath = new Path(TestDFSIO.getDataDir(this.getConf()), name);
            this.fileSize = this.fs.getFileStatus(this.filePath).getLen();
            return null;
        }

        @Override
        public Long doIO(Reporter reporter, String name, long newLength) throws IOException {
            boolean isClosed = this.fs.truncate(this.filePath, newLength);
            reporter.setStatus("truncating " + name + " to newLength " + newLength + " ::host = " + this.hostName);
            int i = 0;
            while (!isClosed) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                FileStatus status = this.fs.getFileStatus(this.filePath);
                assert (status != null) : "status is null";
                isClosed = status.getLen() == newLength;
                reporter.setStatus("truncate recover for " + name + " to newLength " + newLength + " attempt " + i + " ::host = " + this.hostName);
                ++i;
            }
            return this.fileSize - newLength;
        }
    }

    public static class RandomReadMapper
    extends IOStatMapper {
        private ThreadLocalRandom rnd = ThreadLocalRandom.current();
        private long fileSize;
        private long skipSize;

        @Override
        public void configure(JobConf conf) {
            super.configure(conf);
            this.skipSize = conf.getLong("test.io.skip.size", 0L);
        }

        @Override
        public Closeable getIOStream(String name) throws IOException {
            Path filePath = new Path(TestDFSIO.getDataDir(this.getConf()), name);
            this.fileSize = this.fs.getFileStatus(filePath).getLen();
            FSDataInputStream in = this.fs.open(filePath);
            if (this.compressionCodec != null) {
                in = new FSDataInputStream((InputStream)this.compressionCodec.createInputStream((InputStream)in));
            }
            LOG.info("in = " + in.getClass().getName());
            LOG.info("skipSize = " + this.skipSize);
            return in;
        }

        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            int curSize;
            PositionedReadable in = (PositionedReadable)this.stream;
            long actualSize = 0L;
            long pos = this.nextOffset(-1L);
            while (actualSize < totalSize && (curSize = in.read(pos, this.buffer, 0, this.bufferSize)) >= 0) {
                reporter.setStatus("reading " + name + "@" + (actualSize += (long)curSize) + "/" + totalSize + " ::host = " + this.hostName);
                pos = this.nextOffset(pos);
            }
            return actualSize;
        }

        private long nextOffset(long current) {
            if (this.skipSize == 0L) {
                return this.rnd.nextLong(this.fileSize);
            }
            if (this.skipSize > 0L) {
                return current < 0L ? 0L : current + (long)this.bufferSize + this.skipSize;
            }
            return current < 0L ? Math.max(0L, this.fileSize - (long)this.bufferSize) : Math.max(0L, current + this.skipSize);
        }
    }

    public static class DFSIOFileInputFormat
    extends FileInputFormat<Text, LongWritable> {
        public RecordReader<Text, LongWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) {
            FileSplit fileSplit = (FileSplit)split;
            LOG.warn("Split Details: File = " + fileSplit.getPath().toString() + ", Start Offset = " + fileSplit.getStart() + ", Length = " + fileSplit.getLength());
            return new DFSIORecordReader(new Text(fileSplit.getPath().toString()), new LongWritable(fileSplit.getLength()));
        }
    }

    public static class DFSIORecordReader
    implements RecordReader<Text, LongWritable> {
        Text filename;
        LongWritable size;
        boolean eof = false;

        public DFSIORecordReader(Text filename, LongWritable size) {
            this.filename = filename;
            this.size = size;
            this.eof = false;
        }

        public LongWritable createValue() {
            return new LongWritable();
        }

        public Text createKey() {
            return new Text();
        }

        public synchronized boolean next(Text key, LongWritable value) {
            if (this.eof) {
                return false;
            }
            key.set(this.filename);
            value.set(this.size.get());
            this.eof = true;
            return true;
        }

        public float getProgress() {
            if (this.eof) {
                return 1.0f;
            }
            return 0.0f;
        }

        public synchronized long getPos() throws IOException {
            return 0L;
        }

        public synchronized void close() throws IOException {
        }
    }

    public static class DFSIOReadMapper
    extends Configured
    implements Mapper<Text, LongWritable, Text, Text> {
        protected byte[] buffer;
        protected int bufferSize;
        protected FileSystem fs;
        protected String hostName;

        public void configure(JobConf conf) {
            this.setConf((Configuration)conf);
            try {
                this.fs = FileSystem.get((Configuration)conf);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create file system.", e);
            }
            this.bufferSize = conf.getInt("test.io.file.buffer.size", 4096);
            this.buffer = new byte[this.bufferSize];
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.hostName = "localhost";
            }
        }

        public void close() throws IOException {
        }

        void collectStats(OutputCollector<Text, Text> output, String name, long execTime, Long objSize) throws IOException {
            long totalSize = objSize;
            float ioRateMbSec = (float)totalSize * 1000.0f / (float)(execTime * MEGA);
            LOG.info("Number of bytes processed = " + totalSize);
            LOG.info("Exec time = " + execTime);
            LOG.info("IO rate = " + ioRateMbSec);
            output.collect((Object)new Text("l:tasks"), (Object)new Text(String.valueOf(1)));
            output.collect((Object)new Text("l:size"), (Object)new Text(String.valueOf(totalSize)));
            output.collect((Object)new Text("l:time"), (Object)new Text(String.valueOf(execTime)));
            output.collect((Object)new Text("f:rate"), (Object)new Text(String.valueOf(ioRateMbSec * 1000.0f)));
            output.collect((Object)new Text("f:sqrate"), (Object)new Text(String.valueOf(ioRateMbSec * ioRateMbSec * 1000.0f)));
        }

        public void map(Text key, LongWritable value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            String name = key.toString();
            long longValue = value.get();
            reporter.setStatus("starting " + name + " host: " + this.hostName);
            long tStart = System.currentTimeMillis();
            Long statValue = this.doIO(reporter, name, longValue);
            long tEnd = System.currentTimeMillis();
            long execTime = tEnd - tStart;
            this.collectStats(output, name, execTime, statValue);
            reporter.setStatus("finished " + name + " host: " + this.hostName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            FSDataInputStream in = this.fs.open(new Path(TestDFSIO.getDataDir(this.getConf()), name));
            long actualSize = 0L;
            try {
                while (actualSize < totalSize) {
                    int curSize = in.read(this.buffer, 0, this.bufferSize);
                    if (curSize < 0) {
                        break;
                    }
                    reporter.setStatus("reading " + name + "@" + (actualSize += (long)curSize) + "/" + totalSize + " ::host = " + this.hostName);
                }
            }
            finally {
                block10: {
                    try {
                        in.adviseFile(FSDataInputStream.FadviseType.FILE_DONTNEED, 0L, totalSize);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isInfoEnabled()) break block10;
                        LOG.info("Error " + ioe + " in fadvise. Ignoring it.");
                    }
                }
                in.close();
            }
            return actualSize;
        }
    }

    public static class ReadMapper
    extends IOStatMapper {
        @Override
        public Closeable getIOStream(String name) throws IOException {
            FSDataInputStream in = this.fs.open(new Path(TestDFSIO.getDataDir(this.getConf()), name));
            if (this.compressionCodec != null) {
                in = this.compressionCodec.createInputStream((InputStream)in);
            }
            LOG.info("in = " + in.getClass().getName());
            return in;
        }

        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            int curSize;
            InputStream in = (InputStream)this.stream;
            long actualSize = 0L;
            while (actualSize < totalSize && (curSize = in.read(this.buffer, 0, this.bufferSize)) >= 0) {
                reporter.setStatus("reading " + name + "@" + (actualSize += (long)curSize) + "/" + totalSize + " ::host = " + this.hostName);
            }
            return actualSize;
        }
    }

    public static class AppendMapper
    extends IOStatMapper {
        public AppendMapper() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer[i] = (byte)(48 + i % 50);
            }
        }

        @Override
        public Closeable getIOStream(String name) throws IOException {
            FSDataOutputStream out = this.fs.append(new Path(TestDFSIO.getDataDir(this.getConf()), name), this.bufferSize);
            if (this.compressionCodec != null) {
                out = this.compressionCodec.createOutputStream((OutputStream)out);
            }
            LOG.info("out = " + out.getClass().getName());
            return out;
        }

        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            OutputStream out = (OutputStream)this.stream;
            for (long nrRemaining = totalSize; nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
                int curSize = (long)this.bufferSize < nrRemaining ? this.bufferSize : (int)nrRemaining;
                out.write(this.buffer, 0, curSize);
                reporter.setStatus("writing " + name + "@" + (totalSize - nrRemaining) + "/" + totalSize + " ::host = " + this.hostName);
            }
            return totalSize;
        }
    }

    public static class WriteMapper
    extends IOStatMapper {
        public WriteMapper() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer[i] = (byte)(48 + i % 50);
            }
        }

        @Override
        public Closeable getIOStream(String name) throws IOException {
            Path filePath = new Path(TestDFSIO.getDataDir(this.getConf()), name);
            FSDataOutputStream out = this.fs.create(filePath, true, this.bufferSize);
            if (this.blockStoragePolicy != null) {
                this.fs.setStoragePolicy(filePath, this.blockStoragePolicy);
            }
            if (this.compressionCodec != null) {
                out = this.compressionCodec.createOutputStream((OutputStream)out);
            }
            LOG.info("out = " + out.getClass().getName());
            return out;
        }

        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            OutputStream out = (OutputStream)this.stream;
            for (long nrRemaining = totalSize; nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
                int curSize = (long)this.bufferSize < nrRemaining ? this.bufferSize : (int)nrRemaining;
                out.write(this.buffer, 0, curSize);
                reporter.setStatus("writing " + name + "@" + (totalSize - nrRemaining) + "/" + totalSize + " ::host = " + this.hostName);
            }
            return totalSize;
        }
    }

    private static abstract class IOStatMapper
    extends IOMapperBase<Long> {
        protected CompressionCodec compressionCodec;
        protected String blockStoragePolicy;

        IOStatMapper() {
        }

        @Override
        public void configure(JobConf conf) {
            Class<CompressionCodec> codec;
            super.configure(conf);
            String compression = this.getConf().get("test.io.compression.class", null);
            try {
                codec = compression == null ? null : Class.forName(compression).asSubclass(CompressionCodec.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Compression codec not found: ", e);
            }
            if (codec != null) {
                this.compressionCodec = (CompressionCodec)ReflectionUtils.newInstance(codec, (Configuration)this.getConf());
            }
            this.blockStoragePolicy = this.getConf().get(TestDFSIO.STORAGE_POLICY_NAME_KEY, null);
        }

        @Override
        void collectStats(OutputCollector<Text, Text> output, String name, long execTime, Long objSize) throws IOException {
            long totalSize = objSize;
            float ioRateMbSec = (float)totalSize * 1000.0f / (float)(execTime * MEGA);
            LOG.info("Number of bytes processed = " + totalSize);
            LOG.info("Exec time = " + execTime);
            LOG.info("IO rate = " + ioRateMbSec);
            output.collect((Object)new Text("l:tasks"), (Object)new Text(String.valueOf(1)));
            output.collect((Object)new Text("l:size"), (Object)new Text(String.valueOf(totalSize)));
            output.collect((Object)new Text("l:time"), (Object)new Text(String.valueOf(execTime)));
            output.collect((Object)new Text("f:rate"), (Object)new Text(String.valueOf(ioRateMbSec * 1000.0f)));
            output.collect((Object)new Text("f:sqrate"), (Object)new Text(String.valueOf(ioRateMbSec * ioRateMbSec * 1000.0f)));
        }
    }

    private class ControlFileCreateTask
    implements Runnable {
        private SequenceFile.Writer writer = null;
        private String name;
        private long nrBytes;

        ControlFileCreateTask(SequenceFile.Writer writer, String name, long nrBytes) {
            this.writer = writer;
            this.name = name;
            this.nrBytes = nrBytes;
        }

        @Override
        public void run() {
            try {
                this.writer.append((Writable)new Text(this.name), (Writable)new LongWritable(this.nrBytes));
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage());
            }
            finally {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException e) {
                        LOG.error(e.toString());
                    }
                }
                this.writer = null;
            }
        }
    }

    static enum ByteMultiple {
        B(1L),
        KB(1024L),
        MB(0x100000L),
        GB(0x40000000L),
        TB(0x10000000000L);

        private long multiplier;

        private ByteMultiple(long mult) {
            this.multiplier = mult;
        }

        long value() {
            return this.multiplier;
        }

        static ByteMultiple parseString(String sMultiple) {
            if (sMultiple == null || sMultiple.isEmpty()) {
                return MB;
            }
            String sMU = StringUtils.toUpperCase((String)sMultiple);
            if (StringUtils.toUpperCase((String)B.name()).endsWith(sMU)) {
                return B;
            }
            if (StringUtils.toUpperCase((String)KB.name()).endsWith(sMU)) {
                return KB;
            }
            if (StringUtils.toUpperCase((String)MB.name()).endsWith(sMU)) {
                return MB;
            }
            if (StringUtils.toUpperCase((String)GB.name()).endsWith(sMU)) {
                return GB;
            }
            if (StringUtils.toUpperCase((String)TB.name()).endsWith(sMU)) {
                return TB;
            }
            throw new IllegalArgumentException("Unsupported ByteMultiple " + sMultiple);
        }
    }

    private static enum TestType {
        TEST_TYPE_READ("read"),
        TEST_TYPE_WRITE("write"),
        TEST_TYPE_CLEANUP("cleanup"),
        TEST_TYPE_APPEND("append"),
        TEST_TYPE_READ_RANDOM("random read"),
        TEST_TYPE_READ_BACKWARD("backward read"),
        TEST_TYPE_READ_SKIP("skip read"),
        TEST_TYPE_TRUNCATE("truncate");

        private String type;

        private TestType(String t) {
            this.type = t;
        }

        public String toString() {
            return this.type;
        }
    }
}

