/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HdfsBlockLocation;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.thirdparty.com.google.common.collect.HashMultiset;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestCombineFileInputFormat {
    private static final String[] rack1 = new String[]{"/r1"};
    private static final String[] hosts1 = new String[]{"host1.rack1.com"};
    private static final String[] rack2 = new String[]{"/r2"};
    private static final String[] hosts2 = new String[]{"host2.rack2.com"};
    private static final String[] rack3 = new String[]{"/r3"};
    private static final String[] hosts3 = new String[]{"host3.rack3.com"};
    final Path inDir = new Path("/racktesting");
    final Path outputPath = new Path("/output");
    final Path dir1 = new Path(this.inDir, "/dir1");
    final Path dir2 = new Path(this.inDir, "/dir2");
    final Path dir3 = new Path(this.inDir, "/dir3");
    final Path dir4 = new Path(this.inDir, "/dir4");
    final Path dir5 = new Path(this.inDir, "/dir5");
    static final int BLOCKSIZE = 1024;
    static final byte[] databuf = new byte[1024];
    @Mock
    private List<String> mockList;
    private static final String DUMMY_FS_URI = "dummyfs:///";
    private static final String DUMMY_KEY = "dummy.rr.key";

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testRecordReaderInit() throws InterruptedException, IOException {
        TaskAttemptID taskId = new TaskAttemptID("jt", 0, TaskType.MAP, 0, 0);
        Configuration conf1 = new Configuration();
        conf1.set(DUMMY_KEY, "STATE1");
        TaskAttemptContextImpl context1 = new TaskAttemptContextImpl(conf1, taskId);
        ChildRRInputFormat inputFormat = new ChildRRInputFormat();
        Path[] files = new Path[]{new Path("file1")};
        long[] lengths = new long[]{1L};
        CombineFileSplit split = new CombineFileSplit(files, lengths);
        RecordReader rr = inputFormat.createRecordReader((InputSplit)split, (TaskAttemptContext)context1);
        Assert.assertTrue((String)"Unexpected RR type!", (boolean)(rr instanceof CombineFileRecordReader));
        Assert.assertEquals((String)"Invalid initial dummy key value", (Object)"STATE1", (Object)rr.getCurrentKey().toString());
        Configuration conf2 = new Configuration();
        conf2.set(DUMMY_KEY, "STATE2");
        TaskAttemptContextImpl context2 = new TaskAttemptContextImpl(conf2, taskId);
        rr.initialize((InputSplit)split, (TaskAttemptContext)context2);
        Assert.assertEquals((String)"Invalid secondary dummy key value", (Object)"STATE2", (Object)rr.getCurrentKey().toString());
    }

    @Test
    public void testReinit() throws Exception {
        TaskAttemptID taskId = new TaskAttemptID("jt", 0, TaskType.MAP, 0, 0);
        Configuration conf = new Configuration();
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, taskId);
        ChildRRInputFormat inputFormat = new ChildRRInputFormat();
        Path[] files = new Path[]{new Path("file1"), new Path("file2")};
        long[] lengths = new long[]{1L, 1L};
        CombineFileSplit split = new CombineFileSplit(files, lengths);
        RecordReader rr = inputFormat.createRecordReader((InputSplit)split, (TaskAttemptContext)context);
        Assert.assertTrue((String)"Unexpected RR type!", (boolean)(rr instanceof CombineFileRecordReader));
        rr.initialize((InputSplit)split, (TaskAttemptContext)context);
        Assert.assertTrue((boolean)rr.nextKeyValue());
        Assert.assertEquals((Object)"file1", (Object)rr.getCurrentValue().toString());
        Assert.assertTrue((boolean)rr.nextKeyValue());
        Assert.assertEquals((Object)"file2", (Object)rr.getCurrentValue().toString());
        Assert.assertFalse((boolean)rr.nextKeyValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitPlacement() throws Exception {
        MiniDFSCluster dfs = null;
        DistributedFileSystem fileSys = null;
        try {
            long offset;
            long length;
            Configuration conf = new Configuration();
            conf.setBoolean("mapreduce.multi.split.locations.enabled", false);
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster.Builder(conf).racks(rack1).hosts(hosts1).build();
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1");
            TestCombineFileInputFormat.writeFile(conf, file1, (short)1, 1);
            Path file5 = new Path(this.dir5 + "/file5");
            TestCombineFileInputFormat.writeFile(conf, file5, (short)1, 1);
            DummyInputFormat inFormat = new DummyInputFormat();
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir5));
            List splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test0): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            Assert.assertEquals((long)1L, (long)splits.size());
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file5.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack2, hosts2, null);
            dfs.waitActive();
            Path file2 = new Path(this.dir2 + "/file2");
            TestCombineFileInputFormat.writeFile(conf, file2, (short)2, 2);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test1): " + splits.size());
            for (Object split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            for (Object split : splits) {
                fileSplit = (CombineFileSplit)split;
                if (splits.size() == 2) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
                        Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
                        Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (!split.equals(splits.get(1))) continue;
                    Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                    Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                    Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
                    Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                    Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
                    Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    continue;
                }
                if (splits.size() == 1) {
                    Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
                    HashSet<Split> expected = new HashSet<Split>();
                    expected.add(new Split(file1.getName(), 1024L, 0L));
                    expected.add(new Split(file2.getName(), 1024L, 0L));
                    expected.add(new Split(file2.getName(), 1024L, 1024L));
                    ArrayList<Split> actual = new ArrayList<Split>();
                    for (int i = 0; i < 3; ++i) {
                        String name = fileSplit.getPath(i).getName();
                        long length2 = fileSplit.getLength(i);
                        long offset2 = fileSplit.getOffset(i);
                        actual.add(new Split(name, length2, offset2));
                    }
                    Assert.assertTrue((boolean)actual.containsAll(expected));
                    Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                    Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    continue;
                }
                Assert.fail((String)("Expected split size is 1 or 2, but actual size is " + splits.size()));
            }
            dfs.startDataNodes(conf, 1, true, null, rack3, hosts3, null);
            dfs.waitActive();
            Path file3 = new Path(this.dir3 + "/file3");
            TestCombineFileInputFormat.writeFile(conf, new Path(this.dir3 + "/file3"), (short)3, 3);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test2): " + split);
            }
            HashSet<Split> expected = new HashSet<Split>();
            expected.add(new Split(file1.getName(), 1024L, 0L));
            expected.add(new Split(file2.getName(), 1024L, 0L));
            expected.add(new Split(file2.getName(), 1024L, 1024L));
            expected.add(new Split(file3.getName(), 1024L, 0L));
            expected.add(new Split(file3.getName(), 1024L, 1024L));
            expected.add(new Split(file3.getName(), 1024L, 2048L));
            ArrayList<Split> actual = new ArrayList<Split>();
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                if (splits.size() == 3) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
                        Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(1).getName());
                        Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
                        Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(2).getName());
                        Assert.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(2));
                        Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
                        Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
                        Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(2))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else if (splits.size() == 2) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        if (fileSplit.getLocations()[0].equals(hosts2[0])) {
                            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        } else if (fileSplit.getLocations()[0].equals(hosts3[0])) {
                            Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
                        } else {
                            Assert.fail((String)"First split should be on rack2 or rack3.");
                        }
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else if (splits.size() == 1) {
                    Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                    Assert.assertEquals((long)6L, (long)fileSplit.getNumPaths());
                    Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                } else {
                    Assert.fail((String)"Split size should be 1, 2, or 3.");
                }
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    String name = fileSplit.getPath(i).getName();
                    long length3 = fileSplit.getLength(i);
                    long offset3 = fileSplit.getOffset(i);
                    actual.add(new Split(name, length3, offset3));
                }
            }
            Assert.assertEquals((long)6L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            Path file4 = new Path(this.dir4 + "/file4");
            TestCombineFileInputFormat.writeFile(conf, file4, (short)3, 3);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test3): " + split);
            }
            expected.add(new Split(file4.getName(), 1024L, 0L));
            expected.add(new Split(file4.getName(), 1024L, 1024L));
            expected.add(new Split(file4.getName(), 1024L, 2048L));
            actual.clear();
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                if (splits.size() == 3) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)6L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
                        Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
                        Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(2))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else if (splits.size() == 2) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        if (fileSplit.getLocations()[0].equals(hosts2[0])) {
                            Assert.assertEquals((long)5L, (long)fileSplit.getNumPaths());
                        } else if (fileSplit.getLocations()[0].equals(hosts3[0])) {
                            Assert.assertEquals((long)6L, (long)fileSplit.getNumPaths());
                        } else {
                            Assert.fail((String)"First split should be on rack2 or rack3.");
                        }
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else if (splits.size() == 1) {
                    Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                    Assert.assertEquals((long)9L, (long)fileSplit.getNumPaths());
                    Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                } else {
                    Assert.fail((String)"Split size should be 1, 2, or 3.");
                }
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    String name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
            }
            Assert.assertEquals((long)9L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            inFormat.setMaxBlocksNum(3);
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test4): " + split);
            }
            actual.clear();
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                if (splits.size() == 3) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(1).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(1));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(2).getName());
                        Assert.assertEquals((long)1024L, (long)fileSplit.getOffset(2));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(2));
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(2))) {
                        Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)file4.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
                        Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else {
                    Assert.fail((String)"Split size should be 3.");
                }
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    String name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
            }
            Assert.assertEquals((long)9L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(2048L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test4): " + split);
            }
            Assert.assertEquals((long)5L, (long)splits.size());
            actual.clear();
            Mockito.reset((Object[])new List[]{this.mockList});
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    String name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
                this.mockList.add(fileSplit.getLocations()[0]);
            }
            Assert.assertEquals((long)9L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.atLeastOnce())).add(hosts1[0]);
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.atLeastOnce())).add(hosts2[0]);
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.atLeastOnce())).add(hosts3[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(3072L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test5): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            actual.clear();
            Mockito.reset((Object[])new List[]{this.mockList});
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    String name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
                this.mockList.add(fileSplit.getLocations()[0]);
            }
            Assert.assertEquals((long)9L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.atLeastOnce())).add(hosts1[0]);
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.atLeastOnce())).add(hosts2[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(4096L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test6): " + split);
            }
            Assert.assertEquals((long)3L, (long)splits.size());
            actual.clear();
            Mockito.reset((Object[])new List[]{this.mockList});
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    String name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
                this.mockList.add(fileSplit.getLocations()[0]);
            }
            Assert.assertEquals((long)9L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.atLeastOnce())).add(hosts1[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(7168L);
            inFormat.setMinSplitSizeNode(3072L);
            inFormat.setMinSplitSizeRack(3072L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test7): " + split);
            }
            Assert.assertEquals((long)2L, (long)splits.size());
            actual.clear();
            Mockito.reset((Object[])new List[]{this.mockList});
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    String name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
                this.mockList.add(fileSplit.getLocations()[0]);
            }
            Assert.assertEquals((long)9L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.atLeastOnce())).add(hosts1[0]);
            inFormat = new DummyInputFormat();
            FileInputFormat.addInputPath((Job)job, (Path)this.inDir);
            inFormat.setMinSplitSizeRack(1L);
            inFormat.createPool(new PathFilter[]{new TestFilter(this.dir1), new TestFilter(this.dir2)});
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            for (InputSplit split : splits) {
                String name;
                int i;
                fileSplit = (CombineFileSplit)split;
                if (splits.size() == 2) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
                        expected.clear();
                        expected.add(new Split(file1.getName(), 1024L, 0L));
                        expected.add(new Split(file2.getName(), 1024L, 0L));
                        expected.add(new Split(file2.getName(), 1024L, 1024L));
                        actual.clear();
                        for (i = 0; i < 3; ++i) {
                            name = fileSplit.getPath(i).getName();
                            length = fileSplit.getLength(i);
                            offset = fileSplit.getOffset(i);
                            actual.add(new Split(name, length, offset));
                        }
                        Assert.assertTrue((boolean)actual.containsAll(expected));
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (!split.equals(splits.get(1))) continue;
                    Assert.assertEquals((long)6L, (long)fileSplit.getNumPaths());
                    expected.clear();
                    expected.add(new Split(file3.getName(), 1024L, 0L));
                    expected.add(new Split(file3.getName(), 1024L, 1024L));
                    expected.add(new Split(file3.getName(), 1024L, 2048L));
                    expected.add(new Split(file4.getName(), 1024L, 0L));
                    expected.add(new Split(file4.getName(), 1024L, 1024L));
                    expected.add(new Split(file4.getName(), 1024L, 2048L));
                    actual.clear();
                    for (i = 0; i < 6; ++i) {
                        name = fileSplit.getPath(i).getName();
                        length = fileSplit.getLength(i);
                        offset = fileSplit.getOffset(i);
                        actual.add(new Split(name, length, offset));
                    }
                    Assert.assertTrue((boolean)actual.containsAll(expected));
                    Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                    continue;
                }
                if (splits.size() == 3) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        expected.clear();
                        expected.add(new Split(file2.getName(), 1024L, 0L));
                        expected.add(new Split(file2.getName(), 1024L, 1024L));
                        actual.clear();
                        for (i = 0; i < 2; ++i) {
                            name = fileSplit.getPath(i).getName();
                            length = fileSplit.getLength(i);
                            offset = fileSplit.getOffset(i);
                            actual.add(new Split(name, length, offset));
                        }
                        Assert.assertTrue((boolean)actual.containsAll(expected));
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (!split.equals(splits.get(2))) continue;
                    Assert.assertEquals((long)6L, (long)fileSplit.getNumPaths());
                    expected.clear();
                    expected.add(new Split(file3.getName(), 1024L, 0L));
                    expected.add(new Split(file3.getName(), 1024L, 1024L));
                    expected.add(new Split(file3.getName(), 1024L, 2048L));
                    expected.add(new Split(file4.getName(), 1024L, 0L));
                    expected.add(new Split(file4.getName(), 1024L, 1024L));
                    expected.add(new Split(file4.getName(), 1024L, 2048L));
                    actual.clear();
                    for (i = 0; i < 6; ++i) {
                        name = fileSplit.getPath(i).getName();
                        length = fileSplit.getLength(i);
                        offset = fileSplit.getOffset(i);
                        actual.add(new Split(name, length, offset));
                    }
                    Assert.assertTrue((boolean)actual.containsAll(expected));
                    Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                    continue;
                }
                Assert.fail((String)"Split size should be 2 or 3.");
            }
            int numPools = 100;
            int numFiles = 1000;
            DummyInputFormat1 inFormat1 = new DummyInputFormat1();
            for (int i = 0; i < numFiles; ++i) {
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{file1});
            }
            inFormat1.setMinSplitSizeRack(1L);
            Path dirNoMatch1 = new Path(this.inDir, "/dirxx");
            Path dirNoMatch2 = new Path(this.inDir, "/diryy");
            for (int i = 0; i < numPools; ++i) {
                inFormat1.createPool(new PathFilter[]{new TestFilter(dirNoMatch1), new TestFilter(dirNoMatch2)});
            }
            long start = System.currentTimeMillis();
            splits = inFormat1.getSplits((JobContext)job);
            long end = System.currentTimeMillis();
            System.out.println("Elapsed time for " + numPools + " pools  and " + numFiles + " files is " + (end - start) / 1000L + " seconds.");
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(512L);
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.dir3});
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test8): " + split);
            }
            Assert.assertEquals((long)splits.size(), (long)6L);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static void writeFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException, TimeoutException, InterruptedException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        FSDataOutputStream stm = fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L);
        TestCombineFileInputFormat.writeDataAndSetReplication(fileSys, name, (OutputStream)stm, replication, numBlocks);
    }

    static FileStatus writeGzipFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException, TimeoutException, InterruptedException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        GZIPOutputStream out = new GZIPOutputStream((OutputStream)fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L));
        TestCombineFileInputFormat.writeDataAndSetReplication(fileSys, name, out, replication, numBlocks);
        return fileSys.getFileStatus(name);
    }

    private static void writeDataAndSetReplication(FileSystem fileSys, Path name, OutputStream out, short replication, int numBlocks) throws IOException, TimeoutException, InterruptedException {
        for (int i = 0; i < numBlocks; ++i) {
            out.write(databuf);
        }
        out.close();
        DFSTestUtil.waitReplication((FileSystem)fileSys, (Path)name, (short)replication);
    }

    @Test
    public void testNodeDistribution() throws IOException, InterruptedException {
        DummyInputFormat inFormat = new DummyInputFormat();
        int numBlocks = 60;
        long totLength = 0L;
        long blockSize = 100L;
        int numNodes = 10;
        long minSizeNode = 50L;
        long minSizeRack = 50L;
        int maxSplitSize = 200;
        int maxBlocks = 0;
        String[] locations = new String[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            locations[i] = "h" + i;
        }
        String[] racks = new String[]{};
        Path path = new Path("hdfs://file");
        CombineFileInputFormat.OneBlockInfo[] blocks = new CombineFileInputFormat.OneBlockInfo[numBlocks];
        int hostCountBase = 0;
        for (int i = 0; i < numBlocks; ++i) {
            int localHostCount = hostCountBase;
            String[] blockHosts = new String[3];
            for (int j = 0; j < 3; ++j) {
                int hostNum = localHostCount % numNodes;
                blockHosts[j] = "h" + hostNum;
                ++localHostCount;
            }
            ++hostCountBase;
            blocks[i] = new CombineFileInputFormat.OneBlockInfo(path, (long)i * blockSize, blockSize, blockHosts, racks);
            totLength += blockSize;
        }
        ArrayList splits = new ArrayList();
        HashMap rackToNodes = new HashMap();
        HashMap rackToBlocks = new HashMap();
        HashMap blockToNodes = new HashMap();
        TreeMap nodeToBlocks = new TreeMap();
        CombineFileInputFormat.OneFileInfo.populateBlockInfo((CombineFileInputFormat.OneBlockInfo[])blocks, rackToBlocks, blockToNodes, nodeToBlocks, rackToNodes);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.multi.split.locations.enabled", false);
        inFormat.createSplits(nodeToBlocks, blockToNodes, rackToBlocks, totLength, maxBlocks, maxSplitSize, minSizeNode, minSizeRack, splits, conf);
        int expectedSplitCount = (int)(totLength / (long)maxSplitSize);
        Assert.assertEquals((long)expectedSplitCount, (long)splits.size());
        int numLocalSplits = 0;
        for (InputSplit inputSplit : splits) {
            Assert.assertEquals((long)maxSplitSize, (long)inputSplit.getLength());
            if (inputSplit.getLocations().length != 1) continue;
            ++numLocalSplits;
        }
        Assert.assertTrue(((double)numLocalSplits >= 0.9 * (double)splits.size() ? 1 : 0) != 0);
    }

    @Test
    public void testNodeInputSplit() throws IOException, InterruptedException {
        DummyInputFormat inFormat = new DummyInputFormat();
        int numBlocks = 12;
        long totLength = 0L;
        long blockSize = 100L;
        long maxSize = 200L;
        int maxBlocks = 0;
        long minSizeNode = 50L;
        long minSizeRack = 50L;
        String[] locations = new String[]{"h1", "h2"};
        String[] racks = new String[]{};
        Path path = new Path("hdfs://file");
        CombineFileInputFormat.OneBlockInfo[] blocks = new CombineFileInputFormat.OneBlockInfo[numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            blocks[i] = new CombineFileInputFormat.OneBlockInfo(path, (long)i * blockSize, blockSize, locations, racks);
            totLength += blockSize;
        }
        ArrayList splits = new ArrayList();
        HashMap rackToNodes = new HashMap();
        HashMap rackToBlocks = new HashMap();
        HashMap blockToNodes = new HashMap();
        HashMap nodeToBlocks = new HashMap();
        CombineFileInputFormat.OneFileInfo.populateBlockInfo((CombineFileInputFormat.OneBlockInfo[])blocks, rackToBlocks, blockToNodes, nodeToBlocks, rackToNodes);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.multi.split.locations.enabled", false);
        inFormat.createSplits(nodeToBlocks, blockToNodes, rackToBlocks, totLength, maxBlocks, maxSize, minSizeNode, minSizeRack, splits, conf);
        int expectedSplitCount = (int)(totLength / maxSize);
        Assert.assertEquals((long)expectedSplitCount, (long)splits.size());
        HashMultiset nodeSplits = HashMultiset.create();
        for (int i = 0; i < expectedSplitCount; ++i) {
            InputSplit inSplit = (InputSplit)splits.get(i);
            Assert.assertEquals((long)maxSize, (long)inSplit.getLength());
            Assert.assertEquals((long)1L, (long)inSplit.getLocations().length);
            nodeSplits.add((Object)inSplit.getLocations()[0]);
        }
        Assert.assertEquals((long)3L, (long)nodeSplits.count((Object)locations[0]));
        Assert.assertEquals((long)3L, (long)nodeSplits.count((Object)locations[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitPlacementForCompressedFiles() throws Exception {
        MiniDFSCluster dfs = null;
        DistributedFileSystem fileSys = null;
        try {
            long offset;
            long length;
            String name;
            Configuration conf = new Configuration();
            conf.setBoolean("mapreduce.multi.split.locations.enabled", false);
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster.Builder(conf).racks(rack1).hosts(hosts1).build();
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1.gz");
            FileStatus f1 = TestCombineFileInputFormat.writeGzipFile(conf, file1, (short)1, 1);
            Path file5 = new Path(this.dir5 + "/file5.gz");
            FileStatus f5 = TestCombineFileInputFormat.writeGzipFile(conf, file5, (short)1, 1);
            DummyInputFormat inFormat = new DummyInputFormat();
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir5));
            List splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test0): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            Assert.assertEquals((long)1L, (long)splits.size());
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file5.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)f5.getLen(), (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack2, hosts2, null);
            dfs.waitActive();
            Path file2 = new Path(this.dir2 + "/file2.gz");
            FileStatus f2 = TestCombineFileInputFormat.writeGzipFile(conf, file2, (short)2, 2);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2));
            inFormat.setMinSplitSizeRack(f1.getLen());
            splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test1): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            HashSet<Split> expected = new HashSet<Split>();
            expected.add(new Split(file1.getName(), f1.getLen(), 0L));
            expected.add(new Split(file2.getName(), f2.getLen(), 0L));
            ArrayList<Split> actual = new ArrayList<Split>();
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                if (splits.size() == 2) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
                        Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else if (splits.size() == 1) {
                    Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                    Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                    Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                } else {
                    Assert.fail((String)"Split size should be 1 or 2.");
                }
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    String name2 = fileSplit.getPath(i).getName();
                    long length2 = fileSplit.getLength(i);
                    long offset2 = fileSplit.getOffset(i);
                    actual.add(new Split(name2, length2, offset2));
                }
            }
            Assert.assertEquals((long)2L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            dfs.startDataNodes(conf, 1, true, null, rack3, hosts3, null);
            dfs.waitActive();
            Path file3 = new Path(this.dir3 + "/file3.gz");
            FileStatus f3 = TestCombineFileInputFormat.writeGzipFile(conf, file3, (short)3, 3);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3));
            inFormat.setMinSplitSizeRack(f1.getLen());
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test2): " + split);
            }
            expected.add(new Split(file3.getName(), f3.getLen(), 0L));
            actual.clear();
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                if (splits.size() == 3) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((Object)file3.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(2))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else if (splits.size() == 2) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        if (fileSplit.getLocations()[0].equals(hosts2[0])) {
                            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        } else if (fileSplit.getLocations()[0].equals(hosts3[0])) {
                            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        } else {
                            Assert.fail((String)"First split should be on rack2 or rack3.");
                        }
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else if (splits.size() == 1) {
                    Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                    Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
                    Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                } else {
                    Assert.fail((String)"Split size should be 1, 2, or 3.");
                }
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    String name3 = fileSplit.getPath(i).getName();
                    long length3 = fileSplit.getLength(i);
                    long offset3 = fileSplit.getOffset(i);
                    actual.add(new Split(name3, length3, offset3));
                }
            }
            Assert.assertEquals((long)3L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            Path file4 = new Path(this.dir4 + "/file4.gz");
            FileStatus f4 = TestCombineFileInputFormat.writeGzipFile(conf, file4, (short)3, 3);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            inFormat.setMinSplitSizeRack(f1.getLen());
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test3): " + split);
            }
            expected.add(new Split(file3.getName(), f3.getLen(), 0L));
            actual.clear();
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                if (splits.size() == 3) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((Object)file2.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(2))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
                        Assert.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
                        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else if (splits.size() == 2) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        if (fileSplit.getLocations()[0].equals(hosts2[0])) {
                            Assert.assertEquals((long)3L, (long)fileSplit.getNumPaths());
                        } else if (fileSplit.getLocations()[0].equals(hosts3[0])) {
                            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        } else {
                            Assert.fail((String)"First split should be on rack2 or rack3.");
                        }
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else if (splits.size() == 1) {
                    Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                    Assert.assertEquals((long)4L, (long)fileSplit.getNumPaths());
                    Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                } else {
                    Assert.fail((String)"Split size should be 1, 2, or 3.");
                }
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
            }
            Assert.assertEquals((long)4L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(f1.getLen());
            inFormat.setMaxSplitSize(f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test4): " + split);
            }
            Assert.assertEquals((long)4L, (long)splits.size());
            actual.clear();
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
                this.mockList.add(fileSplit.getLocations()[0]);
            }
            Assert.assertEquals((long)4L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.atLeastOnce())).add(hosts1[0]);
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.atLeastOnce())).add(hosts2[0]);
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.atLeastOnce())).add(hosts3[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(f1.getLen());
            inFormat.setMaxSplitSize(2L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test5): " + split);
            }
            actual.clear();
            Mockito.reset((Object[])new List[]{this.mockList});
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
                this.mockList.add(fileSplit.getLocations()[0]);
            }
            Assert.assertEquals((long)4L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            if (splits.size() == 3) {
                ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.times((int)1))).add(hosts1[0]);
                ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.times((int)1))).add(hosts2[0]);
                ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.times((int)1))).add(hosts3[0]);
            } else if (splits.size() == 2) {
                ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.times((int)1))).add(hosts1[0]);
            } else {
                Assert.fail((String)"Split size should be 2 or 3.");
            }
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(2L * f1.getLen());
            inFormat.setMaxSplitSize(4L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test6): " + split);
            }
            Assert.assertTrue((String)"Split size should be 1 or 2.", (splits.size() == 1 || splits.size() == 2 ? 1 : 0) != 0);
            actual.clear();
            Mockito.reset((Object[])new List[]{this.mockList});
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
                this.mockList.add(fileSplit.getLocations()[0]);
            }
            Assert.assertEquals((long)4L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            ((List)Mockito.verify(this.mockList, (VerificationMode)Mockito.times((int)1))).add(hosts1[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(4L * f1.getLen());
            inFormat.setMinSplitSizeRack(4L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test7): " + split);
            }
            Assert.assertEquals((long)1L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)4L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(4L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test8): " + split);
            }
            Assert.assertEquals((long)1L, (long)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)4L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat();
            FileInputFormat.addInputPath((Job)job, (Path)this.inDir);
            inFormat.setMinSplitSizeRack(1L);
            inFormat.createPool(new PathFilter[]{new TestFilter(this.dir1), new TestFilter(this.dir2)});
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test9): " + split);
            }
            actual.clear();
            for (InputSplit split : splits) {
                fileSplit = (CombineFileSplit)split;
                if (splits.size() == 3) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts2[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(2))) {
                        Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else if (splits.size() == 2) {
                    if (split.equals(splits.get(0))) {
                        Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
                    }
                    if (split.equals(splits.get(1))) {
                        Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
                        Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
                        Assert.assertEquals((Object)hosts3[0], (Object)fileSplit.getLocations()[0]);
                    }
                } else {
                    Assert.fail((String)"Split size should be 2 or 3.");
                }
                for (int i = 0; i < fileSplit.getNumPaths(); ++i) {
                    name = fileSplit.getPath(i).getName();
                    length = fileSplit.getLength(i);
                    offset = fileSplit.getOffset(i);
                    actual.add(new Split(name, length, offset));
                }
            }
            Assert.assertEquals((long)4L, (long)actual.size());
            Assert.assertTrue((boolean)actual.containsAll(expected));
            int numPools = 100;
            int numFiles = 1000;
            DummyInputFormat1 inFormat1 = new DummyInputFormat1();
            for (int i = 0; i < numFiles; ++i) {
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{file1});
            }
            inFormat1.setMinSplitSizeRack(1L);
            Path dirNoMatch1 = new Path(this.inDir, "/dirxx");
            Path dirNoMatch2 = new Path(this.inDir, "/diryy");
            for (int i = 0; i < numPools; ++i) {
                inFormat1.createPool(new PathFilter[]{new TestFilter(dirNoMatch1), new TestFilter(dirNoMatch2)});
            }
            long start = System.currentTimeMillis();
            splits = inFormat1.getSplits((JobContext)job);
            long end = System.currentTimeMillis();
            System.out.println("Elapsed time for " + numPools + " pools  and " + numFiles + " files is " + (end - start) + " milli seconds.");
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    @Test
    public void testMissingBlocks() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.hdfs.impl", MissingBlockFileSystem.class.getName());
        conf.setBoolean("dfs.replication.considerLoad", false);
        try (MiniDFSCluster dfs = new MiniDFSCluster.Builder(conf).racks(rack1).hosts(hosts1).build();){
            dfs.waitActive();
            FileSystem fileSys = MissingBlockFileSystem.newInstance((URI)dfs.getURI(), (Configuration)conf);
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1");
            TestCombineFileInputFormat.writeFile(conf, file1, (short)1, 1);
            Path file5 = new Path(this.dir5 + "/file5");
            TestCombineFileInputFormat.writeFile(conf, file5, (short)1, 1);
            ((MissingBlockFileSystem)fileSys).setFileWithMissingBlocks(file1.toUri().getPath());
            DummyInputFormat inFormat = new DummyInputFormat();
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir5));
            List splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test0): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            Assertions.assertThat((int)splits.size()).isEqualTo(1);
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)2L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((long)1L, (long)fileSplit.getLocations().length);
            Assert.assertEquals((Object)file1.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            Assert.assertEquals((Object)file5.getName(), (Object)fileSplit.getPath(1).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            Assert.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            Assert.assertEquals((Object)hosts1[0], (Object)fileSplit.getLocations()[0]);
        }
    }

    @Test
    public void testForEmptyFile() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        Path file = new Path("test/file");
        FSDataOutputStream out = fileSys.create(file, true, conf.getInt("io.file.buffer.size", 4096), (short)1, 1024L);
        out.write(new byte[0]);
        out.close();
        DummyInputFormat inFormat = new DummyInputFormat();
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (String)"test");
        List splits = inFormat.getSplits((JobContext)job);
        Assert.assertEquals((long)1L, (long)splits.size());
        CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
        Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
        Assert.assertEquals((Object)file.getName(), (Object)fileSplit.getPath(0).getName());
        Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
        Assert.assertEquals((long)0L, (long)fileSplit.getLength(0));
        fileSys.delete(file.getParent(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSplitsWithDirectory() throws Exception {
        MiniDFSCluster dfs = null;
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster.Builder(conf).racks(rack1).hosts(hosts1).build();
            dfs.waitActive();
            DistributedFileSystem fileSys = dfs.getFileSystem();
            Path dir1 = new Path("/dir1");
            Path file = new Path("/dir1/file1");
            Path dir2 = new Path("/dir1/dir2");
            if (!fileSys.mkdirs(dir1)) {
                throw new IOException("Mkdirs failed to create " + dir1.toString());
            }
            FSDataOutputStream out = fileSys.create(file);
            out.write(new byte[0]);
            out.close();
            if (!fileSys.mkdirs(dir2)) {
                throw new IOException("Mkdirs failed to create " + dir2.toString());
            }
            DummyInputFormat inFormat = new DummyInputFormat();
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)"/dir1");
            List splits = inFormat.getSplits((JobContext)job);
            Assert.assertEquals((long)1L, (long)splits.size());
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            Assert.assertEquals((long)1L, (long)fileSplit.getNumPaths());
            Assert.assertEquals((Object)file.getName(), (Object)fileSplit.getPath(0).getName());
            Assert.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            Assert.assertEquals((long)0L, (long)fileSplit.getLength(0));
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    @Test
    public void testForNonDefaultFileSystem() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", DUMMY_FS_URI);
        Assert.assertEquals((Object)DUMMY_FS_URI, (Object)FileSystem.getDefaultUri((Configuration)conf).toString());
        String localPathRoot = System.getProperty("test.build.data", "build/test/data");
        Path localPath = new Path(localPathRoot, "testFile1");
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        FSDataOutputStream dos = lfs.create(localPath);
        dos.writeChars("Local file for CFIF");
        dos.close();
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{lfs.makeQualified(localPath)});
        DummyInputFormat inFormat = new DummyInputFormat();
        List splits = inFormat.getSplits((JobContext)job);
        Assert.assertTrue((splits.size() > 0 ? 1 : 0) != 0);
        for (InputSplit s : splits) {
            CombineFileSplit cfs = (CombineFileSplit)s;
            for (Path p : cfs.getPaths()) {
                Assertions.assertThat((String)p.toUri().getScheme()).isEqualTo((Object)"file");
            }
        }
    }

    private void splitRealFiles(String[] args) throws IOException {
        Configuration conf = new Configuration();
        Job job = Job.getInstance();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IOException("Wrong file system: " + fs.getClass().getName());
        }
        long blockSize = fs.getDefaultBlockSize();
        DummyInputFormat inFormat = new DummyInputFormat();
        for (int i = 0; i < args.length; ++i) {
            FileInputFormat.addInputPaths((Job)job, (String)args[i]);
        }
        inFormat.setMinSplitSizeRack(blockSize);
        inFormat.setMaxSplitSize(10L * blockSize);
        List splits = inFormat.getSplits((JobContext)job);
        System.out.println("Total number of splits " + splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(i);
            System.out.println("Split[" + i + "] " + fileSplit);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.splitRealFiles(args);
        } else {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.testSplitPlacement();
        }
    }

    static class TestFilter
    implements PathFilter {
        private Path p;

        public TestFilter(Path p) {
            this.p = p;
        }

        public boolean accept(Path path) {
            return path.toUri().getPath().indexOf(this.p.toString()) == 0;
        }

        public String toString() {
            return "PathFilter:" + this.p;
        }
    }

    private final class Split {
        private String name;
        private long length;
        private long offset;

        public Split(String name, long length, long offset) {
            this.name = name;
            this.length = length;
            this.offset = offset;
        }

        public String getName() {
            return this.name;
        }

        public long getLength() {
            return this.length;
        }

        public long getOffset() {
            return this.offset;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Split) {
                Split split = (Split)obj;
                return split.name.equals(this.name) && split.length == this.length && split.offset == this.offset;
            }
            return false;
        }
    }

    private class ChildRRInputFormat
    extends CombineFileInputFormat<Text, Text> {
        private ChildRRInputFormat() {
        }

        public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return new CombineFileRecordReader((CombineFileSplit)split, context, DummyRecordReader.class);
        }
    }

    private static class DummyRecordReader
    extends RecordReader<Text, Text> {
        private TaskAttemptContext context;
        private CombineFileSplit s;
        private int idx;
        private boolean used;

        public DummyRecordReader(CombineFileSplit split, TaskAttemptContext context, Integer i) {
            this.context = context;
            this.idx = i;
            this.s = split;
            this.used = true;
        }

        public String getDummyConfVal() {
            return this.context.getConfiguration().get(TestCombineFileInputFormat.DUMMY_KEY);
        }

        public void initialize(InputSplit split, TaskAttemptContext context) {
            this.context = context;
            this.s = (CombineFileSplit)split;
            this.used = false;
        }

        public boolean nextKeyValue() {
            boolean ret = !this.used;
            this.used = true;
            return ret;
        }

        public Text getCurrentKey() {
            return new Text(this.context.getConfiguration().get(TestCombineFileInputFormat.DUMMY_KEY));
        }

        public Text getCurrentValue() {
            return new Text(this.s.getPath(this.idx).toString());
        }

        public float getProgress() {
            return this.used ? 1.0f : 0.0f;
        }

        public void close() {
        }
    }

    public static class MissingBlockFileSystem
    extends DistributedFileSystem {
        String fileWithMissingBlocks;

        public void initialize(URI name, Configuration conf) throws IOException {
            this.fileWithMissingBlocks = "";
            super.initialize(name, conf);
        }

        public BlockLocation[] getFileBlockLocations(FileStatus stat, long start, long len) throws IOException {
            if (stat.isDirectory()) {
                return null;
            }
            System.out.println("File " + stat.getPath());
            String name = stat.getPath().toUri().getPath();
            BlockLocation[] locs = super.getFileBlockLocations(stat, start, len);
            if (name.equals(this.fileWithMissingBlocks)) {
                System.out.println("Returning missing blocks for " + this.fileWithMissingBlocks);
                locs[0] = new HdfsBlockLocation(new BlockLocation(new String[0], new String[0], locs[0].getOffset(), locs[0].getLength()), null);
            }
            return locs;
        }

        public void setFileWithMissingBlocks(String f) {
            this.fileWithMissingBlocks = f;
        }
    }

    private class DummyInputFormat1
    extends DummyInputFormat {
        private DummyInputFormat1() {
        }

        protected List<FileStatus> listStatus(JobContext job) throws IOException {
            Path[] files = DummyInputFormat1.getInputPaths((JobContext)job);
            ArrayList<FileStatus> results = new ArrayList<FileStatus>();
            for (int i = 0; i < files.length; ++i) {
                Path p = files[i];
                FileSystem fs = p.getFileSystem(job.getConfiguration());
                results.add(fs.getFileStatus(p));
            }
            return results;
        }
    }

    private class DummyInputFormat
    extends CombineFileInputFormat<Text, Text> {
        private DummyInputFormat() {
        }

        public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return null;
        }
    }
}

