/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClientCache;
import org.apache.hadoop.mapred.ClientServiceDelegate;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.mapred.YARNRunner;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestYARNRunner {
    private static final Logger LOG = LoggerFactory.getLogger(TestYARNRunner.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static final String PROFILE_PARAMS = "-agentlib:hprof=cpu=samples,heap=sites,force=n,thread=y,verbose=n,file=%s".substring(0, "-agentlib:hprof=cpu=samples,heap=sites,force=n,thread=y,verbose=n,file=%s".lastIndexOf("%"));
    private static final String CUSTOM_RESOURCE_NAME = "a-custom-resource";
    private YARNRunner yarnRunner;
    private ResourceMgrDelegate resourceMgrDelegate;
    private YarnConfiguration conf;
    private ClientCache clientCache;
    private ApplicationId appId;
    private JobID jobId;
    private File testWorkDir = new File("target", TestYARNRunner.class.getName());
    private ApplicationSubmissionContext submissionContext;
    private ClientServiceDelegate clientDelegate;
    private static final String failString = "Rejected job";

    @BeforeClass
    public static void setupBeforeClass() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
    }

    @Before
    public void setUp() throws Exception {
        this.resourceMgrDelegate = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.resourcemanager.principal", "mapred/host@REALM");
        this.clientCache = new ClientCache((Configuration)this.conf, this.resourceMgrDelegate);
        this.clientCache = (ClientCache)Mockito.spy((Object)this.clientCache);
        this.yarnRunner = new YARNRunner((Configuration)this.conf, this.resourceMgrDelegate, this.clientCache);
        this.yarnRunner = (YARNRunner)Mockito.spy((Object)this.yarnRunner);
        this.submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        ((YARNRunner)Mockito.doAnswer((Answer)new Answer<ApplicationSubmissionContext>(){

            public ApplicationSubmissionContext answer(InvocationOnMock invocation) throws Throwable {
                return TestYARNRunner.this.submissionContext;
            }
        }).when((Object)this.yarnRunner)).createApplicationSubmissionContext((Configuration)ArgumentMatchers.any(Configuration.class), (String)ArgumentMatchers.any(String.class), (Credentials)ArgumentMatchers.any(Credentials.class));
        this.appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        this.jobId = TypeConverter.fromYarn((ApplicationId)this.appId);
        if (this.testWorkDir.exists()) {
            FileContext.getLocalFSFileContext().delete(new Path(this.testWorkDir.toString()), true);
        }
        this.testWorkDir.mkdirs();
    }

    @After
    public void cleanup() {
        FileUtil.fullyDelete((File)this.testWorkDir);
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
    }

    @Test(timeout=20000L)
    public void testJobKill() throws Exception {
        this.clientDelegate = (ClientServiceDelegate)Mockito.mock(ClientServiceDelegate.class);
        Mockito.when((Object)this.clientDelegate.getJobStatus((JobID)ArgumentMatchers.any(JobID.class))).thenReturn((Object)new JobStatus(this.jobId, 0.0f, 0.0f, 0.0f, 0.0f, JobStatus.State.PREP, JobPriority.HIGH, "tmp", "tmp", "tmp", "tmp"));
        Mockito.when((Object)this.clientDelegate.killJob((JobID)ArgumentMatchers.any(JobID.class))).thenReturn((Object)true);
        ((ClientCache)Mockito.doAnswer((Answer)new Answer<ClientServiceDelegate>(){

            public ClientServiceDelegate answer(InvocationOnMock invocation) throws Throwable {
                return TestYARNRunner.this.clientDelegate;
            }
        }).when((Object)this.clientCache)).getClient((JobID)ArgumentMatchers.any(JobID.class));
        this.yarnRunner.killJob(this.jobId);
        ((ResourceMgrDelegate)Mockito.verify((Object)this.resourceMgrDelegate)).killApplication(this.appId);
        Mockito.when((Object)this.clientDelegate.getJobStatus((JobID)ArgumentMatchers.any(JobID.class))).thenReturn((Object)new JobStatus(this.jobId, 0.0f, 0.0f, 0.0f, 0.0f, JobStatus.State.RUNNING, JobPriority.HIGH, "tmp", "tmp", "tmp", "tmp"));
        this.yarnRunner.killJob(this.jobId);
        ((ClientServiceDelegate)Mockito.verify((Object)this.clientDelegate)).killJob(this.jobId);
        Mockito.when((Object)this.clientDelegate.getJobStatus((JobID)ArgumentMatchers.any(JobID.class))).thenReturn(null);
        Mockito.when((Object)this.resourceMgrDelegate.getApplicationReport((ApplicationId)ArgumentMatchers.any(ApplicationId.class))).thenReturn((Object)ApplicationReport.newInstance((ApplicationId)this.appId, null, (String)"tmp", (String)"tmp", (String)"tmp", (String)"tmp", (int)0, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"tmp", (String)"tmp", (long)0L, (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, null, (float)0.0f, (String)"tmp", null));
        this.yarnRunner.killJob(this.jobId);
        ((ClientServiceDelegate)Mockito.verify((Object)this.clientDelegate)).killJob(this.jobId);
    }

    @Test(timeout=60000L)
    public void testJobKillTimeout() throws Exception {
        long timeToWaitBeforeHardKill = 20000L;
        this.conf.setLong("yarn.app.mapreduce.am.hard-kill-timeout-ms", timeToWaitBeforeHardKill);
        this.clientDelegate = (ClientServiceDelegate)Mockito.mock(ClientServiceDelegate.class);
        ((ClientCache)Mockito.doAnswer((Answer)new Answer<ClientServiceDelegate>(){

            public ClientServiceDelegate answer(InvocationOnMock invocation) throws Throwable {
                return TestYARNRunner.this.clientDelegate;
            }
        }).when((Object)this.clientCache)).getClient((JobID)ArgumentMatchers.any(JobID.class));
        Mockito.when((Object)this.clientDelegate.getJobStatus((JobID)ArgumentMatchers.any(JobID.class))).thenReturn((Object)new JobStatus(this.jobId, 0.0f, 0.0f, 0.0f, 0.0f, JobStatus.State.RUNNING, JobPriority.HIGH, "tmp", "tmp", "tmp", "tmp"));
        long startTimeMillis = System.currentTimeMillis();
        this.yarnRunner.killJob(this.jobId);
        Assert.assertTrue((String)("killJob should have waited at least " + timeToWaitBeforeHardKill + " ms."), (System.currentTimeMillis() - startTimeMillis >= timeToWaitBeforeHardKill ? 1 : 0) != 0);
    }

    @Test(timeout=20000L)
    public void testJobSubmissionFailure() throws Exception {
        Mockito.when((Object)this.resourceMgrDelegate.submitApplication((ApplicationSubmissionContext)ArgumentMatchers.any(ApplicationSubmissionContext.class))).thenReturn((Object)this.appId);
        ApplicationReport report = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        Mockito.when((Object)report.getApplicationId()).thenReturn((Object)this.appId);
        Mockito.when((Object)report.getDiagnostics()).thenReturn((Object)failString);
        Mockito.when((Object)report.getYarnApplicationState()).thenReturn((Object)YarnApplicationState.FAILED);
        Mockito.when((Object)this.resourceMgrDelegate.getApplicationReport(this.appId)).thenReturn((Object)report);
        Credentials credentials = new Credentials();
        File jobxml = new File(this.testWorkDir, "job.xml");
        FileOutputStream out = new FileOutputStream(jobxml);
        this.conf.writeXml((OutputStream)out);
        ((OutputStream)out).close();
        try {
            this.yarnRunner.submitJob(this.jobId, this.testWorkDir.getAbsolutePath().toString(), credentials);
        }
        catch (IOException io) {
            LOG.info("Logging exception:", (Throwable)io);
            Assert.assertTrue((boolean)io.getLocalizedMessage().contains(failString));
        }
    }

    @Test(timeout=20000L)
    public void testResourceMgrDelegate() throws Exception {
        final ApplicationClientProtocol clientRMProtocol = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
        ResourceMgrDelegate delegate = new ResourceMgrDelegate(this.conf){

            protected void serviceStart() throws Exception {
                Assert.assertTrue((boolean)(this.client instanceof YarnClientImpl));
                ((YarnClientImpl)this.client).setRMClient(clientRMProtocol);
            }
        };
        Mockito.when((Object)clientRMProtocol.forceKillApplication((KillApplicationRequest)ArgumentMatchers.any(KillApplicationRequest.class))).thenReturn((Object)KillApplicationResponse.newInstance((boolean)true));
        delegate.killApplication(this.appId);
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).forceKillApplication((KillApplicationRequest)ArgumentMatchers.any(KillApplicationRequest.class));
        Mockito.when((Object)clientRMProtocol.getApplications((GetApplicationsRequest)ArgumentMatchers.any(GetApplicationsRequest.class))).thenReturn((Object)((GetApplicationsResponse)recordFactory.newRecordInstance(GetApplicationsResponse.class)));
        delegate.getAllJobs();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getApplications((GetApplicationsRequest)ArgumentMatchers.any(GetApplicationsRequest.class));
        Mockito.when((Object)clientRMProtocol.getApplicationReport((GetApplicationReportRequest)ArgumentMatchers.any(GetApplicationReportRequest.class))).thenReturn((Object)((GetApplicationReportResponse)recordFactory.newRecordInstance(GetApplicationReportResponse.class)));
        delegate.getApplicationReport(this.appId);
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getApplicationReport((GetApplicationReportRequest)ArgumentMatchers.any(GetApplicationReportRequest.class));
        GetClusterMetricsResponse clusterMetricsResponse = (GetClusterMetricsResponse)recordFactory.newRecordInstance(GetClusterMetricsResponse.class);
        clusterMetricsResponse.setClusterMetrics((YarnClusterMetrics)recordFactory.newRecordInstance(YarnClusterMetrics.class));
        Mockito.when((Object)clientRMProtocol.getClusterMetrics((GetClusterMetricsRequest)ArgumentMatchers.any(GetClusterMetricsRequest.class))).thenReturn((Object)clusterMetricsResponse);
        delegate.getClusterMetrics();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getClusterMetrics((GetClusterMetricsRequest)ArgumentMatchers.any(GetClusterMetricsRequest.class));
        Mockito.when((Object)clientRMProtocol.getClusterNodes((GetClusterNodesRequest)ArgumentMatchers.any(GetClusterNodesRequest.class))).thenReturn((Object)((GetClusterNodesResponse)recordFactory.newRecordInstance(GetClusterNodesResponse.class)));
        delegate.getActiveTrackers();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getClusterNodes((GetClusterNodesRequest)ArgumentMatchers.any(GetClusterNodesRequest.class));
        GetNewApplicationResponse newAppResponse = (GetNewApplicationResponse)recordFactory.newRecordInstance(GetNewApplicationResponse.class);
        newAppResponse.setApplicationId(this.appId);
        Mockito.when((Object)clientRMProtocol.getNewApplication((GetNewApplicationRequest)ArgumentMatchers.any(GetNewApplicationRequest.class))).thenReturn((Object)newAppResponse);
        delegate.getNewJobID();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getNewApplication((GetNewApplicationRequest)ArgumentMatchers.any(GetNewApplicationRequest.class));
        GetQueueInfoResponse queueInfoResponse = (GetQueueInfoResponse)recordFactory.newRecordInstance(GetQueueInfoResponse.class);
        queueInfoResponse.setQueueInfo((QueueInfo)recordFactory.newRecordInstance(QueueInfo.class));
        Mockito.when((Object)clientRMProtocol.getQueueInfo((GetQueueInfoRequest)ArgumentMatchers.any(GetQueueInfoRequest.class))).thenReturn((Object)queueInfoResponse);
        delegate.getQueues();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getQueueInfo((GetQueueInfoRequest)ArgumentMatchers.any(GetQueueInfoRequest.class));
        GetQueueUserAclsInfoResponse aclResponse = (GetQueueUserAclsInfoResponse)recordFactory.newRecordInstance(GetQueueUserAclsInfoResponse.class);
        Mockito.when((Object)clientRMProtocol.getQueueUserAcls((GetQueueUserAclsInfoRequest)ArgumentMatchers.any(GetQueueUserAclsInfoRequest.class))).thenReturn((Object)aclResponse);
        delegate.getQueueAclsForCurrentUser();
        ((ApplicationClientProtocol)Mockito.verify((Object)clientRMProtocol)).getQueueUserAcls((GetQueueUserAclsInfoRequest)ArgumentMatchers.any(GetQueueUserAclsInfoRequest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testGetHSDelegationToken() throws Exception {
        try {
            Configuration conf = new Configuration();
            InetSocketAddress mockRmAddress = new InetSocketAddress("localhost", 4444);
            Text rmTokenSevice = SecurityUtil.buildTokenService((InetSocketAddress)mockRmAddress);
            InetSocketAddress mockHsAddress = new InetSocketAddress("localhost", 9200);
            Text hsTokenSevice = SecurityUtil.buildTokenService((InetSocketAddress)mockHsAddress);
            RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(new Text("owner"), new Text("renewer"), new Text("real"));
            Token token = new Token(new byte[0], new byte[0], tokenIdentifier.getKind(), rmTokenSevice);
            token.setKind(RMDelegationTokenIdentifier.KIND_NAME);
            org.apache.hadoop.yarn.api.records.Token historyToken = org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])new byte[0], (String)MRDelegationTokenIdentifier.KIND_NAME.toString(), (byte[])new byte[0], (String)hsTokenSevice.toString());
            GetDelegationTokenResponse getDtResponse = (GetDelegationTokenResponse)Records.newRecord(GetDelegationTokenResponse.class);
            getDtResponse.setDelegationToken(historyToken);
            MRClientProtocol mockHsProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
            ((MRClientProtocol)Mockito.doReturn((Object)mockHsAddress).when((Object)mockHsProxy)).getConnectAddress();
            ((MRClientProtocol)Mockito.doReturn((Object)getDtResponse).when((Object)mockHsProxy)).getDelegationToken((GetDelegationTokenRequest)ArgumentMatchers.any(GetDelegationTokenRequest.class));
            ResourceMgrDelegate rmDelegate = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
            ((ResourceMgrDelegate)Mockito.doReturn((Object)rmTokenSevice).when((Object)rmDelegate)).getRMDelegationTokenService();
            ClientCache clientCache = (ClientCache)Mockito.mock(ClientCache.class);
            ((ClientCache)Mockito.doReturn((Object)mockHsProxy).when((Object)clientCache)).getInitializedHSProxy();
            Credentials creds = new Credentials();
            YARNRunner yarnRunner = new YARNRunner(conf, rmDelegate, clientCache);
            yarnRunner.addHistoryToken(creds);
            ((MRClientProtocol)Mockito.verify((Object)mockHsProxy, (VerificationMode)Mockito.times((int)0))).getDelegationToken((GetDelegationTokenRequest)ArgumentMatchers.any(GetDelegationTokenRequest.class));
            creds.addToken(new Text("rmdt"), token);
            yarnRunner.addHistoryToken(creds);
            ((MRClientProtocol)Mockito.verify((Object)mockHsProxy, (VerificationMode)Mockito.times((int)0))).getDelegationToken((GetDelegationTokenRequest)ArgumentMatchers.any(GetDelegationTokenRequest.class));
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            creds = new Credentials();
            yarnRunner.addHistoryToken(creds);
            ((MRClientProtocol)Mockito.verify((Object)mockHsProxy, (VerificationMode)Mockito.times((int)0))).getDelegationToken((GetDelegationTokenRequest)ArgumentMatchers.any(GetDelegationTokenRequest.class));
            creds.addToken(new Text("rmdt"), token);
            yarnRunner.addHistoryToken(creds);
            ((MRClientProtocol)Mockito.verify((Object)mockHsProxy, (VerificationMode)Mockito.times((int)1))).getDelegationToken((GetDelegationTokenRequest)ArgumentMatchers.any(GetDelegationTokenRequest.class));
            yarnRunner.addHistoryToken(creds);
            ((MRClientProtocol)Mockito.verify((Object)mockHsProxy, (VerificationMode)Mockito.times((int)1))).getDelegationToken((GetDelegationTokenRequest)ArgumentMatchers.any(GetDelegationTokenRequest.class));
        }
        finally {
            UserGroupInformation.setConfiguration((Configuration)new Configuration());
        }
    }

    @Test(timeout=20000L)
    public void testHistoryServerToken() throws Exception {
        this.conf.set("yarn.resourcemanager.principal", "foo@LOCAL");
        final String masterPrincipal = Master.getMasterPrincipal((Configuration)this.conf);
        final MRClientProtocol hsProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)hsProxy.getDelegationToken((GetDelegationTokenRequest)ArgumentMatchers.any(GetDelegationTokenRequest.class))).thenAnswer((Answer)new Answer<GetDelegationTokenResponse>(){

            public GetDelegationTokenResponse answer(InvocationOnMock invocation) {
                GetDelegationTokenRequest request = (GetDelegationTokenRequest)invocation.getArguments()[0];
                Assert.assertEquals((Object)masterPrincipal, (Object)request.getRenewer());
                org.apache.hadoop.yarn.api.records.Token token = (org.apache.hadoop.yarn.api.records.Token)recordFactory.newRecordInstance(org.apache.hadoop.yarn.api.records.Token.class);
                token.setKind("");
                token.setService("");
                token.setIdentifier(ByteBuffer.allocate(0));
                token.setPassword(ByteBuffer.allocate(0));
                GetDelegationTokenResponse tokenResponse = (GetDelegationTokenResponse)recordFactory.newRecordInstance(GetDelegationTokenResponse.class);
                tokenResponse.setDelegationToken(token);
                return tokenResponse;
            }
        });
        UserGroupInformation.createRemoteUser((String)"someone").doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestYARNRunner.this.yarnRunner = new YARNRunner((Configuration)TestYARNRunner.this.conf, null, null);
                TestYARNRunner.this.yarnRunner.getDelegationTokenFromHS(hsProxy);
                ((MRClientProtocol)Mockito.verify((Object)hsProxy)).getDelegationToken((GetDelegationTokenRequest)ArgumentMatchers.any(GetDelegationTokenRequest.class));
                return null;
            }
        });
    }

    @Test(timeout=20000L)
    public void testAMAdminCommandOpts() throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.set("yarn.app.mapreduce.am.admin-command-opts", "-Djava.net.preferIPv4Stack=true");
        jobConf.set("yarn.app.mapreduce.am.command-opts", "-Xmx1024m");
        YARNRunner yarnRunner = new YARNRunner((Configuration)jobConf);
        ApplicationSubmissionContext submissionContext = this.buildSubmitContext(yarnRunner, jobConf);
        ContainerLaunchContext containerSpec = submissionContext.getAMContainerSpec();
        List commands = containerSpec.getCommands();
        int index = 0;
        int adminIndex = 0;
        int adminPos = -1;
        int userIndex = 0;
        int userPos = -1;
        int tmpDirPos = -1;
        for (String command : commands) {
            if (command != null) {
                Assert.assertFalse((String)"Profiler should be disabled by default", (boolean)command.contains(PROFILE_PARAMS));
                adminPos = command.indexOf("-Djava.net.preferIPv4Stack=true");
                if (adminPos >= 0) {
                    adminIndex = index;
                }
                if ((userPos = command.indexOf("-Xmx1024m")) >= 0) {
                    userIndex = index;
                }
                tmpDirPos = command.indexOf("-Djava.io.tmpdir=");
            }
            ++index;
        }
        Assert.assertTrue((String)"java.io.tmpdir is not set for AM", (tmpDirPos > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"AM admin command opts not in the commands.", (adminPos > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"AM user command opts not in the commands.", (userPos > 0 ? 1 : 0) != 0);
        if (adminIndex == userIndex) {
            Assert.assertTrue((String)"AM admin command opts is after user command opts.", (adminPos < userPos ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"AM admin command opts is after user command opts.", (adminIndex < userIndex ? 1 : 0) != 0);
        }
    }

    @Test(timeout=20000L)
    public void testWarnCommandOpts() throws Exception {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(YARNRunner.class);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        SimpleLayout layout = new SimpleLayout();
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)bout);
        logger.addAppender((Appender)appender);
        JobConf jobConf = new JobConf();
        jobConf.set("yarn.app.mapreduce.am.admin-command-opts", "-Djava.net.preferIPv4Stack=true -Djava.library.path=foo");
        jobConf.set("yarn.app.mapreduce.am.command-opts", "-Xmx1024m -Djava.library.path=bar");
        YARNRunner yarnRunner = new YARNRunner((Configuration)jobConf);
        ApplicationSubmissionContext submissionContext = this.buildSubmitContext(yarnRunner, jobConf);
        String logMsg = bout.toString();
        Assert.assertTrue((boolean)logMsg.contains("WARN - Usage of -Djava.library.path in yarn.app.mapreduce.am.admin-command-opts can cause programs to no longer function if hadoop native libraries are used. These values should be set as part of the LD_LIBRARY_PATH in the app master JVM env using yarn.app.mapreduce.am.admin.user.env config settings."));
        Assert.assertTrue((boolean)logMsg.contains("WARN - Usage of -Djava.library.path in yarn.app.mapreduce.am.command-opts can cause programs to no longer function if hadoop native libraries are used. These values should be set as part of the LD_LIBRARY_PATH in the app master JVM env using yarn.app.mapreduce.am.env config settings."));
    }

    @Test(timeout=20000L)
    public void testAMProfiler() throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.setBoolean("yarn.app.mapreduce.am.profile", true);
        YARNRunner yarnRunner = new YARNRunner((Configuration)jobConf);
        ApplicationSubmissionContext submissionContext = this.buildSubmitContext(yarnRunner, jobConf);
        ContainerLaunchContext containerSpec = submissionContext.getAMContainerSpec();
        List commands = containerSpec.getCommands();
        for (String command : commands) {
            if (command == null || !command.contains(PROFILE_PARAMS)) continue;
            return;
        }
        throw new IllegalStateException("Profiler opts not found!");
    }

    @Test
    public void testNodeLabelExp() throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.set("mapreduce.job.node-label-expression", "GPU");
        jobConf.set("mapreduce.job.am.node-label-expression", "highMem");
        YARNRunner yarnRunner = new YARNRunner((Configuration)jobConf);
        ApplicationSubmissionContext appSubCtx = this.buildSubmitContext(yarnRunner, jobConf);
        Assertions.assertThat((String)appSubCtx.getNodeLabelExpression()).isEqualTo((Object)"GPU");
        Assertions.assertThat((String)((ResourceRequest)appSubCtx.getAMContainerResourceRequests().get(0)).getNodeLabelExpression()).isEqualTo((Object)"highMem");
    }

    @Test
    public void testResourceRequestLocalityAny() throws Exception {
        ResourceRequest amAnyResourceRequest = this.createResourceRequest("*", true);
        this.verifyResourceRequestLocality(null, null, amAnyResourceRequest);
        this.verifyResourceRequestLocality(null, "label1", amAnyResourceRequest);
    }

    @Test
    public void testResourceRequestLocalityRack() throws Exception {
        ResourceRequest amAnyResourceRequest = this.createResourceRequest("*", false);
        ResourceRequest amRackResourceRequest = this.createResourceRequest("/rack1", true);
        this.verifyResourceRequestLocality("/rack1", null, amAnyResourceRequest, amRackResourceRequest);
        this.verifyResourceRequestLocality("/rack1", "label1", amAnyResourceRequest, amRackResourceRequest);
    }

    @Test
    public void testResourceRequestLocalityNode() throws Exception {
        ResourceRequest amAnyResourceRequest = this.createResourceRequest("*", false);
        ResourceRequest amRackResourceRequest = this.createResourceRequest("/rack1", false);
        ResourceRequest amNodeResourceRequest = this.createResourceRequest("node1", true);
        this.verifyResourceRequestLocality("/rack1/node1", null, amAnyResourceRequest, amRackResourceRequest, amNodeResourceRequest);
        this.verifyResourceRequestLocality("/rack1/node1", "label1", amAnyResourceRequest, amRackResourceRequest, amNodeResourceRequest);
    }

    @Test
    public void testResourceRequestLocalityNodeDefaultRack() throws Exception {
        ResourceRequest amAnyResourceRequest = this.createResourceRequest("*", false);
        ResourceRequest amRackResourceRequest = this.createResourceRequest("/default-rack", false);
        ResourceRequest amNodeResourceRequest = this.createResourceRequest("node1", true);
        this.verifyResourceRequestLocality("node1", null, amAnyResourceRequest, amRackResourceRequest, amNodeResourceRequest);
        this.verifyResourceRequestLocality("node1", "label1", amAnyResourceRequest, amRackResourceRequest, amNodeResourceRequest);
    }

    @Test
    public void testResourceRequestLocalityMultipleNodes() throws Exception {
        ResourceRequest amAnyResourceRequest = this.createResourceRequest("*", false);
        ResourceRequest amRackResourceRequest = this.createResourceRequest("/rack1", false);
        ResourceRequest amNodeResourceRequest = this.createResourceRequest("node1", true);
        ResourceRequest amNode2ResourceRequest = this.createResourceRequest("node2", true);
        this.verifyResourceRequestLocality("/rack1/node1,/rack1/node2", null, amAnyResourceRequest, amRackResourceRequest, amNodeResourceRequest, amNode2ResourceRequest);
        this.verifyResourceRequestLocality("/rack1/node1,/rack1/node2", "label1", amAnyResourceRequest, amRackResourceRequest, amNodeResourceRequest, amNode2ResourceRequest);
    }

    @Test
    public void testResourceRequestLocalityMultipleNodesDifferentRack() throws Exception {
        ResourceRequest amAnyResourceRequest = this.createResourceRequest("*", false);
        ResourceRequest amRackResourceRequest = this.createResourceRequest("/rack1", false);
        ResourceRequest amNodeResourceRequest = this.createResourceRequest("node1", true);
        ResourceRequest amRack2ResourceRequest = this.createResourceRequest("/rack2", false);
        ResourceRequest amNode2ResourceRequest = this.createResourceRequest("node2", true);
        this.verifyResourceRequestLocality("/rack1/node1,/rack2/node2", null, amAnyResourceRequest, amRackResourceRequest, amNodeResourceRequest, amRack2ResourceRequest, amNode2ResourceRequest);
        this.verifyResourceRequestLocality("/rack1/node1,/rack2/node2", "label1", amAnyResourceRequest, amRackResourceRequest, amNodeResourceRequest, amRack2ResourceRequest, amNode2ResourceRequest);
    }

    @Test
    public void testResourceRequestLocalityMultipleNodesDefaultRack() throws Exception {
        ResourceRequest amAnyResourceRequest = this.createResourceRequest("*", false);
        ResourceRequest amRackResourceRequest = this.createResourceRequest("/rack1", false);
        ResourceRequest amNodeResourceRequest = this.createResourceRequest("node1", true);
        ResourceRequest amRack2ResourceRequest = this.createResourceRequest("/default-rack", false);
        ResourceRequest amNode2ResourceRequest = this.createResourceRequest("node2", true);
        this.verifyResourceRequestLocality("/rack1/node1,node2", null, amAnyResourceRequest, amRackResourceRequest, amNodeResourceRequest, amRack2ResourceRequest, amNode2ResourceRequest);
        this.verifyResourceRequestLocality("/rack1/node1,node2", "label1", amAnyResourceRequest, amRackResourceRequest, amNodeResourceRequest, amRack2ResourceRequest, amNode2ResourceRequest);
    }

    @Test
    public void testResourceRequestLocalityInvalid() throws Exception {
        try {
            this.verifyResourceRequestLocality("rack/node1", null, new ResourceRequest[0]);
            Assert.fail((String)"Should have failed due to invalid resource but did not");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getMessage().contains("Invalid resource name"));
        }
        try {
            this.verifyResourceRequestLocality("/rack/node1/blah", null, new ResourceRequest[0]);
            Assert.fail((String)"Should have failed due to invalid resource but did not");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getMessage().contains("Invalid resource name"));
        }
    }

    private void verifyResourceRequestLocality(String strictResource, String label, ResourceRequest ... expectedReqs) throws Exception {
        JobConf jobConf = new JobConf();
        if (strictResource != null) {
            jobConf.set("mapreduce.job.am.strict-locality", strictResource);
        }
        if (label != null) {
            jobConf.set("mapreduce.job.am.node-label-expression", label);
            for (ResourceRequest expectedReq : expectedReqs) {
                expectedReq.setNodeLabelExpression(label);
            }
        }
        YARNRunner yarnRunner = new YARNRunner((Configuration)jobConf);
        ApplicationSubmissionContext appSubCtx = this.buildSubmitContext(yarnRunner, jobConf);
        Assert.assertEquals(Arrays.asList(expectedReqs), (Object)appSubCtx.getAMContainerResourceRequests());
    }

    private ResourceRequest createResourceRequest(String name, boolean relaxLocality) {
        Resource capability = (Resource)recordFactory.newRecordInstance(Resource.class);
        capability.setMemorySize(1536L);
        capability.setVirtualCores(1);
        ResourceRequest req = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        req.setPriority(YARNRunner.AM_CONTAINER_PRIORITY);
        req.setResourceName(name);
        req.setCapability(capability);
        req.setNumContainers(1);
        req.setRelaxLocality(relaxLocality);
        return req;
    }

    @Test
    public void testAMStandardEnvWithDefaultLibPath() throws Exception {
        this.testAMStandardEnv(false, false);
    }

    @Test
    public void testAMStandardEnvWithCustomLibPath() throws Exception {
        this.testAMStandardEnv(true, false);
    }

    @Test
    public void testAMStandardEnvWithCustomLibPathWithSeparateEnvProps() throws Exception {
        this.testAMStandardEnv(true, true);
    }

    private void testAMStandardEnv(boolean customLibPath, boolean useSeparateEnvProps) throws Exception {
        PlatformAssumptions.assumeNotWindows();
        String ADMIN_LIB_PATH = "foo";
        String USER_LIB_PATH = "bar";
        String USER_SHELL = "shell";
        JobConf jobConf = new JobConf();
        String pathKey = ApplicationConstants.Environment.LD_LIBRARY_PATH.name();
        if (customLibPath) {
            if (useSeparateEnvProps) {
                jobConf.set("yarn.app.mapreduce.am.admin.user.env." + pathKey, "foo");
                jobConf.set("yarn.app.mapreduce.am.env." + pathKey, "bar");
            } else {
                jobConf.set("yarn.app.mapreduce.am.admin.user.env", pathKey + "=" + "foo");
                jobConf.set("yarn.app.mapreduce.am.env", pathKey + "=" + "bar");
            }
        }
        jobConf.set("mapreduce.admin.user.shell", "shell");
        YARNRunner yarnRunner = new YARNRunner((Configuration)jobConf);
        ApplicationSubmissionContext appSubCtx = this.buildSubmitContext(yarnRunner, jobConf);
        ContainerLaunchContext clc = appSubCtx.getAMContainerSpec();
        Map env = clc.getEnvironment();
        String libPath = (String)env.get(pathKey);
        Assert.assertNotNull((String)(pathKey + " not set"), (Object)libPath);
        String cps = jobConf.getBoolean("mapreduce.app-submission.cross-platform", false) ? "<CPS>" : File.pathSeparator;
        String expectedLibPath = MRApps.crossPlatformifyMREnv((Configuration)this.conf, (ApplicationConstants.Environment)ApplicationConstants.Environment.PWD);
        expectedLibPath = customLibPath ? expectedLibPath + cps + "foo" + cps + "bar" : expectedLibPath + cps + MRJobConfig.DEFAULT_MR_AM_ADMIN_USER_ENV.substring(pathKey.length() + 1);
        Assert.assertEquals((String)("Bad AM " + pathKey + " setting"), (Object)expectedLibPath, (Object)libPath);
        String shell = (String)env.get(ApplicationConstants.Environment.SHELL.name());
        Assert.assertNotNull((String)"SHELL not set", (Object)shell);
        Assert.assertEquals((String)"Bad SHELL setting", (Object)"shell", (Object)shell);
    }

    @Test
    public void testJobPriority() throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.set("mapreduce.job.priority", "LOW");
        YARNRunner yarnRunner = new YARNRunner((Configuration)jobConf);
        ApplicationSubmissionContext appSubCtx = this.buildSubmitContext(yarnRunner, jobConf);
        Assert.assertEquals((Object)appSubCtx.getPriority(), (Object)Priority.newInstance((int)2));
        jobConf.set("mapreduce.job.priority", "12");
        yarnRunner = new YARNRunner((Configuration)jobConf);
        appSubCtx = this.buildSubmitContext(yarnRunner, jobConf);
        Assert.assertEquals((Object)appSubCtx.getPriority(), (Object)Priority.newInstance((int)12));
    }

    private ApplicationSubmissionContext buildSubmitContext(YARNRunner yarnRunner, JobConf jobConf) throws IOException {
        File jobxml = new File(this.testWorkDir, "job.xml");
        FileOutputStream out = new FileOutputStream(jobxml);
        this.conf.writeXml((OutputStream)out);
        ((OutputStream)out).close();
        File jobsplit = new File(this.testWorkDir, "job.split");
        out = new FileOutputStream(jobsplit);
        ((OutputStream)out).close();
        File jobsplitmetainfo = new File(this.testWorkDir, "job.splitmetainfo");
        out = new FileOutputStream(jobsplitmetainfo);
        ((OutputStream)out).close();
        return yarnRunner.createApplicationSubmissionContext((Configuration)jobConf, this.testWorkDir.toString(), new Credentials());
    }

    @Test
    public void testSendJobConf() throws IOException {
        JobConf jobConf = new JobConf();
        jobConf.set("dfs.nameservices", "mycluster1,mycluster2");
        jobConf.set("dfs.namenode.rpc-address.mycluster2.nn1", "123.0.0.1");
        jobConf.set("dfs.namenode.rpc-address.mycluster2.nn2", "123.0.0.2");
        jobConf.set("dfs.ha.namenodes.mycluster2", "nn1,nn2");
        jobConf.set("dfs.client.failover.proxy.provider.mycluster2", "provider");
        jobConf.set("hadoop.tmp.dir", "testconfdir");
        jobConf.set("hadoop.security.authentication", "kerberos");
        jobConf.set("mapreduce.job.send-token-conf", "dfs.nameservices|^dfs.namenode.rpc-address.*$|^dfs.ha.namenodes.*$|^dfs.client.failover.proxy.provider.*$|dfs.namenode.kerberos.principal");
        UserGroupInformation.setConfiguration((Configuration)jobConf);
        YARNRunner yarnRunner = new YARNRunner((Configuration)jobConf);
        ApplicationSubmissionContext submissionContext = this.buildSubmitContext(yarnRunner, jobConf);
        Configuration confSent = BuilderUtils.parseTokensConf((ApplicationSubmissionContext)submissionContext);
        Assert.assertEquals((Object)"123.0.0.1", (Object)confSent.get("dfs.namenode.rpc-address.mycluster2.nn1"));
        Assert.assertEquals((Object)"123.0.0.2", (Object)confSent.get("dfs.namenode.rpc-address.mycluster2.nn2"));
        Assert.assertTrue((confSent.get("hadoop.tmp.dir") == null || !confSent.get("hadoop.tmp.dir").equals("testconfdir") ? 1 : 0) != 0);
        UserGroupInformation.reset();
    }

    @Test
    public void testCustomAMRMResourceType() throws Exception {
        this.initResourceTypes();
        JobConf jobConf = new JobConf();
        jobConf.setInt("yarn.app.mapreduce.am.resource.a-custom-resource", 5);
        jobConf.setInt("yarn.app.mapreduce.am.resource.cpu-vcores", 3);
        this.yarnRunner = new YARNRunner((Configuration)jobConf);
        this.submissionContext = this.buildSubmitContext(this.yarnRunner, jobConf);
        List resourceRequests = this.submissionContext.getAMContainerResourceRequests();
        Assert.assertEquals((long)1L, (long)resourceRequests.size());
        ResourceRequest resourceRequest = (ResourceRequest)resourceRequests.get(0);
        ResourceInformation resourceInformation = resourceRequest.getCapability().getResourceInformation(CUSTOM_RESOURCE_NAME);
        Assert.assertEquals((String)"Expecting the default unit (G)", (Object)"G", (Object)resourceInformation.getUnits());
        Assert.assertEquals((long)5L, (long)resourceInformation.getValue());
        Assert.assertEquals((long)3L, (long)resourceRequest.getCapability().getVirtualCores());
    }

    @Test
    public void testAMRMemoryRequest() throws Exception {
        for (String memoryName : ImmutableList.of((Object)"memory", (Object)"memory-mb")) {
            JobConf jobConf = new JobConf();
            jobConf.set("yarn.app.mapreduce.am.resource." + memoryName, "3 Gi");
            this.yarnRunner = new YARNRunner((Configuration)jobConf);
            this.submissionContext = this.buildSubmitContext(this.yarnRunner, jobConf);
            List resourceRequests = this.submissionContext.getAMContainerResourceRequests();
            Assert.assertEquals((long)1L, (long)resourceRequests.size());
            ResourceRequest resourceRequest = (ResourceRequest)resourceRequests.get(0);
            long memorySize = resourceRequest.getCapability().getMemorySize();
            Assert.assertEquals((long)3072L, (long)memorySize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAMRMemoryRequestOverriding() throws Exception {
        for (String memoryName : ImmutableList.of((Object)"memory", (Object)"memory-mb")) {
            TestAppender testAppender = new TestAppender();
            org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(YARNRunner.class);
            logger.addAppender((Appender)testAppender);
            try {
                JobConf jobConf = new JobConf();
                jobConf.set("yarn.app.mapreduce.am.resource." + memoryName, "3 Gi");
                jobConf.setInt("yarn.app.mapreduce.am.resource.mb", 2048);
                this.yarnRunner = new YARNRunner((Configuration)jobConf);
                this.submissionContext = this.buildSubmitContext(this.yarnRunner, jobConf);
                List resourceRequests = this.submissionContext.getAMContainerResourceRequests();
                Assert.assertEquals((long)1L, (long)resourceRequests.size());
                ResourceRequest resourceRequest = (ResourceRequest)resourceRequests.get(0);
                long memorySize = resourceRequest.getCapability().getMemorySize();
                Assert.assertEquals((long)3072L, (long)memorySize);
                Assert.assertTrue((boolean)testAppender.getLogEvents().stream().anyMatch(e -> e.getLevel() == Level.WARN && ("Configuration yarn.app.mapreduce.am.resource." + memoryName + "=3Gi is overriding the yarn.app.mapreduce.am.resource.mb=2048 configuration").equals(e.getMessage())));
            }
            finally {
                logger.removeAppender((Appender)testAppender);
            }
        }
    }

    private void initResourceTypes() {
        CustomResourceTypesConfigurationProvider.initResourceTypes((Map)ImmutableMap.builder().put((Object)CUSTOM_RESOURCE_NAME, (Object)"G").build());
    }

    private static class TestAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> logEvents = new CopyOnWriteArrayList<LoggingEvent>();

        private TestAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        protected void append(LoggingEvent arg0) {
            this.logEvents.add(arg0);
        }

        private List<LoggingEvent> getLogEvents() {
            return this.logEvents;
        }
    }
}

