/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapTaskAttemptImpl;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTaskAttemptContainerRequest {
    @After
    public void cleanup() {
        UserGroupInformation.reset();
    }

    @Test
    public void testAttemptContainerRequest() throws Exception {
        Text SECRET_KEY_ALIAS = new Text("secretkeyalias");
        byte[] SECRET_KEY = "secretkey".getBytes();
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(1);
        acls.put(ApplicationAccessType.VIEW_APP, "otheruser");
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        Path jobFile = (Path)Mockito.mock(Path.class);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("hadoop.security.authentication", "kerberos");
        jobConf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        jobConf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        UserGroupInformation.setConfiguration((Configuration)jobConf);
        Credentials credentials = new Credentials();
        credentials.addSecretKey(SECRET_KEY_ALIAS, SECRET_KEY);
        Token jobToken = new Token("tokenid".getBytes(), "tokenpw".getBytes(), new Text("tokenkind"), new Text("tokenservice"));
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, eventHandler, jobFile, 1, (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class), jobConf, taListener, jobToken, credentials, (Clock)SystemClock.getInstance(), null);
        jobConf.set("mapreduce.job.application.attempt.id", taImpl.getID().toString());
        ContainerLaunchContext launchCtx = TaskAttemptImpl.createContainerLaunchContext(acls, (Configuration)jobConf, (Token)jobToken, (Task)taImpl.createRemoteTask(), (JobID)TypeConverter.fromYarn((JobId)jobId), (WrappedJvmID)((WrappedJvmID)Mockito.mock(WrappedJvmID.class)), (TaskAttemptListener)taListener, (Credentials)credentials);
        Assert.assertEquals((String)"ACLs mismatch", acls, (Object)launchCtx.getApplicationACLs());
        Credentials launchCredentials = new Credentials();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        dibb.reset(new ByteBuffer[]{launchCtx.getTokens()});
        launchCredentials.readTokenStorageStream((DataInputStream)dibb);
        for (Token token : credentials.getAllTokens()) {
            Token launchToken = launchCredentials.getToken(token.getService());
            Assert.assertNotNull((String)("Token " + token.getService() + " is missing"), (Object)launchToken);
            Assert.assertEquals((String)("Token " + token.getService() + " mismatch"), (Object)token, (Object)launchToken);
        }
        Assert.assertNotNull((String)"Secret key missing", (Object)launchCredentials.getSecretKey(SECRET_KEY_ALIAS));
        Assert.assertTrue((String)"Secret key mismatch", (boolean)Arrays.equals(SECRET_KEY, launchCredentials.getSecretKey(SECRET_KEY_ALIAS)));
    }

    public static class StubbedFS
    extends RawLocalFileSystem {
        public FileStatus getFileStatus(Path f) throws IOException {
            return new FileStatus(1L, false, 1, 1L, 1L, f);
        }
    }
}

