/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.Event;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskRecoverEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.MapTaskImpl;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRecovery {
    private static final Logger LOG = LoggerFactory.getLogger(TestRecovery.class);
    private static Path outputDir = new Path(new File("target", TestRecovery.class.getName()).getAbsolutePath() + "/out");
    private static String partFile = "part-r-00000";
    private Text key1 = new Text("key1");
    private Text key2 = new Text("key2");
    private Text val1 = new Text("val1");
    private Text val2 = new Text("val2");

    @Test
    public void testCrashed() throws Exception {
        int runCount = 0;
        long am1StartTimeEst = System.currentTimeMillis();
        MRAppWithHistory app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        long jobStartTime = job.getReport().getStartTime();
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        Task reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        TaskAttempt task1Attempt1 = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        TaskAttempt task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt1, TaskAttemptState.RUNNING);
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((String)"Reduce Task state not correct", (Object)TaskState.RUNNING, (Object)reduceTask.getReport().getTaskState());
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt1.getID(), TaskAttemptEventType.TA_FAILMSG));
        app.waitForState(task1Attempt1, TaskAttemptState.FAILED);
        int timeOut = 0;
        while (mapTask1.getAttempts().size() != 2 && timeOut++ < 10) {
            Thread.sleep(2000L);
            LOG.info("Waiting for next attempt to start");
        }
        Assert.assertEquals((long)2L, (long)mapTask1.getAttempts().size());
        Iterator itr = mapTask1.getAttempts().values().iterator();
        itr.next();
        TaskAttempt task1Attempt2 = (TaskAttempt)itr.next();
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt2.getID(), TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED));
        app.waitForState(task1Attempt2, TaskAttemptState.FAILED);
        timeOut = 0;
        while (mapTask1.getAttempts().size() != 3 && timeOut++ < 10) {
            Thread.sleep(2000L);
            LOG.info("Waiting for next attempt to start");
        }
        Assert.assertEquals((long)3L, (long)mapTask1.getAttempts().size());
        itr = mapTask1.getAttempts().values().iterator();
        itr.next();
        itr.next();
        TaskAttempt task1Attempt3 = (TaskAttempt)itr.next();
        app.waitForState(task1Attempt3, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt3.getID(), TaskAttemptEventType.TA_KILL));
        app.waitForState(task1Attempt3, TaskAttemptState.KILLED);
        timeOut = 0;
        while (mapTask1.getAttempts().size() != 4 && timeOut++ < 10) {
            Thread.sleep(2000L);
            LOG.info("Waiting for next attempt to start");
        }
        Assert.assertEquals((long)4L, (long)mapTask1.getAttempts().size());
        itr = mapTask1.getAttempts().values().iterator();
        itr.next();
        itr.next();
        itr.next();
        TaskAttempt task1Attempt4 = (TaskAttempt)itr.next();
        app.waitForState(task1Attempt4, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt4.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        long task1StartTime = mapTask1.getReport().getStartTime();
        long task1FinishTime = mapTask1.getReport().getFinishTime();
        app.stop();
        long am2StartTimeEst = System.currentTimeMillis();
        app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        mapTask2 = (Task)it.next();
        reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.RUNNING);
        task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)mapTask2.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        app.waitForState(reduceTask, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)reduceTask.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertEquals((String)"Job Start time not correct", (long)jobStartTime, (long)job.getReport().getStartTime());
        Assert.assertEquals((String)"Task Start time not correct", (long)task1StartTime, (long)mapTask1.getReport().getStartTime());
        Assert.assertEquals((String)"Task Finish time not correct", (long)task1FinishTime, (long)mapTask1.getReport().getFinishTime());
        Assert.assertEquals((long)2L, (long)job.getAMInfos().size());
        int attemptNum = 1;
        for (AMInfo amInfo : job.getAMInfos()) {
            Assert.assertEquals((long)attemptNum++, (long)amInfo.getAppAttemptId().getAttemptId());
            Assert.assertEquals((Object)amInfo.getAppAttemptId(), (Object)amInfo.getContainerId().getApplicationAttemptId());
            Assert.assertEquals((Object)MRApp.NM_HOST, (Object)amInfo.getNodeManagerHost());
            Assert.assertEquals((long)MRApp.NM_PORT, (long)amInfo.getNodeManagerPort());
            Assert.assertEquals((long)MRApp.NM_HTTP_PORT, (long)amInfo.getNodeManagerHttpPort());
        }
        long am1StartTimeReal = ((AMInfo)job.getAMInfos().get(0)).getStartTime();
        long am2StartTimeReal = ((AMInfo)job.getAMInfos().get(1)).getStartTime();
        Assert.assertTrue((am1StartTimeReal >= am1StartTimeEst && am1StartTimeReal <= am2StartTimeEst ? 1 : 0) != 0);
        Assert.assertTrue((am2StartTimeReal >= am2StartTimeEst && am2StartTimeReal <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testCrashOfMapsOnlyJob() throws Exception {
        int runCount = 0;
        MRAppWithHistory app = new MRAppWithHistory(3, 0, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        Task mapTask3 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        app.waitForState(mapTask3, TaskState.RUNNING);
        TaskAttempt task1Attempt = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        TaskAttempt task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        TaskAttempt task3Attempt = (TaskAttempt)mapTask3.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt, TaskAttemptState.RUNNING);
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        app.waitForState(task3Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task2Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        app.stop();
        app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setInt("mapreduce.job.reduces", 0);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        mapTask2 = (Task)it.next();
        mapTask3 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        app.waitForState(mapTask3, TaskState.RUNNING);
        task3Attempt = (TaskAttempt)mapTask3.getAttempts().values().iterator().next();
        app.waitForState(task3Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)mapTask3.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask3, TaskState.SUCCEEDED);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
    }

    @Test
    public void testRecoverySuccessUsingCustomOutputCommitter() throws Exception {
        int runCount = 0;
        MRAppWithHistory app = new MRAppWithHistory(3, 0, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setClass("mapred.output.committer.class", TestFileOutputCommitter.class, OutputCommitter.class);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setBoolean("want.am.recovery", true);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        Task mapTask3 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        app.waitForState(mapTask3, TaskState.RUNNING);
        TaskAttempt task1Attempt = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        TaskAttempt task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        TaskAttempt task3Attempt = (TaskAttempt)mapTask3.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt, TaskAttemptState.RUNNING);
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        app.waitForState(task3Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task2Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        app.stop();
        app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setClass("mapred.output.committer.class", TestFileOutputCommitter.class, OutputCommitter.class);
        conf.setBoolean("want.am.recovery", true);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setInt("mapreduce.job.reduces", 0);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        mapTask2 = (Task)it.next();
        mapTask3 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        app.waitForState(mapTask3, TaskState.RUNNING);
        task3Attempt = (TaskAttempt)mapTask3.getAttempts().values().iterator().next();
        app.waitForState(task3Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)mapTask3.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask3, TaskState.SUCCEEDED);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
    }

    @Test
    public void testRecoveryFailsUsingCustomOutputCommitter() throws Exception {
        int runCount = 0;
        MRAppWithHistory app = new MRAppWithHistory(3, 0, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setClass("mapred.output.committer.class", TestFileOutputCommitter.class, OutputCommitter.class);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setBoolean("want.am.recovery", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        Task mapTask3 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        app.waitForState(mapTask3, TaskState.RUNNING);
        TaskAttempt task1Attempt = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        TaskAttempt task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        TaskAttempt task3Attempt = (TaskAttempt)mapTask3.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt, TaskAttemptState.RUNNING);
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        app.waitForState(task3Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task2Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        app.stop();
        app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setClass("mapred.output.committer.class", TestFileOutputCommitter.class, OutputCommitter.class);
        conf.setBoolean("want.am.recovery", false);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setInt("mapreduce.job.reduces", 0);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        mapTask2 = (Task)it.next();
        mapTask3 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        app.waitForState(mapTask3, TaskState.RUNNING);
        task3Attempt = (TaskAttempt)mapTask3.getAttempts().values().iterator().next();
        app.waitForState(task3Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)mapTask1.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)mapTask2.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)mapTask3.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask3, TaskState.SUCCEEDED);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
    }

    @Test
    public void testMultipleCrashes() throws Exception {
        int runCount = 0;
        MRAppWithHistory app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        Task reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        TaskAttempt task1Attempt1 = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        TaskAttempt task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt1, TaskAttemptState.RUNNING);
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((String)"Reduce Task state not correct", (Object)TaskState.RUNNING, (Object)reduceTask.getReport().getTaskState());
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt1.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.stop();
        app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        mapTask2 = (Task)it.next();
        reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.RUNNING);
        task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)mapTask2.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        app.stop();
        app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        mapTask2 = (Task)it.next();
        reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        app.waitForState(reduceTask, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)reduceTask.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
    }

    @Test
    public void testOutputRecovery() throws Exception {
        int runCount = 0;
        MRAppWithHistory app = new MRAppWithHistory(1, 2, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task reduceTask1 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        TaskAttempt task1Attempt1 = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt1, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt1.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        Assert.assertEquals((long)5467L, (long)task1Attempt1.getShufflePort());
        app.waitForState(reduceTask1, TaskState.RUNNING);
        TaskAttempt reduce1Attempt1 = (TaskAttempt)reduceTask1.getAttempts().values().iterator().next();
        this.writeOutput(reduce1Attempt1, conf);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(reduce1Attempt1.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(reduceTask1, TaskState.SUCCEEDED);
        app.stop();
        app = new MRAppWithHistory(1, 2, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        reduceTask1 = (Task)it.next();
        Task reduceTask2 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        task1Attempt1 = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        Assert.assertEquals((long)5467L, (long)task1Attempt1.getShufflePort());
        app.waitForState(reduceTask1, TaskState.SUCCEEDED);
        app.waitForState(reduceTask2, TaskState.RUNNING);
        TaskAttempt reduce2Attempt = (TaskAttempt)reduceTask2.getAttempts().values().iterator().next();
        app.waitForState(reduce2Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(reduce2Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(reduceTask2, TaskState.SUCCEEDED);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        this.validateOutput();
    }

    @Test
    public void testOutputRecoveryMapsOnly() throws Exception {
        int runCount = 0;
        MRAppWithHistory app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        Task reduceTask1 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        TaskAttempt task1Attempt1 = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt1, TaskAttemptState.RUNNING);
        this.writeBadOutput(task1Attempt1, conf);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt1.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        Assert.assertEquals((long)5467L, (long)task1Attempt1.getShufflePort());
        app.stop();
        app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        mapTask2 = (Task)it.next();
        reduceTask1 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        task1Attempt1 = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        Assert.assertEquals((long)5467L, (long)task1Attempt1.getShufflePort());
        app.waitForState(mapTask2, TaskState.RUNNING);
        TaskAttempt task2Attempt1 = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.waitForState(task2Attempt1, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task2Attempt1.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        Assert.assertEquals((long)5467L, (long)task2Attempt1.getShufflePort());
        app.waitForState(reduceTask1, TaskState.RUNNING);
        TaskAttempt reduce1Attempt1 = (TaskAttempt)reduceTask1.getAttempts().values().iterator().next();
        this.writeOutput(reduce1Attempt1, conf);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(reduce1Attempt1.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(reduceTask1, TaskState.SUCCEEDED);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        this.validateOutput();
    }

    @Test
    public void testRecoveryWithOldCommiter() throws Exception {
        int runCount = 0;
        MRAppWithHistory app = new MRAppWithHistory(1, 2, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.mapper.new-api", false);
        conf.setBoolean("mapred.reducer.new-api", false);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task reduceTask1 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        TaskAttempt task1Attempt1 = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt1, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt1.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        Assert.assertEquals((long)5467L, (long)task1Attempt1.getShufflePort());
        app.waitForState(reduceTask1, TaskState.RUNNING);
        TaskAttempt reduce1Attempt1 = (TaskAttempt)reduceTask1.getAttempts().values().iterator().next();
        this.writeOutput(reduce1Attempt1, conf);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(reduce1Attempt1.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(reduceTask1, TaskState.SUCCEEDED);
        app.stop();
        app = new MRAppWithHistory(1, 2, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        conf.setBoolean("mapred.mapper.new-api", false);
        conf.setBoolean("mapred.reducer.new-api", false);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        reduceTask1 = (Task)it.next();
        Task reduceTask2 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        task1Attempt1 = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        Assert.assertEquals((long)5467L, (long)task1Attempt1.getShufflePort());
        app.waitForState(reduceTask1, TaskState.SUCCEEDED);
        app.waitForState(reduceTask2, TaskState.RUNNING);
        TaskAttempt reduce2Attempt = (TaskAttempt)reduceTask2.getAttempts().values().iterator().next();
        app.waitForState(reduce2Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(reduce2Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(reduceTask2, TaskState.SUCCEEDED);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        this.validateOutput();
    }

    @Test
    public void testSpeculative() throws Exception {
        int runCount = 0;
        long am1StartTimeEst = System.currentTimeMillis();
        MRAppWithHistory app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        long jobStartTime = job.getReport().getStartTime();
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        Task reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskEvent(mapTask1.getID(), TaskEventType.T_ADD_SPEC_ATTEMPT));
        int timeOut = 0;
        while (mapTask1.getAttempts().size() != 2 && timeOut++ < 10) {
            Thread.sleep(1000L);
            LOG.info("Waiting for next attempt to start");
        }
        Iterator t1it = mapTask1.getAttempts().values().iterator();
        TaskAttempt task1Attempt1 = (TaskAttempt)t1it.next();
        TaskAttempt task1Attempt2 = (TaskAttempt)t1it.next();
        TaskAttempt task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        ContainerId t1a2contId = task1Attempt2.getAssignedContainerID();
        LOG.info(t1a2contId.toString());
        LOG.info(task1Attempt1.getID().toString());
        LOG.info(task1Attempt2.getID().toString());
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptContainerLaunchedEvent(task1Attempt2.getID(), runCount));
        app.waitForState(task1Attempt1, TaskAttemptState.RUNNING);
        app.waitForState(task1Attempt2, TaskAttemptState.RUNNING);
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((String)"Reduce Task state not correct", (Object)TaskState.RUNNING, (Object)reduceTask.getReport().getTaskState());
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt1.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(task1Attempt1, TaskAttemptState.SUCCEEDED);
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        long task1StartTime = mapTask1.getReport().getStartTime();
        long task1FinishTime = mapTask1.getReport().getFinishTime();
        app.stop();
        long am2StartTimeEst = System.currentTimeMillis();
        app = new MRAppWithHistory(2, 1, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        mapTask2 = (Task)it.next();
        reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.RUNNING);
        task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)mapTask2.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        app.waitForState(reduceTask, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)reduceTask.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertEquals((String)"Job Start time not correct", (long)jobStartTime, (long)job.getReport().getStartTime());
        Assert.assertEquals((String)"Task Start time not correct", (long)task1StartTime, (long)mapTask1.getReport().getStartTime());
        Assert.assertEquals((String)"Task Finish time not correct", (long)task1FinishTime, (long)mapTask1.getReport().getFinishTime());
        Assert.assertEquals((long)2L, (long)job.getAMInfos().size());
        int attemptNum = 1;
        for (AMInfo amInfo : job.getAMInfos()) {
            Assert.assertEquals((long)attemptNum++, (long)amInfo.getAppAttemptId().getAttemptId());
            Assert.assertEquals((Object)amInfo.getAppAttemptId(), (Object)amInfo.getContainerId().getApplicationAttemptId());
            Assert.assertEquals((Object)MRApp.NM_HOST, (Object)amInfo.getNodeManagerHost());
            Assert.assertEquals((long)MRApp.NM_PORT, (long)amInfo.getNodeManagerPort());
            Assert.assertEquals((long)MRApp.NM_HTTP_PORT, (long)amInfo.getNodeManagerHttpPort());
        }
        long am1StartTimeReal = ((AMInfo)job.getAMInfos().get(0)).getStartTime();
        long am2StartTimeReal = ((AMInfo)job.getAMInfos().get(1)).getStartTime();
        Assert.assertTrue((am1StartTimeReal >= am1StartTimeEst && am1StartTimeReal <= am2StartTimeEst ? 1 : 0) != 0);
        Assert.assertTrue((am2StartTimeReal >= am2StartTimeEst && am2StartTimeReal <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testRecoveryWithoutShuffleSecret() throws Exception {
        int runCount = 0;
        MRAppNoShuffleSecret app = new MRAppNoShuffleSecret(2, 1, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        Task reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        TaskAttempt task1Attempt = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        TaskAttempt task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt, TaskAttemptState.RUNNING);
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((String)"Reduce Task state not correct", (Object)TaskState.RUNNING, (Object)reduceTask.getReport().getTaskState());
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(task1Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.stop();
        app = new MRAppNoShuffleSecret(2, 1, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setBoolean("mapred.reducer.new-api", true);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        mapTask2 = (Task)it.next();
        reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)mapTask2.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)mapTask1.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(reduceTask, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((org.apache.hadoop.yarn.event.Event)new TaskAttemptEvent(((TaskAttempt)reduceTask.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
    }

    @Test
    public void testRecoverySuccessAttempt() {
        LOG.info("--- START: testRecoverySuccessAttempt ---");
        long clusterTimestamp = System.currentTimeMillis();
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        MapTaskImpl recoverMapTask = this.getMockMapTask(clusterTimestamp, mockEventHandler);
        TaskId taskId = recoverMapTask.getID();
        JobID jobID = new JobID(Long.toString(clusterTimestamp), 1);
        TaskID taskID = new TaskID(jobID, TaskType.MAP, taskId.getId());
        HashMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> mockTaskAttempts = new HashMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo>();
        TaskAttemptID taId1 = new TaskAttemptID(taskID, 2);
        JobHistoryParser.TaskAttemptInfo mockTAinfo1 = this.getMockTaskAttemptInfo(taId1, TaskAttemptState.SUCCEEDED);
        mockTaskAttempts.put(taId1, mockTAinfo1);
        TaskAttemptID taId2 = new TaskAttemptID(taskID, 1);
        JobHistoryParser.TaskAttemptInfo mockTAinfo2 = this.getMockTaskAttemptInfo(taId2, TaskAttemptState.FAILED);
        mockTaskAttempts.put(taId2, mockTAinfo2);
        org.apache.hadoop.mapreduce.OutputCommitter mockCommitter = (org.apache.hadoop.mapreduce.OutputCommitter)Mockito.mock(org.apache.hadoop.mapreduce.OutputCommitter.class);
        JobHistoryParser.TaskInfo mockTaskInfo = (JobHistoryParser.TaskInfo)Mockito.mock(JobHistoryParser.TaskInfo.class);
        Mockito.when((Object)mockTaskInfo.getTaskStatus()).thenReturn((Object)"SUCCEEDED");
        Mockito.when((Object)mockTaskInfo.getTaskId()).thenReturn((Object)taskID);
        Mockito.when((Object)mockTaskInfo.getAllTaskAttempts()).thenReturn(mockTaskAttempts);
        recoverMapTask.handle((TaskEvent)new TaskRecoverEvent(taskId, mockTaskInfo, mockCommitter, true));
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)mockEventHandler, (VerificationMode)Mockito.atLeast((int)1))).handle((org.apache.hadoop.yarn.event.Event)arg.capture());
        HashMap<TaskAttemptID, TaskAttemptState> finalAttemptStates = new HashMap<TaskAttemptID, TaskAttemptState>();
        finalAttemptStates.put(taId1, TaskAttemptState.SUCCEEDED);
        finalAttemptStates.put(taId2, TaskAttemptState.FAILED);
        ArrayList<EventType> jobHistoryEvents = new ArrayList<EventType>();
        jobHistoryEvents.add(EventType.TASK_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_FINISHED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_FAILED);
        jobHistoryEvents.add(EventType.TASK_FINISHED);
        this.recoveryChecker(recoverMapTask, TaskState.SUCCEEDED, finalAttemptStates, (ArgumentCaptor<Event>)arg, jobHistoryEvents, 2L, 1L);
    }

    @Test
    public void testRecoveryAllFailAttempts() {
        LOG.info("--- START: testRecoveryAllFailAttempts ---");
        long clusterTimestamp = System.currentTimeMillis();
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        MapTaskImpl recoverMapTask = this.getMockMapTask(clusterTimestamp, mockEventHandler);
        TaskId taskId = recoverMapTask.getID();
        JobID jobID = new JobID(Long.toString(clusterTimestamp), 1);
        TaskID taskID = new TaskID(jobID, TaskType.MAP, taskId.getId());
        HashMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> mockTaskAttempts = new HashMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo>();
        TaskAttemptID taId1 = new TaskAttemptID(taskID, 2);
        JobHistoryParser.TaskAttemptInfo mockTAinfo1 = this.getMockTaskAttemptInfo(taId1, TaskAttemptState.FAILED);
        mockTaskAttempts.put(taId1, mockTAinfo1);
        TaskAttemptID taId2 = new TaskAttemptID(taskID, 1);
        JobHistoryParser.TaskAttemptInfo mockTAinfo2 = this.getMockTaskAttemptInfo(taId2, TaskAttemptState.FAILED);
        mockTaskAttempts.put(taId2, mockTAinfo2);
        org.apache.hadoop.mapreduce.OutputCommitter mockCommitter = (org.apache.hadoop.mapreduce.OutputCommitter)Mockito.mock(org.apache.hadoop.mapreduce.OutputCommitter.class);
        JobHistoryParser.TaskInfo mockTaskInfo = (JobHistoryParser.TaskInfo)Mockito.mock(JobHistoryParser.TaskInfo.class);
        Mockito.when((Object)mockTaskInfo.getTaskStatus()).thenReturn((Object)"FAILED");
        Mockito.when((Object)mockTaskInfo.getTaskId()).thenReturn((Object)taskID);
        Mockito.when((Object)mockTaskInfo.getAllTaskAttempts()).thenReturn(mockTaskAttempts);
        recoverMapTask.handle((TaskEvent)new TaskRecoverEvent(taskId, mockTaskInfo, mockCommitter, true));
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)mockEventHandler, (VerificationMode)Mockito.atLeast((int)1))).handle((org.apache.hadoop.yarn.event.Event)arg.capture());
        HashMap<TaskAttemptID, TaskAttemptState> finalAttemptStates = new HashMap<TaskAttemptID, TaskAttemptState>();
        finalAttemptStates.put(taId1, TaskAttemptState.FAILED);
        finalAttemptStates.put(taId2, TaskAttemptState.FAILED);
        ArrayList<EventType> jobHistoryEvents = new ArrayList<EventType>();
        jobHistoryEvents.add(EventType.TASK_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_FAILED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_FAILED);
        jobHistoryEvents.add(EventType.TASK_FAILED);
        this.recoveryChecker(recoverMapTask, TaskState.FAILED, finalAttemptStates, (ArgumentCaptor<Event>)arg, jobHistoryEvents, 2L, 2L);
    }

    @Test
    public void testRecoveryTaskSuccessAllAttemptsFail() {
        LOG.info("--- START:  testRecoveryTaskSuccessAllAttemptsFail ---");
        long clusterTimestamp = System.currentTimeMillis();
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        MapTaskImpl recoverMapTask = this.getMockMapTask(clusterTimestamp, mockEventHandler);
        TaskId taskId = recoverMapTask.getID();
        JobID jobID = new JobID(Long.toString(clusterTimestamp), 1);
        TaskID taskID = new TaskID(jobID, TaskType.MAP, taskId.getId());
        HashMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> mockTaskAttempts = new HashMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo>();
        TaskAttemptID taId1 = new TaskAttemptID(taskID, 2);
        JobHistoryParser.TaskAttemptInfo mockTAinfo1 = this.getMockTaskAttemptInfo(taId1, TaskAttemptState.FAILED);
        mockTaskAttempts.put(taId1, mockTAinfo1);
        TaskAttemptID taId2 = new TaskAttemptID(taskID, 1);
        JobHistoryParser.TaskAttemptInfo mockTAinfo2 = this.getMockTaskAttemptInfo(taId2, TaskAttemptState.FAILED);
        mockTaskAttempts.put(taId2, mockTAinfo2);
        org.apache.hadoop.mapreduce.OutputCommitter mockCommitter = (org.apache.hadoop.mapreduce.OutputCommitter)Mockito.mock(org.apache.hadoop.mapreduce.OutputCommitter.class);
        JobHistoryParser.TaskInfo mockTaskInfo = (JobHistoryParser.TaskInfo)Mockito.mock(JobHistoryParser.TaskInfo.class);
        Mockito.when((Object)mockTaskInfo.getTaskStatus()).thenReturn((Object)"SUCCEEDED");
        Mockito.when((Object)mockTaskInfo.getTaskId()).thenReturn((Object)taskID);
        Mockito.when((Object)mockTaskInfo.getAllTaskAttempts()).thenReturn(mockTaskAttempts);
        recoverMapTask.handle((TaskEvent)new TaskRecoverEvent(taskId, mockTaskInfo, mockCommitter, true));
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)mockEventHandler, (VerificationMode)Mockito.atLeast((int)1))).handle((org.apache.hadoop.yarn.event.Event)arg.capture());
        HashMap<TaskAttemptID, TaskAttemptState> finalAttemptStates = new HashMap<TaskAttemptID, TaskAttemptState>();
        finalAttemptStates.put(taId1, TaskAttemptState.FAILED);
        finalAttemptStates.put(taId2, TaskAttemptState.FAILED);
        TaskAttemptID taId3 = new TaskAttemptID(taskID, 2000);
        finalAttemptStates.put(taId3, TaskAttemptState.NEW);
        ArrayList<EventType> jobHistoryEvents = new ArrayList<EventType>();
        jobHistoryEvents.add(EventType.TASK_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_FAILED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_FAILED);
        this.recoveryChecker(recoverMapTask, TaskState.RUNNING, finalAttemptStates, (ArgumentCaptor<Event>)arg, jobHistoryEvents, 2L, 2L);
    }

    @Test
    public void testRecoveryTaskSuccessAllAttemptsSucceed() {
        LOG.info("--- START:  testRecoveryTaskSuccessAllAttemptsFail ---");
        long clusterTimestamp = System.currentTimeMillis();
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        MapTaskImpl recoverMapTask = this.getMockMapTask(clusterTimestamp, mockEventHandler);
        TaskId taskId = recoverMapTask.getID();
        JobID jobID = new JobID(Long.toString(clusterTimestamp), 1);
        TaskID taskID = new TaskID(jobID, TaskType.MAP, taskId.getId());
        HashMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> mockTaskAttempts = new HashMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo>();
        TaskAttemptID taId1 = new TaskAttemptID(taskID, 2);
        JobHistoryParser.TaskAttemptInfo mockTAinfo1 = this.getMockTaskAttemptInfo(taId1, TaskAttemptState.SUCCEEDED);
        mockTaskAttempts.put(taId1, mockTAinfo1);
        TaskAttemptID taId2 = new TaskAttemptID(taskID, 1);
        JobHistoryParser.TaskAttemptInfo mockTAinfo2 = this.getMockTaskAttemptInfo(taId2, TaskAttemptState.SUCCEEDED);
        mockTaskAttempts.put(taId2, mockTAinfo2);
        org.apache.hadoop.mapreduce.OutputCommitter mockCommitter = (org.apache.hadoop.mapreduce.OutputCommitter)Mockito.mock(org.apache.hadoop.mapreduce.OutputCommitter.class);
        JobHistoryParser.TaskInfo mockTaskInfo = (JobHistoryParser.TaskInfo)Mockito.mock(JobHistoryParser.TaskInfo.class);
        Mockito.when((Object)mockTaskInfo.getTaskStatus()).thenReturn((Object)"SUCCEEDED");
        Mockito.when((Object)mockTaskInfo.getTaskId()).thenReturn((Object)taskID);
        Mockito.when((Object)mockTaskInfo.getAllTaskAttempts()).thenReturn(mockTaskAttempts);
        recoverMapTask.handle((TaskEvent)new TaskRecoverEvent(taskId, mockTaskInfo, mockCommitter, true));
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)mockEventHandler, (VerificationMode)Mockito.atLeast((int)1))).handle((org.apache.hadoop.yarn.event.Event)arg.capture());
        HashMap<TaskAttemptID, TaskAttemptState> finalAttemptStates = new HashMap<TaskAttemptID, TaskAttemptState>();
        finalAttemptStates.put(taId1, TaskAttemptState.SUCCEEDED);
        finalAttemptStates.put(taId2, TaskAttemptState.SUCCEEDED);
        ArrayList<EventType> jobHistoryEvents = new ArrayList<EventType>();
        jobHistoryEvents.add(EventType.TASK_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_FINISHED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_FINISHED);
        jobHistoryEvents.add(EventType.TASK_FINISHED);
        this.recoveryChecker(recoverMapTask, TaskState.SUCCEEDED, finalAttemptStates, (ArgumentCaptor<Event>)arg, jobHistoryEvents, 2L, 0L);
    }

    @Test
    public void testRecoveryAllAttemptsKilled() {
        LOG.info("--- START:  testRecoveryAllAttemptsKilled ---");
        long clusterTimestamp = System.currentTimeMillis();
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        MapTaskImpl recoverMapTask = this.getMockMapTask(clusterTimestamp, mockEventHandler);
        TaskId taskId = recoverMapTask.getID();
        JobID jobID = new JobID(Long.toString(clusterTimestamp), 1);
        TaskID taskID = new TaskID(jobID, TaskType.MAP, taskId.getId());
        HashMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> mockTaskAttempts = new HashMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo>();
        TaskAttemptID taId1 = new TaskAttemptID(taskID, 2);
        JobHistoryParser.TaskAttemptInfo mockTAinfo1 = this.getMockTaskAttemptInfo(taId1, TaskAttemptState.KILLED);
        mockTaskAttempts.put(taId1, mockTAinfo1);
        TaskAttemptID taId2 = new TaskAttemptID(taskID, 1);
        JobHistoryParser.TaskAttemptInfo mockTAinfo2 = this.getMockTaskAttemptInfo(taId2, TaskAttemptState.KILLED);
        mockTaskAttempts.put(taId2, mockTAinfo2);
        org.apache.hadoop.mapreduce.OutputCommitter mockCommitter = (org.apache.hadoop.mapreduce.OutputCommitter)Mockito.mock(org.apache.hadoop.mapreduce.OutputCommitter.class);
        JobHistoryParser.TaskInfo mockTaskInfo = (JobHistoryParser.TaskInfo)Mockito.mock(JobHistoryParser.TaskInfo.class);
        Mockito.when((Object)mockTaskInfo.getTaskStatus()).thenReturn((Object)"KILLED");
        Mockito.when((Object)mockTaskInfo.getTaskId()).thenReturn((Object)taskID);
        Mockito.when((Object)mockTaskInfo.getAllTaskAttempts()).thenReturn(mockTaskAttempts);
        recoverMapTask.handle((TaskEvent)new TaskRecoverEvent(taskId, mockTaskInfo, mockCommitter, true));
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)mockEventHandler, (VerificationMode)Mockito.atLeast((int)1))).handle((org.apache.hadoop.yarn.event.Event)arg.capture());
        HashMap<TaskAttemptID, TaskAttemptState> finalAttemptStates = new HashMap<TaskAttemptID, TaskAttemptState>();
        finalAttemptStates.put(taId1, TaskAttemptState.KILLED);
        finalAttemptStates.put(taId2, TaskAttemptState.KILLED);
        ArrayList<EventType> jobHistoryEvents = new ArrayList<EventType>();
        jobHistoryEvents.add(EventType.TASK_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_KILLED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_STARTED);
        jobHistoryEvents.add(EventType.MAP_ATTEMPT_KILLED);
        jobHistoryEvents.add(EventType.TASK_FAILED);
        this.recoveryChecker(recoverMapTask, TaskState.KILLED, finalAttemptStates, (ArgumentCaptor<Event>)arg, jobHistoryEvents, 2L, 0L);
    }

    private void recoveryChecker(MapTaskImpl checkTask, TaskState finalState, Map<TaskAttemptID, TaskAttemptState> finalAttemptStates, ArgumentCaptor<Event> arg, List<EventType> expectedJobHistoryEvents, long expectedMapLaunches, long expectedFailedMaps) {
        Assert.assertEquals((String)"Final State of Task", (Object)finalState, (Object)checkTask.getState());
        Map recoveredAttempts = checkTask.getAttempts();
        Assert.assertEquals((String)"Expected Number of Task Attempts", (long)finalAttemptStates.size(), (long)recoveredAttempts.size());
        for (TaskAttemptID taID : finalAttemptStates.keySet()) {
            Assert.assertEquals((String)"Expected Task Attempt State", (Object)finalAttemptStates.get(taID), (Object)((TaskAttempt)recoveredAttempts.get(TypeConverter.toYarn((TaskAttemptID)taID))).getState());
        }
        Iterator ie = arg.getAllValues().iterator();
        int eventNum = 0;
        long totalLaunchedMaps = 0L;
        long totalFailedMaps = 0L;
        boolean jobTaskEventReceived = false;
        while (ie.hasNext()) {
            Object current = ie.next();
            LOG.info(++eventNum + " " + current.getClass().getName());
            if (current instanceof JobHistoryEvent) {
                JobHistoryEvent jhe = (JobHistoryEvent)current;
                LOG.info(expectedJobHistoryEvents.get(0).toString() + " " + jhe.getHistoryEvent().getEventType().toString() + " " + jhe.getJobID());
                Assert.assertEquals((Object)expectedJobHistoryEvents.get(0), (Object)jhe.getHistoryEvent().getEventType());
                expectedJobHistoryEvents.remove(0);
                continue;
            }
            if (current instanceof JobCounterUpdateEvent) {
                JobCounterUpdateEvent jcue = (JobCounterUpdateEvent)current;
                LOG.info("JobCounterUpdateEvent " + ((JobCounterUpdateEvent.CounterIncrementalUpdate)jcue.getCounterUpdates().get(0)).getCounterKey() + " " + ((JobCounterUpdateEvent.CounterIncrementalUpdate)jcue.getCounterUpdates().get(0)).getIncrementValue());
                if (((JobCounterUpdateEvent.CounterIncrementalUpdate)jcue.getCounterUpdates().get(0)).getCounterKey() == JobCounter.NUM_FAILED_MAPS) {
                    totalFailedMaps += ((JobCounterUpdateEvent.CounterIncrementalUpdate)jcue.getCounterUpdates().get(0)).getIncrementValue();
                    continue;
                }
                if (((JobCounterUpdateEvent.CounterIncrementalUpdate)jcue.getCounterUpdates().get(0)).getCounterKey() != JobCounter.TOTAL_LAUNCHED_MAPS) continue;
                totalLaunchedMaps += ((JobCounterUpdateEvent.CounterIncrementalUpdate)jcue.getCounterUpdates().get(0)).getIncrementValue();
                continue;
            }
            if (!(current instanceof JobTaskEvent)) continue;
            JobTaskEvent jte = (JobTaskEvent)current;
            Assert.assertEquals((Object)jte.getState(), (Object)finalState);
            jobTaskEventReceived = true;
        }
        Assert.assertTrue((jobTaskEventReceived || finalState == TaskState.RUNNING ? 1 : 0) != 0);
        Assert.assertEquals((String)"Did not process all expected JobHistoryEvents", (long)0L, (long)expectedJobHistoryEvents.size());
        Assert.assertEquals((String)"Expected Map Launches", (long)expectedMapLaunches, (long)totalLaunchedMaps);
        Assert.assertEquals((String)"Expected Failed Maps", (long)expectedFailedMaps, (long)totalFailedMaps);
    }

    private MapTaskImpl getMockMapTask(long clusterTimestamp, EventHandler eh) {
        ApplicationId appId = ApplicationId.newInstance((long)clusterTimestamp, (int)1);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        int partitions = 2;
        Path remoteJobConfFile = (Path)Mockito.mock(Path.class);
        JobConf conf = new JobConf();
        TaskAttemptListener taskAttemptListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Token jobToken = (Token)Mockito.mock(Token.class);
        Credentials credentials = null;
        SystemClock clock = new SystemClock();
        int appAttemptId = 3;
        MRAppMetrics metrics = (MRAppMetrics)Mockito.mock(MRAppMetrics.class);
        Resource minContainerRequirements = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)minContainerRequirements.getMemory()).thenReturn((Object)1000);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getClusterInfo()).thenReturn((Object)clusterInfo);
        JobSplit.TaskSplitMetaInfo taskSplitMetaInfo = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        MapTaskImpl mapTask = new MapTaskImpl(jobId, partitions, eh, remoteJobConfFile, conf, taskSplitMetaInfo, taskAttemptListener, jobToken, credentials, (Clock)clock, appAttemptId, metrics, appContext);
        return mapTask;
    }

    private JobHistoryParser.TaskAttemptInfo getMockTaskAttemptInfo(TaskAttemptID tai, TaskAttemptState tas) {
        ContainerId ci = (ContainerId)Mockito.mock(ContainerId.class);
        Counters counters = (Counters)Mockito.mock(Counters.class);
        TaskType tt = TaskType.MAP;
        long finishTime = System.currentTimeMillis();
        JobHistoryParser.TaskAttemptInfo mockTAinfo = (JobHistoryParser.TaskAttemptInfo)Mockito.mock(JobHistoryParser.TaskAttemptInfo.class);
        Mockito.when((Object)mockTAinfo.getAttemptId()).thenReturn((Object)tai);
        Mockito.when((Object)mockTAinfo.getContainerId()).thenReturn((Object)ci);
        Mockito.when((Object)mockTAinfo.getCounters()).thenReturn((Object)counters);
        Mockito.when((Object)mockTAinfo.getError()).thenReturn((Object)"");
        Mockito.when((Object)mockTAinfo.getFinishTime()).thenReturn((Object)finishTime);
        Mockito.when((Object)mockTAinfo.getHostname()).thenReturn((Object)"localhost");
        Mockito.when((Object)mockTAinfo.getHttpPort()).thenReturn((Object)23);
        Mockito.when((Object)mockTAinfo.getMapFinishTime()).thenReturn((Object)(finishTime - 1000L));
        Mockito.when((Object)mockTAinfo.getPort()).thenReturn((Object)24);
        Mockito.when((Object)mockTAinfo.getRackname()).thenReturn((Object)"defaultRack");
        Mockito.when((Object)mockTAinfo.getShuffleFinishTime()).thenReturn((Object)(finishTime - 2000L));
        Mockito.when((Object)mockTAinfo.getShufflePort()).thenReturn((Object)25);
        Mockito.when((Object)mockTAinfo.getSortFinishTime()).thenReturn((Object)(finishTime - 3000L));
        Mockito.when((Object)mockTAinfo.getStartTime()).thenReturn((Object)(finishTime - 10000L));
        Mockito.when((Object)mockTAinfo.getState()).thenReturn((Object)"task in progress");
        Mockito.when((Object)mockTAinfo.getTaskStatus()).thenReturn((Object)tas.toString());
        Mockito.when((Object)mockTAinfo.getTaskType()).thenReturn((Object)tt);
        Mockito.when((Object)mockTAinfo.getTrackerName()).thenReturn((Object)"TrackerName");
        return mockTAinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBadOutput(TaskAttempt attempt, Configuration conf) throws Exception {
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, (TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)attempt.getID()));
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        NullWritable nullWritable = NullWritable.get();
        try {
            theRecordWriter.write((Object)this.key2, (Object)this.val2);
            theRecordWriter.write(null, (Object)nullWritable);
            theRecordWriter.write(null, (Object)this.val2);
            theRecordWriter.write((Object)nullWritable, (Object)this.val1);
            theRecordWriter.write((Object)this.key1, (Object)nullWritable);
            theRecordWriter.write((Object)this.key2, null);
            theRecordWriter.write(null, null);
            theRecordWriter.write((Object)this.key1, (Object)this.val1);
        }
        finally {
            theRecordWriter.close((TaskAttemptContext)tContext);
        }
        OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)tContext.getOutputFormatClass(), (Configuration)conf);
        org.apache.hadoop.mapreduce.OutputCommitter committer = outputFormat.getOutputCommitter((TaskAttemptContext)tContext);
        committer.commitTask((TaskAttemptContext)tContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(TaskAttempt attempt, Configuration conf) throws Exception {
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, (TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)attempt.getID()));
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        NullWritable nullWritable = NullWritable.get();
        try {
            theRecordWriter.write((Object)this.key1, (Object)this.val1);
            theRecordWriter.write(null, (Object)nullWritable);
            theRecordWriter.write(null, (Object)this.val1);
            theRecordWriter.write((Object)nullWritable, (Object)this.val2);
            theRecordWriter.write((Object)this.key2, (Object)nullWritable);
            theRecordWriter.write((Object)this.key1, null);
            theRecordWriter.write(null, null);
            theRecordWriter.write((Object)this.key2, (Object)this.val2);
        }
        finally {
            theRecordWriter.close((TaskAttemptContext)tContext);
        }
        OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)tContext.getOutputFormatClass(), (Configuration)conf);
        org.apache.hadoop.mapreduce.OutputCommitter committer = outputFormat.getOutputCommitter((TaskAttemptContext)tContext);
        committer.commitTask((TaskAttemptContext)tContext);
    }

    private void validateOutput() throws IOException {
        File expectedFile = new File(new Path(outputDir, partFile).toString());
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append(this.key1).append('\t').append(this.val1).append("\n");
        expectedOutput.append(this.val1).append("\n");
        expectedOutput.append(this.val2).append("\n");
        expectedOutput.append(this.key2).append("\n");
        expectedOutput.append(this.key1).append("\n");
        expectedOutput.append(this.key2).append('\t').append(this.val2).append("\n");
        String output = TestRecovery.slurp(expectedFile);
        Assert.assertEquals((Object)output, (Object)expectedOutput.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurp(File f) throws IOException {
        int len = (int)f.length();
        byte[] buf = new byte[len];
        String contents = null;
        try (FileInputStream in = new FileInputStream(f);){
            in.read(buf, 0, len);
            contents = new String(buf, "UTF-8");
        }
        return contents;
    }

    public static void main(String[] arg) throws Exception {
        TestRecovery test = new TestRecovery();
        test.testCrashed();
        test.testMultipleCrashes();
        test.testOutputRecovery();
        test.testOutputRecoveryMapsOnly();
        test.testRecoveryWithOldCommiter();
        test.testSpeculative();
        test.testRecoveryWithoutShuffleSecret();
        test.testRecoverySuccessAttempt();
        test.testRecoveryAllFailAttempts();
        test.testRecoveryTaskSuccessAllAttemptsFail();
        test.testRecoveryTaskSuccessAllAttemptsSucceed();
        test.testRecoveryAllAttemptsKilled();
    }

    static class MRAppNoShuffleSecret
    extends MRAppWithHistory {
        public MRAppNoShuffleSecret(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount) {
            super(maps, reduces, autoComplete, testName, cleanOnStart, startCount);
        }

        @Override
        protected void initJobCredentialsAndUGI(Configuration conf) {
        }
    }

    static class MRAppWithHistory
    extends MRApp {
        public MRAppWithHistory(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount) {
            super(maps, reduces, autoComplete, testName, cleanOnStart, startCount);
        }

        @Override
        protected ContainerLauncher createContainerLauncher(AppContext context) {
            MRApp.MockContainerLauncher launcher = new MRApp.MockContainerLauncher(){

                @Override
                public void handle(ContainerLauncherEvent event) {
                    TaskAttemptId taskAttemptID = event.getTaskAttemptID();
                    if (taskAttemptID.getId() != 1 || taskAttemptID.getTaskId().getId() != 0) {
                        super.handle(event);
                    }
                }
            };
            launcher.shufflePort = 5467;
            return launcher;
        }

        @Override
        protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
            JobHistoryEventHandler eventHandler = new JobHistoryEventHandler(context, this.getStartCount());
            return eventHandler;
        }
    }

    public static class TestFileOutputCommitter
    extends FileOutputCommitter {
        public boolean isRecoverySupported(JobContext jobContext) {
            boolean isRecoverySupported = false;
            if (jobContext != null && jobContext.getConfiguration() != null) {
                isRecoverySupported = jobContext.getConfiguration().getBoolean("want.am.recovery", false);
            }
            return isRecoverySupported;
        }
    }
}

