/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LocalContainerLauncher;
import org.apache.hadoop.mapred.MROutputFiles;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLocalContainerLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(TestLocalContainerLauncher.class);
    private static File testWorkDir;
    private static final String[] localDirs;

    private static void delete(File dir) throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path p = fs.makeQualified(new Path(dir.getAbsolutePath()));
        fs.delete(p, true);
    }

    @BeforeClass
    public static void setupTestDirs() throws IOException {
        testWorkDir = new File("target", TestLocalContainerLauncher.class.getCanonicalName());
        testWorkDir.delete();
        testWorkDir.mkdirs();
        testWorkDir = testWorkDir.getAbsoluteFile();
        for (int i = 0; i < localDirs.length; ++i) {
            File dir = new File(testWorkDir, "local-" + i);
            dir.mkdirs();
            TestLocalContainerLauncher.localDirs[i] = dir.toString();
        }
    }

    @AfterClass
    public static void cleanupTestDirs() throws IOException {
        if (testWorkDir != null) {
            TestLocalContainerLauncher.delete(testWorkDir);
        }
    }

    @Test(timeout=10000L)
    public void testKillJob() throws Exception {
        JobConf conf = new JobConf();
        AppContext context = (AppContext)Mockito.mock(AppContext.class);
        final CountDownLatch isDone = new CountDownLatch(1);
        EventHandler handler = new EventHandler(){

            public void handle(Event event) {
                LOG.info("handling event " + event.getClass() + " with type " + event.getType());
                if (event instanceof TaskAttemptEvent && event.getType() == TaskAttemptEventType.TA_CONTAINER_CLEANED) {
                    isDone.countDown();
                }
            }
        };
        Mockito.when((Object)context.getEventHandler()).thenReturn((Object)handler);
        LocalContainerLauncher launcher = new LocalContainerLauncher(context, (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class));
        launcher.init((Configuration)conf);
        launcher.start();
        JobId jobId = MRBuilderUtils.newJobId((long)System.currentTimeMillis(), (int)1, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId taId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getTotalMaps()).thenReturn((Object)1);
        Mockito.when((Object)job.getTotalReduces()).thenReturn((Object)0);
        HashMap<JobId, Job> jobs = new HashMap<JobId, Job>();
        jobs.put(jobId, job);
        Mockito.when((Object)context.getAllJobs()).thenReturn(jobs);
        org.apache.hadoop.mapreduce.v2.app.job.Task ytask = (org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.mock(org.apache.hadoop.mapreduce.v2.app.job.Task.class);
        Mockito.when((Object)ytask.getType()).thenReturn((Object)TaskType.MAP);
        Mockito.when((Object)job.getTask(taskId)).thenReturn((Object)ytask);
        MapTask mapTask = (MapTask)Mockito.mock(MapTask.class);
        Mockito.when((Object)mapTask.isMapOrReduce()).thenReturn((Object)true);
        Mockito.when((Object)mapTask.isMapTask()).thenReturn((Object)true);
        TaskAttemptID taskID = TypeConverter.fromYarn((TaskAttemptId)taId);
        Mockito.when((Object)mapTask.getTaskID()).thenReturn((Object)taskID);
        Mockito.when((Object)mapTask.getJobID()).thenReturn((Object)taskID.getJobID());
        ((MapTask)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                LOG.info("sleeping for 5 minutes...");
                Thread.sleep(300000L);
                return null;
            }
        }).when((Object)mapTask)).run((JobConf)Matchers.isA(JobConf.class), (TaskUmbilicalProtocol)Matchers.isA(TaskUmbilicalProtocol.class));
        ContainerRemoteLaunchEvent launchEvent = new ContainerRemoteLaunchEvent(taId, null, TestLocalContainerLauncher.createMockContainer(), (Task)mapTask);
        launcher.handle((ContainerLauncherEvent)launchEvent);
        Thread.sleep(200L);
        ContainerLauncherEvent cleanupEvent = new ContainerLauncherEvent(taId, null, null, null, ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP);
        launcher.handle(cleanupEvent);
        isDone.await();
        launcher.close();
    }

    private static Container createMockContainer() {
        Container container = (Container)Mockito.mock(Container.class);
        NodeId nodeId = NodeId.newInstance((String)"foo.bar.org", (int)1234);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nodeId);
        return container;
    }

    @Test
    public void testRenameMapOutputForReduce() throws Exception {
        JobConf conf = new JobConf();
        MROutputFiles mrOutputFiles = new MROutputFiles();
        mrOutputFiles.setConf((Configuration)conf);
        conf.set("mapreduce.cluster.local.dir", localDirs[0].toString());
        Path mapOut = mrOutputFiles.getOutputFileForWrite(1L);
        conf.set("mapreduce.cluster.local.dir", localDirs[1].toString());
        Path mapOutIdx = mrOutputFiles.getOutputIndexFileForWrite(1L);
        Assert.assertNotEquals((String)"Paths must be different!", (Object)mapOut.getParent(), (Object)mapOutIdx.getParent());
        conf.setStrings("mapreduce.cluster.local.dir", localDirs);
        FileContext lfc = FileContext.getLocalFSFileContext((Configuration)conf);
        lfc.create(mapOut, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]).close();
        lfc.create(mapOutIdx, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]).close();
        JobId jobId = MRBuilderUtils.newJobId((long)12345L, (int)1, (int)2);
        TaskId tid = MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.MAP);
        TaskAttemptId taid = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)0);
        LocalContainerLauncher.renameMapOutputForReduce((JobConf)conf, (TaskAttemptId)taid, (MapOutputFile)mrOutputFiles);
    }

    static {
        localDirs = new String[2];
    }
}

