/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.crypto.key.kms.server.KMSMDCFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestKMSMDCFilter {
    private static final String REMOTE_ADDRESS = "192.168.100.100";
    private static final String URL = "/admin";
    private static final String METHOD = "GET";
    private KMSMDCFilter filter;
    private HttpServletRequest httpRequest;
    private HttpServletResponse httpResponse;

    @Before
    public void setUp() throws IOException {
        this.filter = new KMSMDCFilter();
        this.httpRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.httpResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        KMSMDCFilter.setContext(null, null, null, null);
    }

    @Test
    public void testFilter() throws IOException, ServletException {
        Mockito.when((Object)this.httpRequest.getMethod()).thenReturn((Object)METHOD);
        Mockito.when((Object)this.httpRequest.getRequestURL()).thenReturn((Object)new StringBuffer(URL));
        Mockito.when((Object)this.httpRequest.getRemoteAddr()).thenReturn((Object)REMOTE_ADDRESS);
        FilterChain filterChain = new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                Assert.assertEquals((String)"filter.remoteClientAddress", (Object)TestKMSMDCFilter.REMOTE_ADDRESS, (Object)KMSMDCFilter.getRemoteClientAddress());
                Assert.assertEquals((String)"filter.method", (Object)TestKMSMDCFilter.METHOD, (Object)KMSMDCFilter.getMethod());
                Assert.assertEquals((String)"filter.url", (Object)TestKMSMDCFilter.URL, (Object)KMSMDCFilter.getURL());
            }
        };
        this.checkMDCValuesAreEmpty();
        this.filter.doFilter((ServletRequest)this.httpRequest, (ServletResponse)this.httpResponse, filterChain);
        this.checkMDCValuesAreEmpty();
    }

    private void checkMDCValuesAreEmpty() {
        Assert.assertNull((String)"getRemoteClientAddress", (Object)KMSMDCFilter.getRemoteClientAddress());
        Assert.assertNull((String)"getMethod", (Object)KMSMDCFilter.getMethod());
        Assert.assertNull((String)"getURL", (Object)KMSMDCFilter.getURL());
        Assert.assertNull((String)"getUgi", (Object)KMSMDCFilter.getUgi());
    }
}

