/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewerPB;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOfflineImageViewerForStoragePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TestOfflineImageViewerForStoragePolicy.class);
    private static File originalFsimage = null;
    private static File tempDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void createOriginalFSImage() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.namenode.acls.enabled", true);
            conf.setBoolean("dfs.storage.policy.enabled", true);
            File[] nnDirs = MiniDFSCluster.getNameNodeDirectory(MiniDFSCluster.getBaseDirectory(), 0, 0);
            tempDir = nnDirs[0];
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            Path dir = new Path("/dir_wo_sp");
            hdfs.mkdirs(dir);
            dir = new Path("/dir_wo_sp/sub_dir_wo_sp");
            hdfs.mkdirs(dir);
            dir = new Path("/dir_wo_sp/sub_dir_w_sp_allssd");
            hdfs.mkdirs(dir);
            hdfs.setStoragePolicy(dir, "ALL_SSD");
            Path file = new Path("/dir_wo_sp/file_wo_sp");
            try (FSDataOutputStream o = hdfs.create(file);){
                o.write(123);
                o.close();
            }
            file = new Path("/dir_wo_sp/file_w_sp_allssd");
            o = hdfs.create(file);
            try {
                o.write(123);
                o.close();
                hdfs.setStoragePolicy(file, "ALL_SSD");
            }
            finally {
                if (o != null) {
                    o.close();
                }
            }
            dir = new Path("/dir_w_sp_allssd");
            hdfs.mkdirs(dir);
            hdfs.setStoragePolicy(dir, "ALL_SSD");
            dir = new Path("/dir_w_sp_allssd/sub_dir_wo_sp");
            hdfs.mkdirs(dir);
            file = new Path("/dir_w_sp_allssd/file_wo_sp");
            o = hdfs.create(file);
            try {
                o.write(123);
                o.close();
            }
            finally {
                if (o != null) {
                    o.close();
                }
            }
            dir = new Path("/dir_w_sp_allssd/sub_dir_w_sp_hot");
            hdfs.mkdirs(dir);
            hdfs.setStoragePolicy(dir, "HOT");
            hdfs.setSafeMode(SafeModeAction.ENTER, false);
            hdfs.saveNamespace();
            originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (originalFsimage == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
            LOG.debug("original FS image file is " + originalFsimage);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void deleteOriginalFSImage() throws IOException {
        if (originalFsimage != null && originalFsimage.exists()) {
            originalFsimage.delete();
        }
    }

    @Test
    public void testPBDelimitedWriterForStoragePolicy() throws Exception {
        String expected = DFSTestUtil.readResoucePlainFile("testStoragePolicy.csv");
        String result = this.readStoragePolicyFromFsimageFile();
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private String readStoragePolicyFromFsimageFile() throws Exception {
        StringBuilder builder = new StringBuilder();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String delemiter = "\t";
        File delimitedOutput = new File(tempDir, "delimitedOutput");
        if (OfflineImageViewerPB.run((String[])new String[]{"-p", "Delimited", "-i", originalFsimage.getAbsolutePath(), "-o", delimitedOutput.getAbsolutePath(), "-sp"}) != 0) {
            throw new IOException("oiv returned failure creating delimited output with sp.");
        }
        try (FileInputStream input = new FileInputStream(delimitedOutput);
             BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            boolean header = true;
            while ((line = reader.readLine()) != null) {
                String[] fields = line.split(delemiter);
                if (!header) {
                    String path = fields[0];
                    int storagePolicy = Integer.parseInt(fields[12]);
                    builder.append(path).append(",").append(storagePolicy).append("\n");
                }
                header = false;
            }
        }
        return builder.toString();
    }
}

