/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.checker.AsyncChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import org.apache.hadoop.hdfs.server.datanode.checker.DatasetVolumeChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestDatasetVolumeChecker {
    public static final Logger LOG = LoggerFactory.getLogger(TestDatasetVolumeChecker.class);
    @Rule
    public TestName testName = new TestName();
    private final VolumeCheckResult expectedVolumeHealth;
    private static final int NUM_VOLUMES = 2;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (VolumeCheckResult result : VolumeCheckResult.values()) {
            values.add(new Object[]{result});
        }
        values.add(new Object[]{null});
        return values;
    }

    public TestDatasetVolumeChecker(VolumeCheckResult expectedVolumeHealth) {
        this.expectedVolumeHealth = expectedVolumeHealth;
    }

    @Test(timeout=10000L)
    public void testCheckOneVolume() throws Exception {
        LOG.info("Executing {}", (Object)this.testName.getMethodName());
        FsVolumeSpi volume = TestDatasetVolumeChecker.makeVolumes(1, this.expectedVolumeHealth).get(0);
        DatasetVolumeChecker checker = new DatasetVolumeChecker((Configuration)new HdfsConfiguration(), (Timer)new FakeTimer());
        checker.setDelegateChecker((AsyncChecker)new DummyChecker());
        final AtomicLong numCallbackInvocations = new AtomicLong(0L);
        boolean result = checker.checkVolume(volume, new DatasetVolumeChecker.Callback(){

            public void call(Set<FsVolumeSpi> healthyVolumes, Set<FsVolumeSpi> failedVolumes) {
                numCallbackInvocations.incrementAndGet();
                if (TestDatasetVolumeChecker.this.expectedVolumeHealth != null && TestDatasetVolumeChecker.this.expectedVolumeHealth != VolumeCheckResult.FAILED) {
                    Assert.assertThat((Object)healthyVolumes.size(), (Matcher)CoreMatchers.is((Object)1));
                    Assert.assertThat((Object)failedVolumes.size(), (Matcher)CoreMatchers.is((Object)0));
                } else {
                    Assert.assertThat((Object)healthyVolumes.size(), (Matcher)CoreMatchers.is((Object)0));
                    Assert.assertThat((Object)failedVolumes.size(), (Matcher)CoreMatchers.is((Object)1));
                }
            }
        });
        GenericTestUtils.waitFor(() -> numCallbackInvocations.get() > 0L, (long)5L, (long)10000L);
        ((FsVolumeSpi)Mockito.verify((Object)volume, (VerificationMode)Mockito.times((int)1))).check((Object)((FsVolumeSpi.VolumeCheckContext)Mockito.any()));
        if (result) {
            Assert.assertThat((Object)numCallbackInvocations.get(), (Matcher)CoreMatchers.is((Object)1L));
        }
    }

    @Test(timeout=10000L)
    public void testCheckAllVolumes() throws Exception {
        LOG.info("Executing {}", (Object)this.testName.getMethodName());
        List<FsVolumeSpi> volumes = TestDatasetVolumeChecker.makeVolumes(2, this.expectedVolumeHealth);
        FsDatasetSpi<FsVolumeSpi> dataset = TestDatasetVolumeChecker.makeDataset(volumes);
        DatasetVolumeChecker checker = new DatasetVolumeChecker((Configuration)new HdfsConfiguration(), (Timer)new FakeTimer());
        checker.setDelegateChecker((AsyncChecker)new DummyChecker());
        Set failedVolumes = checker.checkAllVolumes(dataset);
        LOG.info("Got back {} failed volumes", (Object)failedVolumes.size());
        if (this.expectedVolumeHealth == null || this.expectedVolumeHealth == VolumeCheckResult.FAILED) {
            Assert.assertThat((Object)failedVolumes.size(), (Matcher)CoreMatchers.is((Object)2));
        } else {
            Assert.assertTrue((boolean)failedVolumes.isEmpty());
        }
        for (FsVolumeSpi volume : volumes) {
            ((FsVolumeSpi)Mockito.verify((Object)volume, (VerificationMode)Mockito.times((int)1))).check((Object)((FsVolumeSpi.VolumeCheckContext)Mockito.any()));
        }
    }

    static FsDatasetSpi<FsVolumeSpi> makeDataset(List<FsVolumeSpi> volumes) throws Exception {
        FsDatasetSpi dataset = (FsDatasetSpi)Mockito.mock(FsDatasetSpi.class);
        FsDatasetSpi.FsVolumeReferences references = new FsDatasetSpi.FsVolumeReferences(volumes);
        Mockito.when((Object)dataset.getFsVolumeReferences()).thenReturn((Object)references);
        return dataset;
    }

    static List<FsVolumeSpi> makeVolumes(int numVolumes, VolumeCheckResult health) throws Exception {
        ArrayList<FsVolumeSpi> volumes = new ArrayList<FsVolumeSpi>(numVolumes);
        for (int i = 0; i < numVolumes; ++i) {
            FsVolumeSpi volume = (FsVolumeSpi)Mockito.mock(FsVolumeSpi.class);
            FsVolumeReference reference = (FsVolumeReference)Mockito.mock(FsVolumeReference.class);
            StorageLocation location = (StorageLocation)Mockito.mock(StorageLocation.class);
            Mockito.when((Object)reference.getVolume()).thenReturn((Object)volume);
            Mockito.when((Object)volume.obtainReference()).thenReturn((Object)reference);
            Mockito.when((Object)volume.getStorageLocation()).thenReturn((Object)location);
            if (health != null) {
                Mockito.when((Object)((VolumeCheckResult)volume.check((Object)((FsVolumeSpi.VolumeCheckContext)Mockito.any())))).thenReturn((Object)health);
            } else {
                DiskChecker.DiskErrorException de = new DiskChecker.DiskErrorException("Fake Exception");
                Mockito.when((Object)((VolumeCheckResult)volume.check((Object)((FsVolumeSpi.VolumeCheckContext)Mockito.any())))).thenThrow(new Throwable[]{de});
            }
            volumes.add(volume);
        }
        return volumes;
    }

    @Test
    public void testInvalidConfigurationValues() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.disk.check.timeout", 0);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.disk.check.timeout - 0 (should be > 0)", () -> new DatasetVolumeChecker((Configuration)conf, (Timer)new FakeTimer()));
        conf.unset("dfs.datanode.disk.check.timeout");
        conf.setInt("dfs.datanode.disk.check.min.gap", -1);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.disk.check.min.gap - -1 (should be >= 0)", () -> new DatasetVolumeChecker((Configuration)conf, (Timer)new FakeTimer()));
        conf.unset("dfs.datanode.disk.check.min.gap");
        conf.setInt("dfs.datanode.disk.check.timeout", -1);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.disk.check.timeout - -1 (should be > 0)", () -> new DatasetVolumeChecker((Configuration)conf, (Timer)new FakeTimer()));
        conf.unset("dfs.datanode.disk.check.timeout");
        conf.setInt("dfs.datanode.failed.volumes.tolerated", -2);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.failed.volumes.tolerated - -2 should be greater than or equal to -1", () -> new DatasetVolumeChecker((Configuration)conf, (Timer)new FakeTimer()));
    }

    static class DummyChecker
    implements AsyncChecker<FsVolumeSpi.VolumeCheckContext, VolumeCheckResult> {
        DummyChecker() {
        }

        public Optional<ListenableFuture<VolumeCheckResult>> schedule(Checkable<FsVolumeSpi.VolumeCheckContext, VolumeCheckResult> target, FsVolumeSpi.VolumeCheckContext context) {
            try {
                return Optional.of(Futures.immediateFuture((Object)((VolumeCheckResult)target.check((Object)context))));
            }
            catch (Exception e) {
                LOG.info("check routine threw exception " + e);
                return Optional.of(Futures.immediateFailedFuture((Throwable)e));
            }
        }

        public void shutdownAndWait(long timeout, TimeUnit timeUnit) throws InterruptedException {
        }
    }
}

