/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.commons.text.CaseUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.UnknownCryptoProtocolVersionException;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.BatchedDirectoryListing;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsPartialListing;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.ECTopologyVerifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.DefaultAuditLogger;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirAclOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirAppendOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirConcatOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirDeleteOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirEncryptionZoneOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirErasureCodingOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirMkdirOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirRenameOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirSatisfyStoragePolicyOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirSnapshotOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirStatAndListingOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirSymlinkOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirTruncateOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirWriteFileOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNDNCacheOp;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystemLock;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.HdfsAuditLogger;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.StandbyCheckpointer;
import org.apache.hadoop.hdfs.server.namenode.metrics.ECBlockGroupsMBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.metrics.ReplicatedBlocksMBean;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.hdfs.server.namenode.top.TopAuditLogger;
import org.apache.hadoop.hdfs.server.namenode.top.TopConf;
import org.apache.hadoop.hdfs.server.namenode.top.metrics.TopMetrics;
import org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindowManager;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.ObserverRetryOnActiveException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Charsets;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@Metrics(context="dfs")
public class FSNamesystem
implements Namesystem,
FSNamesystemMBean,
NameNodeMXBean,
ReplicatedBlocksMBean,
ECBlockGroupsMBean {
    public static final Logger LOG = LoggerFactory.getLogger((String)FSNamesystem.class.getName());
    private final MetricsRegistry registry = new MetricsRegistry("FSNamesystem");
    @Metric
    final MutableRatesWithAggregation detailedLockHoldTimeMetrics = this.registry.newRatesWithAggregation("detailedLockHoldTimeMetrics");
    public static final Log auditLog = LogFactory.getLog((String)(FSNamesystem.class.getName() + ".audit"));
    private final int maxCorruptFileBlocksReturn;
    private final boolean isPermissionEnabled;
    private final boolean isStoragePolicyEnabled;
    private final boolean isStoragePolicySuperuserOnly;
    private final UserGroupInformation fsOwner;
    private final String supergroup;
    private final boolean standbyShouldCheckpoint;
    private final int snapshotDiffReportLimit;
    private final int blockDeletionIncrement;
    private final long leaseRecheckIntervalMs;
    private final long maxLockHoldToReleaseLeaseMs;
    private final int maxListOpenFilesResponses;
    private final boolean allowOwnerSetQuota;
    private static final long DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    final DelegationTokenSecretManager dtSecretManager;
    private final boolean alwaysUseDelegationTokensForTests;
    private static final Step STEP_AWAITING_REPORTED_BLOCKS = new Step(StepType.AWAITING_REPORTED_BLOCKS);
    private final boolean isDefaultAuditLogger;
    private final List<AuditLogger> auditLoggers;
    FSDirectory dir;
    private BlockManager blockManager;
    private final SnapshotManager snapshotManager;
    private final CacheManager cacheManager;
    private final DatanodeStatistics datanodeStatistics;
    private String nameserviceId;
    private volatile RollingUpgradeInfo rollingUpgradeInfo = null;
    private volatile boolean needRollbackFsImage;
    final LeaseManager leaseManager = new LeaseManager(this);
    Daemon nnrmthread = null;
    Daemon nnEditLogRoller = null;
    Daemon lazyPersistFileScrubber = null;
    private final AtomicLong lazyPersistFileScrubberTS = new AtomicLong(0L);
    private ExecutorService edekCacheLoader = null;
    private final int edekCacheLoaderDelay;
    private final int edekCacheLoaderInterval;
    private final long editLogRollerThreshold;
    private final int editLogRollerInterval;
    private final int lazyPersistFileScrubIntervalSec;
    private volatile boolean hasResourcesAvailable = false;
    private volatile boolean fsRunning = true;
    private final long startTime = Time.now();
    private final long resourceRecheckInterval;
    NameNodeResourceChecker nnResourceChecker;
    private final FsServerDefaults serverDefaults;
    private final ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure;
    private final long maxFsObjects;
    private final long minBlockSize;
    final long maxBlocksPerFile;
    private final int batchedListingLimit;
    private final int numCommittedAllowed;
    private final FSNamesystemLock fsLock;
    private final ReentrantLock cpLock;
    private EditLogTailer editLogTailer = null;
    private StandbyCheckpointer standbyCheckpointer;
    private HAContext haContext;
    private final boolean haEnabled;
    private volatile boolean startingActiveService = false;
    private final RetryCache retryCache;
    private KeyProviderCryptoExtension provider = null;
    private volatile boolean imageLoaded = false;
    private final Condition cond;
    private final FSImage fsImage;
    private final TopConf topConf;
    private TopMetrics topMetrics;
    private INodeAttributeProvider inodeAttributeProvider;
    private boolean manualSafeMode = false;
    private boolean resourceLowSafeMode = false;
    private String nameNodeHostName = null;
    private final Object metaSaveLock = new Object();
    private final MessageDigest digest;
    private ObjectName namesystemMBeanName;
    private ObjectName replicatedBlocksMBeanName;
    private ObjectName ecBlockGroupsMBeanName;
    private ObjectName namenodeMXBeanName;

    boolean isAuditEnabled() {
        return (!this.isDefaultAuditLogger || auditLog.isInfoEnabled()) && !this.auditLoggers.isEmpty();
    }

    void logAuditEvent(boolean succeeded, String cmd, String src) throws IOException {
        this.logAuditEvent(succeeded, cmd, src, null, null);
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src, String dst, FileStatus stat) throws IOException {
        if (this.isAuditEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(succeeded, Server.getRemoteUser(), Server.getRemoteIp(), cmd, src, dst, stat);
        }
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src, HdfsFileStatus stat) throws IOException {
        if (!this.isAuditEnabled() || !this.isExternalInvocation()) {
            return;
        }
        FileStatus status = null;
        if (stat != null) {
            Path symlink = stat.isSymlink() ? new Path(DFSUtilClient.bytes2String((byte[])stat.getSymlinkInBytes())) : null;
            Path path = new Path(src);
            status = new FileStatus(stat.getLen(), stat.isDirectory(), (int)stat.getReplication(), stat.getBlockSize(), stat.getModificationTime(), stat.getAccessTime(), stat.getPermission(), stat.getOwner(), stat.getGroup(), symlink, path);
        }
        this.logAuditEvent(succeeded, cmd, src, null, status);
    }

    private void logAuditEvent(boolean succeeded, UserGroupInformation ugi, InetAddress addr, String cmd, String src, String dst, FileStatus status) {
        String ugiStr = ugi.toString();
        for (AuditLogger logger : this.auditLoggers) {
            if (logger instanceof HdfsAuditLogger) {
                HdfsAuditLogger hdfsLogger = (HdfsAuditLogger)logger;
                hdfsLogger.logAuditEvent(succeeded, ugiStr, addr, cmd, src, dst, status, CallerContext.getCurrent(), ugi, this.dtSecretManager);
                continue;
            }
            logger.logAuditEvent(succeeded, ugiStr, addr, cmd, src, dst, status);
        }
    }

    void imageLoadComplete() {
        Preconditions.checkState((!this.imageLoaded ? 1 : 0) != 0, (Object)"FSDirectory already loaded");
        this.setImageLoaded();
    }

    void setImageLoaded() {
        if (this.imageLoaded) {
            return;
        }
        this.writeLock();
        try {
            this.setImageLoaded(true);
            this.dir.markNameCacheInitialized();
            this.cond.signalAll();
        }
        finally {
            this.writeUnlock("setImageLoaded");
        }
    }

    @VisibleForTesting
    boolean isImageLoaded() {
        return this.imageLoaded;
    }

    protected void setImageLoaded(boolean flag) {
        this.imageLoaded = flag;
    }

    void clear() {
        this.dir.reset();
        this.dtSecretManager.reset();
        this.leaseManager.removeAllLeases();
        this.snapshotManager.clearSnapshottableDirs();
        this.cacheManager.clear();
        this.setImageLoaded(false);
        this.blockManager.clear();
        ErasureCodingPolicyManager.getInstance().clear();
    }

    @VisibleForTesting
    LeaseManager getLeaseManager() {
        return this.leaseManager;
    }

    @VisibleForTesting
    public long getLazyPersistFileScrubberTS() {
        return this.lazyPersistFileScrubber == null ? -1L : this.lazyPersistFileScrubberTS.get();
    }

    public boolean isHaEnabled() {
        return this.haEnabled;
    }

    private static void checkConfiguration(Configuration conf) throws IOException {
        Collection<URI> namespaceDirs = FSNamesystem.getNamespaceDirs(conf);
        List<URI> editsDirs = FSNamesystem.getNamespaceEditsDirs(conf);
        Collection<URI> requiredEditsDirs = FSNamesystem.getRequiredNamespaceEditsDirs(conf);
        List<URI> sharedEditsDirs = FSNamesystem.getSharedEditsDirs(conf);
        for (URI u : requiredEditsDirs) {
            if (u.toString().compareTo("file:///tmp/hadoop/dfs/name") == 0 || editsDirs.contains(u) || sharedEditsDirs.contains(u)) continue;
            throw new IllegalArgumentException("Required edits directory " + u + " not found: " + "dfs.namenode.edits.dir" + "=" + editsDirs + "; " + "dfs.namenode.edits.dir.required" + "=" + requiredEditsDirs + "; " + "dfs.namenode.shared.edits.dir" + "=" + sharedEditsDirs);
        }
        if (namespaceDirs.size() == 1) {
            LOG.warn("Only one image storage directory (dfs.namenode.name.dir) configured. Beware of data loss due to lack of redundant storage directories!");
        }
        if (editsDirs.size() == 1) {
            LOG.warn("Only one namespace edits storage directory (dfs.namenode.edits.dir) configured. Beware of data loss due to lack of redundant storage directories!");
        }
    }

    static FSNamesystem loadFromDisk(Configuration conf) throws IOException {
        FSNamesystem.checkConfiguration(conf);
        FSImage fsImage = new FSImage(conf, FSNamesystem.getNamespaceDirs(conf), FSNamesystem.getNamespaceEditsDirs(conf));
        FSNamesystem namesystem = new FSNamesystem(conf, fsImage, false);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.RECOVER) {
            namesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        }
        long loadStart = Time.monotonicNow();
        try {
            namesystem.loadFSImage(startOpt);
        }
        catch (IOException ioe) {
            LOG.warn("Encountered exception loading fsimage", (Throwable)ioe);
            fsImage.close();
            throw ioe;
        }
        long timeTakenToLoadFSImage = Time.monotonicNow() - loadStart;
        LOG.info("Finished loading FSImage in " + timeTakenToLoadFSImage + " msecs");
        NameNodeMetrics nnMetrics = NameNode.getNameNodeMetrics();
        if (nnMetrics != null) {
            nnMetrics.setFsImageLoadTime((int)timeTakenToLoadFSImage);
        }
        namesystem.getFSDirectory().createReservedStatuses(namesystem.getCTime());
        return namesystem;
    }

    FSNamesystem(Configuration conf, FSImage fsImage) throws IOException {
        this(conf, fsImage, false);
    }

    FSNamesystem(Configuration conf, FSImage fsImage, boolean ignoreRetryCache) throws IOException {
        this.provider = DFSUtil.createKeyProviderCryptoExtension(conf);
        LOG.info("KeyProvider: " + this.provider);
        if (conf.getBoolean("dfs.namenode.audit.log.async", false)) {
            LOG.info("Enabling async auditlog");
            FSNamesystem.enableAsyncAuditLog(conf);
        }
        this.fsLock = new FSNamesystemLock(conf, this.detailedLockHoldTimeMetrics);
        this.cond = this.fsLock.newWriteLockCondition();
        this.cpLock = new ReentrantLock();
        this.fsImage = fsImage;
        try {
            DataChecksum.Type checksumType;
            this.resourceRecheckInterval = conf.getLong("dfs.namenode.resource.check.interval", 5000L);
            this.fsOwner = UserGroupInformation.getCurrentUser();
            this.supergroup = conf.get("dfs.permissions.superusergroup", "supergroup");
            this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
            this.isStoragePolicyEnabled = conf.getBoolean("dfs.storage.policy.enabled", true);
            this.isStoragePolicySuperuserOnly = conf.getBoolean("dfs.storage.policy.permissions.superuser-only", false);
            this.snapshotDiffReportLimit = conf.getInt("dfs.namenode.snapshotdiff.listing.limit", 1000);
            LOG.info("fsOwner                = " + this.fsOwner);
            LOG.info("supergroup             = " + this.supergroup);
            LOG.info("isPermissionEnabled    = " + this.isPermissionEnabled);
            LOG.info("isStoragePolicyEnabled = " + this.isStoragePolicyEnabled);
            this.nameserviceId = DFSUtil.getNamenodeNameServiceId(conf);
            this.haEnabled = HAUtil.isHAEnabled(conf, this.nameserviceId);
            if (this.nameserviceId != null) {
                LOG.info("Determined nameservice ID: " + this.nameserviceId);
            }
            LOG.info("HA Enabled: " + this.haEnabled);
            if (!this.haEnabled && HAUtil.usesSharedEditsDir(conf)) {
                LOG.warn("Configured NNs:\n" + DFSUtil.nnAddressesAsString(conf));
                throw new IOException("Invalid configuration: a shared edits dir must not be specified if HA is not enabled.");
            }
            this.blockManager = new BlockManager(this, this.haEnabled, conf);
            this.datanodeStatistics = this.blockManager.getDatanodeManager().getDatanodeStatistics();
            String checksumTypeStr = conf.get("dfs.checksum.type", "CRC32C");
            try {
                checksumType = DataChecksum.Type.valueOf((String)checksumTypeStr);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Invalid checksum type in dfs.checksum.type: " + checksumTypeStr);
            }
            try {
                this.digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Algorithm 'MD5' not found");
            }
            this.serverDefaults = new FsServerDefaults(conf.getLongBytes("dfs.blocksize", 0x8000000L), conf.getInt("dfs.bytes-per-checksum", 512), conf.getInt("dfs.client-write-packet-size", 65536), (short)conf.getInt("dfs.replication", 3), conf.getInt("io.file.buffer.size", 4096), conf.getBoolean("dfs.encrypt.data.transfer", false), conf.getLong("fs.trash.interval", 0L), checksumType, conf.getTrimmed("hadoop.security.key.provider.path", ""), this.blockManager.getStoragePolicySuite().getDefaultPolicy().getId());
            this.maxFsObjects = conf.getLong("dfs.namenode.max.objects", 0L);
            this.minBlockSize = conf.getLongBytes("dfs.namenode.fs-limits.min-block-size", 0x100000L);
            this.maxBlocksPerFile = conf.getLong("dfs.namenode.fs-limits.max-blocks-per-file", 10000L);
            this.batchedListingLimit = conf.getInt("dfs.batched.ls.limit", 100);
            Preconditions.checkArgument((this.batchedListingLimit > 0 ? 1 : 0) != 0, (Object)"dfs.batched.ls.limit must be greater than zero");
            this.numCommittedAllowed = conf.getInt("dfs.namenode.file.close.num-committed-allowed", 0);
            this.maxCorruptFileBlocksReturn = conf.getInt("dfs.namenode.max-corrupt-file-blocks-returned", 100);
            this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get((Configuration)conf);
            this.standbyShouldCheckpoint = conf.getBoolean("dfs.ha.standby.checkpoints", true);
            this.editLogRollerThreshold = (long)(conf.getFloat("dfs.namenode.edit.log.autoroll.multiplier.threshold", 0.5f) * (float)conf.getLong("dfs.namenode.checkpoint.txns", 1000000L));
            this.editLogRollerInterval = conf.getInt("dfs.namenode.edit.log.autoroll.check.interval.ms", 300000);
            this.lazyPersistFileScrubIntervalSec = conf.getInt("dfs.namenode.lazypersist.file.scrub.interval.sec", 300);
            if (this.lazyPersistFileScrubIntervalSec < 0) {
                throw new IllegalArgumentException("dfs.namenode.lazypersist.file.scrub.interval.sec must be zero (for disable) or greater than zero.");
            }
            this.edekCacheLoaderDelay = conf.getInt("dfs.namenode.edekcacheloader.initial.delay.ms", 3000);
            this.edekCacheLoaderInterval = conf.getInt("dfs.namenode.edekcacheloader.interval.ms", 1000);
            this.leaseRecheckIntervalMs = conf.getLong("dfs.namenode.lease-recheck-interval-ms", 2000L);
            Preconditions.checkArgument((this.leaseRecheckIntervalMs > 0L ? 1 : 0) != 0, (Object)"dfs.namenode.lease-recheck-interval-ms must be greater than zero");
            this.maxLockHoldToReleaseLeaseMs = conf.getLong("dfs.namenode.max-lock-hold-to-release-lease-ms", 25L);
            this.alwaysUseDelegationTokensForTests = conf.getBoolean("dfs.namenode.delegation.token.always-use", false);
            this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
            this.dir = new FSDirectory(this, conf);
            this.snapshotManager = new SnapshotManager(conf, this.dir);
            this.cacheManager = new CacheManager(this, conf, this.blockManager);
            ErasureCodingPolicyManager.getInstance().init(conf);
            this.topConf = new TopConf(conf);
            this.auditLoggers = this.initAuditLoggers(conf);
            this.isDefaultAuditLogger = this.auditLoggers.size() == 1 && this.auditLoggers.get(0) instanceof DefaultAuditLogger;
            this.retryCache = ignoreRetryCache ? null : FSNamesystem.initRetryCache(conf);
            Class klass = conf.getClass("dfs.namenode.inode.attributes.provider.class", null, INodeAttributeProvider.class);
            if (klass != null) {
                this.inodeAttributeProvider = (INodeAttributeProvider)ReflectionUtils.newInstance((Class)klass, (Configuration)conf);
                LOG.info("Using INode attribute provider: " + klass.getName());
            }
            this.maxListOpenFilesResponses = conf.getInt("dfs.namenode.list.openfiles.num.responses", 1000);
            Preconditions.checkArgument((this.maxListOpenFilesResponses > 0 ? 1 : 0) != 0, (Object)"dfs.namenode.list.openfiles.num.responses must be a positive integer.");
            this.allowOwnerSetQuota = conf.getBoolean("dfs.permissions.allow.owner.set.quota", false);
            this.blockDeletionIncrement = conf.getInt("dfs.namenode.block.deletion.increment", 1000);
            Preconditions.checkArgument((this.blockDeletionIncrement > 0 ? 1 : 0) != 0, (Object)"dfs.namenode.block.deletion.increment must be a positive integer.");
        }
        catch (IOException e) {
            LOG.error(this.getClass().getSimpleName() + " initialization failed.", (Throwable)e);
            this.close();
            throw e;
        }
        catch (RuntimeException re) {
            LOG.error(this.getClass().getSimpleName() + " initialization failed.", (Throwable)re);
            this.close();
            throw re;
        }
    }

    @VisibleForTesting
    public List<AuditLogger> getAuditLoggers() {
        return this.auditLoggers;
    }

    @VisibleForTesting
    public RetryCache getRetryCache() {
        return this.retryCache;
    }

    @VisibleForTesting
    public long getLeaseRecheckIntervalMs() {
        return this.leaseRecheckIntervalMs;
    }

    @VisibleForTesting
    public long getMaxLockHoldToReleaseLeaseMs() {
        return this.maxLockHoldToReleaseLeaseMs;
    }

    public int getMaxListOpenFilesResponses() {
        return this.maxListOpenFilesResponses;
    }

    void lockRetryCache() {
        if (this.retryCache != null) {
            this.retryCache.lock();
        }
    }

    void unlockRetryCache() {
        if (this.retryCache != null) {
            this.retryCache.unlock();
        }
    }

    boolean hasRetryCache() {
        return this.retryCache != null;
    }

    void addCacheEntryWithPayload(byte[] clientId, int callId, Object payload) {
        if (this.retryCache != null) {
            this.retryCache.addCacheEntryWithPayload(clientId, callId, payload);
        }
    }

    void addCacheEntry(byte[] clientId, int callId) {
        if (this.retryCache != null) {
            this.retryCache.addCacheEntry(clientId, callId);
        }
    }

    @VisibleForTesting
    public KeyProviderCryptoExtension getProvider() {
        return this.provider;
    }

    @VisibleForTesting
    static RetryCache initRetryCache(Configuration conf) {
        boolean enable = conf.getBoolean("dfs.namenode.enable.retrycache", true);
        LOG.info("Retry cache on namenode is " + (enable ? "enabled" : "disabled"));
        if (enable) {
            float heapPercent = conf.getFloat("dfs.namenode.retrycache.heap.percent", 0.03f);
            long entryExpiryMillis = conf.getLong("dfs.namenode.retrycache.expirytime.millis", 600000L);
            LOG.info("Retry cache will use " + heapPercent + " of total heap and retry cache entry expiry time is " + entryExpiryMillis + " millis");
            long entryExpiryNanos = entryExpiryMillis * 1000L * 1000L;
            return new RetryCache("NameNodeRetryCache", (double)heapPercent, entryExpiryNanos);
        }
        return null;
    }

    void setCallerContextEnabled(boolean value) {
        for (AuditLogger logger : this.auditLoggers) {
            if (!(logger instanceof DefaultAuditLogger)) continue;
            ((DefaultAuditLogger)logger).setCallerContextEnabled(value);
            break;
        }
    }

    boolean getCallerContextEnabled() {
        for (AuditLogger logger : this.auditLoggers) {
            if (!(logger instanceof DefaultAuditLogger)) continue;
            return ((DefaultAuditLogger)logger).getCallerContextEnabled();
        }
        return false;
    }

    private List<AuditLogger> initAuditLoggers(Configuration conf) {
        Collection alClasses = conf.getTrimmedStringCollection("dfs.namenode.audit.loggers");
        ArrayList auditLoggers = Lists.newArrayList();
        boolean topAuditLoggerAdded = false;
        if (alClasses != null && !alClasses.isEmpty()) {
            for (String className : alClasses) {
                try {
                    AuditLogger logger;
                    if ("default".equals(className)) {
                        logger = new FSNamesystemAuditLogger();
                    } else {
                        logger = (AuditLogger)Class.forName(className).newInstance();
                        if (TopAuditLogger.class.getName().equals(logger.getClass().getName())) {
                            topAuditLoggerAdded = true;
                        }
                    }
                    logger.initialize(conf);
                    auditLoggers.add(logger);
                }
                catch (InstantiationException e) {
                    LOG.error("{} instantiation failed.", (Object)className, (Object)e);
                    throw new RuntimeException(e);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (auditLoggers.isEmpty()) {
            FSNamesystemAuditLogger fsNamesystemAuditLogger = new FSNamesystemAuditLogger();
            fsNamesystemAuditLogger.initialize(conf);
            auditLoggers.add(fsNamesystemAuditLogger);
        }
        if (this.topConf.isEnabled && !topAuditLoggerAdded) {
            this.topMetrics = new TopMetrics(conf, this.topConf.nntopReportingPeriodsMs);
            if (DefaultMetricsSystem.instance().getSource("NNTopUserOpCounts") == null) {
                DefaultMetricsSystem.instance().register("NNTopUserOpCounts", "Top N operations by user", (Object)this.topMetrics);
            }
            auditLoggers.add(new TopAuditLogger(this.topMetrics));
        }
        return Collections.unmodifiableList(auditLoggers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFSImage(HdfsServerConstants.StartupOption startOpt) throws IOException {
        FSImage fsImage = this.getFSImage();
        if (startOpt == HdfsServerConstants.StartupOption.FORMAT) {
            fsImage.format(this, fsImage.getStorage().determineClusterId(), false);
            startOpt = HdfsServerConstants.StartupOption.REGULAR;
        }
        boolean success = false;
        this.writeLock();
        try {
            MetaRecoveryContext recovery = startOpt.createRecoveryContext();
            boolean staleImage = fsImage.recoverTransitionRead(startOpt, this, recovery);
            if (HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK.matches(startOpt)) {
                this.rollingUpgradeInfo = null;
            }
            boolean needToSave = staleImage && !this.haEnabled && !this.isRollingUpgrade();
            LOG.info("Need to save fs image? " + needToSave + " (staleImage=" + staleImage + ", haEnabled=" + this.haEnabled + ", isRollingUpgrade=" + this.isRollingUpgrade() + ")");
            if (needToSave) {
                fsImage.saveNamespace(this);
            } else {
                StartupProgress prog = NameNode.getStartupProgress();
                prog.beginPhase(Phase.SAVING_CHECKPOINT);
                prog.endPhase(Phase.SAVING_CHECKPOINT);
            }
            if (!this.haEnabled || this.haEnabled && startOpt == HdfsServerConstants.StartupOption.UPGRADE || this.haEnabled && startOpt == HdfsServerConstants.StartupOption.UPGRADEONLY) {
                fsImage.openEditLogForWrite(this.getEffectiveLayoutVersion());
            }
            success = true;
        }
        finally {
            if (!success) {
                fsImage.close();
            }
            this.writeUnlock("loadFSImage", true);
        }
        this.imageLoadComplete();
    }

    private void startSecretManager() {
        if (this.dtSecretManager != null) {
            try {
                this.dtSecretManager.startThreads();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void startSecretManagerIfNecessary() {
        assert (this.hasWriteLock()) : "Starting secret manager needs write lock";
        boolean shouldRun = this.shouldUseDelegationTokens() && !this.isInSafeMode() && this.getEditLog().isOpenForWrite();
        boolean running = this.dtSecretManager.isRunning();
        if (shouldRun && !running) {
            this.startSecretManager();
        }
    }

    private void stopSecretManager() {
        if (this.dtSecretManager != null) {
            this.dtSecretManager.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCommonServices(Configuration conf, HAContext haContext) throws IOException {
        this.registerMBean();
        this.writeLock();
        this.haContext = haContext;
        try {
            this.nnResourceChecker = new NameNodeResourceChecker(conf);
            this.checkAvailableResources();
            assert (!this.blockManager.isPopulatingReplQueues());
            StartupProgress prog = NameNode.getStartupProgress();
            prog.beginPhase(Phase.SAFEMODE);
            long completeBlocksTotal = this.getCompleteBlocksTotal();
            prog.setTotal(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS, completeBlocksTotal);
            this.blockManager.activate(conf, completeBlocksTotal);
        }
        finally {
            this.writeUnlock("startCommonServices");
        }
        this.registerMXBean();
        DefaultMetricsSystem.instance().register((Object)this);
        if (this.inodeAttributeProvider != null) {
            this.inodeAttributeProvider.start();
            this.dir.setINodeAttributeProvider(this.inodeAttributeProvider);
        }
        this.snapshotManager.registerMXBean();
        InetSocketAddress serviceAddress = NameNode.getServiceAddress(conf, true);
        this.nameNodeHostName = serviceAddress != null ? serviceAddress.getHostName() : "";
    }

    void stopCommonServices() {
        this.writeLock();
        if (this.inodeAttributeProvider != null) {
            this.dir.setINodeAttributeProvider(null);
            this.inodeAttributeProvider.stop();
        }
        try {
            if (this.blockManager != null) {
                this.blockManager.close();
            }
        }
        finally {
            this.writeUnlock("stopCommonServices");
        }
        RetryCache.clear((RetryCache)this.retryCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startActiveServices() throws IOException {
        this.startingActiveService = true;
        LOG.info("Starting services required for active state");
        this.writeLock();
        try {
            FSEditLog editLog = this.getFSImage().getEditLog();
            if (!editLog.isOpenForWrite()) {
                editLog.initJournalsForWrite();
                editLog.recoverUnclosedStreams();
                LOG.info("Catching up to latest edits from old active before taking over writer role in edits logs");
                this.editLogTailer.catchupDuringFailover();
                this.blockManager.setPostponeBlocksFromFuture(false);
                this.blockManager.getDatanodeManager().markAllDatanodesStale();
                this.blockManager.clearQueues();
                this.blockManager.processAllPendingDNMessages();
                this.blockManager.getBlockIdManager().applyImpendingGenerationStamp();
                if (!this.isInSafeMode()) {
                    LOG.info("Reprocessing replication and invalidation queues");
                    this.blockManager.initializeReplQueues();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("NameNode metadata after re-processing replication and invalidation queues during failover:\n" + this.metaSaveAsString());
                }
                long nextTxId = this.getFSImage().getLastAppliedTxId() + 1L;
                LOG.info("Will take over writing edit logs at txnid " + nextTxId);
                editLog.setNextTxId(nextTxId);
                this.getFSImage().editLog.openForWrite(this.getEffectiveLayoutVersion());
            }
            this.dir.updateCountForQuota();
            this.dir.enableQuotaChecks();
            this.dir.ezManager.startReencryptThreads();
            if (this.haEnabled) {
                this.leaseManager.renewAllLeases();
            }
            this.leaseManager.startMonitor();
            this.startSecretManagerIfNecessary();
            this.nnrmthread = new Daemon((Runnable)new NameNodeResourceMonitor());
            this.nnrmthread.start();
            this.nnEditLogRoller = new Daemon((Runnable)new NameNodeEditLogRoller(this.editLogRollerThreshold, this.editLogRollerInterval));
            this.nnEditLogRoller.start();
            if (this.lazyPersistFileScrubIntervalSec > 0) {
                this.lazyPersistFileScrubber = new Daemon((Runnable)new LazyPersistFileScrubber(this.lazyPersistFileScrubIntervalSec));
                this.lazyPersistFileScrubber.start();
            } else {
                LOG.warn("Lazy persist file scrubber is disabled, configured scrub interval is zero.");
            }
            this.cacheManager.startMonitorThread();
            this.blockManager.getDatanodeManager().setShouldSendCachingCommands(true);
            if (this.provider != null) {
                this.edekCacheLoader = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Warm Up EDEK Cache Thread #%d").build());
                FSDirEncryptionZoneOp.warmUpEdekCache(this.edekCacheLoader, this.dir, this.edekCacheLoaderDelay, this.edekCacheLoaderInterval);
            }
            if (this.blockManager.getSPSManager() != null) {
                this.blockManager.getSPSManager().start();
            }
        }
        finally {
            this.startingActiveService = false;
            this.blockManager.checkSafeMode();
            this.writeUnlock("startActiveServices");
        }
    }

    private boolean inActiveState() {
        return this.haContext != null && this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE;
    }

    @Override
    public boolean inTransitionToActive() {
        return this.haEnabled && this.inActiveState() && this.startingActiveService;
    }

    private boolean shouldUseDelegationTokens() {
        return UserGroupInformation.isSecurityEnabled() || this.alwaysUseDelegationTokensForTests;
    }

    void stopActiveServices() {
        LOG.info("Stopping services started for active state");
        this.writeLock();
        try {
            if (this.blockManager != null) {
                this.blockManager.stopReconstructionInitializer();
                if (this.blockManager.getSPSManager() != null) {
                    this.blockManager.getSPSManager().stop();
                }
            }
            this.stopSecretManager();
            this.leaseManager.stopMonitor();
            if (this.nnrmthread != null) {
                ((NameNodeResourceMonitor)this.nnrmthread.getRunnable()).stopMonitor();
                this.nnrmthread.interrupt();
            }
            if (this.edekCacheLoader != null) {
                this.edekCacheLoader.shutdownNow();
            }
            if (this.nnEditLogRoller != null) {
                ((NameNodeEditLogRoller)this.nnEditLogRoller.getRunnable()).stop();
                this.nnEditLogRoller.interrupt();
            }
            if (this.lazyPersistFileScrubber != null) {
                ((LazyPersistFileScrubber)this.lazyPersistFileScrubber.getRunnable()).stop();
                this.lazyPersistFileScrubber.interrupt();
            }
            if (this.dir != null && this.getFSImage() != null) {
                if (this.getFSImage().editLog != null) {
                    this.getFSImage().editLog.close();
                }
                this.getFSImage().updateLastAppliedTxIdFromWritten();
            }
            if (this.dir != null) {
                this.dir.ezManager.stopReencryptThread();
            }
            if (this.cacheManager != null) {
                this.cacheManager.stopMonitorThread();
                this.cacheManager.clearDirectiveStats();
            }
            if (this.blockManager != null) {
                this.blockManager.getDatanodeManager().clearPendingCachingCommands();
                this.blockManager.getDatanodeManager().setShouldSendCachingCommands(false);
                this.blockManager.clearQueues();
                this.blockManager.setInitializedReplQueues(false);
            }
        }
        finally {
            this.writeUnlock("stopActiveServices");
        }
    }

    void startStandbyServices(Configuration conf, boolean isObserver) throws IOException {
        LOG.info("Starting services required for " + (isObserver ? "observer" : "standby") + " state");
        if (!this.getFSImage().editLog.isOpenForRead()) {
            this.getFSImage().editLog.initSharedJournalsForRead();
        }
        this.blockManager.setPostponeBlocksFromFuture(true);
        this.dir.disableQuotaChecks();
        this.editLogTailer = new EditLogTailer(this, conf);
        this.editLogTailer.start();
        if (!isObserver && this.standbyShouldCheckpoint) {
            this.standbyCheckpointer = new StandbyCheckpointer(conf, this);
            this.standbyCheckpointer.start();
        }
    }

    void triggerRollbackCheckpoint() {
        this.setNeedRollbackFsImage(true);
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.triggerRollbackCheckpoint();
        }
    }

    void prepareToStopStandbyServices() throws ServiceFailedException {
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.cancelAndPreventCheckpoints("About to leave standby state");
        }
    }

    void stopStandbyServices() throws IOException {
        HAServiceProtocol.HAServiceState curState = this.getState() == HAServiceProtocol.HAServiceState.OBSERVER ? HAServiceProtocol.HAServiceState.OBSERVER : HAServiceProtocol.HAServiceState.STANDBY;
        LOG.info("Stopping services started for {} state", (Object)curState);
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.stop();
        }
        if (this.editLogTailer != null) {
            this.editLogTailer.stop();
        }
        if (this.dir != null && this.getFSImage() != null && this.getFSImage().editLog != null) {
            this.getFSImage().editLog.close();
        }
    }

    public void checkOperation(NameNode.OperationCategory op) throws StandbyException {
        if (this.haContext != null) {
            this.haContext.checkOperation(op);
        }
    }

    void checkNameNodeSafeMode(String errorMsg) throws RetriableException, SafeModeException {
        if (this.isInSafeMode()) {
            SafeModeException se = this.newSafemodeException(errorMsg);
            if (this.haEnabled && this.haContext != null && this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE && this.isInStartupSafeMode()) {
                throw new RetriableException((Exception)((Object)se));
            }
            throw se;
        }
    }

    private SafeModeException newSafemodeException(String errorMsg) {
        return new SafeModeException(errorMsg + ". Name node is in safe mode.\n" + this.getSafeModeTip() + " NamenodeHostName:" + this.nameNodeHostName);
    }

    boolean isPermissionEnabled() {
        return this.isPermissionEnabled;
    }

    public static Collection<URI> getNamespaceDirs(Configuration conf) {
        return FSNamesystem.getStorageDirs(conf, "dfs.namenode.name.dir");
    }

    public static Collection<URI> getRequiredNamespaceEditsDirs(Configuration conf) {
        HashSet<URI> ret = new HashSet<URI>();
        ret.addAll(FSNamesystem.getStorageDirs(conf, "dfs.namenode.edits.dir.required"));
        ret.addAll(FSNamesystem.getSharedEditsDirs(conf));
        return ret;
    }

    private static Collection<URI> getStorageDirs(Configuration conf, String propertyName) {
        List<String> dirNames = conf.getTrimmedStringCollection(propertyName);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.IMPORT) {
            HdfsConfiguration cE = new HdfsConfiguration(false);
            cE.addResource("core-default.xml");
            cE.addResource("core-site.xml");
            cE.addResource("hdfs-default.xml");
            Collection dirNames2 = cE.getTrimmedStringCollection(propertyName);
            dirNames.removeAll(dirNames2);
            if (dirNames.isEmpty()) {
                LOG.warn("!!! WARNING !!!\n\tThe NameNode currently runs without persistent storage.\n\tAny changes to the file system meta-data may be lost.\n\tRecommended actions:\n\t\t- shutdown and restart NameNode with configured \"" + propertyName + "\" in hdfs-site.xml;\n\t\t- use Backup Node as a persistent and up-to-date storage of the file system meta-data.");
            }
        } else if (dirNames.isEmpty()) {
            dirNames = Collections.singletonList("file:///tmp/hadoop/dfs/name");
        }
        return Util.stringCollectionAsURIs((Collection<String>)dirNames);
    }

    public static List<URI> getNamespaceEditsDirs(Configuration conf) throws IOException {
        return FSNamesystem.getNamespaceEditsDirs(conf, true);
    }

    public static List<URI> getNamespaceEditsDirs(Configuration conf, boolean includeShared) throws IOException {
        LinkedHashSet<URI> editsDirs = new LinkedHashSet<URI>();
        if (includeShared) {
            List<URI> sharedDirs = FSNamesystem.getSharedEditsDirs(conf);
            if (sharedDirs.size() > 1) {
                throw new IOException("Multiple shared edits directories are not yet supported");
            }
            for (URI dir : sharedDirs) {
                if (editsDirs.add(dir)) continue;
                LOG.warn("Edits URI " + dir + " listed multiple times in " + "dfs.namenode.shared.edits.dir" + ". Ignoring duplicates.");
            }
        }
        for (URI dir : FSNamesystem.getStorageDirs(conf, "dfs.namenode.edits.dir")) {
            if (editsDirs.add(dir)) continue;
            LOG.warn("Edits URI " + dir + " listed multiple times in " + "dfs.namenode.shared.edits.dir" + " and " + "dfs.namenode.edits.dir" + ". Ignoring duplicates.");
        }
        if (editsDirs.isEmpty()) {
            return Lists.newArrayList(FSNamesystem.getNamespaceDirs(conf));
        }
        return Lists.newArrayList(editsDirs);
    }

    public static List<URI> getSharedEditsDirs(Configuration conf) {
        Collection dirNames = conf.getTrimmedStringCollection("dfs.namenode.shared.edits.dir");
        return Util.stringCollectionAsURIs(dirNames);
    }

    @Override
    public void readLock() {
        this.fsLock.readLock();
    }

    @Override
    public void readLockInterruptibly() throws InterruptedException {
        this.fsLock.readLockInterruptibly();
    }

    @Override
    public void readUnlock() {
        this.fsLock.readUnlock();
    }

    public void readUnlock(String opName) {
        this.fsLock.readUnlock(opName);
    }

    @Override
    public void writeLock() {
        this.fsLock.writeLock();
    }

    @Override
    public void writeLockInterruptibly() throws InterruptedException {
        this.fsLock.writeLockInterruptibly();
    }

    @Override
    public void writeUnlock() {
        this.fsLock.writeUnlock();
    }

    public void writeUnlock(String opName) {
        this.fsLock.writeUnlock(opName);
    }

    public void writeUnlock(String opName, boolean suppressWriteLockReport) {
        this.fsLock.writeUnlock(opName, suppressWriteLockReport);
    }

    @Override
    public boolean hasWriteLock() {
        return this.fsLock.isWriteLockedByCurrentThread();
    }

    @Override
    public boolean hasReadLock() {
        return this.fsLock.getReadHoldCount() > 0 || this.hasWriteLock();
    }

    public int getReadHoldCount() {
        return this.fsLock.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.fsLock.getWriteHoldCount();
    }

    public void cpLock() {
        this.cpLock.lock();
    }

    public void cpLockInterruptibly() throws InterruptedException {
        this.cpLock.lockInterruptibly();
    }

    public void cpUnlock() {
        this.cpLock.unlock();
    }

    NamespaceInfo getNamespaceInfo() {
        this.readLock();
        try {
            NamespaceInfo namespaceInfo = this.unprotectedGetNamespaceInfo();
            return namespaceInfo;
        }
        finally {
            this.readUnlock("getNamespaceInfo");
        }
    }

    @VisibleForTesting
    long getCTime() {
        return this.fsImage == null ? 0L : this.fsImage.getStorage().getCTime();
    }

    NamespaceInfo unprotectedGetNamespaceInfo() {
        return new NamespaceInfo(this.getFSImage().getStorage().getNamespaceID(), this.getClusterId(), this.getBlockPoolId(), this.getFSImage().getStorage().getCTime(), this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void close() {
        this.fsRunning = false;
        try {
            this.stopCommonServices();
        }
        catch (Throwable throwable) {
            block9: {
                try {
                    this.stopActiveServices();
                    this.stopStandbyServices();
                }
                catch (IOException iOException) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.dir});
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.fsImage});
                    break block9;
                    catch (Throwable throwable2) {
                        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.dir});
                        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.fsImage});
                        throw throwable2;
                    }
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.dir});
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.fsImage});
            }
            throw throwable;
        }
        try {
            this.stopActiveServices();
            this.stopStandbyServices();
        }
        catch (IOException iOException) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.dir});
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.fsImage});
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.dir});
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.fsImage});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.dir});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.fsImage});
    }

    @Override
    public boolean isRunning() {
        return this.fsRunning;
    }

    public boolean isInStandbyState() {
        if (this.haContext == null || this.haContext.getState() == null) {
            return this.haEnabled;
        }
        return HAServiceProtocol.HAServiceState.STANDBY == this.haContext.getState().getServiceState() || HAServiceProtocol.HAServiceState.OBSERVER == this.haContext.getState().getServiceState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlocksWithLocations getBlocks(DatanodeID datanode, long size, long minimumBlockSize) throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            BlocksWithLocations blocksWithLocations = this.getBlockManager().getBlocksWithLocations(datanode, size, minimumBlockSize);
            return blocksWithLocations;
        }
        finally {
            this.readUnlock("getBlocks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(String filename) throws IOException {
        String operationName = "metaSave";
        this.checkSuperuserPrivilege(operationName);
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            Object object = this.metaSaveLock;
            synchronized (object) {
                File file = new File(System.getProperty("hadoop.log.dir"), filename);
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), Charsets.UTF_8)));
                this.metaSave(out);
                out.flush();
                out.close();
            }
        }
        finally {
            this.readUnlock(operationName);
        }
        this.logAuditEvent(true, operationName, null);
    }

    private void metaSave(PrintWriter out) {
        assert (this.hasReadLock());
        long totalInodes = this.dir.totalInodes();
        long totalBlocks = this.getBlocksTotal();
        out.println(totalInodes + " files and directories, " + totalBlocks + " blocks = " + (totalInodes + totalBlocks) + " total filesystem objects");
        this.blockManager.metaSave(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<OpenFileEntry> listOpenFiles(long prevId, EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes, String path) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<OpenFileEntry> batchedListEntries;
        block7: {
            INode.checkAbsolutePath(path);
            String operationName = "listOpenFiles";
            this.checkSuperuserPrivilege();
            this.checkOperation(NameNode.OperationCategory.READ);
            String normalizedPath = new Path(path).toString();
            try {
                this.readLock();
                try {
                    this.checkOperation(NameNode.OperationCategory.READ);
                    if (openFilesTypes.contains(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES)) {
                        batchedListEntries = this.leaseManager.getUnderConstructionFiles(prevId, normalizedPath);
                        break block7;
                    }
                    if (openFilesTypes.contains(OpenFilesIterator.OpenFilesType.BLOCKING_DECOMMISSION)) {
                        batchedListEntries = this.getFilesBlockingDecom(prevId, normalizedPath);
                        break block7;
                    }
                    throw new IllegalArgumentException("Unknown OpenFileType: " + openFilesTypes);
                }
                finally {
                    this.readUnlock("listOpenFiles");
                }
            }
            catch (AccessControlException e) {
                this.logAuditEvent(false, "listOpenFiles", null);
                throw e;
            }
        }
        this.logAuditEvent(true, "listOpenFiles", null);
        return batchedListEntries;
    }

    public BatchedRemoteIterator.BatchedListEntries<OpenFileEntry> getFilesBlockingDecom(long prevId, String path) {
        assert (this.hasReadLock());
        ArrayList openFileEntries = Lists.newArrayList();
        LightWeightHashSet<Long> openFileIds = new LightWeightHashSet<Long>();
        for (DatanodeDescriptor dataNode : this.blockManager.getDatanodeManager().getDatanodes()) {
            LightWeightHashSet<Long> dnOpenFiles = dataNode.getLeavingServiceStatus().getOpenFiles();
            Long[] dnOpenFileIds = new Long[dnOpenFiles.size()];
            Arrays.sort((Object[])dnOpenFiles.toArray((U[])dnOpenFileIds));
            for (Long ucFileId : dnOpenFileIds) {
                INode ucFile = this.getFSDirectory().getInode(ucFileId);
                if (ucFile == null || ucFileId <= prevId || openFileIds.contains(ucFileId)) continue;
                Preconditions.checkState((boolean)(ucFile instanceof INodeFile));
                INodeFile inodeFile = ucFile.asFile();
                if (!inodeFile.isUnderConstruction()) {
                    LOG.warn("The file {} is not under construction but has lease.", (Object)inodeFile.getFullPathName());
                    continue;
                }
                openFileIds.add(ucFileId);
                String fullPathName = inodeFile.getFullPathName();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)path) || DFSUtil.isParentEntry(fullPathName, path)) {
                    openFileEntries.add(new OpenFileEntry(inodeFile.getId(), inodeFile.getFullPathName(), inodeFile.getFileUnderConstructionFeature().getClientName(), inodeFile.getFileUnderConstructionFeature().getClientMachine()));
                }
                if (openFileIds.size() < this.maxListOpenFilesResponses) continue;
                return new BatchedRemoteIterator.BatchedListEntries((List)openFileEntries, true);
            }
        }
        return new BatchedRemoteIterator.BatchedListEntries((List)openFileEntries, false);
    }

    private String metaSaveAsString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.metaSave(pw);
        pw.flush();
        return sw.toString();
    }

    @VisibleForTesting
    public FsServerDefaults getServerDefaults() throws StandbyException {
        this.checkOperation(NameNode.OperationCategory.READ);
        return this.serverDefaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPermission(String src, FsPermission permission) throws IOException {
        FileStatus auditStat;
        String operationName = "setPermission";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("setPermission");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot set permission for " + src);
                auditStat = FSDirAttrOp.setPermission(this.dir, pc, src, permission);
            }
            finally {
                this.writeUnlock("setPermission");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setPermission", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setPermission", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwner(String src, String username, String group) throws IOException {
        FileStatus auditStat;
        String operationName = "setOwner";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("setOwner");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot set owner for " + src);
                auditStat = FSDirAttrOp.setOwner(this.dir, pc, src, username, group);
            }
            finally {
                this.writeUnlock("setOwner");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setOwner", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setOwner", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlocks getBlockLocations(String clientMachine, String srcArg, long offset, long length) throws IOException {
        INode inode;
        String operationName = "open";
        this.checkOperation(NameNode.OperationCategory.READ);
        FSDirStatAndListingOp.GetBlockLocationsResult res = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("open");
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                res = FSDirStatAndListingOp.getBlockLocations(this.dir, pc, srcArg, offset, length, true);
                inode = res.getIIp().getLastINode();
                if (this.isInSafeMode()) {
                    for (LocatedBlock b : res.blocks.getLocatedBlocks()) {
                        if (b.getLocations() != null && b.getLocations().length != 0) continue;
                        SafeModeException se = this.newSafemodeException("Zero blocklocations for " + srcArg);
                        if (this.haEnabled && this.haContext != null && (this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE || this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.OBSERVER)) {
                            throw new RetriableException((Exception)((Object)se));
                        }
                        throw se;
                    }
                } else if (this.haEnabled && this.haContext != null && this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.OBSERVER) {
                    for (LocatedBlock b : res.blocks.getLocatedBlocks()) {
                        if (b.getLocations() != null && b.getLocations().length != 0) continue;
                        throw new ObserverRetryOnActiveException("Zero blocklocations for " + srcArg);
                    }
                }
            }
            finally {
                this.readUnlock("open");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "open", srcArg);
            throw e;
        }
        this.logAuditEvent(true, "open", srcArg);
        if (!this.isInSafeMode() && res.updateAccessTime()) {
            String src = srcArg;
            this.checkOperation(NameNode.OperationCategory.WRITE);
            try {
                this.writeLock();
                long now = Time.now();
                try {
                    INodesInPath iip;
                    boolean changed;
                    boolean updateAccessTime;
                    this.checkOperation(NameNode.OperationCategory.WRITE);
                    boolean bl = updateAccessTime = now > inode.getAccessTime() + this.dir.getAccessTimePrecision();
                    if (!this.isInSafeMode() && updateAccessTime && !inode.isDeleted() && (changed = FSDirAttrOp.setTimes(this.dir, iip = this.dir.resolvePath(pc, src = inode.getFullPathName(), FSDirectory.DirOp.READ), -1L, now, false))) {
                        this.getEditLog().logTimes(src, -1L, now);
                    }
                }
                finally {
                    this.writeUnlock("open");
                }
            }
            catch (Throwable e) {
                LOG.warn("Failed to update the access time of " + src, e);
            }
        }
        LocatedBlocks blocks = res.blocks;
        this.sortLocatedBlocks(clientMachine, blocks);
        return blocks;
    }

    private void sortLocatedBlocks(String clientMachine, LocatedBlocks blocks) {
        if (blocks != null) {
            List blkList = blocks.getLocatedBlocks();
            if (blkList == null || blkList.size() == 0) {
                return;
            }
            this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, blkList);
            LocatedBlock lastBlock = blocks.getLastLocatedBlock();
            if (lastBlock != null) {
                ArrayList lastBlockList = Lists.newArrayList((Object[])new LocatedBlock[]{lastBlock});
                this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, lastBlockList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void concat(String target, String[] srcs, boolean logRetryCache) throws IOException {
        String operationName = "concat";
        FileStatus stat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("concat");
        this.checkOperation(NameNode.OperationCategory.WRITE);
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot concat " + target);
                stat = FSDirConcatOp.concat(this.dir, pc, target, srcs, logRetryCache);
            }
            finally {
                this.writeUnlock("concat");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "concat", Arrays.toString(srcs), target, stat);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "concat", Arrays.toString(srcs), target, stat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimes(String src, long mtime, long atime) throws IOException {
        FileStatus auditStat;
        String operationName = "setTimes";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("setTimes");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot set times " + src);
                auditStat = FSDirAttrOp.setTimes(this.dir, pc, src, mtime, atime);
            }
            finally {
                this.writeUnlock("setTimes");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setTimes", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setTimes", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean truncate(String src, long newLength, String clientName, String clientMachine, long mtime) throws IOException, UnresolvedLinkException {
        FSDirTruncateOp.TruncateResult r;
        String operationName = "truncate";
        this.requireEffectiveLayoutVersionForFeature(NameNodeLayoutVersion.Feature.TRUNCATE);
        try {
            NameNode.stateChangeLog.debug("DIR* NameSystem.truncate: src={} newLength={}", (Object)src, (Object)newLength);
            if (newLength < 0L) {
                throw new HadoopIllegalArgumentException("Cannot truncate to a negative file size: " + newLength + ".");
            }
            this.checkOperation(NameNode.OperationCategory.WRITE);
            FSPermissionChecker pc = this.getPermissionChecker();
            FSPermissionChecker.setOperationType("truncate");
            this.writeLock();
            INode.BlocksMapUpdateInfo toRemoveBlocks = new INode.BlocksMapUpdateInfo();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot truncate for " + src);
                r = FSDirTruncateOp.truncate(this, src, newLength, clientName, clientMachine, mtime, toRemoveBlocks, pc);
            }
            finally {
                this.writeUnlock("truncate");
            }
            this.getEditLog().logSync();
            if (!toRemoveBlocks.getToDeleteList().isEmpty()) {
                this.blockManager.addBLocksToMarkedDeleteQueue(toRemoveBlocks.getToDeleteList());
            }
            this.logAuditEvent(true, "truncate", src, null, r.getFileStatus());
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "truncate", src);
            throw e;
        }
        return r.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSymlink(String target, String link, PermissionStatus dirPerms, boolean createParent, boolean logRetryCache) throws IOException {
        String operationName = "createSymlink";
        if (!FileSystem.areSymlinksEnabled()) {
            throw new UnsupportedOperationException("Symlinks not supported");
        }
        FileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker.setOperationType("createSymlink");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot create symlink " + link);
                auditStat = FSDirSymlinkOp.createSymlinkInt(this, target, link, dirPerms, createParent, logRetryCache);
            }
            finally {
                this.writeUnlock("createSymlink");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "createSymlink", link, target, null);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "createSymlink", link, target, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setReplication(String src, short replication) throws IOException {
        String operationName = "setReplication";
        boolean success = false;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("setReplication");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot set replication for " + src);
                success = FSDirAttrOp.setReplication(this.dir, pc, this.blockManager, src, replication);
            }
            finally {
                this.writeUnlock("setReplication");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setReplication", src);
            throw e;
        }
        if (success) {
            this.getEditLog().logSync();
            this.logAuditEvent(true, "setReplication", src);
        }
        return success;
    }

    private void checkStoragePolicyEnabled(String operationNameReadable, boolean checkSuperUser) throws IOException {
        if (!this.isStoragePolicyEnabled) {
            throw new IOException(String.format("Failed to %s since %s is set to false.", operationNameReadable, "dfs.storage.policy.enabled"));
        }
        if (checkSuperUser && this.isStoragePolicySuperuserOnly) {
            this.checkSuperuserPrivilege(CaseUtils.toCamelCase((String)operationNameReadable, (boolean)false, (char[])new char[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStoragePolicy(String src, String policyName) throws IOException {
        FileStatus auditStat;
        String operationName = "setStoragePolicy";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkStoragePolicyEnabled("set storage policy", true);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("setStoragePolicy");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot set storage policy for " + src);
                auditStat = FSDirAttrOp.setStoragePolicy(this.dir, pc, this.blockManager, src, policyName);
            }
            finally {
                this.writeUnlock("setStoragePolicy");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setStoragePolicy", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setStoragePolicy", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void satisfyStoragePolicy(String src, boolean logRetryCache) throws IOException {
        FileStatus auditStat;
        String operationName = "satisfyStoragePolicy";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkStoragePolicyEnabled("satisfy storage policy", false);
        this.validateStoragePolicySatisfy();
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot satisfy storage policy for " + src);
                auditStat = FSDirSatisfyStoragePolicyOp.satisfyStoragePolicy(this.dir, this.blockManager, src, logRetryCache);
            }
            finally {
                this.writeUnlock("satisfyStoragePolicy");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "satisfyStoragePolicy", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "satisfyStoragePolicy", src, null, auditStat);
    }

    private void validateStoragePolicySatisfy() throws UnsupportedActionException, IOException {
        boolean disabled;
        boolean bl = disabled = this.blockManager.getSPSManager() == null;
        if (disabled) {
            throw new UnsupportedActionException("Cannot request to satisfy storage policy when storage policy satisfier feature has been disabled by admin. Seek for an admin help to enable it or use Mover tool.");
        }
        this.blockManager.getSPSManager().verifyOutstandingPathQLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsetStoragePolicy(String src) throws IOException {
        FileStatus auditStat;
        String operationName = "unsetStoragePolicy";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkStoragePolicyEnabled("unset storage policy", true);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("unsetStoragePolicy");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot unset storage policy for " + src);
                auditStat = FSDirAttrOp.unsetStoragePolicy(this.dir, pc, this.blockManager, src);
            }
            finally {
                this.writeUnlock("unsetStoragePolicy");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "unsetStoragePolicy", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "unsetStoragePolicy", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockStoragePolicy getStoragePolicy(String src) throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType(null);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            BlockStoragePolicy blockStoragePolicy = FSDirAttrOp.getStoragePolicy(this.dir, pc, this.blockManager, src);
            return blockStoragePolicy;
        }
        finally {
            this.readUnlock("getStoragePolicy");
        }
    }

    BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            BlockStoragePolicy[] blockStoragePolicyArray = FSDirAttrOp.getStoragePolicies(this.blockManager);
            return blockStoragePolicyArray;
        }
        finally {
            this.readUnlock("getStoragePolicies");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPreferredBlockSize(String src) throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType(null);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            long l = FSDirAttrOp.getPreferredBlockSize(this.dir, pc, src);
            return l;
        }
        finally {
            this.readUnlock("getPreferredBlockSize");
        }
    }

    CryptoProtocolVersion chooseProtocolVersion(EncryptionZone zone, CryptoProtocolVersion[] supportedVersions) throws UnknownCryptoProtocolVersionException, UnresolvedLinkException, SnapshotAccessControlException {
        Preconditions.checkNotNull((Object)zone);
        Preconditions.checkNotNull((Object)supportedVersions);
        CryptoProtocolVersion required = zone.getVersion();
        for (CryptoProtocolVersion c : supportedVersions) {
            if (c.equals((Object)CryptoProtocolVersion.UNKNOWN)) {
                LOG.debug("Ignoring unknown CryptoProtocolVersion provided by client: {}", (Object)c.getUnknownValue());
                continue;
            }
            if (!c.equals((Object)required)) continue;
            return c;
        }
        throw new UnknownCryptoProtocolVersionException("No crypto protocol versions provided by the client are supported. Client provided: " + Arrays.toString(supportedVersions) + " NameNode supports: " + Arrays.toString(CryptoProtocolVersion.values()));
    }

    HdfsFileStatus startFile(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, String ecPolicyName, String storagePolicy, boolean logRetryCache) throws IOException {
        HdfsFileStatus status;
        try {
            status = this.startFileInt(src, permissions, holder, clientMachine, flag, createParent, replication, blockSize, supportedVersions, ecPolicyName, storagePolicy, logRetryCache);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "create", src);
            throw e;
        }
        this.logAuditEvent(true, "create", src, status);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HdfsFileStatus startFileInt(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, String ecPolicyName, String storagePolicy, boolean logRetryCache) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("DIR* NameSystem.startFile: src=").append(src).append(", holder=").append(holder).append(", clientMachine=").append(clientMachine).append(", createParent=").append(createParent).append(", replication=").append(replication).append(", createFlag=").append(flag).append(", blockSize=").append(blockSize).append(", supportedVersions=").append(Arrays.toString(supportedVersions)).append(", ecPolicyName=").append(ecPolicyName).append(", storagePolicy=").append(storagePolicy);
            NameNode.stateChangeLog.debug(builder.toString());
        }
        if (!DFSUtil.isValidName(src) || FSDirectory.isExactReservedName(src) || FSDirectory.isReservedName(src) && !FSDirectory.isReservedRawName(src) && !FSDirectory.isReservedInodesName(src)) {
            throw new InvalidPathException(src);
        }
        boolean shouldReplicate = flag.contains(CreateFlag.SHOULD_REPLICATE);
        if (shouldReplicate && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ecPolicyName)) {
            throw new HadoopIllegalArgumentException("SHOULD_REPLICATE flag and ecPolicyName are exclusive parameters. Set both is not allowed!");
        }
        INodesInPath iip = null;
        boolean skipSync = true;
        HdfsFileStatus stat = null;
        INode.BlocksMapUpdateInfo toRemoveBlocks = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType(null);
        this.writeLock();
        try {
            FSDirEncryptionZoneOp.EncryptionKeyInfo ezInfo;
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot create file" + src);
            iip = FSDirWriteFileOp.resolvePathForStartFile(this.dir, pc, src, flag, createParent);
            if (blockSize < this.minBlockSize) {
                throw new IOException("Specified block size is less than configured minimum value (dfs.namenode.fs-limits.min-block-size): " + blockSize + " < " + this.minBlockSize);
            }
            if (shouldReplicate) {
                this.blockManager.verifyReplication(src, replication, clientMachine);
            } else {
                ErasureCodingPolicy ecPolicy = FSDirErasureCodingOp.getErasureCodingPolicy(this, ecPolicyName, iip);
                if (ecPolicy != null && !ecPolicy.isReplicationPolicy()) {
                    this.checkErasureCodingSupported("createWithEC");
                    if (blockSize < (long)ecPolicy.getCellSize()) {
                        throw new IOException("Specified block size (" + blockSize + ") is less than the cell size (" + ecPolicy.getCellSize() + ") of the erasure coding policy (" + ecPolicy + ").");
                    }
                } else {
                    this.blockManager.verifyReplication(src, replication, clientMachine);
                }
            }
            FileEncryptionInfo feInfo = null;
            if (!iip.isRaw() && this.provider != null && (ezInfo = FSDirEncryptionZoneOp.getEncryptionKeyInfo(this, iip, supportedVersions)) != null) {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                iip = FSDirWriteFileOp.resolvePathForStartFile(this.dir, pc, iip.getPath(), flag, createParent);
                feInfo = FSDirEncryptionZoneOp.getFileEncryptionInfo(this.dir, iip, ezInfo);
            }
            skipSync = false;
            toRemoveBlocks = new INode.BlocksMapUpdateInfo();
            this.dir.writeLock();
            try {
                stat = FSDirWriteFileOp.startFile(this, iip, permissions, holder, clientMachine, flag, createParent, replication, blockSize, feInfo, toRemoveBlocks, shouldReplicate, ecPolicyName, storagePolicy, logRetryCache);
            }
            catch (IOException e) {
                skipSync = e instanceof StandbyException;
                throw e;
            }
            finally {
                this.dir.writeUnlock();
            }
        }
        finally {
            this.writeUnlock("create");
            if (!skipSync) {
                this.getEditLog().logSync();
                if (toRemoveBlocks != null) {
                    this.blockManager.addBLocksToMarkedDeleteQueue(toRemoveBlocks.getToDeleteList());
                }
            }
        }
        return stat;
    }

    boolean recoverLease(String src, String holder, String clientMachine) throws IOException {
        boolean skipSync = false;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType(null);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot recover the lease of " + src);
            INodesInPath iip = this.dir.resolvePath(pc, src, FSDirectory.DirOp.WRITE);
            src = iip.getPath();
            INodeFile inode = INodeFile.valueOf(iip.getLastINode(), src);
            if (!inode.isUnderConstruction()) {
                boolean bl = true;
                return bl;
            }
            if (this.isPermissionEnabled) {
                this.dir.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            boolean bl = this.recoverLeaseInternal(RecoverLeaseOp.RECOVER_LEASE, iip, src, holder, clientMachine, true);
            return bl;
        }
        catch (StandbyException se) {
            skipSync = true;
            throw se;
        }
        finally {
            this.writeUnlock("recoverLease");
            if (!skipSync) {
                this.getEditLog().logSync();
            }
        }
    }

    boolean recoverLeaseInternal(RecoverLeaseOp op, INodesInPath iip, String src, String holder, String clientMachine, boolean force) throws IOException {
        assert (this.hasWriteLock());
        INodeFile file = iip.getLastINode().asFile();
        if (file.isUnderConstruction()) {
            LeaseManager.Lease leaseFile;
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            if (!force && lease != null && (leaseFile = this.leaseManager.getLease(file)) != null && leaseFile.equals(lease)) {
                throw new AlreadyBeingCreatedException(op.getExceptionMessage(src, holder, clientMachine, holder + " is already the current lease holder."));
            }
            FileUnderConstructionFeature uc = file.getFileUnderConstructionFeature();
            String clientName = uc.getClientName();
            lease = this.leaseManager.getLease(clientName);
            if (lease == null) {
                throw new AlreadyBeingCreatedException(op.getExceptionMessage(src, holder, clientMachine, "the file is under construction but no leases found."));
            }
            if (force) {
                LOG.info("recoverLease: " + lease + ", src=" + src + " from client " + clientName);
                return this.internalReleaseLease(lease, src, iip, holder);
            }
            assert (lease.getHolder().equals(clientName)) : "Current lease holder " + lease.getHolder() + " does not match file creator " + clientName;
            if (lease.expiredSoftLimit()) {
                LOG.info("startFile: recover " + lease + ", src=" + src + " client " + clientName);
                if (this.internalReleaseLease(lease, src, iip, null)) {
                    return true;
                }
                throw new RecoveryInProgressException(op.getExceptionMessage(src, holder, clientMachine, "lease recovery is in progress. Try again later."));
            }
            BlockInfo lastBlock = file.getLastBlock();
            if (lastBlock != null && lastBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.UNDER_RECOVERY) {
                throw new RecoveryInProgressException(op.getExceptionMessage(src, holder, clientMachine, "another recovery is in progress by " + clientName + " on " + uc.getClientMachine()));
            }
            throw new AlreadyBeingCreatedException(op.getExceptionMessage(src, holder, clientMachine, "this file lease is currently owned by " + clientName + " on " + uc.getClientMachine()));
        }
        return true;
    }

    LastBlockWithStatus appendFile(String srcArg, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean logRetryCache) throws IOException {
        String operationName = "append";
        boolean newBlock = flag.contains(CreateFlag.NEW_BLOCK);
        if (newBlock) {
            this.requireEffectiveLayoutVersionForFeature(NameNodeLayoutVersion.Feature.APPEND_NEW_BLOCK);
        }
        NameNode.stateChangeLog.debug("DIR* NameSystem.appendFile: src={}, holder={}, clientMachine={}", new Object[]{srcArg, holder, clientMachine});
        try {
            boolean skipSync = false;
            LastBlockWithStatus lbs = null;
            this.checkOperation(NameNode.OperationCategory.WRITE);
            FSPermissionChecker pc = this.getPermissionChecker();
            FSPermissionChecker.setOperationType("append");
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot append to file" + srcArg);
                lbs = FSDirAppendOp.appendFile(this, srcArg, pc, holder, clientMachine, newBlock, logRetryCache);
            }
            catch (StandbyException se) {
                skipSync = true;
                throw se;
            }
            finally {
                this.writeUnlock("append");
                if (!skipSync) {
                    this.getEditLog().logSync();
                }
            }
            this.logAuditEvent(true, "append", srcArg);
            return lbs;
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "append", srcArg);
            throw e;
        }
    }

    ExtendedBlock getExtendedBlock(Block blk) {
        return new ExtendedBlock(this.getBlockPoolId(), blk);
    }

    void setBlockPoolId(String bpid) {
        this.blockManager.setBlockPoolId(bpid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock getAdditionalBlock(String src, long fileId, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, String[] favoredNodes, EnumSet<AddBlockFlag> flags) throws IOException {
        LocatedBlock lb;
        FSDirWriteFileOp.ValidateAddBlockResult r;
        String operationName = "getAdditionalBlock";
        NameNode.stateChangeLog.debug("BLOCK* getAdditionalBlock: {}  inodeId {} for {}", new Object[]{src, fileId, clientName});
        LocatedBlock[] onRetryBlock = new LocatedBlock[1];
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("getAdditionalBlock");
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            r = FSDirWriteFileOp.validateAddBlock(this, pc, src, fileId, clientName, previous, onRetryBlock);
        }
        finally {
            this.readUnlock("getAdditionalBlock");
        }
        if (r == null) {
            assert (onRetryBlock[0] != null) : "Retry block is null";
            return onRetryBlock[0];
        }
        DatanodeStorageInfo[] targets = FSDirWriteFileOp.chooseTargetForNewBlock(this.blockManager, src, excludedNodes, favoredNodes, flags, r);
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            lb = FSDirWriteFileOp.storeAllocatedBlock(this, src, fileId, clientName, previous, targets);
        }
        finally {
            this.writeUnlock("getAdditionalBlock");
        }
        this.getEditLog().logSync();
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] storageIDs, Set<Node> excludes, int numAdditionalNodes, String clientName) throws IOException {
        List<DatanodeStorageInfo> chosen;
        BlockType blockType;
        byte storagePolicyID;
        long preferredblocksize;
        String clientMachine;
        this.dtpReplaceDatanodeOnFailure.checkEnabled();
        DatanodeDescriptor clientnode = null;
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType(null);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            this.checkNameNodeSafeMode("Cannot add datanode; src=" + src + ", blk=" + blk);
            INodesInPath iip = this.dir.resolvePath(pc, src, fileId);
            src = iip.getPath();
            INodeFile file = this.checkLease(iip, clientName, fileId);
            clientMachine = file.getFileUnderConstructionFeature().getClientMachine();
            clientnode = this.blockManager.getDatanodeManager().getDatanodeByHost(clientMachine);
            preferredblocksize = file.getPreferredBlockSize();
            storagePolicyID = file.getStoragePolicyID();
            blockType = file.getBlockType();
            DatanodeManager dm = this.blockManager.getDatanodeManager();
            chosen = Arrays.asList(dm.getDatanodeStorageInfos((DatanodeID[])existings, storageIDs, "src=%s, fileId=%d, blk=%s, clientName=%s, clientMachine=%s", src, fileId, blk, clientName, clientMachine));
        }
        finally {
            this.readUnlock("getAdditionalDatanode");
        }
        if (clientnode == null) {
            clientnode = FSDirWriteFileOp.getClientNode(this.blockManager, clientMachine);
        }
        DatanodeStorageInfo[] targets = this.blockManager.chooseTarget4AdditionalDatanode(src, numAdditionalNodes, (Node)clientnode, chosen, excludes, preferredblocksize, storagePolicyID, blockType);
        LocatedBlock lb = BlockManager.newLocatedBlock(blk, targets, -1L, false);
        this.blockManager.setBlockToken(lb, BlockTokenIdentifier.AccessMode.COPY);
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        NameNode.stateChangeLog.debug("BLOCK* NameSystem.abandonBlock: {} of file {}", (Object)b, (Object)src);
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType(null);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot abandon block " + b + " for file" + src);
            FSDirWriteFileOp.abandonBlock(this.dir, pc, b, fileId, src, holder);
            NameNode.stateChangeLog.debug("BLOCK* NameSystem.abandonBlock: {} is removed from pendingCreates", (Object)b);
        }
        finally {
            this.writeUnlock("abandonBlock");
        }
        this.getEditLog().logSync();
    }

    private String leaseExceptionString(String src, long fileId, String holder) {
        LeaseManager.Lease lease = this.leaseManager.getLease(holder);
        return src + " (inode " + fileId + ") " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files.");
    }

    INodeFile checkLease(INodesInPath iip, String holder, long fileId) throws LeaseExpiredException, FileNotFoundException {
        String src = iip.getPath();
        INode inode = iip.getLastINode();
        assert (this.hasReadLock());
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + this.leaseExceptionString(src, fileId, holder));
        }
        if (!inode.isFile()) {
            throw new LeaseExpiredException("INode is not a regular file: " + this.leaseExceptionString(src, fileId, holder));
        }
        INodeFile file = inode.asFile();
        if (!file.isUnderConstruction()) {
            throw new LeaseExpiredException("File is not open for writing: " + this.leaseExceptionString(src, fileId, holder));
        }
        if (this.isFileDeleted(file)) {
            throw new FileNotFoundException("File is deleted: " + this.leaseExceptionString(src, fileId, holder));
        }
        String owner = file.getFileUnderConstructionFeature().getClientName();
        if (holder != null && !owner.equals(holder)) {
            throw new LeaseExpiredException("Client (=" + holder + ") is not the lease owner (=" + owner + ": " + this.leaseExceptionString(src, fileId, holder));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean completeFile(String src, String holder, ExtendedBlock last, long fileId) throws IOException {
        boolean success = false;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType(null);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot complete file " + src);
            success = FSDirWriteFileOp.completeFile(this, pc, src, holder, last, fileId);
        }
        finally {
            this.writeUnlock("completeFile");
        }
        this.getEditLog().logSync();
        if (success) {
            NameNode.stateChangeLog.info("DIR* completeFile: " + src + " is closed by " + holder);
        }
        return success;
    }

    Block createNewBlock(BlockType blockType) throws IOException {
        assert (this.hasWriteLock());
        Block b = new Block(this.nextBlockId(blockType), 0L, 0L);
        b.setGenerationStamp(this.nextGenerationStamp(false));
        return b;
    }

    boolean checkFileProgress(String src, INodeFile v, boolean checkall) {
        assert (this.hasReadLock());
        if (checkall) {
            return this.checkBlocksComplete(src, true, v.getBlocks());
        }
        BlockInfo[] blocks = v.getBlocks();
        int i = blocks.length - this.numCommittedAllowed - 2;
        return i < 0 || blocks[i] == null || this.checkBlocksComplete(src, false, blocks[i]);
    }

    private boolean checkBlocksComplete(String src, boolean allowCommittedBlock, BlockInfo ... blocks) {
        int n = allowCommittedBlock ? this.numCommittedAllowed : 0;
        for (int i = 0; i < blocks.length; ++i) {
            short min = this.blockManager.getMinStorageNum(blocks[i]);
            String err = INodeFile.checkBlockComplete(blocks, i, n, min);
            if (err == null) continue;
            int numNodes = blocks[i].numNodes();
            LOG.info("BLOCK* " + err + "(numNodes= " + numNodes + (numNodes < min ? " < " : " >= ") + " minimum = " + min + ") in file " + src);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    boolean renameTo(String src, String dst, boolean logRetryCache) throws IOException {
        String operationName = "rename";
        FSDirRenameOp.RenameResult ret = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("rename");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot rename " + src);
                ret = FSDirRenameOp.renameToInt(this.dir, pc, src, dst, logRetryCache);
            }
            finally {
                this.writeUnlock("rename");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "rename", src, dst, null);
            throw e;
        }
        boolean success = ret.success;
        if (success) {
            this.getEditLog().logSync();
            this.logAuditEvent(true, "rename", src, dst, ret.auditStat);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameTo(String src, String dst, boolean logRetryCache, Options.Rename ... options) throws IOException {
        String operationName = "rename";
        FSDirRenameOp.RenameResult res = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("rename");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot rename " + src);
                res = FSDirRenameOp.renameToInt(this.dir, pc, src, dst, logRetryCache, options);
            }
            finally {
                this.writeUnlock("rename");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "rename (options=" + Arrays.toString(options) + ")", src, dst, null);
            throw e;
        }
        this.getEditLog().logSync();
        INode.BlocksMapUpdateInfo collectedBlocks = res.collectedBlocks;
        if (!collectedBlocks.getToDeleteList().isEmpty()) {
            this.blockManager.addBLocksToMarkedDeleteQueue(collectedBlocks.getToDeleteList());
        }
        this.logAuditEvent(true, "rename (options=" + Arrays.toString(options) + ")", src, dst, res.auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean delete(String src, boolean recursive, boolean logRetryCache) throws IOException {
        String operationName = "delete";
        INode.BlocksMapUpdateInfo toRemovedBlocks = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("delete");
        boolean ret = false;
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot delete " + src);
                toRemovedBlocks = FSDirDeleteOp.delete(this, pc, src, recursive, logRetryCache);
                ret = toRemovedBlocks != null;
            }
            finally {
                this.writeUnlock("delete");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "delete", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(ret, "delete", src);
        if (toRemovedBlocks != null) {
            this.blockManager.addBLocksToMarkedDeleteQueue(toRemovedBlocks.getToDeleteList());
        }
        return ret;
    }

    FSPermissionChecker getPermissionChecker() throws AccessControlException {
        return this.dir.getPermissionChecker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLeasesAndINodes(List<Long> removedUCFiles, List<INode> removedINodes, boolean acquireINodeMapLock) {
        assert (this.hasWriteLock());
        for (long i : removedUCFiles) {
            this.leaseManager.removeLease(i);
        }
        if (removedINodes != null) {
            if (acquireINodeMapLock) {
                this.dir.writeLock();
            }
            try {
                this.dir.removeFromInodeMap(removedINodes);
            }
            finally {
                if (acquireINodeMapLock) {
                    this.dir.writeUnlock();
                }
            }
            removedINodes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdfsFileStatus getFileInfo(String src, boolean resolveLink, boolean needLocation, boolean needBlockToken) throws IOException {
        String operationName = needBlockToken ? "open" : "getfileinfo";
        this.checkOperation(NameNode.OperationCategory.READ);
        HdfsFileStatus stat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType(operationName);
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                stat = FSDirStatAndListingOp.getFileInfo(this.dir, pc, src, resolveLink, needLocation, needBlockToken);
            }
            finally {
                this.readUnlock(operationName);
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, operationName, src);
            throw e;
        }
        this.logAuditEvent(true, operationName, src);
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFileClosed(String src) throws IOException {
        String operationName = "isFileClosed";
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("isFileClosed");
        boolean success = false;
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                success = FSDirStatAndListingOp.isFileClosed(this.dir, pc, src);
            }
            finally {
                this.readUnlock("isFileClosed");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "isFileClosed", src);
            throw e;
        }
        if (success) {
            this.logAuditEvent(true, "isFileClosed", src);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mkdirs(String src, PermissionStatus permissions, boolean createParent) throws IOException {
        String operationName = "mkdirs";
        FileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("mkdirs");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot create directory " + src);
                auditStat = FSDirMkdirOp.mkdirs(this, pc, src, permissions, createParent);
            }
            finally {
                this.writeUnlock("mkdirs");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "mkdirs", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "mkdirs", src, null, auditStat);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws IOException {
        ContentSummary cs;
        this.checkOperation(NameNode.OperationCategory.READ);
        String operationName = "contentSummary";
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("contentSummary");
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                cs = FSDirStatAndListingOp.getContentSummary(this.dir, pc, src);
            }
            finally {
                this.readUnlock("contentSummary");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "contentSummary", src);
            throw ace;
        }
        this.logAuditEvent(true, "contentSummary", src);
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QuotaUsage getQuotaUsage(String src) throws IOException {
        QuotaUsage quotaUsage;
        this.checkOperation(NameNode.OperationCategory.READ);
        String operationName = "quotaUsage";
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("quotaUsage");
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                quotaUsage = FSDirStatAndListingOp.getQuotaUsage(this.dir, pc, src);
            }
            finally {
                this.readUnlock("quotaUsage");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "quotaUsage", src);
            throw ace;
        }
        this.logAuditEvent(true, "quotaUsage", src);
        return quotaUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String src, long nsQuota, long ssQuota, StorageType type) throws IOException {
        if (type != null) {
            this.requireEffectiveLayoutVersionForFeature(NameNodeLayoutVersion.Feature.QUOTA_BY_STORAGE_TYPE);
        }
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String operationName = this.getQuotaCommand(nsQuota, ssQuota);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType(operationName);
        try {
            if (!this.allowOwnerSetQuota) {
                this.checkSuperuserPrivilege(pc);
            }
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot set quota on " + src);
                FSDirAttrOp.setQuota(this.dir, pc, src, nsQuota, ssQuota, type, this.allowOwnerSetQuota);
            }
            finally {
                this.writeUnlock(operationName);
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, operationName, src);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, operationName, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fsync(String src, long fileId, String clientName, long lastBlockLength) throws IOException {
        NameNode.stateChangeLog.info("BLOCK* fsync: " + src + " for " + clientName);
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType(null);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot fsync file " + src);
            INodesInPath iip = this.dir.resolvePath(pc, src, fileId);
            src = iip.getPath();
            INodeFile pendingFile = this.checkLease(iip, clientName, fileId);
            if (lastBlockLength > 0L) {
                pendingFile.getFileUnderConstructionFeature().updateLengthOfLastBlock(pendingFile, lastBlockLength);
            }
            FSDirWriteFileOp.persistBlocks(this.dir, src, pendingFile, false);
        }
        finally {
            this.writeUnlock("fsync");
        }
        this.getEditLog().logSync();
    }

    boolean internalReleaseLease(LeaseManager.Lease lease, String src, INodesInPath iip, String recoveryLeaseHolder) throws IOException {
        int nrCompleteBlocks;
        LOG.info("Recovering " + lease + ", src=" + src);
        assert (!this.isInSafeMode());
        assert (this.hasWriteLock());
        INodeFile pendingFile = iip.getLastINode().asFile();
        int nrBlocks = pendingFile.numBlocks();
        BlockInfo[] blocks = pendingFile.getBlocks();
        BlockInfo curBlock = null;
        for (nrCompleteBlocks = 0; nrCompleteBlocks < nrBlocks && (curBlock = blocks[nrCompleteBlocks]).isComplete(); ++nrCompleteBlocks) {
            assert (this.blockManager.hasMinStorage(curBlock)) : "A COMPLETE block is not minimally replicated in " + src;
        }
        if (nrCompleteBlocks == nrBlocks) {
            this.finalizeINodeFileUnderConstruction(src, pendingFile, iip.getLatestSnapshotId(), false);
            NameNode.stateChangeLog.warn("BLOCK* internalReleaseLease: All existing blocks are COMPLETE, lease removed, file " + src + " closed.");
            return true;
        }
        if (nrCompleteBlocks < nrBlocks - 2 || nrCompleteBlocks == nrBlocks - 2 && curBlock != null && curBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " but file is already closed.";
            NameNode.stateChangeLog.warn(message);
            throw new IOException(message);
        }
        BlockInfo lastBlock = pendingFile.getLastBlock();
        HdfsServerConstants.BlockUCState lastBlockState = lastBlock.getBlockUCState();
        BlockInfo penultimateBlock = pendingFile.getPenultimateBlock();
        boolean penultimateBlockMinStorage = penultimateBlock == null || this.blockManager.hasMinStorage(penultimateBlock);
        switch (lastBlockState) {
            case COMPLETE: {
                assert (false) : "Already checked that the last block is incomplete";
                break;
            }
            case COMMITTED: {
                if (penultimateBlockMinStorage && this.blockManager.hasMinStorage(lastBlock)) {
                    this.finalizeINodeFileUnderConstruction(src, pendingFile, iip.getLatestSnapshotId(), false);
                    NameNode.stateChangeLog.warn("BLOCK* internalReleaseLease: Committed blocks are minimally replicated, lease removed, file" + src + " closed.");
                    return true;
                }
                String message = "DIR* NameSystem.internalReleaseLease: Failed to release lease for file " + src + ". Committed blocks are waiting to be minimally replicated.";
                NameNode.stateChangeLog.warn(message);
                if (!penultimateBlockMinStorage) {
                    throw new AlreadyBeingCreatedException(message);
                }
            }
            case UNDER_CONSTRUCTION: 
            case UNDER_RECOVERY: {
                boolean copyOnTruncate;
                BlockUnderConstructionFeature uc = lastBlock.getUnderConstructionFeature();
                BlockInfo recoveryBlock = uc.getTruncateBlock();
                boolean truncateRecovery = recoveryBlock != null;
                boolean bl = copyOnTruncate = truncateRecovery && recoveryBlock.getBlockId() != lastBlock.getBlockId();
                assert (!copyOnTruncate || recoveryBlock.getBlockId() < lastBlock.getBlockId() && recoveryBlock.getGenerationStamp() < lastBlock.getGenerationStamp() && recoveryBlock.getNumBytes() > lastBlock.getNumBytes()) : "wrong recoveryBlock";
                if (uc.getNumExpectedLocations() == 0) {
                    uc.setExpectedLocations(lastBlock, this.blockManager.getStorages(lastBlock), lastBlock.getBlockType());
                }
                if (uc.getNumExpectedLocations() == 0 && lastBlock.getNumBytes() == 0L) {
                    pendingFile.removeLastBlock(lastBlock);
                    this.finalizeINodeFileUnderConstruction(src, pendingFile, iip.getLatestSnapshotId(), false);
                    NameNode.stateChangeLog.warn("BLOCK* internalReleaseLease: Removed empty last block and closed file " + src);
                    return true;
                }
                if (this.blockManager.addBlockRecoveryAttempt(lastBlock)) {
                    long blockRecoveryId = this.nextGenerationStamp(this.blockManager.isLegacyBlock(lastBlock));
                    if (copyOnTruncate) {
                        lastBlock.setGenerationStamp(blockRecoveryId);
                    } else if (truncateRecovery) {
                        recoveryBlock.setGenerationStamp(blockRecoveryId);
                    }
                    uc.initializeBlockRecovery(lastBlock, blockRecoveryId, true);
                    NameNode.stateChangeLog.warn("DIR* NameSystem.internalReleaseLease: File " + src + " has not been closed. Lease recovery is in progress. RecoveryId = " + blockRecoveryId + " for block " + (Object)((Object)lastBlock));
                }
                lease = this.reassignLease(lease, src, recoveryLeaseHolder, pendingFile);
                this.leaseManager.renewLease(lease);
            }
        }
        return false;
    }

    private LeaseManager.Lease reassignLease(LeaseManager.Lease lease, String src, String newHolder, INodeFile pendingFile) {
        assert (this.hasWriteLock());
        if (newHolder == null) {
            return lease;
        }
        this.logReassignLease(lease.getHolder(), src, newHolder);
        return this.reassignLeaseInternal(lease, newHolder, pendingFile);
    }

    LeaseManager.Lease reassignLeaseInternal(LeaseManager.Lease lease, String newHolder, INodeFile pendingFile) {
        assert (this.hasWriteLock());
        pendingFile.getFileUnderConstructionFeature().setClientName(newHolder);
        return this.leaseManager.reassignLease(lease, pendingFile, newHolder);
    }

    void commitOrCompleteLastBlock(INodeFile fileINode, INodesInPath iip, Block commitBlock) throws IOException {
        assert (this.hasWriteLock());
        Preconditions.checkArgument((boolean)fileINode.isUnderConstruction());
        this.blockManager.commitOrCompleteLastBlock(fileINode, commitBlock, iip);
    }

    void addCommittedBlocksToPending(INodeFile pendingFile) {
        BlockInfo[] blocks = pendingFile.getBlocks();
        int i = blocks.length - this.numCommittedAllowed;
        if (i < 0) {
            i = 0;
        }
        while (i < blocks.length) {
            BlockInfo b = blocks[i];
            if (b != null && b.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED) {
                this.blockManager.addExpectedReplicasToPending(b);
            }
            ++i;
        }
    }

    void finalizeINodeFileUnderConstruction(String src, INodeFile pendingFile, int latestSnapshot, boolean allowCommittedBlock) throws IOException {
        assert (this.hasWriteLock());
        FileUnderConstructionFeature uc = pendingFile.getFileUnderConstructionFeature();
        if (uc == null) {
            throw new IOException("Cannot finalize file " + src + " because it is not under construction");
        }
        pendingFile.recordModification(latestSnapshot);
        pendingFile.toCompleteFile(Time.now(), allowCommittedBlock ? this.numCommittedAllowed : 0, this.blockManager.getMinReplication());
        this.leaseManager.removeLease(uc.getClientName(), pendingFile);
        this.closeFile(src, pendingFile);
        this.blockManager.checkRedundancy(pendingFile);
    }

    @VisibleForTesting
    BlockInfo getStoredBlock(Block block) {
        return this.blockManager.getStoredBlock(block);
    }

    @Override
    public boolean isInSnapshot(long blockCollectionID) {
        assert (this.hasReadLock());
        INodeFile bc = this.getBlockCollection(blockCollectionID);
        if (bc == null || !bc.isUnderConstruction()) {
            return false;
        }
        String fullName = bc.getName();
        try {
            if (fullName != null && fullName.startsWith("/") && this.dir.getINode(fullName, FSDirectory.DirOp.READ) == bc) {
                return false;
            }
        }
        catch (IOException e) {
            LOG.error("Error while resolving the path : " + fullName, (Throwable)e);
            return false;
        }
        return true;
    }

    INodeFile getBlockCollection(BlockInfo b) {
        return this.getBlockCollection(b.getBlockCollectionId());
    }

    @Override
    public INodeFile getBlockCollection(long id) {
        assert (this.hasReadLock()) : "Accessing INode id = " + id + " without read lock";
        INode inode = this.getFSDirectory().getInode(id);
        return inode == null ? null : inode.asFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitBlockSynchronization(ExtendedBlock oldBlock, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        String src;
        LOG.info("commitBlockSynchronization(oldBlock=" + oldBlock + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ", closeFile=" + closeFile + ", deleteBlock=" + deleteblock + ")");
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        boolean copyTruncate = false;
        BlockInfo truncatedBlock = null;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot commitBlockSynchronization while in safe mode");
            BlockInfo storedBlock = this.getStoredBlock(ExtendedBlock.getLocalBlock((ExtendedBlock)oldBlock));
            if (storedBlock == null) {
                if (deleteblock) {
                    LOG.debug("Block (={}) not found", (Object)oldBlock);
                    return;
                }
                throw new IOException("Block (=" + oldBlock + ") not found");
            }
            long oldGenerationStamp = storedBlock.getGenerationStamp();
            long oldNumBytes = storedBlock.getNumBytes();
            if (storedBlock.isDeleted()) {
                throw new IOException("The blockCollection of " + (Object)((Object)storedBlock) + " is null, likely because the file owning this block was deleted and the block removal is delayed");
            }
            INodeFile iFile = this.getBlockCollection(storedBlock);
            src = iFile.getFullPathName();
            if (this.isFileDeleted(iFile)) {
                throw new FileNotFoundException("File not found: " + src + ", likely due to delayed block removal");
            }
            if ((!iFile.isUnderConstruction() || storedBlock.isComplete()) && iFile.getLastBlock().isComplete()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unexpected block (={}) since the file (={}) is not under construction", (Object)oldBlock, (Object)iFile.getLocalName());
                }
                return;
            }
            truncatedBlock = iFile.getLastBlock();
            long recoveryId = truncatedBlock.getUnderConstructionFeature().getBlockRecoveryId();
            boolean bl = copyTruncate = truncatedBlock.getBlockId() != storedBlock.getBlockId();
            if (recoveryId != newgenerationstamp) {
                throw new IOException("The recovery id " + newgenerationstamp + " does not match current recovery id " + recoveryId + " for block " + oldBlock);
            }
            if (deleteblock) {
                boolean remove;
                Block blockToDel = ExtendedBlock.getLocalBlock((ExtendedBlock)oldBlock);
                boolean bl2 = remove = iFile.removeLastBlock(blockToDel) != null;
                if (remove) {
                    this.blockManager.removeBlock(storedBlock);
                }
            } else {
                if (!copyTruncate) {
                    storedBlock.setGenerationStamp(newgenerationstamp);
                    storedBlock.setNumBytes(newlength);
                }
                DatanodeStorageInfo[] dsInfos = this.blockManager.getDatanodeManager().getDatanodeStorageInfos(newtargets, newtargetstorages, "src=%s, oldBlock=%s, newgenerationstamp=%d, newlength=%d", src, oldBlock, newgenerationstamp, newlength);
                if (closeFile && dsInfos != null) {
                    for (int i = 0; i < dsInfos.length; ++i) {
                        if (dsInfos[i] == null) continue;
                        if (copyTruncate) {
                            dsInfos[i].addBlock(truncatedBlock, truncatedBlock);
                            continue;
                        }
                        Block bi = new Block((Block)storedBlock);
                        if (storedBlock.isStriped()) {
                            bi.setBlockId(bi.getBlockId() + (long)i);
                        }
                        dsInfos[i].addBlock(storedBlock, bi);
                    }
                }
                if (copyTruncate) {
                    iFile.convertLastBlockToUC(truncatedBlock, dsInfos);
                } else {
                    iFile.convertLastBlockToUC(storedBlock, dsInfos);
                    if (closeFile) {
                        this.blockManager.markBlockReplicasAsCorrupt(oldBlock.getLocalBlock(), storedBlock, oldGenerationStamp, oldNumBytes, dsInfos);
                    }
                }
            }
            if (closeFile) {
                if (copyTruncate) {
                    this.closeFileCommitBlocks(src, iFile, truncatedBlock);
                    if (!iFile.isBlockInLatestSnapshot(storedBlock)) {
                        this.blockManager.removeBlock(storedBlock);
                    }
                } else {
                    this.closeFileCommitBlocks(src, iFile, storedBlock);
                }
            } else {
                FSDirWriteFileOp.persistBlocks(this.dir, src, iFile, false);
            }
            this.blockManager.successfulBlockRecovery(storedBlock);
        }
        finally {
            this.writeUnlock("commitBlockSynchronization");
        }
        this.getEditLog().logSync();
        if (closeFile) {
            LOG.info("commitBlockSynchronization(oldBlock=" + oldBlock + ", file=" + src + (copyTruncate ? ", newBlock=" + (Object)((Object)truncatedBlock) : ", newgenerationstamp=" + newgenerationstamp) + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ") successful");
        } else {
            LOG.info("commitBlockSynchronization(" + oldBlock + ") successful");
        }
    }

    @VisibleForTesting
    void closeFileCommitBlocks(String src, INodeFile pendingFile, BlockInfo storedBlock) throws IOException {
        INodesInPath iip = INodesInPath.fromINode(pendingFile);
        this.commitOrCompleteLastBlock(pendingFile, iip, storedBlock);
        int s = Snapshot.findLatestSnapshot(pendingFile, 0x7FFFFFFE);
        this.finalizeINodeFileUnderConstruction(src, pendingFile, s, false);
    }

    void renewLease(String holder) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkNameNodeSafeMode("Cannot renew lease for " + holder);
        this.leaseManager.renewLease(holder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        String operationName = "listStatus";
        DirectoryListing dl = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("listStatus");
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                dl = FSDirStatAndListingOp.getListingInt(this.dir, pc, src, startAfter, needLocation);
            }
            finally {
                this.readUnlock("listStatus");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "listStatus", src);
            throw e;
        }
        this.logAuditEvent(true, "listStatus", src);
        return dl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSrcPathsHash(String[] srcs) {
        MessageDigest messageDigest = this.digest;
        synchronized (messageDigest) {
            for (String src : srcs) {
                this.digest.update(src.getBytes(Charsets.UTF_8));
            }
            byte[] result = this.digest.digest();
            this.digest.reset();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedDirectoryListing getBatchedListing(String[] srcs, byte[] startAfter, boolean needLocation) throws IOException {
        BatchedDirectoryListing bdl;
        if (srcs.length > this.batchedListingLimit) {
            String msg = String.format("Too many source paths (%d > %d)", srcs.length, this.batchedListingLimit);
            throw new IllegalArgumentException(msg);
        }
        int srcsIndex = 0;
        byte[] indexStartAfter = new byte[]{};
        if (startAfter.length > 0) {
            HdfsProtos.BatchedListingKeyProto startAfterProto = HdfsProtos.BatchedListingKeyProto.parseFrom((byte[])startAfter);
            Preconditions.checkArgument((boolean)Arrays.equals(startAfterProto.getChecksum().toByteArray(), this.getSrcPathsHash(srcs)));
            srcsIndex = startAfterProto.getPathIndex();
            indexStartAfter = startAfterProto.getStartAfter().toByteArray();
            if (indexStartAfter.length == 0) {
                ++srcsIndex;
            }
        }
        int startSrcsIndex = srcsIndex;
        String operationName = "listStatus";
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            LinkedHashMap listings = Maps.newLinkedHashMap();
            DirectoryListing lastListing = null;
            int numEntries = 0;
            while (srcsIndex < srcs.length) {
                HdfsPartialListing listing;
                String src = srcs[srcsIndex];
                try {
                    DirectoryListing dirListing = FSDirStatAndListingOp.getListingInt(this.dir, pc, src, indexStartAfter, needLocation);
                    if (dirListing == null) {
                        throw new FileNotFoundException("Path " + src + " does not exist");
                    }
                    listing = new HdfsPartialListing(srcsIndex, (List)Lists.newArrayList((Object[])dirListing.getPartialListing()));
                    numEntries += listing.getPartialListing().size();
                    lastListing = dirListing;
                }
                catch (Exception e) {
                    if (e instanceof AccessControlException) {
                        this.logAuditEvent(false, "listStatus", src);
                    }
                    listing = new HdfsPartialListing(srcsIndex, new RemoteException(e.getClass().getCanonicalName(), e.getMessage()));
                    lastListing = null;
                    LOG.info("Exception listing src {}", (Object)src, (Object)e);
                }
                listings.put(srcsIndex, listing);
                if (indexStartAfter.length != 0) {
                    indexStartAfter = new byte[]{};
                }
                if (numEntries >= this.dir.getListLimit()) break;
                ++srcsIndex;
            }
            HdfsPartialListing[] partialListingArray = listings.values().toArray(new HdfsPartialListing[0]);
            if (srcsIndex >= srcs.length) {
                bdl = new BatchedDirectoryListing(partialListingArray, false, new byte[0]);
            } else if (srcsIndex == srcs.length - 1 && lastListing != null && !lastListing.hasMore()) {
                bdl = new BatchedDirectoryListing(partialListingArray, false, new byte[0]);
            } else {
                byte[] lastName = lastListing != null && lastListing.getLastName() != null ? lastListing.getLastName() : new byte[]{};
                HdfsProtos.BatchedListingKeyProto proto = HdfsProtos.BatchedListingKeyProto.newBuilder().setChecksum(ByteString.copyFrom((byte[])this.getSrcPathsHash(srcs))).setPathIndex(srcsIndex).setStartAfter(ByteString.copyFrom((byte[])lastName)).build();
                byte[] returnedStartAfter = proto.toByteArray();
                bdl = new BatchedDirectoryListing(partialListingArray, true, returnedStartAfter);
            }
        }
        finally {
            this.readUnlock("listStatus");
        }
        for (int i = startSrcsIndex; i < srcsIndex; ++i) {
            this.logAuditEvent(true, "listStatus", srcs[i]);
        }
        return bdl;
    }

    void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.writeLock();
        try {
            this.blockManager.registerDatanode(nodeReg);
        }
        finally {
            this.writeUnlock("registerDatanode");
        }
    }

    String getRegistrationID() {
        return Storage.getRegistrationID(this.getFSImage().getStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HeartbeatResponse handleHeartbeat(DatanodeRegistration nodeReg, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int xmitsInProgress, int failedVolumes, VolumeFailureSummary volumeFailureSummary, boolean requestFullBlockReportLease, @Nonnull SlowPeerReports slowPeers, @Nonnull SlowDiskReports slowDisks) throws IOException {
        this.readLock();
        try {
            int maxTransfer = this.blockManager.getMaxReplicationStreams() - xmitsInProgress;
            DatanodeCommand[] cmds = this.blockManager.getDatanodeManager().handleHeartbeat(nodeReg, reports, this.getBlockPoolId(), cacheCapacity, cacheUsed, xceiverCount, maxTransfer, failedVolumes, volumeFailureSummary, slowPeers, slowDisks);
            long blockReportLeaseId = 0L;
            if (requestFullBlockReportLease) {
                blockReportLeaseId = this.blockManager.requestBlockReportLeaseId(nodeReg);
            }
            NNHAStatusHeartbeat haState = new NNHAStatusHeartbeat(this.haContext.getState().getServiceState(), this.getFSImage().getCorrectLastAppliedOrWrittenTxId());
            HeartbeatResponse heartbeatResponse = new HeartbeatResponse(cmds, haState, (RollingUpgradeStatus)this.rollingUpgradeInfo, blockReportLeaseId);
            return heartbeatResponse;
        }
        finally {
            this.readUnlock("handleHeartbeat");
        }
    }

    void handleLifeline(DatanodeRegistration nodeReg, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int xmitsInProgress, int failedVolumes, VolumeFailureSummary volumeFailureSummary) throws IOException {
        this.blockManager.getDatanodeManager().handleLifeline(nodeReg, reports, cacheCapacity, cacheUsed, xceiverCount, failedVolumes, volumeFailureSummary);
    }

    boolean nameNodeHasResourcesAvailable() {
        return this.hasResourcesAvailable;
    }

    void checkAvailableResources() {
        long resourceCheckTime = Time.monotonicNow();
        Preconditions.checkState((this.nnResourceChecker != null ? 1 : 0) != 0, (Object)"nnResourceChecker not initialized");
        this.hasResourcesAvailable = this.nnResourceChecker.hasAvailableDiskSpace();
        resourceCheckTime = Time.monotonicNow() - resourceCheckTime;
        NameNode.getNameNodeMetrics().addResourceCheckTime(resourceCheckTime);
    }

    private void closeFile(String path, INodeFile file) {
        assert (this.hasWriteLock());
        this.getEditLog().logCloseFile(path, file);
        NameNode.stateChangeLog.debug("closeFile: {} with {} blocks is persisted to the file system", (Object)path, (Object)file.getBlocks().length);
    }

    public FSImage getFSImage() {
        return this.fsImage;
    }

    public FSEditLog getEditLog() {
        return this.getFSImage().getEditLog();
    }

    @Metric(value={"MissingBlocks", "Number of missing blocks"})
    public long getMissingBlocksCount() {
        return this.blockManager.getMissingBlocksCount();
    }

    @Metric(value={"MissingReplOneBlocks", "Number of missing blocks with replication factor 1"})
    public long getMissingReplOneBlocksCount() {
        return this.blockManager.getMissingReplOneBlocksCount();
    }

    @Metric(value={"ExpiredHeartbeats", "Number of expired heartbeats"}, type=Metric.Type.COUNTER)
    public int getExpiredHeartbeats() {
        return this.datanodeStatistics.getExpiredHeartbeats();
    }

    @Metric(value={"TransactionsSinceLastCheckpoint", "Number of transactions since last checkpoint"})
    public long getTransactionsSinceLastCheckpoint() {
        return this.getFSImage().getLastAppliedOrWrittenTxId() - this.getFSImage().getStorage().getMostRecentCheckpointTxId();
    }

    @Metric(value={"TransactionsSinceLastLogRoll", "Number of transactions since last edit log roll"})
    public long getTransactionsSinceLastLogRoll() {
        if (this.isInStandbyState() || !this.getEditLog().isSegmentOpenWithoutLock()) {
            return 0L;
        }
        return this.getEditLog().getLastWrittenTxIdWithoutLock() - this.getEditLog().getCurSegmentTxIdWithoutLock() + 1L;
    }

    private long getCorrectTransactionsSinceLastLogRoll() {
        if (this.isInStandbyState() || !this.getEditLog().isSegmentOpen()) {
            return 0L;
        }
        return this.getEditLog().getLastWrittenTxId() - this.getEditLog().getCurSegmentTxId() + 1L;
    }

    @Metric(value={"LastWrittenTransactionId", "Transaction ID written to the edit log"})
    public long getLastWrittenTransactionId() {
        return this.getEditLog().getLastWrittenTxIdWithoutLock();
    }

    @Metric(value={"LastCheckpointTime", "Time in milliseconds since the epoch of the last checkpoint"})
    public long getLastCheckpointTime() {
        return this.getFSImage().getStorage().getMostRecentCheckpointTime();
    }

    long[] getStats() {
        long[] stats = this.datanodeStatistics.getStats();
        stats[3] = this.getLowRedundancyBlocks();
        stats[4] = this.getCorruptReplicaBlocks();
        stats[5] = this.getMissingBlocksCount();
        stats[6] = this.getMissingReplOneBlocksCount();
        stats[7] = this.blockManager.getBytesInFuture();
        stats[8] = this.blockManager.getPendingDeletionBlocksCount();
        return stats;
    }

    ReplicatedBlockStats getReplicatedBlockStats() {
        return new ReplicatedBlockStats(this.getLowRedundancyReplicatedBlocks(), this.getCorruptReplicatedBlocks(), this.getMissingReplicatedBlocks(), this.getMissingReplicationOneBlocks(), this.getBytesInFutureReplicatedBlocks(), this.getPendingDeletionReplicatedBlocks(), Long.valueOf(this.getHighestPriorityLowRedundancyReplicatedBlocks()));
    }

    ECBlockGroupStats getECBlockGroupStats() {
        return new ECBlockGroupStats(this.getLowRedundancyECBlockGroups(), this.getCorruptECBlockGroups(), this.getMissingECBlockGroups(), this.getBytesInFutureECBlockGroups(), this.getPendingDeletionECBlocks(), Long.valueOf(this.getHighestPriorityLowRedundancyECBlocks()));
    }

    @Override
    @Metric(value={"CapacityTotal", "Total raw capacity of data nodes in bytes"})
    public long getCapacityTotal() {
        return this.datanodeStatistics.getCapacityTotal();
    }

    @Metric(value={"CapacityTotalGB", "Total raw capacity of data nodes in GB"})
    public float getCapacityTotalGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityTotal());
    }

    @Override
    @Metric(value={"CapacityUsed", "Total used capacity across all data nodes in bytes"})
    public long getCapacityUsed() {
        return this.datanodeStatistics.getCapacityUsed();
    }

    @Metric(value={"CapacityUsedGB", "Total used capacity across all data nodes in GB"})
    public float getCapacityUsedGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityUsed());
    }

    @Override
    @Metric(value={"CapacityRemaining", "Remaining capacity in bytes"})
    public long getCapacityRemaining() {
        return this.datanodeStatistics.getCapacityRemaining();
    }

    @Override
    @Metric(value={"ProvidedCapacityTotal", "Total space used in PROVIDED storage in bytes"})
    public long getProvidedCapacityTotal() {
        return this.datanodeStatistics.getProvidedCapacity();
    }

    @Metric(value={"CapacityRemainingGB", "Remaining capacity in GB"})
    public float getCapacityRemainingGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityRemaining());
    }

    @Metric(value={"CapacityUsedNonDFS", "Total space used by data nodes for non DFS purposes in bytes"})
    public long getCapacityUsedNonDFS() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    @Metric
    public int getTotalLoad() {
        return this.datanodeStatistics.getXceiverCount();
    }

    @Metric(value={"SnapshottableDirectories", "Number of snapshottable directories"})
    public int getNumSnapshottableDirs() {
        return this.snapshotManager.getNumSnapshottableDirs();
    }

    @Metric(value={"Snapshots", "The number of snapshots"})
    public int getNumSnapshots() {
        return this.snapshotManager.getNumSnapshots();
    }

    @Override
    public String getSnapshotStats() {
        HashMap<String, Integer> info = new HashMap<String, Integer>();
        info.put("SnapshottableDirectories", this.getNumSnapshottableDirs());
        info.put("Snapshots", this.getNumSnapshots());
        return JSON.toString(info);
    }

    @Override
    @Metric(value={"NumEncryptionZones", "The number of encryption zones"})
    public int getNumEncryptionZones() {
        return this.dir.ezManager.getNumEncryptionZones();
    }

    @Override
    @Metric(value={"CurrentTokensCount", "The number of delegation tokens"})
    public long getCurrentTokensCount() {
        return this.dtSecretManager != null ? this.dtSecretManager.getCurrentTokensSize() : -1L;
    }

    @Override
    @Metric(value={"LockQueueLength", "Number of threads waiting to acquire FSNameSystemLock"})
    public int getFsLockQueueLength() {
        return this.fsLock.getQueueLength();
    }

    @Metric(value={"ReadLockLongHoldCount", "The number of time the read lock has been held for longer than the threshold"}, type=Metric.Type.COUNTER)
    public long getNumOfReadLockLongHold() {
        return this.fsLock.getNumOfReadLockLongHold();
    }

    @Metric(value={"WriteLockLongHoldCount", "The number of time the write lock has been held for longer than the threshold"}, type=Metric.Type.COUNTER)
    public long getNumOfWriteLockLongHold() {
        return this.fsLock.getNumOfWriteLockLongHold();
    }

    int getNumberOfDatanodes(HdfsConstants.DatanodeReportType type) {
        this.readLock();
        try {
            int n = this.getBlockManager().getDatanodeManager().getDatanodeListForReport(type).size();
            return n;
        }
        finally {
            this.readUnlock("getNumberOfDatanodes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        DatanodeInfo[] arr;
        String operationName = "datanodeReport";
        this.checkSuperuserPrivilege(operationName);
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            DatanodeManager dm = this.getBlockManager().getDatanodeManager();
            List<DatanodeDescriptor> results = dm.getDatanodeListForReport(type);
            arr = new DatanodeInfo[results.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = new DatanodeInfo.DatanodeInfoBuilder().setFrom((DatanodeInfo)results.get(i)).build();
                arr[i].setNumBlocks(results.get(i).numBlocks());
            }
        }
        finally {
            this.readUnlock(operationName);
        }
        this.logAuditEvent(true, operationName, null);
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        DatanodeStorageReport[] reports;
        String operationName = "getDatanodeStorageReport";
        this.checkSuperuserPrivilege(operationName);
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            DatanodeManager dm = this.getBlockManager().getDatanodeManager();
            reports = dm.getDatanodeStorageReport(type);
        }
        finally {
            this.readUnlock(operationName);
        }
        this.logAuditEvent(true, operationName, null);
        return reports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveNamespace(long timeWindow, long txGap) throws IOException {
        String operationName = "saveNamespace";
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.checkSuperuserPrivilege(operationName);
        boolean saved = false;
        this.cpLock();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            if (!this.isInSafeMode()) {
                throw new IOException("Safe mode should be turned ON in order to create namespace image.");
            }
            saved = this.getFSImage().saveNamespace(timeWindow, txGap, this);
        }
        finally {
            this.readUnlock(operationName);
            this.cpUnlock();
        }
        if (saved) {
            LOG.info("New namespace image has been created");
        }
        this.logAuditEvent(true, operationName, null);
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean restoreFailedStorage(String arg) throws IOException {
        String operationName = this.getFailedStorageCommand(arg);
        boolean val = false;
        this.checkSuperuserPrivilege(operationName);
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.cpLock();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            if (arg.equals("check")) {
                val = this.getFSImage().getStorage().getRestoreFailedStorage();
            } else {
                val = arg.equals("true");
                this.getFSImage().getStorage().setRestoreFailedStorage(val);
            }
        }
        finally {
            this.writeUnlock(operationName);
            this.cpUnlock();
        }
        this.logAuditEvent(true, operationName, null);
        return val;
    }

    Date getStartTime() {
        return new Date(this.startTime);
    }

    void finalizeUpgrade() throws IOException {
        String operationName = "finalizeUpgrade";
        this.checkSuperuserPrivilege(operationName);
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.cpLock();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            this.getFSImage().finalizeUpgrade(this.isHaEnabled() && this.inActiveState());
        }
        finally {
            this.writeUnlock(operationName);
            this.cpUnlock();
        }
        this.logAuditEvent(true, operationName, null);
    }

    void refreshNodes() throws IOException {
        String operationName = "refreshNodes";
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.checkSuperuserPrivilege(operationName);
        this.getBlockManager().getDatanodeManager().refreshNodes((Configuration)new HdfsConfiguration());
        this.logAuditEvent(true, operationName, null);
    }

    void setBalancerBandwidth(long bandwidth) throws IOException {
        String operationName = "setBalancerBandwidth";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkSuperuserPrivilege(operationName);
        this.getBlockManager().getDatanodeManager().setBalancerBandwidth(bandwidth);
        this.logAuditEvent(true, operationName, null);
    }

    boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        String operationName = action.toString().toLowerCase();
        boolean error = false;
        if (action != HdfsConstants.SafeModeAction.SAFEMODE_GET) {
            this.checkSuperuserPrivilege(operationName);
            switch (action) {
                case SAFEMODE_LEAVE: {
                    this.leaveSafeMode(false);
                    break;
                }
                case SAFEMODE_ENTER: {
                    this.enterSafeMode(false);
                    break;
                }
                case SAFEMODE_FORCE_EXIT: {
                    this.leaveSafeMode(true);
                    break;
                }
                default: {
                    LOG.error("Unexpected safe mode action");
                    error = true;
                }
            }
        }
        if (!error) {
            this.logAuditEvent(true, operationName, null);
        }
        return this.isInSafeMode();
    }

    @Override
    @Metric
    public long getBlocksTotal() {
        return this.blockManager.getTotalBlocks();
    }

    @Metric(value={"NumFilesUnderConstruction", "Number of files under construction"})
    public long getNumFilesUnderConstruction() {
        return this.leaseManager.countPath();
    }

    @Metric(value={"NumActiveClients", "Number of active clients holding lease"})
    public long getNumActiveClients() {
        return this.leaseManager.countLease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompleteBlocksTotal() {
        long numUCBlocks = 0L;
        this.readLock();
        try {
            numUCBlocks = this.leaseManager.getNumUnderConstructionBlocks();
            long l = this.getBlocksTotal() - numUCBlocks;
            return l;
        }
        finally {
            this.readUnlock("getCompleteBlocksTotal");
        }
    }

    @Override
    public boolean isInSafeMode() {
        return this.isInManualOrResourceLowSafeMode() || this.blockManager.isInSafeMode();
    }

    @Override
    public boolean isInStartupSafeMode() {
        return !this.isInManualOrResourceLowSafeMode() && this.blockManager.isInSafeMode();
    }

    void enterSafeMode(boolean resourcesLow) throws IOException {
        this.writeLock();
        try {
            this.stopSecretManager();
            boolean isEditlogOpenForWrite = this.getEditLog().isOpenForWrite();
            if (isEditlogOpenForWrite) {
                this.getEditLog().logSyncAll();
            }
            this.setManualAndResourceLowSafeMode(!resourcesLow, resourcesLow);
            NameNode.stateChangeLog.info("STATE* Safe mode is ON.\n" + this.getSafeModeTip());
        }
        finally {
            this.writeUnlock("enterSafeMode");
        }
    }

    void leaveSafeMode(boolean force) {
        this.writeLock();
        try {
            if (!this.isInSafeMode()) {
                NameNode.stateChangeLog.info("STATE* Safe mode is already OFF");
                return;
            }
            if (this.blockManager.leaveSafeMode(force)) {
                this.setManualAndResourceLowSafeMode(false, false);
                this.startSecretManagerIfNecessary();
            }
        }
        finally {
            this.writeUnlock("leaveSafeMode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSafeModeTip() {
        String cmd = "Use \"hdfs dfsadmin -safemode leave\" to turn safe mode off.";
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.resourceLowSafeMode) {
                return "Resources are low on NN. Please add or free up more resourcesthen turn off safe mode manually. NOTE:  If you turn off safe mode before adding resources, the NN will immediately return to safe mode. " + cmd;
            }
            if (this.manualSafeMode) {
                return "It was turned on manually. " + cmd;
            }
        }
        return this.blockManager.getSafeModeTip();
    }

    private synchronized boolean isInManualOrResourceLowSafeMode() {
        return this.manualSafeMode || this.resourceLowSafeMode;
    }

    private synchronized void setManualAndResourceLowSafeMode(boolean manual, boolean resourceLow) {
        this.manualSafeMode = manual;
        this.resourceLowSafeMode = resourceLow;
    }

    CheckpointSignature rollEditLog() throws IOException {
        String operationName = "rollEditLog";
        CheckpointSignature result = null;
        this.checkSuperuserPrivilege(operationName);
        this.checkOperation(NameNode.OperationCategory.JOURNAL);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.JOURNAL);
            this.checkNameNodeSafeMode("Log not rolled");
            if (Server.isRpcInvocation()) {
                LOG.info("Roll Edit Log from " + Server.getRemoteAddress());
            }
            result = this.getFSImage().rollEditLog(this.getEffectiveLayoutVersion());
        }
        finally {
            this.writeUnlock(operationName);
        }
        this.logAuditEvent(true, operationName, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamenodeCommand startCheckpoint(NamenodeRegistration backupNode, NamenodeRegistration activeNamenode) throws IOException {
        this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
            this.checkNameNodeSafeMode("Checkpoint not started");
            LOG.info("Start checkpoint for " + backupNode.getAddress());
            NamenodeCommand cmd = this.getFSImage().startCheckpoint(backupNode, activeNamenode, this.getEffectiveLayoutVersion());
            this.getEditLog().logSync();
            NamenodeCommand namenodeCommand = cmd;
            return namenodeCommand;
        }
        finally {
            this.writeUnlock("startCheckpoint");
        }
    }

    public void processIncrementalBlockReport(DatanodeID nodeID, StorageReceivedDeletedBlocks srdb) throws IOException {
        this.writeLock();
        try {
            this.blockManager.processIncrementalBlockReport(nodeID, srdb);
        }
        finally {
            this.writeUnlock("processIncrementalBlockReport");
        }
    }

    void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
            this.checkNameNodeSafeMode("Checkpoint not ended");
            LOG.info("End checkpoint for " + registration.getAddress());
            this.getFSImage().endCheckpoint(sig);
        }
        finally {
            this.readUnlock("endCheckpoint");
        }
    }

    PermissionStatus createFsOwnerPermissions(FsPermission permission) {
        return new PermissionStatus(this.fsOwner.getShortUserName(), this.supergroup, permission);
    }

    void checkSuperuserPrivilege() throws AccessControlException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker pc = this.getPermissionChecker();
            pc.checkSuperuserPrivilege();
        }
    }

    void checkSuperuserPrivilege(FSPermissionChecker pc) throws AccessControlException {
        if (this.isPermissionEnabled) {
            pc.checkSuperuserPrivilege();
        }
    }

    void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    @Override
    public long getMaxObjects() {
        return this.maxFsObjects;
    }

    @Override
    @Metric
    public long getFilesTotal() {
        return this.dir.totalInodes();
    }

    @Override
    @Metric
    @Deprecated
    public long getPendingReplicationBlocks() {
        return this.blockManager.getPendingReconstructionBlocksCount();
    }

    @Override
    @Metric
    public long getPendingReconstructionBlocks() {
        return this.blockManager.getPendingReconstructionBlocksCount();
    }

    @Override
    @Metric
    @Deprecated
    public long getUnderReplicatedBlocks() {
        return this.blockManager.getLowRedundancyBlocksCount();
    }

    @Override
    @Metric
    public long getLowRedundancyBlocks() {
        return this.blockManager.getLowRedundancyBlocksCount();
    }

    @Metric(value={"CorruptBlocks", "Number of blocks with corrupt replicas"})
    public long getCorruptReplicaBlocks() {
        return this.blockManager.getCorruptReplicaBlocksCount();
    }

    @Override
    @Metric
    public long getScheduledReplicationBlocks() {
        return this.blockManager.getScheduledReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getPendingDeletionBlocks() {
        return this.blockManager.getPendingDeletionBlocksCount();
    }

    @Override
    @Metric(value={"LowRedundancyReplicatedBlocks", "Number of low redundancy replicated blocks"})
    public long getLowRedundancyReplicatedBlocks() {
        return this.blockManager.getLowRedundancyBlocks();
    }

    @Override
    @Metric(value={"CorruptReplicatedBlocks", "Number of corrupted replicated blocks"})
    public long getCorruptReplicatedBlocks() {
        return this.blockManager.getCorruptBlocks();
    }

    @Override
    @Metric(value={"MissingReplicatedBlocks", "Number of missing replicated blocks"})
    public long getMissingReplicatedBlocks() {
        return this.blockManager.getMissingBlocks();
    }

    @Override
    @Metric(value={"MissingReplicationOneBlocks", "Number of missing replicated blocks with replication factor 1"})
    public long getMissingReplicationOneBlocks() {
        return this.blockManager.getMissingReplicationOneBlocks();
    }

    @Override
    @Metric(value={"HighestPriorityLowRedundancyReplicatedBlocks", "Number of replicated blocks which have the highest risk of loss."})
    public long getHighestPriorityLowRedundancyReplicatedBlocks() {
        return this.blockManager.getHighestPriorityReplicatedBlockCount();
    }

    @Override
    @Metric(value={"HighestPriorityLowRedundancyECBlocks", "Number of erasure coded blocks which have the highest risk of loss."})
    public long getHighestPriorityLowRedundancyECBlocks() {
        return this.blockManager.getHighestPriorityECBlockCount();
    }

    @Override
    @Metric(value={"BytesInFutureReplicatedBlocks", "Total bytes in replicated blocks with future generation stamp"})
    public long getBytesInFutureReplicatedBlocks() {
        return this.blockManager.getBytesInFutureReplicatedBlocks();
    }

    @Override
    @Metric(value={"PendingDeletionReplicatedBlocks", "Number of replicated blocks that are pending deletion"})
    public long getPendingDeletionReplicatedBlocks() {
        return this.blockManager.getPendingDeletionReplicatedBlocks();
    }

    @Override
    @Metric(value={"TotalReplicatedBlocks", "Total number of replicated blocks"})
    public long getTotalReplicatedBlocks() {
        return this.blockManager.getTotalReplicatedBlocks();
    }

    @Override
    @Metric(value={"LowRedundancyECBlockGroups", "Number of erasure coded block groups with low redundancy"})
    public long getLowRedundancyECBlockGroups() {
        return this.blockManager.getLowRedundancyECBlockGroups();
    }

    @Override
    @Metric(value={"CorruptECBlockGroups", "Number of erasure coded block groups that are corrupt"})
    public long getCorruptECBlockGroups() {
        return this.blockManager.getCorruptECBlockGroups();
    }

    @Override
    @Metric(value={"MissingECBlockGroups", "Number of erasure coded block groups that are missing"})
    public long getMissingECBlockGroups() {
        return this.blockManager.getMissingECBlockGroups();
    }

    @Override
    @Metric(value={"BytesInFutureECBlockGroups", "Total bytes in erasure coded block groups with future generation stamp"})
    public long getBytesInFutureECBlockGroups() {
        return this.blockManager.getBytesInFutureECBlockGroups();
    }

    @Override
    @Metric(value={"PendingDeletionECBlocks", "Number of erasure coded blocks that are pending deletion"})
    public long getPendingDeletionECBlocks() {
        return this.blockManager.getPendingDeletionECBlocks();
    }

    @Override
    @Metric(value={"TotalECBlockGroups", "Total number of erasure coded block groups"})
    public long getTotalECBlockGroups() {
        return this.blockManager.getTotalECBlockGroups();
    }

    @Override
    @Metric(value={"EnabledEcPolicies", "Enabled erasure coding policies"})
    public String getEnabledEcPolicies() {
        return this.getErasureCodingPolicyManager().getEnabledPoliciesMetric();
    }

    @Override
    public long getBlockDeletionStartTime() {
        return this.startTime + this.blockManager.getStartupDelayBlockDeletionInMs();
    }

    @Metric
    public long getExcessBlocks() {
        return this.blockManager.getExcessBlocksCount();
    }

    @Metric
    public long getNumTimedOutPendingReconstructions() {
        return this.blockManager.getNumTimedOutPendingReconstructions();
    }

    @Metric
    public long getPostponedMisreplicatedBlocks() {
        return this.blockManager.getPostponedMisreplicatedBlocksCount();
    }

    @Metric
    public int getPendingDataNodeMessageCount() {
        return this.blockManager.getPendingDataNodeMessageCount();
    }

    @Metric
    public String getHAState() {
        return this.haContext.getState().toString();
    }

    @Metric
    public long getMillisSinceLastLoadedEdits() {
        if (this.isInStandbyState() && this.editLogTailer != null) {
            return Time.monotonicNow() - this.editLogTailer.getLastLoadTimeMs();
        }
        return 0L;
    }

    @Metric
    public int getBlockCapacity() {
        return this.blockManager.getCapacity();
    }

    public HAServiceProtocol.HAServiceState getState() {
        return this.haContext == null ? null : this.haContext.getState().getServiceState();
    }

    @Override
    public String getFSState() {
        return this.isInSafeMode() ? "safeMode" : "Operational";
    }

    private void registerMBean() {
        try {
            StandardMBean namesystemBean = new StandardMBean(this, FSNamesystemMBean.class);
            StandardMBean replicaBean = new StandardMBean(this, ReplicatedBlocksMBean.class);
            StandardMBean ecBean = new StandardMBean(this, ECBlockGroupsMBean.class);
            this.namesystemMBeanName = MBeans.register((String)"NameNode", (String)"FSNamesystemState", (Object)namesystemBean);
            this.replicatedBlocksMBeanName = MBeans.register((String)"NameNode", (String)"ReplicatedBlocksState", (Object)replicaBean);
            this.ecBlockGroupsMBeanName = MBeans.register((String)"NameNode", (String)"ECBlockGroupsState", (Object)ecBean);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad MBean setup", e);
        }
        LOG.info("Registered FSNamesystemState, ReplicatedBlocksState and ECBlockGroupsState MBeans.");
    }

    void shutdown() {
        if (this.snapshotManager != null) {
            this.snapshotManager.shutdown();
        }
        if (this.namesystemMBeanName != null) {
            MBeans.unregister((ObjectName)this.namesystemMBeanName);
            this.namesystemMBeanName = null;
        }
        if (this.replicatedBlocksMBeanName != null) {
            MBeans.unregister((ObjectName)this.replicatedBlocksMBeanName);
            this.replicatedBlocksMBeanName = null;
        }
        if (this.ecBlockGroupsMBeanName != null) {
            MBeans.unregister((ObjectName)this.ecBlockGroupsMBeanName);
            this.ecBlockGroupsMBeanName = null;
        }
        if (this.namenodeMXBeanName != null) {
            MBeans.unregister((ObjectName)this.namenodeMXBeanName);
            this.namenodeMXBeanName = null;
        }
        if (this.dir != null) {
            this.dir.shutdown();
        }
        if (this.blockManager != null) {
            this.blockManager.shutdown();
        }
        if (this.provider != null) {
            try {
                this.provider.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close provider.", (Throwable)e);
            }
        }
    }

    @Override
    @Metric(value={"NumLiveDataNodes", "Number of datanodes which are currently live"})
    public int getNumLiveDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumLiveDataNodes();
    }

    @Override
    @Metric(value={"NumDeadDataNodes", "Number of datanodes which are currently dead"})
    public int getNumDeadDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumDeadDataNodes();
    }

    @Override
    @Metric(value={"NumDecomLiveDataNodes", "Number of datanodes which have been decommissioned and are now live"})
    public int getNumDecomLiveDataNodes() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, false);
        int liveDecommissioned = 0;
        for (DatanodeDescriptor node : live) {
            liveDecommissioned += node.isDecommissioned() ? 1 : 0;
        }
        return liveDecommissioned;
    }

    @Override
    @Metric(value={"NumDecomDeadDataNodes", "Number of datanodes which have been decommissioned and are now dead"})
    public int getNumDecomDeadDataNodes() {
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(null, dead, false);
        int deadDecommissioned = 0;
        for (DatanodeDescriptor node : dead) {
            deadDecommissioned += node.isDecommissioned() ? 1 : 0;
        }
        return deadDecommissioned;
    }

    @Override
    @Metric(value={"NumInServiceLiveDataNodes", "Number of live datanodes which are currently in service"})
    public int getNumInServiceLiveDataNodes() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, true);
        int liveInService = live.size();
        for (DatanodeDescriptor node : live) {
            liveInService -= node.isInMaintenance() ? 1 : 0;
        }
        return liveInService;
    }

    @Override
    @Metric(value={"VolumeFailuresTotal", "Total number of volume failures across all Datanodes"})
    public int getVolumeFailuresTotal() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, false);
        int volumeFailuresTotal = 0;
        for (DatanodeDescriptor node : live) {
            volumeFailuresTotal += node.getVolumeFailures();
        }
        return volumeFailuresTotal;
    }

    @Override
    @Metric(value={"EstimatedCapacityLostTotal", "An estimate of the total capacity lost due to volume failures"})
    public long getEstimatedCapacityLostTotal() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, false);
        long estimatedCapacityLostTotal = 0L;
        for (DatanodeDescriptor node : live) {
            VolumeFailureSummary volumeFailureSummary = node.getVolumeFailureSummary();
            if (volumeFailureSummary == null) continue;
            estimatedCapacityLostTotal += volumeFailureSummary.getEstimatedCapacityLostTotal();
        }
        return estimatedCapacityLostTotal;
    }

    @Override
    @Metric(value={"NumDecommissioningDataNodes", "Number of datanodes in decommissioning state"})
    public int getNumDecommissioningDataNodes() {
        return this.getBlockManager().getDatanodeManager().getDecommissioningNodes().size();
    }

    @Override
    @Metric(value={"StaleDataNodes", "Number of datanodes marked stale due to delayed heartbeat"})
    public int getNumStaleDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumStaleNodes();
    }

    @Override
    @Metric(value={"NumStaleStorages", "Number of storages marked as content stale"})
    public int getNumStaleStorages() {
        return this.getBlockManager().getDatanodeManager().getNumStaleStorages();
    }

    @Override
    public String getTopUserOpCounts() {
        if (!this.topConf.isEnabled) {
            return null;
        }
        Date now = new Date();
        List<RollingWindowManager.TopWindow> topWindows = this.topMetrics.getTopWindows();
        TreeMap<String, Object> topMap = new TreeMap<String, Object>();
        topMap.put("windows", topWindows);
        topMap.put("timestamp", DFSUtil.dateToIso8601String(now));
        try {
            return JsonUtil.toJsonString(topMap);
        }
        catch (IOException e) {
            LOG.warn("Failed to fetch TopUser metrics", (Throwable)e);
            return null;
        }
    }

    long nextGenerationStamp(boolean legacyBlock) throws IOException {
        assert (this.hasWriteLock());
        this.checkNameNodeSafeMode("Cannot get next generation stamp");
        long gs = this.blockManager.nextGenerationStamp(legacyBlock);
        if (legacyBlock) {
            this.getEditLog().logLegacyGenerationStamp(gs);
        } else {
            this.getEditLog().logGenerationStamp(gs);
        }
        return gs;
    }

    private long nextBlockId(BlockType blockType) throws IOException {
        assert (this.hasWriteLock());
        this.checkNameNodeSafeMode("Cannot get next block ID");
        long blockId = this.blockManager.nextBlockId(blockType);
        this.getEditLog().logAllocateBlockId(blockId);
        return blockId;
    }

    boolean isFileDeleted(INodeFile file) {
        assert (this.hasReadLock());
        if (this.dir.getInode(file.getId()) == null) {
            return true;
        }
        INodeWithAdditionalFields tmpChild = file;
        INodeDirectory tmpParent = file.getParent();
        while (true) {
            if (tmpParent == null) {
                return true;
            }
            INode childINode = tmpParent.getChild(tmpChild.getLocalNameBytes(), 0x7FFFFFFE);
            if (childINode == null || !childINode.equals(tmpChild)) {
                return true;
            }
            if (tmpParent.isRoot()) break;
            tmpChild = tmpParent;
            tmpParent = tmpParent.getParent();
        }
        return file.isWithSnapshot() && file.getFileWithSnapshotFeature().isCurrentFileDeleted();
    }

    private INodeFile checkUCBlock(ExtendedBlock block, String clientName) throws IOException {
        assert (this.hasWriteLock());
        this.checkNameNodeSafeMode("Cannot get a new generation stamp and an access token for block " + block);
        BlockInfo storedBlock = this.getStoredBlock(ExtendedBlock.getLocalBlock((ExtendedBlock)block));
        if (storedBlock == null) {
            throw new IOException(block + " does not exist.");
        }
        if (storedBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION) {
            throw new IOException("Unexpected BlockUCState: " + block + " is " + (Object)((Object)storedBlock.getBlockUCState()) + " but not " + (Object)((Object)HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION));
        }
        INodeFile file = this.getBlockCollection(storedBlock);
        if (file == null || !file.isUnderConstruction() || this.isFileDeleted(file)) {
            throw new IOException("The file " + (Object)((Object)storedBlock) + " belonged to does not exist or it is not under construction.");
        }
        if (clientName == null || !clientName.equals(file.getFileUnderConstructionFeature().getClientName())) {
            throw new LeaseExpiredException("Lease mismatch: " + block + " is accessed by a non lease holder " + clientName);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            for (int i = 0; i < blocks.length; ++i) {
                ExtendedBlock blk = blocks[i].getBlock();
                DatanodeInfoWithStorage[] nodes = blocks[i].getLocations();
                String[] storageIDs = blocks[i].getStorageIDs();
                for (int j = 0; j < nodes.length; ++j) {
                    NameNode.stateChangeLog.info("*DIR* reportBadBlocks for block: {} on datanode: {}", (Object)blk, (Object)nodes[j].getXferAddr());
                    this.blockManager.findAndMarkBlockAsCorrupt(blk, (DatanodeInfo)nodes[j], storageIDs == null ? null : storageIDs[j], "client machine reported it");
                }
            }
        }
        finally {
            this.writeUnlock("reportBadBlocks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock bumpBlockGenerationStamp(ExtendedBlock block, String clientName) throws IOException {
        LocatedBlock locatedBlock;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            INodeFile file = this.checkUCBlock(block, clientName);
            block.setGenerationStamp(this.nextGenerationStamp(this.blockManager.isLegacyBlock(block.getLocalBlock())));
            locatedBlock = BlockManager.newLocatedBlock(block, file.getLastBlock(), null, -1L);
            this.blockManager.setBlockToken(locatedBlock, BlockTokenIdentifier.AccessMode.WRITE);
        }
        finally {
            this.writeUnlock("bumpBlockGenerationStamp");
        }
        this.getEditLog().logSync();
        return locatedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs, boolean logRetryCache) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        LOG.info("updatePipeline(" + oldBlock.getLocalBlock() + ", newGS=" + newBlock.getGenerationStamp() + ", newLength=" + newBlock.getNumBytes() + ", newNodes=" + Arrays.asList(newNodes) + ", client=" + clientName + ")");
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Pipeline not updated");
            assert (newBlock.getBlockId() == oldBlock.getBlockId()) : newBlock + " and " + oldBlock + " has different block identifier";
            this.updatePipelineInternal(clientName, oldBlock, newBlock, newNodes, newStorageIDs, logRetryCache);
        }
        finally {
            this.writeUnlock("updatePipeline");
        }
        this.getEditLog().logSync();
        LOG.info("updatePipeline(" + oldBlock.getLocalBlock() + " => " + newBlock.getLocalBlock() + ") success");
    }

    private void updatePipelineInternal(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs, boolean logRetryCache) throws IOException {
        assert (this.hasWriteLock());
        INodeFile pendingFile = this.checkUCBlock(oldBlock, clientName);
        String src = pendingFile.getFullPathName();
        BlockInfo lastBlock = pendingFile.getLastBlock();
        assert (!lastBlock.isComplete());
        if (newBlock.getGenerationStamp() <= lastBlock.getGenerationStamp()) {
            String msg = "Update " + oldBlock + " but the new block " + newBlock + " does not have a larger generation stamp than the last block " + (Object)((Object)lastBlock);
            LOG.warn(msg);
            throw new IOException(msg);
        }
        if (newBlock.getNumBytes() < lastBlock.getNumBytes()) {
            String msg = "Update " + oldBlock + " (size=" + oldBlock.getNumBytes() + ") to a smaller size block " + newBlock + " (size=" + newBlock.getNumBytes() + ")";
            LOG.warn(msg);
            throw new IOException(msg);
        }
        this.blockManager.updateLastBlock(lastBlock, newBlock);
        DatanodeStorageInfo[] storages = this.blockManager.getDatanodeManager().getDatanodeStorageInfos(newNodes, newStorageIDs, "src=%s, oldBlock=%s, newBlock=%s, clientName=%s", src, oldBlock, newBlock, clientName);
        lastBlock.getUnderConstructionFeature().setExpectedLocations(lastBlock, storages, lastBlock.getBlockType());
        FSDirWriteFileOp.persistBlocks(this.dir, src, pendingFile, logRetryCache);
    }

    void registerBackupNode(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        this.writeLock();
        try {
            if (this.getFSImage().getStorage().getNamespaceID() != bnReg.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getStorage().getNamespaceID() + "; " + (Object)((Object)bnReg.getRole()) + " node namespaceID = " + bnReg.getNamespaceID());
            }
            if (bnReg.getRole() == HdfsServerConstants.NamenodeRole.BACKUP) {
                this.getFSImage().getEditLog().registerBackupNode(bnReg, nnReg);
            }
        }
        finally {
            this.writeUnlock("registerBackupNode");
        }
    }

    void releaseBackupNode(NamenodeRegistration registration) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.getFSImage().getStorage().getNamespaceID() != registration.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getStorage().getNamespaceID() + "; " + (Object)((Object)registration.getRole()) + " node namespaceID = " + registration.getNamespaceID());
            }
            this.getEditLog().releaseBackupStream(registration);
        }
        finally {
            this.writeUnlock("releaseBackupNode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CorruptFileBlockInfo> listCorruptFileBlocks(String path, String[] cookieTab) throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.READ);
        int count = 0;
        ArrayList<CorruptFileBlockInfo> corruptFiles = new ArrayList<CorruptFileBlockInfo>();
        if (cookieTab == null) {
            cookieTab = new String[]{null};
        }
        if (this.blockManager.getMissingBlocksCount() == 0L) {
            if (cookieTab[0] == null) {
                cookieTab[0] = String.valueOf(FSNamesystem.getIntCookie(cookieTab[0]));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("there are no corrupt file blocks.");
            }
            return corruptFiles;
        }
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (!this.blockManager.isPopulatingReplQueues()) {
                throw new IOException("Cannot run listCorruptFileBlocks because replication queues have not been initialized.");
            }
            Iterator<BlockInfo> blkIterator = this.blockManager.getCorruptReplicaBlockIterator();
            int skip = FSNamesystem.getIntCookie(cookieTab[0]);
            for (int i = 0; i < skip && blkIterator.hasNext(); ++i) {
                blkIterator.next();
            }
            while (blkIterator.hasNext()) {
                String src;
                BlockInfo blk = blkIterator.next();
                INodeFile inode = this.getBlockCollection(blk);
                ++skip;
                if (inode == null || !DFSUtil.isParentEntry(src = inode.getFullPathName(), path)) continue;
                corruptFiles.add(new CorruptFileBlockInfo(src, blk));
                if (++count < this.maxCorruptFileBlocksReturn) continue;
                break;
            }
            cookieTab[0] = String.valueOf(skip);
            LOG.debug("list corrupt file blocks returned: {}", (Object)count);
            ArrayList<CorruptFileBlockInfo> arrayList = corruptFiles;
            return arrayList;
        }
        finally {
            this.readUnlock("listCorruptFileBlocks");
        }
    }

    private static int getIntCookie(String cookie) {
        int c;
        if (cookie == null) {
            c = 0;
        } else {
            try {
                c = Integer.parseInt(cookie);
            }
            catch (NumberFormatException e) {
                c = 0;
            }
        }
        c = Math.max(0, c);
        return c;
    }

    private DelegationTokenSecretManager createDelegationTokenSecretManager(Configuration conf) {
        return new DelegationTokenSecretManager(conf.getLong("dfs.namenode.delegation.key.update-interval", 86400000L), conf.getLong("dfs.namenode.delegation.token.max-lifetime", 604800000L), conf.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L), DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL, conf.getBoolean("dfs.namenode.audit.log.token.tracking.id", false), this);
    }

    DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.dtSecretManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        String tokenId;
        Token token;
        String operationName = "getDelegationToken";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot issue delegation token");
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be issued only with kerberos or web authentication");
            }
            if (this.dtSecretManager == null || !this.dtSecretManager.isRunning()) {
                LOG.warn("trying to get DT with no secret manager running");
                Token<DelegationTokenIdentifier> token2 = null;
                return token2;
            }
            UserGroupInformation ugi = FSNamesystem.getRemoteUser();
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, renewer, realUser);
            token = new Token((TokenIdentifier)dtId, (SecretManager)this.dtSecretManager);
            long expiryTime = this.dtSecretManager.getTokenExpiryTime(dtId);
            this.getEditLog().logGetDelegationToken(dtId, expiryTime);
            tokenId = dtId.toStringStable();
        }
        finally {
            this.writeUnlock("getDelegationToken");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "getDelegationToken", tokenId);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        String tokenId;
        long expiryTime;
        String operationName = "renewDelegationToken";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot renew delegation token");
                if (!this.isAllowedDelegationTokenOp()) {
                    throw new IOException("Delegation Token can be renewed only with kerberos or web authentication");
                }
                String renewer = FSNamesystem.getRemoteUser().getShortUserName();
                expiryTime = this.dtSecretManager.renewToken(token, renewer);
                DelegationTokenIdentifier id = DFSUtil.decodeDelegationToken(token);
                this.getEditLog().logRenewDelegationToken(id, expiryTime);
                tokenId = id.toStringStable();
            }
            finally {
                this.writeUnlock("renewDelegationToken");
            }
        }
        catch (AccessControlException ace) {
            DelegationTokenIdentifier id = DFSUtil.decodeDelegationToken(token);
            String tokenId2 = id.toStringStable();
            this.logAuditEvent(false, "renewDelegationToken", tokenId2);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "renewDelegationToken", tokenId);
        return expiryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        String tokenId;
        String operationName = "cancelDelegationToken";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot cancel delegation token");
                String canceller = FSNamesystem.getRemoteUser().getUserName();
                DelegationTokenIdentifier id = (DelegationTokenIdentifier)this.dtSecretManager.cancelToken(token, canceller);
                this.getEditLog().logCancelDelegationToken(id);
                tokenId = id.toStringStable();
            }
            finally {
                this.writeUnlock("cancelDelegationToken");
            }
        }
        catch (AccessControlException ace) {
            DelegationTokenIdentifier id = DFSUtil.decodeDelegationToken(token);
            String tokenId2 = id.toStringStable();
            this.logAuditEvent(false, "cancelDelegationToken", tokenId2);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "cancelDelegationToken", tokenId);
    }

    void saveSecretManagerStateCompat(DataOutputStream out, String sdPath) throws IOException {
        this.dtSecretManager.saveSecretManagerStateCompat(out, sdPath);
    }

    DelegationTokenSecretManager.SecretManagerState saveSecretManagerState() {
        return this.dtSecretManager.saveSecretManagerState();
    }

    void loadSecretManagerStateCompat(DataInput in) throws IOException {
        this.dtSecretManager.loadSecretManagerStateCompat(in);
    }

    void loadSecretManagerState(FsImageProto.SecretManagerSection s, List<FsImageProto.SecretManagerSection.DelegationKey> keys, List<FsImageProto.SecretManagerSection.PersistToken> tokens, StartupProgress.Counter counter) throws IOException {
        this.dtSecretManager.loadSecretManagerState(new DelegationTokenSecretManager.SecretManagerState(s, keys, tokens), counter);
    }

    public void logUpdateMasterKey(DelegationKey key) {
        assert (!this.isInSafeMode()) : "this should never be called while in safemode, since we stop the DT manager before entering safemode!";
        assert (this.hasReadLock());
        this.getEditLog().logUpdateMasterKey(key);
        this.getEditLog().logSync();
    }

    public void logExpireDelegationToken(DelegationTokenIdentifier id) {
        assert (!this.isInSafeMode()) : "this should never be called while in safemode, since we stop the DT manager before entering safemode!";
        assert (this.hasReadLock());
        this.getEditLog().logCancelDelegationToken(id);
    }

    private void logReassignLease(String leaseHolder, String src, String newHolder) {
        assert (this.hasWriteLock());
        this.getEditLog().logReassignLease(leaseHolder, src, newHolder);
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        return !UserGroupInformation.isSecurityEnabled() || this.getConnectionAuthenticationMethod().allowsDelegation();
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = FSNamesystem.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    boolean isExternalInvocation() {
        return Server.isRpcInvocation();
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    void logFsckEvent(boolean succeeded, String src, InetAddress remoteAddress) throws IOException {
        if (this.isAuditEnabled()) {
            this.logAuditEvent(succeeded, FSNamesystem.getRemoteUser(), remoteAddress, "fsck", src, null, null);
        }
    }

    private void registerMXBean() {
        this.namenodeMXBeanName = MBeans.register((String)"NameNode", (String)"NameNodeInfo", (Object)this);
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public long getUsed() {
        return this.getCapacityUsed();
    }

    @Override
    public long getFree() {
        return this.getCapacityRemaining();
    }

    @Override
    public long getTotal() {
        return this.getCapacityTotal();
    }

    @Override
    public long getProvidedCapacity() {
        return this.getProvidedCapacityTotal();
    }

    @Override
    public String getSafemode() {
        if (!this.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON. " + this.getSafeModeTip();
    }

    @Override
    public boolean isUpgradeFinalized() {
        return this.getFSImage().isUpgradeFinalized();
    }

    @Override
    public long getNonDfsUsedSpace() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    public float getPercentUsed() {
        return this.datanodeStatistics.getCapacityUsedPercent();
    }

    @Override
    public long getBlockPoolUsedSpace() {
        return this.datanodeStatistics.getBlockPoolUsed();
    }

    @Override
    public float getPercentBlockPoolUsed() {
        return this.datanodeStatistics.getPercentBlockPoolUsed();
    }

    @Override
    public float getPercentRemaining() {
        return this.datanodeStatistics.getCapacityRemainingPercent();
    }

    @Override
    public long getCacheCapacity() {
        return this.datanodeStatistics.getCacheCapacity();
    }

    @Override
    public long getCacheUsed() {
        return this.datanodeStatistics.getCacheUsed();
    }

    @Override
    public long getTotalBlocks() {
        return this.getBlocksTotal();
    }

    @Override
    public long getNumberOfMissingBlocks() {
        return this.getMissingBlocksCount();
    }

    @Override
    public long getNumberOfMissingBlocksWithReplicationFactorOne() {
        return this.getMissingReplOneBlocksCount();
    }

    @Override
    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getLiveNodes() {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, false);
        for (DatanodeDescriptor node : live) {
            ImmutableMap.Builder innerinfo = ImmutableMap.builder();
            innerinfo.put((Object)"infoAddr", (Object)node.getInfoAddr()).put((Object)"infoSecureAddr", (Object)node.getInfoSecureAddr()).put((Object)"xferaddr", (Object)node.getXferAddr()).put((Object)"location", (Object)node.getNetworkLocation()).put((Object)"lastContact", (Object)this.getLastContact(node)).put((Object)"usedSpace", (Object)this.getDfsUsed(node)).put((Object)"adminState", (Object)node.getAdminState().toString()).put((Object)"nonDfsUsedSpace", (Object)node.getNonDfsUsed()).put((Object)"capacity", (Object)node.getCapacity()).put((Object)"numBlocks", (Object)node.numBlocks()).put((Object)"version", (Object)node.getSoftwareVersion()).put((Object)"used", (Object)node.getDfsUsed()).put((Object)"remaining", (Object)node.getRemaining()).put((Object)"blockScheduled", (Object)node.getBlocksScheduled()).put((Object)"blockPoolUsed", (Object)node.getBlockPoolUsed()).put((Object)"blockPoolUsedPercent", (Object)Float.valueOf(node.getBlockPoolUsedPercent())).put((Object)"volfails", (Object)node.getVolumeFailures()).put((Object)"lastBlockReport", this.getLastBlockReport(node));
            VolumeFailureSummary volumeFailureSummary = node.getVolumeFailureSummary();
            if (volumeFailureSummary != null) {
                innerinfo.put((Object)"failedStorageIDs", (Object)volumeFailureSummary.getFailedStorageLocations()).put((Object)"lastVolumeFailureDate", (Object)volumeFailureSummary.getLastVolumeFailureDate()).put((Object)"estimatedCapacityLostTotal", (Object)volumeFailureSummary.getEstimatedCapacityLostTotal());
            }
            if (node.getUpgradeDomain() != null) {
                innerinfo.put((Object)"upgradeDomain", (Object)node.getUpgradeDomain());
            }
            info.put(node.getHostName() + ":" + node.getXferPort(), innerinfo.build());
        }
        return JSON.toString(info);
    }

    @Override
    public String getDeadNodes() {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(null, dead, false);
        for (DatanodeDescriptor node : dead) {
            ImmutableMap innerinfo = ImmutableMap.builder().put((Object)"lastContact", (Object)this.getLastContact(node)).put((Object)"decommissioned", (Object)node.isDecommissioned()).put((Object)"adminState", (Object)node.getAdminState().toString()).put((Object)"xferaddr", (Object)node.getXferAddr()).put((Object)"location", (Object)node.getNetworkLocation()).build();
            info.put(node.getHostName() + ":" + node.getXferPort(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDecomNodes() {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        List<DatanodeDescriptor> decomNodeList = this.blockManager.getDatanodeManager().getDecommissioningNodes();
        for (DatanodeDescriptor node : decomNodeList) {
            ImmutableMap innerinfo = ImmutableMap.builder().put((Object)"xferaddr", (Object)node.getXferAddr()).put((Object)"location", (Object)node.getNetworkLocation()).put((Object)"underReplicatedBlocks", (Object)node.getLeavingServiceStatus().getUnderReplicatedBlocks()).put((Object)"decommissionOnlyReplicas", (Object)node.getLeavingServiceStatus().getOutOfServiceOnlyReplicas()).put((Object)"underReplicateInOpenFiles", (Object)node.getLeavingServiceStatus().getUnderReplicatedInOpenFiles()).build();
            info.put(node.getHostName() + ":" + node.getXferPort(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getEnteringMaintenanceNodes() {
        HashMap<String, ImmutableMap> nodesMap = new HashMap<String, ImmutableMap>();
        List<DatanodeDescriptor> enteringMaintenanceNodeList = this.blockManager.getDatanodeManager().getEnteringMaintenanceNodes();
        for (DatanodeDescriptor node : enteringMaintenanceNodeList) {
            ImmutableMap attrMap = ImmutableMap.builder().put((Object)"xferaddr", (Object)node.getXferAddr()).put((Object)"location", (Object)node.getNetworkLocation()).put((Object)"underReplicatedBlocks", (Object)node.getLeavingServiceStatus().getUnderReplicatedBlocks()).put((Object)"maintenanceOnlyReplicas", (Object)node.getLeavingServiceStatus().getOutOfServiceOnlyReplicas()).put((Object)"underReplicateInOpenFiles", (Object)node.getLeavingServiceStatus().getUnderReplicatedInOpenFiles()).build();
            nodesMap.put(node.getHostName() + ":" + node.getXferPort(), attrMap);
        }
        return JSON.toString(nodesMap);
    }

    private long getLastContact(DatanodeDescriptor alivenode) {
        return (Time.monotonicNow() - alivenode.getLastUpdateMonotonic()) / 1000L;
    }

    private Object getLastBlockReport(DatanodeDescriptor node) {
        return (Time.monotonicNow() - node.getLastBlockReportMonotonic()) / 60000L;
    }

    private long getDfsUsed(DatanodeDescriptor alivenode) {
        return alivenode.getDfsUsed();
    }

    @Override
    public String getClusterId() {
        return this.getFSImage().getStorage().getClusterID();
    }

    @Override
    public String getBlockPoolId() {
        return this.getBlockManager().getBlockPoolId();
    }

    @Override
    public String getNameDirStatuses() {
        HashMap statusMap = new HashMap();
        HashMap<File, Storage.StorageDirType> activeDirs = new HashMap<File, Storage.StorageDirType>();
        Iterator<Storage.StorageDirectory> it = this.getFSImage().getStorage().dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory st = it.next();
            activeDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("active", activeDirs);
        List<Storage.StorageDirectory> removedStorageDirs = this.getFSImage().getStorage().getRemovedStorageDirs();
        HashMap<File, Storage.StorageDirType> failedDirs = new HashMap<File, Storage.StorageDirType>();
        for (Storage.StorageDirectory st : removedStorageDirs) {
            failedDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("failed", failedDirs);
        return JSON.toString(statusMap);
    }

    @Override
    public String getNodeUsage() {
        float median = 0.0f;
        float max = 0.0f;
        float min = 0.0f;
        float dev = 0.0f;
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, true);
        Iterator it = live.iterator();
        while (it.hasNext()) {
            DatanodeDescriptor node = (DatanodeDescriptor)((Object)it.next());
            if (node.isInService()) continue;
            it.remove();
        }
        if (live.size() > 0) {
            float totalDfsUsed = 0.0f;
            float[] usages = new float[live.size()];
            int i = 0;
            for (DatanodeDescriptor dn : live) {
                usages[i++] = dn.getDfsUsedPercent();
                totalDfsUsed += dn.getDfsUsedPercent();
            }
            totalDfsUsed /= (float)live.size();
            Arrays.sort(usages);
            median = usages[usages.length / 2];
            max = usages[usages.length - 1];
            min = usages[0];
            for (i = 0; i < usages.length; ++i) {
                dev += (usages[i] - totalDfsUsed) * (usages[i] - totalDfsUsed);
            }
            dev = (float)Math.sqrt(dev / (float)usages.length);
        }
        HashMap<String, String> innerInfo = new HashMap<String, String>();
        innerInfo.put("min", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(min)}));
        innerInfo.put("median", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(median)}));
        innerInfo.put("max", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(max)}));
        innerInfo.put("stdDev", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(dev)}));
        info.put("nodeUsage", innerInfo);
        return JSON.toString(info);
    }

    @Override
    public String getNameJournalStatus() {
        ArrayList jasList = new ArrayList();
        FSEditLog log = this.getFSImage().getEditLog();
        if (log != null) {
            boolean openForWrite = log.isOpenForWriteWithoutLock();
            for (JournalSet.JournalAndStream jas : log.getJournals()) {
                HashMap<String, String> jasMap = new HashMap<String, String>();
                String manager = jas.getManager().toString();
                jasMap.put("required", String.valueOf(jas.isRequired()));
                jasMap.put("disabled", String.valueOf(jas.isDisabled()));
                jasMap.put("manager", manager);
                if (jas.isDisabled()) {
                    jasMap.put("stream", "Failed");
                } else if (openForWrite) {
                    EditLogOutputStream elos = jas.getCurrentStream();
                    if (elos != null) {
                        jasMap.put("stream", elos.generateReport());
                    } else {
                        jasMap.put("stream", "not currently writing");
                    }
                } else {
                    jasMap.put("stream", "open for read");
                }
                jasList.add(jasMap);
            }
        }
        return JSON.toString(jasList);
    }

    @Override
    public String getJournalTransactionInfo() {
        HashMap<String, String> txnIdMap = new HashMap<String, String>();
        txnIdMap.put("LastAppliedOrWrittenTxId", Long.toString(this.getFSImage().getLastAppliedOrWrittenTxId()));
        txnIdMap.put("MostRecentCheckpointTxId", Long.toString(this.getFSImage().getMostRecentCheckpointTxId()));
        return JSON.toString(txnIdMap);
    }

    @Override
    public long getNNStartedTimeInMillis() {
        return this.startTime;
    }

    @Override
    public String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    @VisibleForTesting
    public void setBlockManagerForTesting(BlockManager bm) {
        this.blockManager = bm;
    }

    @Override
    public FSDirectory getFSDirectory() {
        return this.dir;
    }

    @VisibleForTesting
    public void setFSDirectory(FSDirectory dir) {
        this.dir = dir;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public ErasureCodingPolicyManager getErasureCodingPolicyManager() {
        return ErasureCodingPolicyManager.getInstance();
    }

    @Override
    public HAContext getHAContext() {
        return this.haContext;
    }

    @Override
    public String getCorruptFiles() {
        return JSON.toString(this.getCorruptFilesList());
    }

    @Override
    public int getCorruptFilesCount() {
        return this.getCorruptFilesList().size();
    }

    private List<String> getCorruptFilesList() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Collection<CorruptFileBlockInfo> corruptFileBlocks = this.listCorruptFileBlocks("/", null);
            int corruptFileCount = corruptFileBlocks.size();
            if (corruptFileCount != 0) {
                for (CorruptFileBlockInfo c : corruptFileBlocks) {
                    list.add(c.toString());
                }
            }
        }
        catch (StandbyException e) {
            LOG.debug("Get corrupt file blocks returned error: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            LOG.warn("Get corrupt file blocks returned error", (Throwable)e);
        }
        return list;
    }

    @Override
    public long getNumberOfSnapshottableDirs() {
        return this.snapshotManager.getNumSnapshottableDirs();
    }

    List<String> listCorruptFileBlocksWithSnapshot(String path, List<String> snapshottableDirs, String[] cookieTab) throws IOException {
        Collection<CorruptFileBlockInfo> corruptFileBlocks = this.listCorruptFileBlocks(path, cookieTab);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<DirectorySnapshottableFeature> lsf = new ArrayList<DirectorySnapshottableFeature>();
        if (snapshottableDirs != null) {
            for (String snap : snapshottableDirs) {
                INode isnap = this.getFSDirectory().getINode(snap, FSDirectory.DirOp.READ_LINK);
                DirectorySnapshottableFeature sf = isnap.asDirectory().getDirectorySnapshottableFeature();
                if (sf == null) {
                    throw new SnapshotException("Directory is not a snapshottable directory: " + snap);
                }
                lsf.add(sf);
            }
        }
        for (CorruptFileBlockInfo c : corruptFileBlocks) {
            Collection<String> snaps;
            if (this.getFileInfo(c.path, true, false, false) != null) {
                list.add(c.toString());
            }
            if ((snaps = FSDirSnapshotOp.getSnapshotFiles(this.getFSDirectory(), lsf, c.path)) == null) continue;
            for (String snap : snaps) {
                list.add(c.block.getBlockName() + "\t" + snap);
            }
        }
        return list;
    }

    @Override
    public int getDistinctVersionCount() {
        return this.blockManager.getDatanodeManager().getDatanodesSoftwareVersions().size();
    }

    @Override
    public Map<String, Integer> getDistinctVersions() {
        return this.blockManager.getDatanodeManager().getDatanodesSoftwareVersions();
    }

    @Override
    public String getSoftwareVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public String getNameDirSize() {
        return this.getFSImage().getStorage().getNNDirectorySize();
    }

    public synchronized void verifyToken(DelegationTokenIdentifier identifier, byte[] password) throws SecretManager.InvalidToken, RetriableException {
        try {
            this.getDelegationTokenSecretManager().verifyToken((AbstractDelegationTokenIdentifier)identifier, password);
        }
        catch (SecretManager.InvalidToken it) {
            if (this.inTransitionToActive()) {
                throw new RetriableException((Exception)((Object)it));
            }
            throw it;
        }
    }

    @VisibleForTesting
    public EditLogTailer getEditLogTailer() {
        return this.editLogTailer;
    }

    @VisibleForTesting
    public void setEditLogTailerForTests(EditLogTailer tailer) {
        this.editLogTailer = tailer;
    }

    @VisibleForTesting
    void setFsLockForTests(ReentrantReadWriteLock lock) {
        this.fsLock.coarseLock = lock;
    }

    @VisibleForTesting
    public ReentrantReadWriteLock getFsLockForTests() {
        return this.fsLock.coarseLock;
    }

    @VisibleForTesting
    public ReentrantLock getCpLockForTests() {
        return this.cpLock;
    }

    @VisibleForTesting
    public void setNNResourceChecker(NameNodeResourceChecker nnResourceChecker) {
        this.nnResourceChecker = nnResourceChecker;
    }

    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    void allowSnapshot(String path) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String operationName = "allowSnapshot";
        this.checkSuperuserPrivilege("allowSnapshot");
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot allow snapshot for " + path);
            FSDirSnapshotOp.allowSnapshot(this.dir, this.snapshotManager, path);
        }
        finally {
            this.writeUnlock("allowSnapshot");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "allowSnapshot", path, null, null);
    }

    void disallowSnapshot(String path) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String operationName = "disallowSnapshot";
        this.checkSuperuserPrivilege("disallowSnapshot");
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot disallow snapshot for " + path);
            FSDirSnapshotOp.disallowSnapshot(this.dir, this.snapshotManager, path);
        }
        finally {
            this.writeUnlock("disallowSnapshot");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "disallowSnapshot", path, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String createSnapshot(String snapshotRoot, String snapshotName, boolean logRetryCache) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String operationName = "createSnapshot";
        String snapshotPath = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("createSnapshot");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot create snapshot for " + snapshotRoot);
                snapshotPath = FSDirSnapshotOp.createSnapshot(this.dir, pc, this.snapshotManager, snapshotRoot, snapshotName, logRetryCache);
            }
            finally {
                this.writeUnlock("createSnapshot");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "createSnapshot", snapshotRoot);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "createSnapshot", snapshotRoot, snapshotPath, null);
        return snapshotPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameSnapshot(String path, String snapshotOldName, String snapshotNewName, boolean logRetryCache) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String operationName = "renameSnapshot";
        String oldSnapshotRoot = Snapshot.getSnapshotPath(path, snapshotOldName);
        String newSnapshotRoot = Snapshot.getSnapshotPath(path, snapshotNewName);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("renameSnapshot");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot rename snapshot for " + path);
                FSDirSnapshotOp.renameSnapshot(this.dir, pc, this.snapshotManager, path, snapshotOldName, snapshotNewName, logRetryCache);
            }
            finally {
                this.writeUnlock("renameSnapshot");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "renameSnapshot", oldSnapshotRoot, newSnapshotRoot, null);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "renameSnapshot", oldSnapshotRoot, newSnapshotRoot, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        String operationName = "listSnapshottableDirectory";
        SnapshottableDirectoryStatus[] status = null;
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("listSnapshottableDirectory");
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                status = FSDirSnapshotOp.getSnapshottableDirListing(this.dir, pc, this.snapshotManager);
            }
            finally {
                this.readUnlock("listSnapshottableDirectory");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "listSnapshottableDirectory", null, null, null);
            throw ace;
        }
        this.logAuditEvent(true, "listSnapshottableDirectory", null, null, null);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SnapshotDiffReport getSnapshotDiffReport(String path, String fromSnapshot, String toSnapshot) throws IOException {
        long begTime = Time.monotonicNow();
        String operationName = "computeSnapshotDiff";
        SnapshotDiffReport diffs = null;
        this.checkOperation(NameNode.OperationCategory.READ);
        String fromSnapshotRoot = fromSnapshot == null || fromSnapshot.isEmpty() ? path : Snapshot.getSnapshotPath(path, fromSnapshot);
        String toSnapshotRoot = toSnapshot == null || toSnapshot.isEmpty() ? path : Snapshot.getSnapshotPath(path, toSnapshot);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("computeSnapshotDiff");
        long actualTime = Time.monotonicNow();
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                diffs = FSDirSnapshotOp.getSnapshotDiffReport(this.dir, pc, this.snapshotManager, path, fromSnapshot, toSnapshot);
            }
            finally {
                this.readUnlock("computeSnapshotDiff");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "computeSnapshotDiff", fromSnapshotRoot, toSnapshotRoot, null);
            throw ace;
        }
        if (diffs != null) {
            SnapshotDiffReport.DiffStats dstat = diffs.getStats();
            LOG.info("SnapshotDiffReport '" + fromSnapshot + "' to '" + toSnapshot + "'. Total comparison dirs: " + dstat.getTotalDirsCompared() + "/" + dstat.getTotalDirsProcessed() + ", files: " + dstat.getTotalFilesCompared() + "/" + dstat.getTotalFilesProcessed() + ". Time snapChildrenListing: " + (double)dstat.getTotalChildrenListingTime() / 1000.0 + "s, actual: " + (double)(Time.monotonicNow() - actualTime) / 1000.0 + "s, total: " + (double)(Time.monotonicNow() - begTime) / 1000.0 + "s.");
        }
        this.logAuditEvent(true, "computeSnapshotDiff", fromSnapshotRoot, toSnapshotRoot, null);
        return diffs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SnapshotDiffReportListing getSnapshotDiffReportListing(String path, String fromSnapshot, String toSnapshot, byte[] startPath, int index) throws IOException {
        String operationName = "computeSnapshotDiff";
        SnapshotDiffReportListing diffs = null;
        this.checkOperation(NameNode.OperationCategory.READ);
        String fromSnapshotRoot = fromSnapshot == null || fromSnapshot.isEmpty() ? path : Snapshot.getSnapshotPath(path, fromSnapshot);
        String toSnapshotRoot = toSnapshot == null || toSnapshot.isEmpty() ? path : Snapshot.getSnapshotPath(path, toSnapshot);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("computeSnapshotDiff");
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                diffs = FSDirSnapshotOp.getSnapshotDiffReportListing(this.dir, pc, this.snapshotManager, path, fromSnapshot, toSnapshot, startPath, index, this.snapshotDiffReportLimit);
            }
            finally {
                this.readUnlock("computeSnapshotDiff");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "computeSnapshotDiff", fromSnapshotRoot, toSnapshotRoot, null);
            throw ace;
        }
        this.logAuditEvent(true, "computeSnapshotDiff", fromSnapshotRoot, toSnapshotRoot, null);
        return diffs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSnapshot(String snapshotRoot, String snapshotName, boolean logRetryCache) throws IOException {
        String operationName = "deleteSnapshot";
        String rootPath = null;
        INode.BlocksMapUpdateInfo blocksToBeDeleted = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("deleteSnapshot");
        this.checkOperation(NameNode.OperationCategory.WRITE);
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot delete snapshot for " + snapshotRoot);
                rootPath = Snapshot.getSnapshotPath(snapshotRoot, snapshotName);
                blocksToBeDeleted = FSDirSnapshotOp.deleteSnapshot(this.dir, pc, this.snapshotManager, snapshotRoot, snapshotName, logRetryCache);
            }
            finally {
                this.writeUnlock("deleteSnapshot");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "deleteSnapshot", rootPath, null, null);
            throw ace;
        }
        this.getEditLog().logSync();
        if (blocksToBeDeleted != null) {
            this.blockManager.addBLocksToMarkedDeleteQueue(blocksToBeDeleted.getToDeleteList());
        }
        this.logAuditEvent(true, "deleteSnapshot", rootPath, null, null);
    }

    void removeSnapshottableDirs(List<INodeDirectory> toRemove) {
        if (this.snapshotManager != null) {
            this.snapshotManager.removeSnapshottable(toRemove);
        }
    }

    RollingUpgradeInfo queryRollingUpgrade() throws IOException {
        String operationName = "queryRollingUpgrade";
        this.checkSuperuserPrivilege("queryRollingUpgrade");
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (!this.isRollingUpgrade()) {
                RollingUpgradeInfo rollingUpgradeInfo = null;
                return rollingUpgradeInfo;
            }
            Preconditions.checkNotNull((Object)this.rollingUpgradeInfo);
            boolean hasRollbackImage = this.getFSImage().hasRollbackFSImage();
            this.rollingUpgradeInfo.setCreatedRollbackImages(hasRollbackImage);
        }
        finally {
            this.readUnlock("queryRollingUpgrade");
        }
        this.logAuditEvent(true, "queryRollingUpgrade", null, null, null);
        return this.rollingUpgradeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RollingUpgradeInfo startRollingUpgrade() throws IOException {
        String operationName = "startRollingUpgrade";
        this.checkSuperuserPrivilege("startRollingUpgrade");
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isRollingUpgrade()) {
                RollingUpgradeInfo rollingUpgradeInfo = this.rollingUpgradeInfo;
                return rollingUpgradeInfo;
            }
            long startTime = Time.now();
            if (!this.haEnabled) {
                this.startRollingUpgradeInternalForNonHA(startTime);
            } else {
                this.checkNameNodeSafeMode("Failed to start rolling upgrade");
                this.startRollingUpgradeInternal(startTime);
            }
            this.getEditLog().logStartRollingUpgrade(this.rollingUpgradeInfo.getStartTime());
            if (this.haEnabled) {
                this.getFSImage().rollEditLog(this.getEffectiveLayoutVersion());
            }
        }
        finally {
            this.writeUnlock("startRollingUpgrade");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "startRollingUpgrade", null, null, null);
        return this.rollingUpgradeInfo;
    }

    void startRollingUpgradeInternal(long startTime) throws IOException {
        this.checkRollingUpgrade("start rolling upgrade");
        this.getFSImage().checkUpgrade();
        this.setRollingUpgradeInfo(false, startTime);
    }

    private void startRollingUpgradeInternalForNonHA(long startTime) throws IOException {
        Preconditions.checkState((!this.haEnabled ? 1 : 0) != 0);
        if (!this.isInSafeMode()) {
            throw new IOException("Safe mode should be turned ON in order to create namespace image.");
        }
        this.checkRollingUpgrade("start rolling upgrade");
        this.getFSImage().checkUpgrade();
        this.getFSImage().saveNamespace(this, NNStorage.NameNodeFile.IMAGE_ROLLBACK, null);
        LOG.info("Successfully saved namespace for preparing rolling upgrade.");
        this.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.setRollingUpgradeInfo(true, startTime);
    }

    void setRollingUpgradeInfo(boolean createdRollbackImages, long startTime) {
        this.rollingUpgradeInfo = new RollingUpgradeInfo(this.getBlockPoolId(), createdRollbackImages, startTime, 0L);
    }

    public void setCreatedRollbackImages(boolean created) {
        if (this.rollingUpgradeInfo != null) {
            this.rollingUpgradeInfo.setCreatedRollbackImages(created);
        }
    }

    public RollingUpgradeInfo getRollingUpgradeInfo() {
        return this.rollingUpgradeInfo;
    }

    public boolean isNeedRollbackFsImage() {
        return this.needRollbackFsImage;
    }

    public void setNeedRollbackFsImage(boolean needRollbackFsImage) {
        this.needRollbackFsImage = needRollbackFsImage;
    }

    @Override
    public RollingUpgradeInfo.Bean getRollingUpgradeStatus() {
        if (!this.isRollingUpgrade()) {
            return null;
        }
        RollingUpgradeInfo upgradeInfo = this.getRollingUpgradeInfo();
        if (upgradeInfo.createdRollbackImages()) {
            return new RollingUpgradeInfo.Bean(upgradeInfo);
        }
        this.readLock();
        try {
            upgradeInfo = this.getRollingUpgradeInfo();
            if (upgradeInfo == null) {
                RollingUpgradeInfo.Bean bean = null;
                return bean;
            }
            if (!upgradeInfo.createdRollbackImages()) {
                boolean hasRollbackImage = this.getFSImage().hasRollbackFSImage();
                upgradeInfo.setCreatedRollbackImages(hasRollbackImage);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Encountered exception setting Rollback Image", (Throwable)ioe);
        }
        finally {
            this.readUnlock("getRollingUpgradeStatus");
        }
        return new RollingUpgradeInfo.Bean(upgradeInfo);
    }

    public boolean isRollingUpgrade() {
        return this.rollingUpgradeInfo != null && !this.rollingUpgradeInfo.isFinalized();
    }

    public int getEffectiveLayoutVersion() {
        return FSNamesystem.getEffectiveLayoutVersion(this.isRollingUpgrade(), this.fsImage.getStorage().getLayoutVersion(), NameNodeLayoutVersion.MINIMUM_COMPATIBLE_LAYOUT_VERSION, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
    }

    @VisibleForTesting
    static int getEffectiveLayoutVersion(boolean isRollingUpgrade, int storageLV, int minCompatLV, int currentLV) {
        if (isRollingUpgrade && storageLV <= minCompatLV) {
            return storageLV;
        }
        return currentLV;
    }

    private void requireEffectiveLayoutVersionForFeature(NameNodeLayoutVersion.Feature f) throws HadoopIllegalArgumentException {
        int lv = this.getEffectiveLayoutVersion();
        if (!NameNodeLayoutVersion.supports(f, lv)) {
            throw new HadoopIllegalArgumentException(String.format("Feature %s unsupported at NameNode layout version %d.  If a rolling upgrade is in progress, then it must be finalized before using this feature.", f, lv));
        }
    }

    void checkRollingUpgrade(String action) throws RollingUpgradeException {
        if (this.isRollingUpgrade()) {
            throw new RollingUpgradeException("Failed to " + action + " since a rolling upgrade is already in progress. Existing rolling upgrade info:\n" + this.rollingUpgradeInfo);
        }
    }

    RollingUpgradeInfo finalizeRollingUpgrade() throws IOException {
        String operationName = "finalizeRollingUpgrade";
        this.checkSuperuserPrivilege("finalizeRollingUpgrade");
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (!this.isRollingUpgrade()) {
                RollingUpgradeInfo rollingUpgradeInfo = null;
                return rollingUpgradeInfo;
            }
            this.checkNameNodeSafeMode("Failed to finalize rolling upgrade");
            this.finalizeRollingUpgradeInternal(Time.now());
            this.getEditLog().logFinalizeRollingUpgrade(this.rollingUpgradeInfo.getFinalizeTime());
            if (this.haEnabled) {
                this.getFSImage().rollEditLog(this.getEffectiveLayoutVersion());
            }
            this.getFSImage().updateStorageVersion();
            this.getFSImage().renameCheckpoint(NNStorage.NameNodeFile.IMAGE_ROLLBACK, NNStorage.NameNodeFile.IMAGE);
        }
        finally {
            this.writeUnlock("finalizeRollingUpgrade");
        }
        if (!this.haEnabled) {
            this.getEditLog().logSync();
        }
        this.logAuditEvent(true, "finalizeRollingUpgrade", null, null, null);
        return this.rollingUpgradeInfo;
    }

    void finalizeRollingUpgradeInternal(long finalizeTime) {
        this.rollingUpgradeInfo.finalize(finalizeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags, boolean logRetryCache) throws IOException {
        String operationName = "addCacheDirective";
        CacheDirectiveInfo effectiveDirective = null;
        if (!flags.contains(CacheFlag.FORCE)) {
            this.cacheManager.waitForRescanIfNeeded();
        }
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker.setOperationType("addCacheDirective");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot add cache directive");
                effectiveDirective = FSNDNCacheOp.addCacheDirective(this, this.cacheManager, directive, flags, logRetryCache);
            }
            finally {
                this.writeUnlock("addCacheDirective");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "addCacheDirective", null);
            throw ace;
        }
        this.getEditLog().logSync();
        String effectiveDirectiveStr = effectiveDirective.toString();
        this.logAuditEvent(true, "addCacheDirective", effectiveDirectiveStr);
        return effectiveDirective.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags, boolean logRetryCache) throws IOException {
        String operationName = "modifyCacheDirective";
        String idStr = "{id: " + directive.getId() + "}";
        if (!flags.contains(CacheFlag.FORCE)) {
            this.cacheManager.waitForRescanIfNeeded();
        }
        FSPermissionChecker.setOperationType("modifyCacheDirective");
        this.checkOperation(NameNode.OperationCategory.WRITE);
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot add cache directive");
                FSNDNCacheOp.modifyCacheDirective(this, this.cacheManager, directive, flags, logRetryCache);
            }
            finally {
                this.writeUnlock("modifyCacheDirective");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "modifyCacheDirective", idStr, directive.toString(), null);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "modifyCacheDirective", idStr, directive.toString(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCacheDirective(long id, boolean logRetryCache) throws IOException {
        String operationName = "removeCacheDirective";
        String idStr = "{id: " + Long.toString(id) + "}";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker.setOperationType("removeCacheDirective");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot remove cache directives");
                FSNDNCacheOp.removeCacheDirective(this, this.cacheManager, id, logRetryCache);
            }
            finally {
                this.writeUnlock("removeCacheDirective");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "removeCacheDirective", idStr, null, null);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeCacheDirective", idStr, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> listCacheDirectives(long startId, CacheDirectiveInfo filter) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> results;
        String operationName = "listCacheDirectives";
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker.setOperationType("listCacheDirectives");
        this.cacheManager.waitForRescanIfNeeded();
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                results = FSNDNCacheOp.listCacheDirectives(this, this.cacheManager, startId, filter);
            }
            finally {
                this.readUnlock("listCacheDirectives");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "listCacheDirectives", filter.toString());
            throw ace;
        }
        this.logAuditEvent(true, "listCacheDirectives", filter.toString());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCachePool(CachePoolInfo req, boolean logRetryCache) throws IOException {
        String operationName = "addCachePool";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String poolInfoStr = null;
        try {
            this.checkSuperuserPrivilege();
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot add cache pool" + (req == null ? null : req.getPoolName()));
                CachePoolInfo info = FSNDNCacheOp.addCachePool(this, this.cacheManager, req, logRetryCache);
                poolInfoStr = info.toString();
            }
            finally {
                this.writeUnlock("addCachePool");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "addCachePool", poolInfoStr);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "addCachePool", poolInfoStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyCachePool(CachePoolInfo req, boolean logRetryCache) throws IOException {
        String operationName = "modifyCachePool";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String poolNameStr = "{poolName: " + (req == null ? null : req.getPoolName()) + "}";
        try {
            this.checkSuperuserPrivilege();
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot modify cache pool" + (req == null ? null : req.getPoolName()));
                FSNDNCacheOp.modifyCachePool(this, this.cacheManager, req, logRetryCache);
            }
            finally {
                this.writeUnlock("modifyCachePool");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "modifyCachePool", poolNameStr, req == null ? null : req.toString(), null);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "modifyCachePool", poolNameStr, req == null ? null : req.toString(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCachePool(String cachePoolName, boolean logRetryCache) throws IOException {
        String operationName = "removeCachePool";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String poolNameStr = "{poolName: " + cachePoolName + "}";
        try {
            this.checkSuperuserPrivilege();
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot modify cache pool" + cachePoolName);
                FSNDNCacheOp.removeCachePool(this, this.cacheManager, cachePoolName, logRetryCache);
            }
            finally {
                this.writeUnlock("removeCachePool");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "removeCachePool", poolNameStr);
            throw ace;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeCachePool", poolNameStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> results;
        String operationName = "listCachePools";
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker.setOperationType("listCachePools");
        this.cacheManager.waitForRescanIfNeeded();
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                results = FSNDNCacheOp.listCachePools(this, this.cacheManager, prevKey);
            }
            finally {
                this.readUnlock("listCachePools");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "listCachePools", null);
            throw ace;
        }
        this.logAuditEvent(true, "listCachePools", null);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        String operationName = "modifyAclEntries";
        FileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("modifyAclEntries");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot modify ACL entries on " + src);
                auditStat = FSDirAclOp.modifyAclEntries(this.dir, pc, src, aclSpec);
            }
            finally {
                this.writeUnlock("modifyAclEntries");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "modifyAclEntries", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "modifyAclEntries", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        String operationName = "removeAclEntries";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FileStatus auditStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("removeAclEntries");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot remove ACL entries on " + src);
                auditStat = FSDirAclOp.removeAclEntries(this.dir, pc, src, aclSpec);
            }
            finally {
                this.writeUnlock("removeAclEntries");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeAclEntries", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeAclEntries", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDefaultAcl(String src) throws IOException {
        String operationName = "removeDefaultAcl";
        FileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("removeDefaultAcl");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot remove default ACL entries on " + src);
                auditStat = FSDirAclOp.removeDefaultAcl(this.dir, pc, src);
            }
            finally {
                this.writeUnlock("removeDefaultAcl");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeDefaultAcl", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeDefaultAcl", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAcl(String src) throws IOException {
        String operationName = "removeAcl";
        FileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("removeAcl");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot remove ACL on " + src);
                auditStat = FSDirAclOp.removeAcl(this.dir, pc, src);
            }
            finally {
                this.writeUnlock("removeAcl");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeAcl", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeAcl", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        String operationName = "setAcl";
        FileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("setAcl");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot set ACL on " + src);
                auditStat = FSDirAclOp.setAcl(this.dir, pc, src, aclSpec);
            }
            finally {
                this.writeUnlock("setAcl");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setAcl", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setAcl", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AclStatus getAclStatus(String src) throws IOException {
        AclStatus ret;
        String operationName = "getAclStatus";
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("getAclStatus");
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                ret = FSDirAclOp.getAclStatus(this.dir, pc, src);
            }
            finally {
                this.readUnlock("getAclStatus");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "getAclStatus", src);
            throw ace;
        }
        this.logAuditEvent(true, "getAclStatus", src);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createEncryptionZone(String src, String keyName, boolean logRetryCache) throws IOException, UnresolvedLinkException, SafeModeException, AccessControlException {
        FileStatus resultingStat;
        String operationName = "createEncryptionZone";
        try {
            KeyProvider.Metadata metadata = FSDirEncryptionZoneOp.ensureKeyIsInitialized(this.dir, keyName, src);
            FSPermissionChecker pc = this.getPermissionChecker();
            FSPermissionChecker.setOperationType("createEncryptionZone");
            this.checkSuperuserPrivilege(pc);
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot create encryption zone on " + src);
                resultingStat = FSDirEncryptionZoneOp.createEncryptionZone(this.dir, src, pc, metadata.getCipher(), keyName, logRetryCache);
            }
            finally {
                this.writeUnlock("createEncryptionZone");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "createEncryptionZone", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "createEncryptionZone", src, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EncryptionZone getEZForPath(String srcArg) throws AccessControlException, UnresolvedLinkException, IOException {
        EncryptionZone encryptionZone;
        String operationName = "getEZForPath";
        FileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("getEZForPath");
        this.checkOperation(NameNode.OperationCategory.READ);
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                Map.Entry<EncryptionZone, FileStatus> ezForPath = FSDirEncryptionZoneOp.getEZForPath(this.dir, srcArg, pc);
                resultingStat = ezForPath.getValue();
                encryptionZone = ezForPath.getKey();
            }
            finally {
                this.readUnlock("getEZForPath");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "getEZForPath", srcArg, null, resultingStat);
            throw ace;
        }
        this.logAuditEvent(true, "getEZForPath", srcArg, null, resultingStat);
        return encryptionZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        String operationName = "listEncryptionZones";
        boolean success = false;
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("listEncryptionZones");
        this.checkSuperuserPrivilege(pc);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            BatchedRemoteIterator.BatchedListEntries<EncryptionZone> ret = FSDirEncryptionZoneOp.listEncryptionZones(this.dir, prevId);
            success = true;
            BatchedRemoteIterator.BatchedListEntries<EncryptionZone> batchedListEntries = ret;
            return batchedListEntries;
        }
        finally {
            this.readUnlock("listEncryptionZones");
            this.logAuditEvent(success, "listEncryptionZones", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reencryptEncryptionZone(String zone, HdfsConstants.ReencryptAction action, boolean logRetryCache) throws IOException {
        boolean success = false;
        try {
            Preconditions.checkNotNull((Object)zone, (Object)"zone is null.");
            this.checkOperation(NameNode.OperationCategory.WRITE);
            FSPermissionChecker pc = this.dir.getPermissionChecker();
            this.checkSuperuserPrivilege(pc);
            this.checkNameNodeSafeMode("NameNode in safemode, cannot " + action + " re-encryption on zone " + zone);
            this.reencryptEncryptionZoneInt(pc, zone, action, logRetryCache);
            success = true;
        }
        finally {
            this.logAuditEvent(success, action + "reencryption", zone, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<ZoneReencryptionStatus> listReencryptionStatus(long prevId) throws IOException {
        String operationName = "listReencryptionStatus";
        boolean success = false;
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("listReencryptionStatus");
        this.checkSuperuserPrivilege(pc);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            BatchedRemoteIterator.BatchedListEntries<ZoneReencryptionStatus> ret = FSDirEncryptionZoneOp.listReencryptionStatus(this.dir, prevId);
            success = true;
            BatchedRemoteIterator.BatchedListEntries<ZoneReencryptionStatus> batchedListEntries = ret;
            return batchedListEntries;
        }
        finally {
            this.readUnlock("listReencryptionStatus");
            this.logAuditEvent(success, "listReencryptionStatus", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void reencryptEncryptionZoneInt(FSPermissionChecker pc, String zone, HdfsConstants.ReencryptAction action, boolean logRetryCache) throws IOException {
        if (this.getProvider() == null) {
            throw new IOException("No key provider configured, re-encryption operation is rejected");
        }
        keyVersionName = null;
        if (action == HdfsConstants.ReencryptAction.START) {
            keyVersionName = FSDirEncryptionZoneOp.getCurrentKeyVersion(this.dir, pc, zone);
            if (keyVersionName == null) {
                throw new IOException("Failed to get key version name for " + zone);
            }
            FSNamesystem.LOG.info("Re-encryption using key version " + keyVersionName + " for zone " + zone);
        }
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("NameNode in safemode, cannot " + action + " re-encryption on zone " + zone);
            this.dir.writeLock();
            try {
                iip = this.dir.resolvePath(pc, zone, FSDirectory.DirOp.WRITE);
                if (iip.getLastINode() == null) {
                    throw new FileNotFoundException(zone + " does not exist.");
                }
                switch (1.$SwitchMap$org$apache$hadoop$hdfs$protocol$HdfsConstants$ReencryptAction[action.ordinal()]) {
                    case 1: {
                        xattrs = FSDirEncryptionZoneOp.reencryptEncryptionZone(this.dir, iip, keyVersionName);
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        xattrs = FSDirEncryptionZoneOp.cancelReencryptEncryptionZone(this.dir, iip);
                        ** break;
lbl26:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new IOException("Re-encryption action " + action + " is not supported");
                    }
                }
            }
            finally {
                this.dir.writeUnlock();
            }
            if (xattrs != null && !xattrs.isEmpty()) {
                this.getEditLog().logSetXAttrs(zone, xattrs, logRetryCache);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    void setErasureCodingPolicy(String srcArg, String ecPolicyName, boolean logRetryCache) throws IOException, UnresolvedLinkException, SafeModeException, AccessControlException {
        String operationName = "setErasureCodingPolicy";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkErasureCodingSupported("setErasureCodingPolicy");
        FileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("setErasureCodingPolicy");
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set erasure coding policy on " + srcArg);
            resultingStat = FSDirErasureCodingOp.setErasureCodingPolicy(this, srcArg, ecPolicyName, pc, logRetryCache);
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "setErasureCodingPolicy", srcArg);
            throw ace;
        }
        finally {
            this.writeUnlock("setErasureCodingPolicy");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setErasureCodingPolicy", srcArg, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies, boolean logRetryCache) throws IOException {
        String operationName = "addErasureCodingPolicies";
        ArrayList<String> addECPolicyNames = new ArrayList<String>(policies.length);
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkErasureCodingSupported("addErasureCodingPolicies");
        ArrayList<AddErasureCodingPolicyResponse> responses = new ArrayList<AddErasureCodingPolicyResponse>(policies.length);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot add erasure coding policy");
            for (ErasureCodingPolicy policy : policies) {
                try {
                    ErasureCodingPolicy newPolicy = FSDirErasureCodingOp.addErasureCodingPolicy(this, policy, logRetryCache);
                    addECPolicyNames.add(newPolicy.getName());
                    responses.add(new AddErasureCodingPolicyResponse(newPolicy));
                }
                catch (HadoopIllegalArgumentException e) {
                    responses.add(new AddErasureCodingPolicyResponse(policy, e));
                }
            }
        }
        finally {
            this.writeUnlock("addErasureCodingPolicies");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "addErasureCodingPolicies", ((Object)addECPolicyNames).toString());
        return responses.toArray(new AddErasureCodingPolicyResponse[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeErasureCodingPolicy(String ecPolicyName, boolean logRetryCache) throws IOException {
        String operationName = "removeErasureCodingPolicy";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkErasureCodingSupported("removeErasureCodingPolicy");
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot remove erasure coding policy " + ecPolicyName);
            FSDirErasureCodingOp.removeErasureCodingPolicy(this, ecPolicyName, logRetryCache);
        }
        finally {
            this.writeUnlock("removeErasureCodingPolicy");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeErasureCodingPolicy", ecPolicyName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enableErasureCodingPolicy(String ecPolicyName, boolean logRetryCache) throws IOException {
        String operationName = "enableErasureCodingPolicy";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkErasureCodingSupported("enableErasureCodingPolicy");
        boolean success = false;
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot enable erasure coding policy " + ecPolicyName);
                success = FSDirErasureCodingOp.enableErasureCodingPolicy(this, ecPolicyName, logRetryCache);
            }
            finally {
                this.writeUnlock("enableErasureCodingPolicy");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "enableErasureCodingPolicy", ecPolicyName);
            throw ace;
        }
        if (success) {
            this.getEditLog().logSync();
            this.logAuditEvent(true, "enableErasureCodingPolicy", ecPolicyName);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean disableErasureCodingPolicy(String ecPolicyName, boolean logRetryCache) throws IOException {
        String operationName = "disableErasureCodingPolicy";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkErasureCodingSupported("disableErasureCodingPolicy");
        boolean success = false;
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot disable erasure coding policy " + ecPolicyName);
                success = FSDirErasureCodingOp.disableErasureCodingPolicy(this, ecPolicyName, logRetryCache);
            }
            finally {
                this.writeUnlock("disableErasureCodingPolicy");
            }
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, "disableErasureCodingPolicy", ecPolicyName);
            throw ace;
        }
        if (success) {
            this.getEditLog().logSync();
            this.logAuditEvent(true, "disableErasureCodingPolicy", ecPolicyName);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsetErasureCodingPolicy(String srcArg, boolean logRetryCache) throws IOException, UnresolvedLinkException, SafeModeException, AccessControlException {
        String operationName = "unsetErasureCodingPolicy";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkErasureCodingSupported("unsetErasureCodingPolicy");
        FileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("unsetErasureCodingPolicy");
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot unset erasure coding policy on " + srcArg);
            resultingStat = FSDirErasureCodingOp.unsetErasureCodingPolicy(this, srcArg, pc, logRetryCache);
        }
        finally {
            this.writeUnlock("unsetErasureCodingPolicy");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "unsetErasureCodingPolicy", srcArg, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ECTopologyVerifierResult getECTopologyResultForPolicies(String[] policyNames) throws IOException {
        ECTopologyVerifierResult result;
        String operationName = "getECTopologyResultForPolicies";
        this.checkSuperuserPrivilege(operationName);
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            if (policyNames == null || policyNames.length == 0) {
                result = this.getEcTopologyVerifierResultForEnabledPolicies();
            } else {
                ArrayList<ErasureCodingPolicy> policies = new ArrayList<ErasureCodingPolicy>();
                for (int i = 0; i < policyNames.length; ++i) {
                    policies.add(FSDirErasureCodingOp.getErasureCodingPolicyByName(this, policyNames[i]));
                }
                int numOfDataNodes = this.getBlockManager().getDatanodeManager().getNumOfDataNodes();
                int numOfRacks = this.getBlockManager().getDatanodeManager().getNetworkTopology().getNumOfRacks();
                result = ECTopologyVerifier.getECTopologyVerifierResult(numOfRacks, numOfDataNodes, policies);
            }
        }
        finally {
            this.readUnlock();
        }
        this.logAuditEvent(true, operationName, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ErasureCodingPolicy getErasureCodingPolicy(String src) throws AccessControlException, UnresolvedLinkException, IOException {
        String operationName = "getErasureCodingPolicy";
        boolean success = false;
        this.checkOperation(NameNode.OperationCategory.READ);
        this.checkErasureCodingSupported("getErasureCodingPolicy");
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("getErasureCodingPolicy");
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            ErasureCodingPolicy ret = FSDirErasureCodingOp.getErasureCodingPolicy(this, src, pc);
            success = true;
            ErasureCodingPolicy erasureCodingPolicy = ret;
            return erasureCodingPolicy;
        }
        finally {
            this.readUnlock("getErasureCodingPolicy");
            this.logAuditEvent(success, "getErasureCodingPolicy", src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ErasureCodingPolicyInfo[] getErasureCodingPolicies() throws IOException {
        String operationName = "getErasureCodingPolicies";
        boolean success = false;
        this.checkOperation(NameNode.OperationCategory.READ);
        this.checkErasureCodingSupported("getErasureCodingPolicies");
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            ErasureCodingPolicyInfo[] ret = FSDirErasureCodingOp.getErasureCodingPolicies(this);
            success = true;
            ErasureCodingPolicyInfo[] erasureCodingPolicyInfoArray = ret;
            return erasureCodingPolicyInfoArray;
        }
        finally {
            this.readUnlock("getErasureCodingPolicies");
            this.logAuditEvent(success, "getErasureCodingPolicies", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getErasureCodingCodecs() throws IOException {
        String operationName = "getErasureCodingCodecs";
        boolean success = false;
        this.checkOperation(NameNode.OperationCategory.READ);
        this.checkErasureCodingSupported("getErasureCodingCodecs");
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            Map<String, String> ret = FSDirErasureCodingOp.getErasureCodingCodecs(this);
            success = true;
            Map<String, String> map = ret;
            return map;
        }
        finally {
            this.readUnlock("getErasureCodingCodecs");
            this.logAuditEvent(success, "getErasureCodingCodecs", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag, boolean logRetryCache) throws IOException {
        String operationName = "setXAttr";
        FileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("setXAttr");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot set XAttr on " + src);
                auditStat = FSDirXAttrOp.setXAttr(this.dir, pc, src, xAttr, flag, logRetryCache);
            }
            finally {
                this.writeUnlock("setXAttr");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setXAttr", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setXAttr", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        List<XAttr> fsXattrs;
        String operationName = "getXAttrs";
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("getXAttrs");
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                fsXattrs = FSDirXAttrOp.getXAttrs(this.dir, pc, src, xAttrs);
            }
            finally {
                this.readUnlock("getXAttrs");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "getXAttrs", src);
            throw e;
        }
        this.logAuditEvent(true, "getXAttrs", src);
        return fsXattrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<XAttr> listXAttrs(String src) throws IOException {
        List<XAttr> fsXattrs;
        String operationName = "listXAttrs";
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("listXAttrs");
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                fsXattrs = FSDirXAttrOp.listXAttrs(this.dir, pc, src);
            }
            finally {
                this.readUnlock("listXAttrs");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "listXAttrs", src);
            throw e;
        }
        this.logAuditEvent(true, "listXAttrs", src);
        return fsXattrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeXAttr(String src, XAttr xAttr, boolean logRetryCache) throws IOException {
        String operationName = "removeXAttr";
        FileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("removeXAttr");
        try {
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot remove XAttr entry on " + src);
                auditStat = FSDirXAttrOp.removeXAttr(this.dir, pc, src, xAttr, logRetryCache);
            }
            finally {
                this.writeUnlock("removeXAttr");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeXAttr", src);
            throw e;
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeXAttr", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeXattr(long id, String xattrName) throws IOException {
        this.writeLock();
        try {
            INode inode = this.dir.getInode(id);
            if (inode == null) {
                return;
            }
            XAttrFeature xaf = inode.getXAttrFeature();
            if (xaf == null) {
                return;
            }
            XAttr spsXAttr = xaf.getXAttr(xattrName);
            if (spsXAttr != null) {
                FSDirSatisfyStoragePolicyOp.removeSPSXattr(this.dir, inode, spsXAttr);
            }
        }
        finally {
            this.writeUnlock("removeXAttr");
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAccess(String src, FsAction mode) throws IOException {
        String operationName = "checkAccess";
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        FSPermissionChecker.setOperationType("checkAccess");
        try {
            this.readLock();
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                INodesInPath iip = this.dir.resolvePath(pc, src, FSDirectory.DirOp.READ);
                src = iip.getPath();
                INode inode = iip.getLastINode();
                if (inode == null) {
                    throw new FileNotFoundException("Path not found");
                }
                if (this.isPermissionEnabled) {
                    this.dir.checkPathAccess(pc, iip, mode);
                }
            }
            finally {
                this.readUnlock("checkAccess");
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "checkAccess", src);
            throw e;
        }
        this.logAuditEvent(true, "checkAccess", src);
    }

    private static void enableAsyncAuditLog(Configuration conf) {
        if (!(auditLog instanceof Log4JLogger)) {
            LOG.warn("Log4j is required to enable async auditlog");
            return;
        }
        org.apache.log4j.Logger logger = ((Log4JLogger)auditLog).getLogger();
        ArrayList<Appender> appenders = Collections.list(logger.getAllAppenders());
        if (!appenders.isEmpty() && !(appenders.get(0) instanceof AsyncAppender)) {
            AsyncAppender asyncAppender = new AsyncAppender();
            asyncAppender.setBlocking(conf.getBoolean("dfs.namenode.audit.log.async.blocking", true));
            asyncAppender.setBufferSize(conf.getInt("dfs.namenode.audit.log.async.buffer.size", 128));
            for (Appender appender : appenders) {
                logger.removeAppender(appender);
                asyncAppender.addAppender(appender);
            }
            logger.addAppender((Appender)asyncAppender);
        }
    }

    @Override
    @Metric(value={"TotalSyncCount", "Total number of sync operations performed on edit logs"})
    public long getTotalSyncCount() {
        return this.fsImage.editLog.getTotalSyncCount();
    }

    @Override
    @Metric(value={"TotalSyncTimes", "Total time spend in sync operation on various edit logs"})
    public String getTotalSyncTimes() {
        JournalSet journalSet = this.fsImage.editLog.getJournalSet();
        if (journalSet != null) {
            return journalSet.getSyncTimes();
        }
        return "";
    }

    public long getBytesInFuture() {
        return this.blockManager.getBytesInFuture();
    }

    @Override
    @Metric(value={"NumInMaintenanceLiveDataNodes", "Number of live Datanodes which are in maintenance state"})
    public int getNumInMaintenanceLiveDataNodes() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, true);
        int liveInMaintenance = 0;
        for (DatanodeDescriptor node : live) {
            liveInMaintenance += node.isInMaintenance() ? 1 : 0;
        }
        return liveInMaintenance;
    }

    @Override
    @Metric(value={"NumInMaintenanceDeadDataNodes", "Number of dead Datanodes which are in maintenance state"})
    public int getNumInMaintenanceDeadDataNodes() {
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(null, dead, true);
        int deadInMaintenance = 0;
        for (DatanodeDescriptor node : dead) {
            deadInMaintenance += node.isInMaintenance() ? 1 : 0;
        }
        return deadInMaintenance;
    }

    @Override
    @Metric(value={"NumEnteringMaintenanceDataNodes", "Number of Datanodes that are entering the maintenance state"})
    public int getNumEnteringMaintenanceDataNodes() {
        return this.getBlockManager().getDatanodeManager().getEnteringMaintenanceNodes().size();
    }

    @Override
    public String getVerifyECWithTopologyResult() {
        ECTopologyVerifierResult result = this.getEcTopologyVerifierResultForEnabledPolicies();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("isSupported", Boolean.toString(result.isSupported()));
        resultMap.put("resultMessage", result.getResultMessage());
        return JSON.toString(resultMap);
    }

    private ECTopologyVerifierResult getEcTopologyVerifierResultForEnabledPolicies() {
        int numOfDataNodes = this.getBlockManager().getDatanodeManager().getNumOfDataNodes();
        int numOfRacks = this.getBlockManager().getDatanodeManager().getNetworkTopology().getNumOfRacks();
        ErasureCodingPolicy[] enabledEcPolicies = this.getErasureCodingPolicyManager().getCopyOfEnabledPolicies();
        return ECTopologyVerifier.getECTopologyVerifierResult(numOfRacks, numOfDataNodes, Arrays.asList(enabledEcPolicies));
    }

    void checkSuperuserPrivilege(String operationName) throws IOException {
        try {
            this.checkSuperuserPrivilege();
        }
        catch (AccessControlException ace) {
            this.logAuditEvent(false, operationName, null);
            throw ace;
        }
    }

    String getQuotaCommand(long nsQuota, long dsQuota) {
        if (nsQuota == -1L && dsQuota == Long.MAX_VALUE) {
            return "clearQuota";
        }
        if (nsQuota == Long.MAX_VALUE && dsQuota == -1L) {
            return "clearSpaceQuota";
        }
        if (dsQuota == Long.MAX_VALUE) {
            return "setQuota";
        }
        return "setSpaceQuota";
    }

    String getFailedStorageCommand(String mode) {
        if (mode.equals("check")) {
            return "checkRestoreFailedStorage";
        }
        if (mode.equals("true")) {
            return "enableRestoreFailedStorage";
        }
        return "disableRestoreFailedStorage";
    }

    public void checkErasureCodingSupported(String operationName) throws UnsupportedActionException {
        if (!NameNodeLayoutVersion.supports(NameNodeLayoutVersion.Feature.ERASURE_CODING, this.getEffectiveLayoutVersion())) {
            throw new UnsupportedActionException(operationName + " not supported.");
        }
    }

    @VisibleForTesting
    static class FSNamesystemAuditLogger
    extends DefaultAuditLogger {
        FSNamesystemAuditLogger() {
        }

        @Override
        public void initialize(Configuration conf) {
            this.isCallerContextEnabled = conf.getBoolean("hadoop.caller.context.enabled", false);
            this.callerContextMaxLen = conf.getInt("hadoop.caller.context.max.size", 128);
            this.callerSignatureMaxLen = conf.getInt("hadoop.caller.context.signature.max.size", 40);
            this.logTokenTrackingId = conf.getBoolean("dfs.namenode.audit.log.token.tracking.id", false);
            this.debugCmdSet.addAll(Arrays.asList(conf.getTrimmedStrings("dfs.namenode.audit.log.debug.cmdlist")));
        }

        @Override
        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status, CallerContext callerContext, UserGroupInformation ugi, DelegationTokenSecretManager dtSecretManager) {
            if (auditLog.isDebugEnabled() || auditLog.isInfoEnabled() && !this.debugCmdSet.contains(cmd)) {
                StringBuilder sb = (StringBuilder)STRING_BUILDER.get();
                src = StringEscapeUtils.escapeJava((String)src);
                dst = StringEscapeUtils.escapeJava((String)dst);
                sb.setLength(0);
                sb.append("allowed=").append(succeeded).append("\t").append("ugi=").append(userName).append("\t").append("ip=").append(addr).append("\t").append("cmd=").append(cmd).append("\t").append("src=").append(src).append("\t").append("dst=").append(dst).append("\t");
                if (null == status) {
                    sb.append("perm=null");
                } else {
                    sb.append("perm=").append(status.getOwner()).append(":").append(status.getGroup()).append(":").append(status.getPermission());
                }
                if (this.logTokenTrackingId) {
                    sb.append("\t").append("trackingId=");
                    String trackingId = null;
                    if (ugi != null && dtSecretManager != null && ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.TOKEN) {
                        for (TokenIdentifier tid : ugi.getTokenIdentifiers()) {
                            if (!(tid instanceof DelegationTokenIdentifier)) continue;
                            DelegationTokenIdentifier dtid = (DelegationTokenIdentifier)tid;
                            trackingId = dtSecretManager.getTokenTrackingId((AbstractDelegationTokenIdentifier)dtid);
                            break;
                        }
                    }
                    sb.append(trackingId);
                }
                sb.append("\t").append("proto=").append(Server.getProtocol());
                if (this.isCallerContextEnabled && callerContext != null && callerContext.isContextValid()) {
                    sb.append("\t").append("callerContext=");
                    if (callerContext.getContext().length() > this.callerContextMaxLen) {
                        sb.append(callerContext.getContext().substring(0, this.callerContextMaxLen));
                    } else {
                        sb.append(callerContext.getContext());
                    }
                    if (callerContext.getSignature() != null && callerContext.getSignature().length > 0 && callerContext.getSignature().length <= this.callerSignatureMaxLen) {
                        sb.append(":").append(new String(callerContext.getSignature(), CallerContext.SIGNATURE_ENCODING));
                    }
                }
                this.logAuditMessage(sb.toString());
            }
        }

        @Override
        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status, UserGroupInformation ugi, DelegationTokenSecretManager dtSecretManager) {
            this.logAuditEvent(succeeded, userName, addr, cmd, src, dst, status, null, ugi, dtSecretManager);
        }

        @Override
        public void logAuditMessage(String message) {
            auditLog.info((Object)message);
        }
    }

    static class CorruptFileBlockInfo {
        final String path;
        final Block block;

        public CorruptFileBlockInfo(String p, Block b) {
            this.path = p;
            this.block = b;
        }

        public String toString() {
            return this.block.getBlockName() + "\t" + this.path;
        }
    }

    class LazyPersistFileScrubber
    implements Runnable {
        private volatile boolean shouldRun = true;
        final int scrubIntervalSec;

        public LazyPersistFileScrubber(int scrubIntervalSec) {
            this.scrubIntervalSec = scrubIntervalSec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearCorruptLazyPersistFiles() throws IOException {
            BlockStoragePolicy lpPolicy = FSNamesystem.this.blockManager.getStoragePolicy("LAZY_PERSIST");
            ArrayList<INodeFile> filesToDelete = new ArrayList<INodeFile>();
            boolean changed = false;
            FSNamesystem.this.writeLock();
            try {
                Iterator<BlockInfo> it = FSNamesystem.this.blockManager.getCorruptReplicaBlockIterator();
                while (it.hasNext()) {
                    Block b = it.next();
                    BlockInfo blockInfo = FSNamesystem.this.blockManager.getStoredBlock(b);
                    if (blockInfo == null || blockInfo.isDeleted()) {
                        LOG.info("Cannot find block info for block " + b);
                        continue;
                    }
                    INodeFile bc = FSNamesystem.this.getBlockCollection(blockInfo);
                    if (bc.getStoragePolicyID() != lpPolicy.getId()) continue;
                    filesToDelete.add(bc);
                }
                for (BlockCollection blockCollection : filesToDelete) {
                    LOG.warn("Removing lazyPersist file " + blockCollection.getName() + " with no replicas.");
                    INode.BlocksMapUpdateInfo toRemoveBlocks = FSDirDeleteOp.deleteInternal(FSNamesystem.this, INodesInPath.fromINode((INodeFile)blockCollection), false);
                    changed |= toRemoveBlocks != null;
                    if (toRemoveBlocks == null) continue;
                    FSNamesystem.this.blockManager.addBLocksToMarkedDeleteQueue(toRemoveBlocks.getToDeleteList());
                }
            }
            finally {
                FSNamesystem.this.writeUnlock("clearCorruptLazyPersistFiles");
            }
            if (changed) {
                FSNamesystem.this.getEditLog().logSync();
            }
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning && this.shouldRun) {
                try {
                    if (!FSNamesystem.this.isInSafeMode()) {
                        this.clearCorruptLazyPersistFiles();
                        FSNamesystem.this.lazyPersistFileScrubberTS.set(Time.monotonicNow());
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Namenode is in safemode, skipping scrubbing of corrupted lazy-persist files.");
                    }
                }
                catch (Exception e) {
                    LOG.warn("LazyPersistFileScrubber encountered an exception while scanning for lazyPersist files with missing blocks. Scanning will retry in {} seconds.", (Object)this.scrubIntervalSec, (Object)e);
                }
                try {
                    Thread.sleep(this.scrubIntervalSec * 1000);
                }
                catch (InterruptedException e) {
                    LOG.info("LazyPersistFileScrubber was interrupted, exiting");
                    break;
                }
            }
        }

        public void stop() {
            this.shouldRun = false;
        }
    }

    class NameNodeEditLogRoller
    implements Runnable {
        private boolean shouldRun = true;
        private final long rollThreshold;
        private final long sleepIntervalMs;

        public NameNodeEditLogRoller(long rollThreshold, int sleepIntervalMs) {
            this.rollThreshold = rollThreshold;
            this.sleepIntervalMs = sleepIntervalMs;
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning && this.shouldRun) {
                try {
                    long numEdits = FSNamesystem.this.getCorrectTransactionsSinceLastLogRoll();
                    if (numEdits > this.rollThreshold) {
                        LOG.info("NameNode rolling its own edit log because number of edits in open segment exceeds threshold of " + this.rollThreshold);
                        FSNamesystem.this.rollEditLog();
                    }
                }
                catch (Exception e) {
                    LOG.error("Swallowing exception in " + NameNodeEditLogRoller.class.getSimpleName() + ":", (Throwable)e);
                }
                try {
                    Thread.sleep(this.sleepIntervalMs);
                }
                catch (InterruptedException e) {
                    LOG.info(NameNodeEditLogRoller.class.getSimpleName() + " was interrupted, exiting");
                    break;
                }
            }
        }

        public void stop() {
            this.shouldRun = false;
        }
    }

    class NameNodeResourceMonitor
    implements Runnable {
        boolean shouldNNRmRun = true;

        NameNodeResourceMonitor() {
        }

        @Override
        public void run() {
            try {
                while (FSNamesystem.this.fsRunning && this.shouldNNRmRun) {
                    FSNamesystem.this.checkAvailableResources();
                    if (!FSNamesystem.this.nameNodeHasResourcesAvailable()) {
                        String lowResourcesMsg = "NameNode low on available disk space. ";
                        if (!FSNamesystem.this.isInSafeMode()) {
                            LOG.warn(lowResourcesMsg + "Entering safe mode.");
                        } else {
                            LOG.warn(lowResourcesMsg + "Already in safe mode.");
                        }
                        FSNamesystem.this.enterSafeMode(true);
                    }
                    try {
                        Thread.sleep(FSNamesystem.this.resourceRecheckInterval);
                    }
                    catch (InterruptedException lowResourcesMsg) {}
                }
            }
            catch (Exception e) {
                LOG.error("Exception in NameNodeResourceMonitor: ", (Throwable)e);
            }
        }

        public void stopMonitor() {
            this.shouldNNRmRun = false;
        }
    }

    static enum RecoverLeaseOp {
        CREATE_FILE,
        APPEND_FILE,
        TRUNCATE_FILE,
        RECOVER_LEASE;


        public String getExceptionMessage(String src, String holder, String clientMachine, String reason) {
            return "Failed to " + (Object)((Object)this) + " " + src + " for " + holder + " on " + clientMachine + " because " + reason;
        }
    }
}

