/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.security.token;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedSQLCounter {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedSQLCounter.class);
    private final String field;
    private final String table;
    private final SQLConnectionFactory connectionFactory;

    public DistributedSQLCounter(String field, String table, SQLConnectionFactory connectionFactory) {
        this.field = field;
        this.table = table;
        this.connectionFactory = connectionFactory;
    }

    public int selectCounterValue() throws SQLException {
        try (Connection connection = this.connectionFactory.getConnection();){
            int n = this.selectCounterValue(false, connection);
            return n;
        }
    }

    private int selectCounterValue(boolean forUpdate, Connection connection) throws SQLException {
        String query = String.format("SELECT %s FROM %s %s", this.field, this.table, forUpdate ? "FOR UPDATE" : "");
        LOG.debug("Select counter statement: " + query);
        try (Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery(query);){
            if (result.next()) {
                int n = result.getInt(this.field);
                return n;
            }
            throw new IllegalStateException("Counter table not initialized: " + this.table);
        }
    }

    public void updateCounterValue(int value) throws SQLException {
        try (Connection connection = this.connectionFactory.getConnection(true);){
            this.updateCounterValue(value, connection);
        }
    }

    public void updateCounterValue(int value, Connection connection) throws SQLException {
        String queryText = String.format("UPDATE %s SET %s = ?", this.table, this.field);
        LOG.debug("Update counter statement: " + queryText + ". Value: " + value);
        try (PreparedStatement statement = connection.prepareStatement(queryText);){
            statement.setInt(1, value);
            statement.execute();
        }
    }

    public int incrementCounterValue(int amount) throws SQLException {
        try (Connection connection = this.connectionFactory.getConnection(false);){
            if (connection.getTransactionIsolation() < 4) {
                connection.setTransactionIsolation(4);
            }
            try {
                int lastValue = this.selectCounterValue(true, connection);
                int newValue = lastValue + amount;
                if (newValue < 0) {
                    lastValue = 0;
                    newValue = amount;
                }
                this.updateCounterValue(newValue, connection);
                connection.commit();
                int n = lastValue;
                return n;
            }
            catch (Exception e) {
                connection.rollback();
                throw e;
            }
        }
    }
}

