/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.ConnectionManager;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FederationTestUtils.class);
    public static final String[] NAMESERVICES = new String[]{"ns0", "ns1"};
    public static final String[] NAMENODES = new String[]{"nn0", "nn1", "nn2", "nn3"};
    public static final String[] ROUTERS = new String[]{"router0", "router1", "router2", "router3"};

    private FederationTestUtils() {
    }

    public static void verifyException(Object obj, String methodName, Class<? extends Exception> exceptionClass, Class<?>[] parameterTypes, Object[] arguments) {
        Throwable triggeredException = null;
        try {
            Method m = obj.getClass().getMethod(methodName, parameterTypes);
            m.invoke(obj, arguments);
        }
        catch (InvocationTargetException ex) {
            triggeredException = ex.getTargetException();
        }
        catch (Exception e) {
            triggeredException = e;
        }
        if (exceptionClass != null) {
            Assert.assertNotNull((String)("No exception was triggered, expected exception" + exceptionClass.getName()), (Object)triggeredException);
            Assert.assertEquals(exceptionClass, triggeredException.getClass());
        } else {
            Assert.assertNull((String)"Exception was triggered but no exception was expected", (Object)triggeredException);
        }
    }

    public static NamenodeStatusReport createNamenodeReport(String ns, String nn, HAServiceProtocol.HAServiceState state) {
        Random rand = new Random();
        return FederationTestUtils.createNamenodeReport(ns, nn, "localhost:" + rand.nextInt(10000), state);
    }

    public static NamenodeStatusReport createNamenodeReport(String ns, String nn, String rpcAddress, HAServiceProtocol.HAServiceState state) {
        Random rand = new Random();
        NamenodeStatusReport report = new NamenodeStatusReport(ns, nn, rpcAddress, "localhost:" + rand.nextInt(10000), "localhost:" + rand.nextInt(10000), "http", "testwebaddress-" + ns + nn);
        if (state == null) {
            return report;
        }
        report.setHAServiceState(state);
        NamespaceInfo nsInfo = new NamespaceInfo(1, "tesclusterid", ns, 0L, "testbuildvesion", "testsoftwareversion");
        report.setNamespaceInfo(nsInfo);
        return report;
    }

    public static void waitNamenodeRegistered(final ActiveNamenodeResolver resolver, final String nsId, final String nnId, final FederationNamenodeServiceState state) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    List namenodes = resolver.getNamenodesForNameserviceId(nsId);
                    if (namenodes != null) {
                        for (FederationNamenodeContext namenode : namenodes) {
                            if (namenode.getNamenodeId() != nnId && !namenode.getNamenodeId().equals(nnId)) continue;
                            return state == null || namenode.getState().equals((Object)state);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }, (long)1000L, (long)60000L);
    }

    public static void waitNamenodeRegistered(final ActiveNamenodeResolver resolver, final String nsId, final FederationNamenodeServiceState state) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    List nns = resolver.getNamenodesForNameserviceId(nsId);
                    for (FederationNamenodeContext nn : nns) {
                        if (!nn.getState().equals((Object)state)) continue;
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }, (long)1000L, (long)20000L);
    }

    public static boolean verifyDate(Date d1, Date d2, long precision) {
        return Math.abs(d1.getTime() - d2.getTime()) < precision;
    }

    public static <T> T getBean(String name, Class<T> obj) throws MalformedObjectNameException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName poolName = new ObjectName(name);
        return JMX.newMXBeanProxy(mBeanServer, poolName, obj);
    }

    public static boolean addDirectory(FileSystem context, String path) throws IOException {
        context.mkdirs(new Path(path), new FsPermission("777"));
        return FederationTestUtils.verifyFileExists(context, path);
    }

    public static FileStatus getFileStatus(FileSystem context, String path) throws IOException {
        return context.getFileStatus(new Path(path));
    }

    public static boolean verifyFileExists(FileSystem context, String path) {
        try {
            FileStatus status = FederationTestUtils.getFileStatus(context, path);
            if (status != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean checkForFileInDirectory(FileSystem context, String testPath, String targetFile) throws IOException, AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IllegalArgumentException {
        FileStatus[] fileStatus = context.listStatus(new Path(testPath));
        String file = null;
        String verifyPath = testPath + "/" + targetFile;
        if (testPath.equals("/")) {
            verifyPath = testPath + targetFile;
        }
        Boolean found = false;
        for (int i = 0; i < fileStatus.length; ++i) {
            FileStatus f = fileStatus[i];
            file = Path.getPathWithoutSchemeAndAuthority((Path)f.getPath()).toString();
            if (!file.equals(verifyPath)) continue;
            found = true;
        }
        return found;
    }

    public static int countContents(FileSystem context, String testPath) throws IOException {
        Path path = new Path(testPath);
        FileStatus[] fileStatus = context.listStatus(path);
        return fileStatus.length;
    }

    public static void createFile(FileSystem fs, String path, long length) throws IOException {
        FsPermission permissions = new FsPermission("700");
        FSDataOutputStream writeStream = fs.create(new Path(path), permissions, true, 1000, (short)1, 0x8000000L, null);
        int i = 0;
        while ((long)i < length) {
            writeStream.write(i);
            ++i;
        }
        writeStream.close();
    }

    public static String readFile(FileSystem fs, String path) throws IOException {
        String line;
        Path fileName = new Path(path);
        InputStreamReader reader = new InputStreamReader((InputStream)fs.open(fileName));
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder data = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            data.append(line);
        }
        bufferedReader.close();
        reader.close();
        return data.toString();
    }

    public static boolean deleteFile(FileSystem fs, String path) throws IOException {
        return fs.delete(new Path(path), true);
    }

    public static void simulateSlowNamenode(NameNode nn, final int seconds) throws Exception {
        FSNamesystem namesystem = nn.getNamesystem();
        HAContext haContext = namesystem.getHAContext();
        HAContext spyHAContext = (HAContext)Mockito.spy((Object)haContext);
        ((HAContext)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                LOG.info("Simulating slow namenode {}", invocation.getMock());
                try {
                    Thread.sleep(seconds * 1000);
                }
                catch (InterruptedException e) {
                    LOG.error("Simulating a slow namenode aborted");
                }
                return null;
            }
        }).when((Object)spyHAContext)).checkOperation((NameNode.OperationCategory)ArgumentMatchers.any(NameNode.OperationCategory.class));
        Whitebox.setInternalState((Object)namesystem, (String)"haContext", (Object)spyHAContext);
    }

    public static void waitRouterRegistered(final RouterStore stateManager, final long routerCount, int timeout) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    List cachedRecords = stateManager.getCachedRecords();
                    if ((long)cachedRecords.size() == routerCount) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }, (long)100L, (long)timeout);
    }

    public static void simulateThrowExceptionRouterRpcServer(RouterRpcServer server) throws IOException {
        RouterRpcClient rpcClient = server.getRPCClient();
        ConnectionManager connectionManager = new ConnectionManager(server.getConfig());
        ConnectionManager spyConnectionManager = (ConnectionManager)Mockito.spy((Object)connectionManager);
        ((ConnectionManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                LOG.info("Simulating connectionManager throw IOException {}", invocation.getMock());
                throw new IOException("Simulate connectionManager throw IOException");
            }
        }).when((Object)spyConnectionManager)).getConnection((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (String)ArgumentMatchers.any(String.class), (Class)ArgumentMatchers.any(Class.class));
        Whitebox.setInternalState((Object)rpcClient, (String)"connectionManager", (Object)spyConnectionManager);
    }

    public static void transitionClusterNSToStandby(StateStoreDFSCluster cluster) {
        List<String> nameServiceList = cluster.getNameservices();
        for (String nameService : nameServiceList) {
            List<MiniRouterDFSCluster.NamenodeContext> nnList = cluster.getNamenodes(nameService);
            for (MiniRouterDFSCluster.NamenodeContext namenodeContext : nnList) {
                cluster.switchToStandby(nameService, namenodeContext.getNamenodeId());
            }
        }
    }

    public static void transitionClusterNSToActive(StateStoreDFSCluster cluster, int index) {
        List<String> nameServiceList = cluster.getNameservices();
        for (String nameService : nameServiceList) {
            List<MiniRouterDFSCluster.NamenodeContext> listNamenodeContext = cluster.getNamenodes(nameService);
            cluster.switchToActive(nameService, listNamenodeContext.get(index).getNamenodeId());
        }
    }

    public static FileSystem getFileSystem(int rpcPort) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        URI uri = URI.create("hdfs://localhost:" + rpcPort);
        return DistributedFileSystem.get((URI)uri, (Configuration)conf);
    }

    public static FileSystem getFileSystem(Router router) throws IOException {
        InetSocketAddress rpcAddress = router.getRpcServerAddress();
        int rpcPort = rpcAddress.getPort();
        return FederationTestUtils.getFileSystem(rpcPort);
    }

    public static RouterClient getAdminClient(Router router) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        InetSocketAddress routerSocket = router.getAdminServerAddress();
        return new RouterClient(routerSocket, (Configuration)conf);
    }

    public static void createMountTableEntry(Router router, String mountPoint, DestinationOrder order, Collection<String> nsIds) throws Exception {
        FederationTestUtils.createMountTableEntry(Collections.singletonList(router), mountPoint, order, nsIds);
    }

    public static void createMountTableEntry(List<Router> routers, String mountPoint, DestinationOrder order, Collection<String> nsIds) throws Exception {
        Router router = routers.get(0);
        RouterClient admin = FederationTestUtils.getAdminClient(router);
        MountTableManager mountTable = admin.getMountTableManager();
        HashMap<String, String> destMap = new HashMap<String, String>();
        for (String nsId : nsIds) {
            destMap.put(nsId, mountPoint);
        }
        MountTable newEntry = MountTable.newInstance((String)mountPoint, destMap);
        newEntry.setDestOrder(order);
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        boolean created = addResponse.getStatus();
        Assert.assertTrue((boolean)created);
        FederationTestUtils.refreshRoutersCaches(routers);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)mountPoint);
        GetMountTableEntriesResponse getResponse = mountTable.getMountTableEntries(getRequest);
        List entries = getResponse.getEntries();
        Assert.assertEquals((String)("Too many entries: " + entries), (long)1L, (long)entries.size());
        Assert.assertEquals((Object)mountPoint, (Object)((MountTable)entries.get(0)).getSourcePath());
    }

    public static void refreshRoutersCaches(List<Router> routers) {
        for (Router router : routers) {
            StateStoreService stateStore = router.getStateStore();
            stateStore.refreshCaches(true);
        }
    }
}

