/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.driver.TestStateStoreDriverBase;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreZooKeeperImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.DisabledNameservice;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.zookeeper.CreateMode;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStateStoreZK
extends TestStateStoreDriverBase {
    private static TestingServer curatorTestingServer;
    private static CuratorFramework curatorFramework;
    private static String baseZNode;

    @BeforeClass
    public static void setupCluster() throws Exception {
        curatorTestingServer = new TestingServer();
        curatorTestingServer.start();
        String connectString = curatorTestingServer.getConnectString();
        curatorFramework = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
        curatorFramework.start();
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration(StateStoreZooKeeperImpl.class);
        conf.set("hadoop.zk.address", connectString);
        conf.setLong("dfs.federation.router.store.connection.test", TimeUnit.HOURS.toMillis(1L));
        baseZNode = conf.get("dfs.federation.router.store.driver.zk.parent-path", "/hdfs-federation");
        TestStateStoreZK.getStateStore(conf);
    }

    @AfterClass
    public static void tearDownCluster() {
        curatorFramework.close();
        try {
            curatorTestingServer.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Before
    public void startup() throws IOException {
        TestStateStoreZK.removeAll(this.getStateStoreDriver());
    }

    private <T extends BaseRecord> String generateFakeZNode(Class<T> recordClass) throws IOException {
        String nodeName = StateStoreUtils.getRecordName(recordClass);
        String primaryKey = "test";
        if (nodeName != null) {
            return baseZNode + "/" + nodeName + "/" + primaryKey;
        }
        return null;
    }

    private void testGetNullRecord(StateStoreDriver driver) throws Exception {
        this.testGetNullRecord(driver, MembershipState.class);
        this.testGetNullRecord(driver, MountTable.class);
        this.testGetNullRecord(driver, RouterState.class);
        this.testGetNullRecord(driver, DisabledNameservice.class);
    }

    private <T extends BaseRecord> void testGetNullRecord(StateStoreDriver driver, Class<T> recordClass) throws Exception {
        driver.removeAll(recordClass);
        String znode = this.generateFakeZNode(recordClass);
        Assert.assertNull((Object)curatorFramework.checkExists().forPath(znode));
        ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)curatorFramework.create().withMode(CreateMode.PERSISTENT)).withACL(null)).forPath(znode, null);
        Assert.assertNotNull((Object)curatorFramework.checkExists().forPath(znode));
        driver.get(recordClass);
        Assert.assertNull((Object)curatorFramework.checkExists().forPath(znode));
    }

    @Test
    public void testGetNullRecord() throws Exception {
        this.testGetNullRecord(this.getStateStoreDriver());
    }

    @Test
    public void testInsert() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testInsert(this.getStateStoreDriver());
    }

    @Test
    public void testUpdate() throws IllegalArgumentException, ReflectiveOperationException, IOException, SecurityException {
        this.testPut(this.getStateStoreDriver());
    }

    @Test
    public void testDelete() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testRemove(this.getStateStoreDriver());
    }

    @Test
    public void testFetchErrors() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testFetchErrors(this.getStateStoreDriver());
    }
}

