/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StateStoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreUtils.class);

    private StateStoreUtils() {
    }

    public static <T extends BaseRecord> Class<? extends BaseRecord> getRecordClass(Class<T> clazz) {
        Class<T> actualClazz = clazz;
        while (actualClazz.getSimpleName().endsWith("Impl")) {
            actualClazz = actualClazz.getSuperclass();
        }
        if (actualClazz.equals(BaseRecord.class)) {
            LOG.error("We went too far ({}) with {}", actualClazz, clazz);
            actualClazz = clazz;
        }
        return actualClazz;
    }

    public static <T extends BaseRecord> Class<? extends BaseRecord> getRecordClass(T record) {
        return StateStoreUtils.getRecordClass(record.getClass());
    }

    public static <T extends BaseRecord> String getRecordName(Class<T> clazz) {
        return StateStoreUtils.getRecordClass(clazz).getSimpleName();
    }

    public static <T extends BaseRecord> List<T> filterMultiple(Query<T> query, Iterable<T> records) {
        ArrayList<BaseRecord> matchingList = new ArrayList<BaseRecord>();
        for (BaseRecord record : records) {
            if (!query.matches(record)) continue;
            matchingList.add(record);
        }
        return matchingList;
    }

    public static String getHostPortString(InetSocketAddress address) {
        if (null == address) {
            return "";
        }
        String hostName = address.getHostName();
        if (hostName.equals("0.0.0.0")) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOG.error("Failed to get local host name", (Throwable)e);
                return "";
            }
        }
        return hostName + ":" + address.getPort();
    }
}

